/*
 * Decompiled with CFR 0.152.
 */
package org.linkeddatafragments.fragments;

import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.StmtIterator;
import org.linkeddatafragments.fragments.ILinkedDataFragment;
import org.linkeddatafragments.util.CommonResources;

public abstract class LinkedDataFragmentBase
implements ILinkedDataFragment {
    public final String fragmentURL;
    public final String datasetURL;
    public final long pageNumber;
    public final boolean isLastPage;

    protected LinkedDataFragmentBase(String fragmentURL, String datasetURL, long pageNumber, boolean isLastPage) {
        this.fragmentURL = fragmentURL;
        this.datasetURL = datasetURL;
        this.pageNumber = pageNumber;
        this.isLastPage = isLastPage;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isPageOnly() {
        return true;
    }

    @Override
    public long getPageNumber() {
        return this.pageNumber;
    }

    @Override
    public boolean isLastPage() {
        return this.isLastPage;
    }

    @Override
    public long getMaxPageSize() {
        return 100L;
    }

    @Override
    public StmtIterator getMetadata() {
        Model output = ModelFactory.createDefaultModel();
        this.addMetadata(output);
        return output.listStatements();
    }

    @Override
    public StmtIterator getControls() {
        Model output = ModelFactory.createDefaultModel();
        this.addControls(output);
        return output.listStatements();
    }

    public void addMetadata(Model model) {
        Resource datasetId = model.createResource(this.getDatasetURI());
        Resource fragmentId = model.createResource(this.fragmentURL);
        datasetId.addProperty(CommonResources.RDF_TYPE, (RDFNode)CommonResources.VOID_DATASET);
        datasetId.addProperty(CommonResources.RDF_TYPE, (RDFNode)CommonResources.HYDRA_COLLECTION);
        datasetId.addProperty(CommonResources.VOID_SUBSET, (RDFNode)fragmentId);
        Literal itemsPerPage = model.createTypedLiteral(this.getMaxPageSize());
        datasetId.addProperty(CommonResources.HYDRA_ITEMSPERPAGE, (RDFNode)itemsPerPage);
        fragmentId.addProperty(CommonResources.RDF_TYPE, (RDFNode)CommonResources.HYDRA_COLLECTION);
        fragmentId.addProperty(CommonResources.RDF_TYPE, (RDFNode)CommonResources.HYDRA_PAGEDCOLLECTION);
    }

    public void addControls(Model model) {
        URIBuilder pagedURL;
        try {
            pagedURL = new URIBuilder(this.fragmentURL);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        Resource fragmentId = model.createResource(this.fragmentURL);
        Resource firstPageId = model.createResource(pagedURL.setParameter("page", "1").toString());
        fragmentId.addProperty(CommonResources.HYDRA_FIRSTPAGE, (RDFNode)firstPageId);
        if (this.pageNumber > 1L) {
            String prevPageNumber = Long.toString(this.pageNumber - 1L);
            Resource prevPageId = model.createResource(pagedURL.setParameter("page", prevPageNumber).toString());
            fragmentId.addProperty(CommonResources.HYDRA_PREVIOUSPAGE, (RDFNode)prevPageId);
        }
        if (!this.isLastPage) {
            String nextPageNumber = Long.toString(this.pageNumber + 1L);
            Resource nextPageId = model.createResource(pagedURL.setParameter("page", nextPageNumber).toString());
            fragmentId.addProperty(CommonResources.HYDRA_NEXTPAGE, (RDFNode)nextPageId);
        }
    }

    public String getDatasetURI() {
        return this.datasetURL + "#dataset";
    }
}

