/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.config;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.config.RevisionInfoBean;
import java.util.Arrays;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.javax.servlet.ServletContextStub;
import stubs.javax.servlet.http.HttpSessionStub;

public class RevisionInfoBeanTest
extends AbstractTestClass {
    private static final Date SAMPLE_DATE = new Date();
    private static final RevisionInfoBean.LevelRevisionInfo LEVEL_1_INFO = new RevisionInfoBean.LevelRevisionInfo("level1name", "level1release", "level1revision");
    private static final RevisionInfoBean.LevelRevisionInfo LEVEL_2_INFO = new RevisionInfoBean.LevelRevisionInfo("level2name", "level2release", "level2revision");
    private static final RevisionInfoBean.LevelRevisionInfo LEVEL_3_INFO = new RevisionInfoBean.LevelRevisionInfo("level3name", "level3release", "level3revision");
    private static final RevisionInfoBean BEAN_NO_LEVEL = RevisionInfoBeanTest.buildBean(SAMPLE_DATE, new RevisionInfoBean.LevelRevisionInfo[0]);
    private static final RevisionInfoBean BEAN_1_LEVEL = RevisionInfoBeanTest.buildBean(SAMPLE_DATE, LEVEL_1_INFO);
    private static final RevisionInfoBean BEAN_MULTI_LEVEL = RevisionInfoBeanTest.buildBean(SAMPLE_DATE, LEVEL_1_INFO, LEVEL_2_INFO, LEVEL_3_INFO);
    private ServletContextStub context;
    private HttpSessionStub session;

    private static RevisionInfoBean buildBean(Date date, RevisionInfoBean.LevelRevisionInfo ... levels) {
        return new RevisionInfoBean(date, Arrays.asList(levels));
    }

    @Before
    public void setupContext() {
        this.context = new ServletContextStub();
        this.session = new HttpSessionStub();
        this.session.setServletContext(this.context);
    }

    @Before
    public void suppressInfoMessages() {
        RevisionInfoBeanTest.setLoggerLevel(RevisionInfoBean.class, Level.WARN);
    }

    @Test
    public void setBeanNormal() {
        RevisionInfoBean.setBean((ServletContext)this.context, (RevisionInfoBean)BEAN_1_LEVEL);
        Assert.assertEquals((String)"stored bean", (Object)BEAN_1_LEVEL, (Object)RevisionInfoBean.getBean((HttpSession)this.session));
    }

    @Test
    public void setBeanNull() {
        RevisionInfoBean.setBean((ServletContext)this.context, null);
        Assert.assertEquals((String)"dummy bean", (Object)RevisionInfoBean.DUMMY_BEAN, (Object)RevisionInfoBean.getBean((HttpSession)this.session));
    }

    @Test
    public void getBeanNoSession() {
        RevisionInfoBeanTest.setLoggerLevel(RevisionInfoBean.class, Level.ERROR);
        Assert.assertEquals((String)"noBean", (Object)RevisionInfoBean.DUMMY_BEAN, (Object)RevisionInfoBean.getBean((HttpSession)null));
    }

    @Test
    public void getBeanNoAttribute() {
        RevisionInfoBeanTest.setLoggerLevel(RevisionInfoBean.class, Level.ERROR);
        Assert.assertEquals((String)"noAttribute", (Object)RevisionInfoBean.DUMMY_BEAN, (Object)RevisionInfoBean.getBean((HttpSession)this.session));
    }

    @Test
    public void getBeanAttributeIsWrongClass() {
        RevisionInfoBeanTest.setLoggerLevel(RevisionInfoBean.class, Level.OFF);
        this.context.setAttribute(RevisionInfoBean.ATTRIBUTE_NAME, "A string!");
        Assert.assertEquals((String)"noAttribute", (Object)RevisionInfoBean.DUMMY_BEAN, (Object)RevisionInfoBean.getBean((HttpSession)this.session));
    }

    @Test
    public void removeBean() {
        RevisionInfoBean.setBean((ServletContext)this.context, (RevisionInfoBean)BEAN_1_LEVEL);
        Assert.assertEquals((String)"stored bean", (Object)BEAN_1_LEVEL, (Object)RevisionInfoBean.getBean((HttpSession)this.session));
        RevisionInfoBeanTest.setLoggerLevel(RevisionInfoBean.class, Level.ERROR);
        RevisionInfoBean.removeBean((ServletContext)this.context);
        Assert.assertEquals((String)"dummy bean", (Object)RevisionInfoBean.DUMMY_BEAN, (Object)RevisionInfoBean.getBean((HttpSession)this.session));
    }

    @Test
    public void getReleaseLabelOneLevel() {
        RevisionInfoBean.setBean((ServletContext)this.context, (RevisionInfoBean)BEAN_1_LEVEL);
        Assert.assertEquals((String)"1 level release", (Object)LEVEL_1_INFO.getRelease(), (Object)RevisionInfoBean.getBean((HttpSession)this.session).getReleaseLabel());
    }

    @Test
    public void getReleaseLabelManyLevels() {
        RevisionInfoBean.setBean((ServletContext)this.context, (RevisionInfoBean)BEAN_MULTI_LEVEL);
        Assert.assertEquals((String)"many level release", (Object)LEVEL_3_INFO.getRelease(), (Object)RevisionInfoBean.getBean((HttpSession)this.session).getReleaseLabel());
    }

    @Test
    public void getReleaseLabelNoLevels() {
        RevisionInfoBean.setBean((ServletContext)this.context, (RevisionInfoBean)BEAN_NO_LEVEL);
        Assert.assertEquals((String)"0 level release", (Object)RevisionInfoBean.LevelRevisionInfo.DUMMY_LEVEL.getRelease(), (Object)RevisionInfoBean.getBean((HttpSession)this.session).getReleaseLabel());
    }

    @Test
    public void getReleaseLabelNoBean() {
        RevisionInfoBeanTest.setLoggerLevel(RevisionInfoBean.class, Level.ERROR);
        Assert.assertEquals((String)"no bean release", (Object)RevisionInfoBean.LevelRevisionInfo.DUMMY_LEVEL.getRelease(), (Object)RevisionInfoBean.getBean((HttpSession)this.session).getReleaseLabel());
    }
}

