/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.ListClassGroupsController;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.ListControllerTestBase;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.VClassGroupDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactoryStub;
import stubs.edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccessFactoryStub;
import stubs.javax.servlet.http.HttpServletRequestStub;

public class ListClassGroupsControllerTest
extends ListControllerTestBase {
    private static final String LINK_FORMAT_GROUP = "<a href='./editForm?uri=%s&amp;controller=Classgroup'>%s</a>";
    private static final String LINK_FORMAT_CLASS = "<a href='vclassEdit?uri=%s'>%s</a>";
    private static final String GROUP1 = "http://ont1/group1";
    private static final String GROUP2 = "http://ont1/group2";
    private static final String CLASS1 = "http://ont1/class1";
    private static final String CLASS2 = "http://ont1/class2";
    private static final String CLASS2_NAME = "The Second Class";
    private static final String CLASS2_SHORT_DEF = "A Marvelous Class";
    private static final int GROUP1_RANK = 5;
    private static final String GROUP2_NAME = "The Second Group";
    private static final JsonNode JSON_EMPTY_RESPONSE = ListClassGroupsControllerTest.arrayOf(new JsonNode[0]);
    private static final JsonNode JSON_FULL_RESPONSE = ListClassGroupsControllerTest.arrayOf(new JsonNode[]{ListClassGroupsControllerTest.groupListNode("<a href='./editForm?uri=%s&amp;controller=Classgroup'>%s</a>", "http://ont1/group1", "(unnamed group)", "5", new ObjectNode[0]), ListClassGroupsControllerTest.groupListNode("<a href='./editForm?uri=%s&amp;controller=Classgroup'>%s</a>", "http://ont1/group2", "The Second Group", "", ListClassGroupsControllerTest.groupMemberNode("", "", "", "", new ObjectNode[0]), ListClassGroupsControllerTest.groupMemberNode("<a href='vclassEdit?uri=%s'>%s</a>", "http://ont1/class2", "The Second Class", "A Marvelous Class", new ObjectNode[0]))});
    private ListClassGroupsController controller;
    private HttpServletRequestStub req;
    private ModelAccessFactoryStub modelsFactory;
    private WebappDaoFactoryStub wadf;
    private VClassGroupDaoStub vcgDao;

    @Before
    public void setup() {
        this.controller = new ListClassGroupsController();
        this.req = new HttpServletRequestStub();
        this.vcgDao = new VClassGroupDaoStub();
        this.wadf = new WebappDaoFactoryStub();
        this.wadf.setVClassGroupDao(this.vcgDao);
        this.modelsFactory = new ModelAccessFactoryStub();
        this.modelsFactory.get(this.req).setWebappDaoFactory(this.wadf, new ModelAccess.WebappDaoFactoryOption[]{ModelAccess.PolicyOption.POLICY_NEUTRAL});
    }

    @Test
    public void noData() throws Exception {
        ListClassGroupsControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, JSON_EMPTY_RESPONSE);
    }

    @Test
    public void basicJsonTest() throws Exception {
        this.populate();
        String rawResponse = ListClassGroupsControllerTest.getJsonFromController((FreemarkerHttpServlet)this.controller, this.req);
        String kluged = rawResponse.replace("[\"\"", "[ {\"name\": \"\"");
        this.assertKlugedJson(JSON_FULL_RESPONSE, kluged);
    }

    private void populate() {
        this.vcgDao.setGroups(this.vClassGroup(GROUP1, null, 5, new VClass[0]), this.vClassGroup(GROUP2, GROUP2_NAME, -1, this.vclass(CLASS1, null, null), this.vclass(CLASS2, CLASS2_NAME, CLASS2_SHORT_DEF)));
    }

    private VClassGroup vClassGroup(String uri, String name, int rank, VClass ... vClasses) {
        VClassGroup group = new VClassGroup(uri, name, rank);
        for (VClass vClass : vClasses) {
            group.add((Object)vClass);
        }
        return group;
    }

    private VClass vclass(String uri, String name, String shortDef) {
        VClass vc = new VClass(uri);
        vc.setName(name);
        vc.setShortDef(shortDef);
        return vc;
    }
}

