/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.vitro.webapp.beans.Ontology;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.ListControllerTestBase;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.ShowClassHierarchyController;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.text.Collator;
import javax.servlet.http.HttpServletRequest;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.OntologyDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.VClassDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.VClassGroupDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactoryStub;
import stubs.edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccessFactoryStub;
import stubs.javax.servlet.http.HttpServletRequestStub;

public class ShowClassHierarchyControllerTest
extends ListControllerTestBase {
    private static final String PATH = "vclassEdit";
    private static final String ONT1 = "http://ont1/";
    private static final String ONT2 = "http://ont2/";
    private static final String ONT3 = "http://ont3/";
    private static final String ONT3_NAME = "Fabulous Ontology";
    private static final String URI_GREATAUNT = "http://ont1/greatAunt";
    private static final String URI_GRANDMOTHER = "http://ont2/grandmother";
    private static final String URI_AUNT = "http://ont3/aunt";
    private static final String URI_MOTHER = "http://ont1/mother";
    private static final String NAME_GRANDMOTHER = "GrandMother";
    private static final String NAME_AUNT = "Aunt";
    private static final String NAME_MOTHER = "Mother";
    private static final String SHORT_DEF_GRANDMOTHER = "My GrandMother";
    private static final String SHORT_DEF_AUNT = "My Aunt";
    private static final String SHORT_DEF_MOTHER = "My Mother";
    private static final String GROUP_NONE = "http://domain/noSuchGroup";
    private static final String GROUP_NO_NAME = "http://domain/groupWithNoName";
    private static final String GROUP_W_NAME = "http://domain/namedGroup";
    private static final String NAME_GROUP = "The Groupsters";
    private static final ArrayNode JSON_EMPTY_RESPONSE = ShowClassHierarchyControllerTest.arrayOf(new JsonNode[]{ShowClassHierarchyControllerTest.vclassHierarchyNode("vclassEdit", "http://www.w3.org/1999/02/22-rdf-syntax-ns#Resource", "Resource", "", "", "http://www.w3.org/1999/02/22-rdf-syntax-ns#", new ObjectNode[0])});
    private static final JsonNode RESPONSE_UNFILTERED = ShowClassHierarchyControllerTest.arrayOf(new JsonNode[]{ShowClassHierarchyControllerTest.vclassHierarchyNode("vclassEdit", "http://ont2/grandmother", "GrandMother", "My GrandMother", "", "http://ont2/", ShowClassHierarchyControllerTest.vclassHierarchyNode("vclassEdit", "http://ont3/aunt", "Aunt", "My Aunt", "", "Fabulous Ontology", new ObjectNode[0]), ShowClassHierarchyControllerTest.vclassHierarchyNode("vclassEdit", "http://ont1/mother", "Mother", "My Mother", "The Groupsters", "http://ont1/", new ObjectNode[0])), ShowClassHierarchyControllerTest.vclassHierarchyNode("vclassEdit", "http://ont1/greatAunt", "greatAunt", "", "", "http://ont1/", new ObjectNode[0])});
    private static final JsonNode RESPONSE_FILTERED_BY_ONT1 = ShowClassHierarchyControllerTest.arrayOf(new JsonNode[]{ShowClassHierarchyControllerTest.vclassHierarchyNode("vclassEdit", "http://ont1/greatAunt", "greatAunt", "", "", "http://ont1/", new ObjectNode[0])});
    private static final JsonNode RESPONSE_FILTERED_BY_ONT2 = ShowClassHierarchyControllerTest.arrayOf(new JsonNode[]{ShowClassHierarchyControllerTest.vclassHierarchyNode("vclassEdit", "http://ont2/grandmother", "GrandMother", "My GrandMother", "", "http://ont2/", new ObjectNode[0])});
    private static final JsonNode RESPONSE_FILTERED_BY_ONT3 = ShowClassHierarchyControllerTest.arrayOf(new JsonNode[0]);
    private ShowClassHierarchyController controller;
    private HttpServletRequestStub req;
    private ModelAccessFactoryStub modelsFactory;
    private OntologyDaoStub ontdao;
    private VClassDaoStub vcdao;
    private VClassGroupDaoStub vcgdao;
    private WebappDaoFactoryStub wadf;

    @Before
    public void setup() {
        this.controller = new ShowClassHierarchyController();
        this.req = new HttpServletRequestStub();
        new VitroRequest((HttpServletRequest)this.req).setCollator(Collator.getInstance());
        this.ontdao = new OntologyDaoStub();
        this.vcdao = new VClassDaoStub();
        this.vcgdao = new VClassGroupDaoStub();
        this.wadf = new WebappDaoFactoryStub();
        this.wadf.setOntologyDao(this.ontdao);
        this.wadf.setVClassDao(this.vcdao);
        this.wadf.setVClassGroupDao(this.vcgdao);
        this.modelsFactory = new ModelAccessFactoryStub();
        this.modelsFactory.get(this.req).setWebappDaoFactory(this.wadf, new ModelAccess.WebappDaoFactoryOption[]{ModelAccess.POLICY_NEUTRAL});
        this.modelsFactory.get(this.req).setWebappDaoFactory(this.wadf, new ModelAccess.WebappDaoFactoryOption[]{ModelAccess.POLICY_NEUTRAL, ModelAccess.ASSERTIONS_ONLY});
    }

    @Test
    public void noData() throws Exception {
        ShowClassHierarchyControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, (JsonNode)JSON_EMPTY_RESPONSE);
    }

    @Test
    public void unfiltered() throws Exception {
        this.populate();
        ShowClassHierarchyControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, RESPONSE_UNFILTERED);
    }

    @Test
    public void filteredByOnt1() throws Exception {
        this.populate();
        this.req.addParameter("ontologyUri", ONT1);
        ShowClassHierarchyControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, RESPONSE_FILTERED_BY_ONT1);
    }

    @Test
    public void filteredByOnt2() throws Exception {
        this.populate();
        this.req.addParameter("ontologyUri", ONT2);
        ShowClassHierarchyControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, RESPONSE_FILTERED_BY_ONT2);
    }

    @Test
    public void filteredByOnt3() throws Exception {
        this.populate();
        this.req.addParameter("ontologyUri", ONT3);
        ShowClassHierarchyControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, RESPONSE_FILTERED_BY_ONT3);
    }

    private void populate() {
        this.ontdao.insertNewOntology(this.ontology(ONT2, null));
        this.ontdao.insertNewOntology(this.ontology(ONT3, ONT3_NAME));
        this.vcgdao.setGroups(this.vclassGroup(GROUP_NO_NAME, null));
        this.vcgdao.setGroups(this.vclassGroup(GROUP_W_NAME, NAME_GROUP));
        this.vcdao.setVClass(this.vclass(URI_GREATAUNT, null, null, null));
        this.vcdao.setVClass(this.vclass(URI_GRANDMOTHER, NAME_GRANDMOTHER, GROUP_NONE, SHORT_DEF_GRANDMOTHER));
        this.vcdao.setVClass(this.vclass(URI_AUNT, NAME_AUNT, GROUP_NO_NAME, SHORT_DEF_AUNT), URI_GRANDMOTHER);
        this.vcdao.setVClass(this.vclass(URI_MOTHER, NAME_MOTHER, GROUP_W_NAME, SHORT_DEF_MOTHER), URI_GRANDMOTHER);
    }

    private VClass vclass(String uri, String name, String groupUri, String shortDef) {
        VClass vc = new VClass();
        vc.setURI(uri);
        vc.setPickListName(name);
        vc.setShortDef(shortDef);
        vc.setGroupURI(groupUri);
        VClassGroup group = this.vcgdao.getGroupByURI(groupUri);
        if (group != null) {
            group.add((Object)vc);
        }
        return vc;
    }

    private Ontology ontology(String uri, String name) {
        Ontology o = new Ontology();
        o.setURI(uri);
        o.setName(name);
        return o;
    }

    private VClassGroup vclassGroup(String uri, String name) {
        VClassGroup vcg = new VClassGroup();
        vcg.setURI(uri);
        vcg.setPublicName(name);
        return vcg;
    }
}

