/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.individual;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.policy.BasicPolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ServletPolicyList;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.Authorization;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyIface;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.publish.PublishDataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.publish.PublishObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.individual.IndividualRdfAssembler;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model.RDFServiceModel;
import edu.cornell.mannlib.vitro.webapp.web.ContentType;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.IteratorUtils;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccessFactoryStub;
import stubs.javax.servlet.ServletContextStub;
import stubs.javax.servlet.http.HttpServletRequestStub;
import stubs.javax.servlet.http.HttpSessionStub;

public class IndividualRdfAssemblerTest
extends AbstractTestClass {
    private static final String INDIVIDUAL_URI = "http://vivo.mydomain.edu/individual/n3639";
    private static final String DOCUMENT_URI = "http://vivo.mydomain.edu/individual/n3639/n3639.n3";
    private static final String DATE_DATA_PROPERTY = "http://purl.org/dc/elements/1.1/date";
    private static final String DP1 = "http://dataPropertyUri1";
    private static final String OP1 = "http://objectPropertyUri1";
    private static final String C1 = "http://class1";
    private static final String C2 = "http://class2";
    private static final String I1 = "http://individual1";
    private static final String RAW_RDF_FILENAME = "IndividualRdfAssemblerTest.rawRdf.n3";
    private static final String FILTERED_RDF_FILENAME = "IndividualRdfAssemblerTest.filteredRdf.n3";
    private static final String UNFILTERED_RDF_FILENAME = "IndividualRdfAssemblerTest.unfilteredRdf.n3";
    private static final String[] REAL_WORLD_PROPERTIES = new String[]{"http://vivoweb.org/ontology/core#overview", "http://vivoweb.org/ontology/core#hasResearchArea", "http://vivoweb.org/ontology/core#researchAreaOf"};
    private OntModel rawRdf;
    private OntModel expectedLod;
    private OntModel actualLod;
    private ServletContextStub ctx;
    private HttpSessionStub session;
    private HttpServletRequestStub req;
    private VitroRequest vreq;
    private RDFServiceModel rdfService;
    private IndividualRdfAssembler ira;

    @Before
    public void setLoggingLevels() {
        IndividualRdfAssemblerTest.setLoggerLevel(ModelAccess.class, Level.ERROR);
    }

    @Before
    public void setup() throws IOException {
        this.ctx = new ServletContextStub();
        this.session = new HttpSessionStub();
        this.session.setServletContext(this.ctx);
        this.req = new HttpServletRequestStub();
        this.req.setSession(this.session);
        this.req.setRequestUrl(new URL(DOCUMENT_URI));
    }

    @Test
    public void getOutgoingStatements() {
        Statement s1 = this.dataStmt(INDIVIDUAL_URI, DP1, "value");
        Statement s2 = this.objectStmt(INDIVIDUAL_URI, OP1, I1);
        this.rawRdf = this.model(s1, s2);
        this.expectedLod = this.includeDocInfo(this.model(s1, s2));
        this.policyUnrestricted();
        this.filterAndCompare("getOutgoingStatements");
    }

    @Test
    public void filterOutgoingStatements() {
        Statement s1 = this.dataStmt(INDIVIDUAL_URI, DP1, "value");
        Statement s2 = this.objectStmt(INDIVIDUAL_URI, OP1, I1);
        this.rawRdf = this.model(s1, s2);
        this.expectedLod = this.includeDocInfo(this.model(new Statement[0]));
        this.policyRestrictByPredicate(DP1, OP1);
        this.filterAndCompare("filterOutgoingStatements");
    }

    @Test
    public void getIncomingStatements() {
        Statement s1 = this.objectStmt(I1, OP1, INDIVIDUAL_URI);
        this.rawRdf = this.model(s1);
        this.expectedLod = this.includeDocInfo(this.model(s1));
        this.policyUnrestricted();
        this.filterAndCompare("getIncomingStatements");
    }

    @Test
    public void filterIncomingStatements() {
        Statement s1 = this.objectStmt(I1, OP1, INDIVIDUAL_URI);
        this.rawRdf = this.model(s1);
        this.expectedLod = this.includeDocInfo(this.model(new Statement[0]));
        this.policyRestrictByPredicate(OP1);
        this.filterAndCompare("filterIncomingStatements");
    }

    @Test
    public void getLabelAndTypeOfOutgoingObjects() {
        Statement s1 = this.objectStmt(INDIVIDUAL_URI, OP1, I1);
        Statement s2 = this.dataStmt(I1, "http://www.w3.org/2000/01/rdf-schema#label", "silly label");
        Statement s3 = this.objectStmt(I1, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", C1);
        this.rawRdf = this.model(s1, s2, s3);
        this.expectedLod = this.includeDocInfo(this.model(s1, s2, s3));
        this.policyUnrestricted();
        this.filterAndCompare("getLabelAndTypeOfOutgoingObjects");
    }

    @Test
    public void filterOrphanStatementsOfOutgoingObjects() {
        Statement s1 = this.objectStmt(INDIVIDUAL_URI, OP1, I1);
        Statement s2 = this.dataStmt(I1, "http://www.w3.org/2000/01/rdf-schema#label", "silly label");
        Statement s3 = this.objectStmt(I1, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", C1);
        this.rawRdf = this.model(s1, s2, s3);
        this.expectedLod = this.includeDocInfo(this.model(new Statement[0]));
        this.policyRestrictByPredicate(OP1);
        this.filterAndCompare("filterOrphanStatementsOfOutgoingObjects");
    }

    @Test
    public void getLabelAndTypeOfIncomingObjects() {
        Statement s1 = this.objectStmt(I1, OP1, INDIVIDUAL_URI);
        Statement s2 = this.dataStmt(I1, "http://www.w3.org/2000/01/rdf-schema#label", "silly label");
        Statement s3 = this.objectStmt(I1, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", C1);
        this.rawRdf = this.model(s1, s2, s3);
        this.expectedLod = this.includeDocInfo(this.model(s1, s2, s3));
        this.policyUnrestricted();
        this.filterAndCompare("getLabelAndTypeOfIncomingObjects");
    }

    @Test
    public void filterOrphanStatementsOfIncomingObjects() {
        Statement s1 = this.objectStmt(I1, OP1, INDIVIDUAL_URI);
        Statement s2 = this.dataStmt(I1, "http://www.w3.org/2000/01/rdf-schema#label", "silly label");
        Statement s3 = this.objectStmt(I1, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", C1);
        this.rawRdf = this.model(s1, s2, s3);
        this.expectedLod = this.includeDocInfo(this.model(new Statement[0]));
        this.policyRestrictByPredicate(OP1);
        this.filterAndCompare("filterOrphanStatementsOfIncomingObjects");
    }

    @Test
    public void getTypeStatements() {
        Statement s1 = this.objectStmt(INDIVIDUAL_URI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", C1);
        this.rawRdf = this.model(s1);
        this.expectedLod = this.includeDocInfo(this.model(s1));
        this.policyUnrestricted();
        this.filterAndCompare("getTypeStatements");
    }

    @Test
    public void filterTypeStatements() {
        Statement s1 = this.objectStmt(INDIVIDUAL_URI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", C1);
        this.rawRdf = this.model(s1);
        this.expectedLod = this.includeDocInfo(this.model(new Statement[0]));
        this.policyRestrictByClass(C1);
        this.filterAndCompare("filterTypeStatements");
    }

    @Test
    public void getTypeAndLabelOfType() {
        Statement s1 = this.objectStmt(INDIVIDUAL_URI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", C1);
        Statement s2 = this.dataStmt(C1, "http://www.w3.org/2000/01/rdf-schema#label", "silly label");
        Statement s3 = this.objectStmt(C1, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", C2);
        this.rawRdf = this.model(s1, s2, s3);
        this.expectedLod = this.includeDocInfo(this.model(s1, s2, s3));
        this.policyUnrestricted();
        this.filterAndCompare("getTypeAndLabelOfType");
    }

    @Test
    public void filterOrphanTypeAndLabelOfType() {
        Statement s1 = this.objectStmt(INDIVIDUAL_URI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", C1);
        Statement s2 = this.dataStmt(I1, "http://www.w3.org/2000/01/rdf-schema#label", "silly label");
        Statement s3 = this.objectStmt(I1, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", C2);
        this.rawRdf = this.model(s1, s2, s3);
        this.expectedLod = this.includeDocInfo(this.model(new Statement[0]));
        this.policyRestrictByClass(C1);
        this.filterAndCompare("filterOrphanTypeAndLabelOfType");
    }

    @Test
    public void dontGetOtherStatementsFromOutgoingObjects() {
        Statement s1 = this.objectStmt(INDIVIDUAL_URI, OP1, I1);
        Statement s2 = this.dataStmt(I1, DP1, "silly data property");
        this.rawRdf = this.model(s1, s2);
        this.expectedLod = this.includeDocInfo(this.model(s1));
        this.policyUnrestricted();
        this.filterAndCompare("dontGetOtherStatementsFromOutgoingObjects");
    }

    @Test
    public void dontGetOtherStatementsFromIncomingObjects() {
        Statement s1 = this.objectStmt(I1, OP1, INDIVIDUAL_URI);
        Statement s2 = this.dataStmt(I1, DP1, "silly data property");
        this.rawRdf = this.model(s1, s2);
        this.expectedLod = this.includeDocInfo(this.model(s1));
        this.policyUnrestricted();
        this.filterAndCompare("dontGetOtherStatementsFromIncomingObjects");
    }

    @Test
    public void dontGetUnrelatedStatements() {
        Statement s1 = this.dataStmt(I1, DP1, "silly data property");
        this.rawRdf = this.model(s1);
        this.expectedLod = this.includeDocInfo(this.model(new Statement[0]));
        this.policyUnrestricted();
        this.filterAndCompare("dontGetUnrelatedStatements");
    }

    @Test
    public void realWorldTestRoot() throws IOException {
        this.rawRdf = this.readModelFromFile(RAW_RDF_FILENAME, "N3");
        this.expectedLod = this.readModelFromFile(UNFILTERED_RDF_FILENAME, "N3");
        this.policyUnrestricted();
        this.filterAndCompare("real world test - root");
    }

    @Test
    public void realWorldTestPublic() throws IOException {
        this.rawRdf = this.readModelFromFile(RAW_RDF_FILENAME, "N3");
        this.expectedLod = this.readModelFromFile(FILTERED_RDF_FILENAME, "N3");
        this.policyRestrictByPredicate(REAL_WORLD_PROPERTIES);
        this.filterAndCompare("real world test - public");
    }

    private Statement dataStmt(String subjectUri, String predicateUri, String value) {
        Resource subject = ResourceFactory.createResource((String)subjectUri);
        Property predicate = ResourceFactory.createProperty((String)predicateUri);
        Literal object = ResourceFactory.createPlainLiteral((String)value);
        return ResourceFactory.createStatement((Resource)subject, (Property)predicate, (RDFNode)object);
    }

    private Statement objectStmt(String subjectUri, String predicateUri, String objectUri) {
        Resource subject = ResourceFactory.createResource((String)subjectUri);
        Property predicate = ResourceFactory.createProperty((String)predicateUri);
        Resource object = ResourceFactory.createResource((String)objectUri);
        return ResourceFactory.createStatement((Resource)subject, (Property)predicate, (RDFNode)object);
    }

    private OntModel model(Statement ... stmts) {
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        m.add(Arrays.asList(stmts));
        return m;
    }

    private OntModel includeDocInfo(OntModel m) {
        ArrayList<Statement> list = new ArrayList<Statement>();
        list.add(this.dataStmt(DOCUMENT_URI, "http://www.w3.org/2000/01/rdf-schema#label", "RDF description of http://vivo.mydomain.edu/individual/n3639"));
        list.add(this.dataStmt(DOCUMENT_URI, DATE_DATA_PROPERTY, "bogusTimeStamp"));
        list.add(this.objectStmt(DOCUMENT_URI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://xmlns.com/foaf/0.1/Document"));
        list.add(this.objectStmt(DOCUMENT_URI, "http://purl.org/dc/elements/1.1/publisher", "http://vivo.mydomain.edu"));
        list.add(this.objectStmt(DOCUMENT_URI, "http://purl.org/dc/elements/1.1/rights", "http://vivo.mydomain.edu/termsOfUse"));
        m.add(list);
        return m;
    }

    private void policyUnrestricted() {
        ServletPolicyList.addPolicy((ServletContext)this.ctx, (PolicyIface)new UnrestrictedPolicy());
    }

    private void policyRestrictByPredicate(String ... predicateUris) {
        ServletPolicyList.addPolicy((ServletContext)this.ctx, (PolicyIface)new RestrictionsPolicy(predicateUris, new String[0]));
    }

    private void policyRestrictByClass(String ... classUris) {
        ServletPolicyList.addPolicy((ServletContext)this.ctx, (PolicyIface)new RestrictionsPolicy(new String[0], classUris));
    }

    private void filterAndCompare(String message) {
        this.setupIndividualRdfAssembler();
        this.actualLod = this.runGetRdf();
        List<Statement> missing = this.modelDifference(this.expectedLod, this.actualLod);
        List<Statement> extra = this.modelDifference(this.actualLod, this.expectedLod);
        this.removeMatchingDateStatements(missing, extra);
        if (missing.isEmpty() && extra.isEmpty()) {
            return;
        }
        this.failComparison(message, missing, extra);
    }

    private void setupIndividualRdfAssembler() {
        this.rdfService = new RDFServiceModel((Model)this.rawRdf);
        new ModelAccessFactoryStub().get(this.req).setRDFService((RDFService)this.rdfService, new ModelAccess.RdfServiceOption[]{ModelAccess.LanguageOption.LANGUAGE_NEUTRAL});
        this.vreq = new VitroRequest((HttpServletRequest)this.req);
        this.ira = new IndividualRdfAssembler(this.vreq, INDIVIDUAL_URI, ContentType.N3);
    }

    private OntModel runGetRdf() {
        try {
            Method m = IndividualRdfAssembler.class.getDeclaredMethod("getRdf", new Class[0]);
            m.setAccessible(true);
            return (OntModel)m.invoke((Object)this.ira, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void failComparison(String message, List<Statement> missing, List<Statement> extra) {
        StringWriter sw = new StringWriter();
        PrintWriter w = new PrintWriter(sw);
        w.println(message);
        this.writeStatementList("Missing statements:", missing, w);
        this.writeStatementList("Extra statements:", extra, w);
        System.err.print(sw.toString());
        Assert.fail((String)sw.toString());
    }

    private void writeStatementList(String label, List<Statement> list, PrintWriter w) {
        if (list.isEmpty()) {
            return;
        }
        w.println(label);
        for (Statement s : list) {
            w.println("   " + s);
        }
    }

    private List<Statement> modelDifference(OntModel first, OntModel second) {
        OntModel temp = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        temp.add((Model)first);
        temp.remove(this.statementList(second));
        return this.statementList(temp);
    }

    private List<Statement> statementList(OntModel m) {
        return IteratorUtils.toList((Iterator)m.listStatements());
    }

    private void removeMatchingDateStatements(List<Statement> list1, List<Statement> list2) {
        Iterator<Statement> it1 = list1.iterator();
        while (it1.hasNext()) {
            Statement stmt1 = it1.next();
            String subject1 = stmt1.getSubject().getURI();
            String predicate1 = stmt1.getPredicate().getURI();
            if (!DATE_DATA_PROPERTY.equals(predicate1)) continue;
            Iterator<Statement> it2 = list2.iterator();
            while (it2.hasNext()) {
                Statement stmt2 = it2.next();
                String subject2 = stmt2.getSubject().getURI();
                String predicate2 = stmt2.getPredicate().getURI();
                if (!predicate1.equals(predicate2) || !subject1.equals(subject2)) continue;
                it1.remove();
                it2.remove();
            }
        }
    }

    private static class RestrictionsPolicy
    extends AbstractTestPolicy {
        private final List<String> filteredPropertyUris;
        private final List<String> filteredClassUris;

        public RestrictionsPolicy(String[] filteredPropertyUris, String[] filteredClassUris) {
            this.filteredPropertyUris = Arrays.asList(filteredPropertyUris);
            this.filteredClassUris = Arrays.asList(filteredClassUris);
        }

        @Override
        protected PolicyDecision filter(String propertyUri, String classUri) {
            if (propertyUri != null && this.filteredPropertyUris.contains(propertyUri)) {
                return this.inconclusive("Filtered property: " + propertyUri);
            }
            if (classUri != null && this.filteredClassUris.contains(classUri)) {
                return this.inconclusive("Filtered class: " + classUri);
            }
            return this.authorized("Passed the filters: " + propertyUri + "," + classUri);
        }
    }

    private static class UnrestrictedPolicy
    extends AbstractTestPolicy {
        private UnrestrictedPolicy() {
        }

        @Override
        protected PolicyDecision filter(String propertyUri, String classUri) {
            return this.authorized("Totally unrestricted");
        }
    }

    private static abstract class AbstractTestPolicy
    implements PolicyIface {
        private AbstractTestPolicy() {
        }

        public PolicyDecision isAuthorized(IdentifierBundle whoToAuth, RequestedAction whatToAuth) {
            if (whatToAuth instanceof PublishDataPropertyStatement) {
                return this.filterDataProperty((PublishDataPropertyStatement)whatToAuth);
            }
            if (whatToAuth instanceof PublishObjectPropertyStatement) {
                return this.filterObjectProperty((PublishObjectPropertyStatement)whatToAuth);
            }
            return this.inconclusive("Bogus");
        }

        private PolicyDecision filterDataProperty(PublishDataPropertyStatement pdps) {
            return this.filter(pdps.getPredicateUri(), null);
        }

        private PolicyDecision filterObjectProperty(PublishObjectPropertyStatement pops) {
            String propertyUri = pops.getPredicateUri();
            if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#type".equals(propertyUri)) {
                return this.filter(propertyUri, pops.getObjectUri());
            }
            return this.filter(propertyUri, null);
        }

        protected abstract PolicyDecision filter(String var1, String var2);

        protected BasicPolicyDecision authorized(String message) {
            return new BasicPolicyDecision(Authorization.AUTHORIZED, message);
        }

        protected BasicPolicyDecision inconclusive(String message) {
            return new BasicPolicyDecision(Authorization.INCONCLUSIVE, message);
        }
    }
}

