/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.reasoner;

import edu.cornell.mannlib.vitro.webapp.reasoner.ABoxRecomputer;
import edu.cornell.mannlib.vitro.webapp.reasoner.SimpleReasoner;
import edu.cornell.mannlib.vitro.webapp.reasoner.SimpleReasonerTBoxHelper;
import edu.cornell.mannlib.vitro.webapp.reasoner.SimpleReasonerTBoxListener;
import edu.cornell.mannlib.vitro.webapp.utils.threads.VitroBackgroundThread;
import java.io.OutputStream;
import org.apache.jena.ontology.AnnotationProperty;
import org.apache.jena.ontology.DatatypeProperty;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.ObjectProperty;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SimpleReasonerSameAsTest
extends SimpleReasonerTBoxHelper {
    long delay = 50L;
    private static final String mostSpecificTypePropertyURI = "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#mostSpecificType";

    @Before
    public void suppressErrorOutput() {
        this.suppressSyserr();
        SimpleReasonerSameAsTest.setLoggerLevel(SimpleReasoner.class, Level.OFF);
        SimpleReasonerSameAsTest.setLoggerLevel(SimpleReasonerTBoxListener.class, Level.OFF);
        SimpleReasonerSameAsTest.setLoggerLevel(ABoxRecomputer.class, Level.OFF);
    }

    @Test
    public void addSameAsABoxAssertion1() {
        OntModel tBox = this.createTBoxModel();
        ObjectProperty P = this.createObjectProperty(tBox, "http://test.vivo/P", "property P");
        ObjectProperty Q = this.createObjectProperty(tBox, "http://test.vivo/Q", "property Q");
        ObjectProperty S = this.createObjectProperty(tBox, "http://test.vivo/S", "property S");
        ObjectProperty T = this.createObjectProperty(tBox, "http://test.vivo/T", "property T");
        Literal literal1 = tBox.createLiteral("Literal value 1");
        Literal literal2 = tBox.createLiteral("Literal value 2");
        Model inf = ModelFactory.createDefaultModel();
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        aBox.register((ModelChangedListener)new SimpleReasoner(tBox, aBox, inf));
        Resource a = aBox.createResource("http://test.vivo/a");
        Resource b = aBox.createResource("http://test.vivo/b");
        Resource c = aBox.createResource("http://test.vivo/c");
        Resource d = aBox.createResource("http://test.vivo/d");
        aBox.add(a, (Property)P, (RDFNode)c);
        aBox.add(a, (Property)S, (RDFNode)literal1);
        aBox.add(b, (Property)Q, (RDFNode)d);
        aBox.add(b, (Property)T, (RDFNode)literal2);
        aBox.add(a, OWL.sameAs, (RDFNode)b);
        Assert.assertTrue((boolean)inf.contains(b, OWL.sameAs, (RDFNode)a));
        Assert.assertTrue((boolean)inf.contains(b, (Property)P, (RDFNode)c));
        Assert.assertTrue((boolean)inf.contains(b, (Property)S, (RDFNode)literal1));
        Assert.assertTrue((boolean)inf.contains(a, (Property)Q, (RDFNode)d));
        Assert.assertTrue((boolean)inf.contains(a, (Property)T, (RDFNode)literal2));
        Assert.assertFalse((boolean)aBox.contains(b, OWL.sameAs, (RDFNode)a));
        Assert.assertFalse((boolean)aBox.contains(b, (Property)P, (RDFNode)c));
        Assert.assertFalse((boolean)aBox.contains(b, (Property)S, (RDFNode)literal1));
        Assert.assertFalse((boolean)aBox.contains(a, (Property)Q, (RDFNode)d));
        Assert.assertFalse((boolean)aBox.contains(a, (Property)T, (RDFNode)literal2));
        inf = ModelFactory.createDefaultModel();
        aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        SimpleReasoner sres = new SimpleReasoner(tBox, aBox, inf);
        sres.setSameAsEnabled(false);
        aBox.register((ModelChangedListener)sres);
        a = aBox.createResource("http://test.vivo/a");
        b = aBox.createResource("http://test.vivo/b");
        c = aBox.createResource("http://test.vivo/c");
        d = aBox.createResource("http://test.vivo/d");
        aBox.add(a, (Property)P, (RDFNode)c);
        aBox.add(a, (Property)S, (RDFNode)literal1);
        aBox.add(b, (Property)Q, (RDFNode)d);
        aBox.add(b, (Property)T, (RDFNode)literal2);
        aBox.add(a, OWL.sameAs, (RDFNode)b);
        Assert.assertFalse((boolean)inf.contains(b, OWL.sameAs, (RDFNode)a));
        Assert.assertFalse((boolean)inf.contains(b, (Property)P, (RDFNode)c));
        Assert.assertFalse((boolean)inf.contains(b, (Property)S, (RDFNode)literal1));
        Assert.assertFalse((boolean)inf.contains(a, (Property)Q, (RDFNode)d));
        Assert.assertFalse((boolean)inf.contains(a, (Property)T, (RDFNode)literal2));
        Assert.assertFalse((boolean)aBox.contains(b, OWL.sameAs, (RDFNode)a));
        Assert.assertFalse((boolean)aBox.contains(b, (Property)P, (RDFNode)c));
        Assert.assertFalse((boolean)aBox.contains(b, (Property)S, (RDFNode)literal1));
        Assert.assertFalse((boolean)aBox.contains(a, (Property)Q, (RDFNode)d));
        Assert.assertFalse((boolean)aBox.contains(a, (Property)T, (RDFNode)literal2));
    }

    @Test
    public void removeSameAsABoxAssertion1() {
        OntModel tBox = this.createTBoxModel();
        ObjectProperty P = this.createObjectProperty(tBox, "http://test.vivo/P", "property P");
        ObjectProperty Q = this.createObjectProperty(tBox, "http://test.vivo/Q", "property Q");
        ObjectProperty S = this.createObjectProperty(tBox, "http://test.vivo/S", "property S");
        ObjectProperty T = this.createObjectProperty(tBox, "http://test.vivo/T", "property T");
        Literal literal1 = tBox.createLiteral("Literal value 1");
        Literal literal2 = tBox.createLiteral("Literal value 2");
        Model inf = ModelFactory.createDefaultModel();
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        aBox.register((ModelChangedListener)new SimpleReasoner(tBox, aBox, inf));
        Resource a = aBox.createResource("http://test.vivo/a");
        Resource b = aBox.createResource("http://test.vivo/b");
        Resource c = aBox.createResource("http://test.vivo/c");
        Resource d = aBox.createResource("http://test.vivo/d");
        aBox.add(a, (Property)P, (RDFNode)c);
        aBox.add(a, (Property)S, (RDFNode)literal1);
        aBox.add(b, (Property)Q, (RDFNode)d);
        aBox.add(b, (Property)T, (RDFNode)literal2);
        aBox.add(a, OWL.sameAs, (RDFNode)b);
        Assert.assertTrue((boolean)inf.contains(b, OWL.sameAs, (RDFNode)a));
        Assert.assertTrue((boolean)inf.contains(b, (Property)P, (RDFNode)c));
        Assert.assertTrue((boolean)inf.contains(b, (Property)S, (RDFNode)literal1));
        Assert.assertTrue((boolean)inf.contains(a, (Property)Q, (RDFNode)d));
        Assert.assertTrue((boolean)inf.contains(a, (Property)T, (RDFNode)literal2));
        aBox.remove(a, OWL.sameAs, (RDFNode)b);
        Assert.assertFalse((boolean)inf.contains(b, OWL.sameAs, (RDFNode)a));
        Assert.assertFalse((boolean)inf.contains(b, (Property)P, (RDFNode)c));
        Assert.assertFalse((boolean)inf.contains(b, (Property)S, (RDFNode)literal1));
        Assert.assertFalse((boolean)inf.contains(a, (Property)Q, (RDFNode)d));
        Assert.assertFalse((boolean)inf.contains(a, (Property)T, (RDFNode)literal2));
    }

    @Test
    public void addABoxAssertion1() {
        OntModel tBox = this.createTBoxModel();
        ObjectProperty P = this.createObjectProperty(tBox, "http://test.vivo/P", "property P");
        ObjectProperty Q = this.createObjectProperty(tBox, "http://test.vivo/Q", "property Q");
        ObjectProperty S = this.createObjectProperty(tBox, "http://test.vivo/S", "property S");
        ObjectProperty T = this.createObjectProperty(tBox, "http://test.vivo/T", "property T");
        Literal literal1 = tBox.createLiteral("Literal value 1");
        Literal literal2 = tBox.createLiteral("Literal value 2");
        Model inf = ModelFactory.createDefaultModel();
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        aBox.register((ModelChangedListener)new SimpleReasoner(tBox, aBox, inf));
        Resource a = aBox.createResource("http://test.vivo/a");
        Resource b = aBox.createResource("http://test.vivo/b");
        Resource c = aBox.createResource("http://test.vivo/c");
        Resource d = aBox.createResource("http://test.vivo/d");
        Resource e = aBox.createResource("http://test.vivo/e");
        Resource f = aBox.createResource("http://test.vivo/f");
        aBox.add(a, OWL.sameAs, (RDFNode)b);
        aBox.add(b, OWL.sameAs, (RDFNode)e);
        aBox.add(e, OWL.sameAs, (RDFNode)f);
        Assert.assertTrue((boolean)inf.contains(b, OWL.sameAs, (RDFNode)a));
        Assert.assertTrue((boolean)inf.contains(e, OWL.sameAs, (RDFNode)a));
        Assert.assertTrue((boolean)inf.contains(e, OWL.sameAs, (RDFNode)b));
        Assert.assertTrue((boolean)inf.contains(a, OWL.sameAs, (RDFNode)e));
        Assert.assertTrue((boolean)inf.contains(f, OWL.sameAs, (RDFNode)e));
        Assert.assertTrue((boolean)inf.contains(f, OWL.sameAs, (RDFNode)b));
        Assert.assertTrue((boolean)inf.contains(f, OWL.sameAs, (RDFNode)a));
        Assert.assertTrue((boolean)inf.contains(b, OWL.sameAs, (RDFNode)f));
        Assert.assertTrue((boolean)inf.contains(a, OWL.sameAs, (RDFNode)f));
        aBox.add(a, (Property)P, (RDFNode)c);
        aBox.add(a, (Property)S, (RDFNode)literal1);
        aBox.add(b, (Property)Q, (RDFNode)d);
        aBox.add(b, (Property)T, (RDFNode)literal2);
        Assert.assertTrue((boolean)inf.contains(b, (Property)P, (RDFNode)c));
        Assert.assertTrue((boolean)inf.contains(b, (Property)S, (RDFNode)literal1));
        Assert.assertTrue((boolean)inf.contains(a, (Property)Q, (RDFNode)d));
        Assert.assertTrue((boolean)inf.contains(a, (Property)T, (RDFNode)literal2));
        Assert.assertTrue((boolean)inf.contains(e, (Property)P, (RDFNode)c));
        Assert.assertTrue((boolean)inf.contains(e, (Property)S, (RDFNode)literal1));
        Assert.assertTrue((boolean)inf.contains(e, (Property)Q, (RDFNode)d));
        Assert.assertTrue((boolean)inf.contains(e, (Property)T, (RDFNode)literal2));
        Assert.assertTrue((boolean)inf.contains(f, (Property)P, (RDFNode)c));
        Assert.assertTrue((boolean)inf.contains(f, (Property)S, (RDFNode)literal1));
        Assert.assertTrue((boolean)inf.contains(f, (Property)Q, (RDFNode)d));
        Assert.assertTrue((boolean)inf.contains(f, (Property)T, (RDFNode)literal2));
        aBox.remove(b, OWL.sameAs, (RDFNode)e);
        Assert.assertTrue((boolean)inf.contains(b, OWL.sameAs, (RDFNode)a));
        Assert.assertFalse((boolean)inf.contains(e, OWL.sameAs, (RDFNode)a));
        Assert.assertFalse((boolean)inf.contains(e, OWL.sameAs, (RDFNode)b));
        Assert.assertFalse((boolean)inf.contains(a, OWL.sameAs, (RDFNode)e));
        Assert.assertTrue((boolean)inf.contains(f, OWL.sameAs, (RDFNode)e));
        Assert.assertFalse((boolean)inf.contains(f, OWL.sameAs, (RDFNode)b));
        Assert.assertFalse((boolean)inf.contains(f, OWL.sameAs, (RDFNode)a));
        Assert.assertFalse((boolean)inf.contains(b, OWL.sameAs, (RDFNode)f));
        Assert.assertFalse((boolean)inf.contains(a, OWL.sameAs, (RDFNode)f));
        Assert.assertTrue((boolean)inf.contains(b, (Property)P, (RDFNode)c));
        Assert.assertTrue((boolean)inf.contains(b, (Property)S, (RDFNode)literal1));
        Assert.assertTrue((boolean)inf.contains(a, (Property)Q, (RDFNode)d));
        Assert.assertTrue((boolean)inf.contains(a, (Property)T, (RDFNode)literal2));
        Assert.assertFalse((boolean)inf.contains(e, (Property)P, (RDFNode)c));
        Assert.assertFalse((boolean)inf.contains(e, (Property)S, (RDFNode)literal1));
        Assert.assertFalse((boolean)inf.contains(e, (Property)Q, (RDFNode)d));
        Assert.assertFalse((boolean)inf.contains(e, (Property)T, (RDFNode)literal2));
        Assert.assertFalse((boolean)inf.contains(f, (Property)P, (RDFNode)c));
        Assert.assertFalse((boolean)inf.contains(f, (Property)S, (RDFNode)literal1));
        Assert.assertFalse((boolean)inf.contains(f, (Property)Q, (RDFNode)d));
        Assert.assertFalse((boolean)inf.contains(f, (Property)T, (RDFNode)literal2));
    }

    @Test
    public void disabledSameAs() {
        OntModel tBox = this.createTBoxModel();
        ObjectProperty P = this.createObjectProperty(tBox, "http://test.vivo/P", "property P");
        ObjectProperty Q = this.createObjectProperty(tBox, "http://test.vivo/Q", "property Q");
        ObjectProperty S = this.createObjectProperty(tBox, "http://test.vivo/S", "property S");
        ObjectProperty T = this.createObjectProperty(tBox, "http://test.vivo/T", "property T");
        Literal literal1 = tBox.createLiteral("Literal value 1");
        Literal literal2 = tBox.createLiteral("Literal value 2");
        Model inf = ModelFactory.createDefaultModel();
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        aBox.register((ModelChangedListener)new SimpleReasoner(tBox, aBox, inf));
        Resource a = aBox.createResource("http://test.vivo/a");
        Resource b = aBox.createResource("http://test.vivo/b");
        Resource c = aBox.createResource("http://test.vivo/c");
        Resource d = aBox.createResource("http://test.vivo/d");
        aBox.add(a, (Property)P, (RDFNode)c);
        aBox.add(a, (Property)S, (RDFNode)literal1);
        aBox.add(b, (Property)Q, (RDFNode)d);
        aBox.add(b, (Property)T, (RDFNode)literal2);
        aBox.add(a, OWL.sameAs, (RDFNode)b);
        Assert.assertTrue((boolean)inf.contains(b, OWL.sameAs, (RDFNode)a));
        Assert.assertTrue((boolean)inf.contains(b, (Property)P, (RDFNode)c));
        Assert.assertTrue((boolean)inf.contains(b, (Property)S, (RDFNode)literal1));
        Assert.assertTrue((boolean)inf.contains(a, (Property)Q, (RDFNode)d));
        Assert.assertTrue((boolean)inf.contains(a, (Property)T, (RDFNode)literal2));
        Assert.assertFalse((boolean)aBox.contains(b, OWL.sameAs, (RDFNode)a));
        Assert.assertFalse((boolean)aBox.contains(b, (Property)P, (RDFNode)c));
        Assert.assertFalse((boolean)aBox.contains(b, (Property)S, (RDFNode)literal1));
        Assert.assertFalse((boolean)aBox.contains(a, (Property)Q, (RDFNode)d));
        Assert.assertFalse((boolean)aBox.contains(a, (Property)T, (RDFNode)literal2));
        inf = ModelFactory.createDefaultModel();
        aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        SimpleReasoner sres = new SimpleReasoner(tBox, aBox, inf);
        sres.setSameAsEnabled(false);
        aBox.register((ModelChangedListener)sres);
        a = aBox.createResource("http://test.vivo/a");
        b = aBox.createResource("http://test.vivo/b");
        c = aBox.createResource("http://test.vivo/c");
        d = aBox.createResource("http://test.vivo/d");
        aBox.add(a, (Property)P, (RDFNode)c);
        aBox.add(a, (Property)S, (RDFNode)literal1);
        aBox.add(b, (Property)Q, (RDFNode)d);
        aBox.add(b, (Property)T, (RDFNode)literal2);
        aBox.add(a, OWL.sameAs, (RDFNode)b);
        Assert.assertFalse((boolean)inf.contains(b, OWL.sameAs, (RDFNode)a));
        Assert.assertFalse((boolean)inf.contains(b, (Property)P, (RDFNode)c));
        Assert.assertFalse((boolean)inf.contains(b, (Property)S, (RDFNode)literal1));
        Assert.assertFalse((boolean)inf.contains(a, (Property)Q, (RDFNode)d));
        Assert.assertFalse((boolean)inf.contains(a, (Property)T, (RDFNode)literal2));
        Assert.assertFalse((boolean)aBox.contains(b, OWL.sameAs, (RDFNode)a));
        Assert.assertFalse((boolean)aBox.contains(b, (Property)P, (RDFNode)c));
        Assert.assertFalse((boolean)aBox.contains(b, (Property)S, (RDFNode)literal1));
        Assert.assertFalse((boolean)aBox.contains(a, (Property)Q, (RDFNode)d));
        Assert.assertFalse((boolean)aBox.contains(a, (Property)T, (RDFNode)literal2));
    }

    @Test
    public void addABoxAssertion2() {
        OntModel tBox = this.createTBoxModel();
        DatatypeProperty desc = tBox.createDatatypeProperty("http://test.vivo/desc");
        desc.setLabel("property desc", "en-US");
        Literal desc1 = tBox.createLiteral("individual 1");
        Literal desc2 = tBox.createLiteral("individual 2");
        Model inf = ModelFactory.createDefaultModel();
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        aBox.register((ModelChangedListener)new SimpleReasoner(tBox, aBox, inf));
        Resource a = aBox.createResource("http://test.vivo/a");
        Resource b = aBox.createResource("http://test.vivo/b");
        aBox.add(a, (Property)desc, (RDFNode)desc1);
        aBox.add(b, (Property)desc, (RDFNode)desc2);
        aBox.add(a, OWL.sameAs, (RDFNode)b);
        Assert.assertTrue((boolean)inf.contains(a, (Property)desc, (RDFNode)desc2));
        Assert.assertTrue((boolean)inf.contains(b, (Property)desc, (RDFNode)desc1));
        Assert.assertTrue((boolean)inf.contains(b, OWL.sameAs, (RDFNode)a));
    }

    @Test
    public void removeABoxAssertion1() {
        OntModel tBox = this.createTBoxModel();
        ObjectProperty P = this.createObjectProperty(tBox, "http://test.vivo/P", "property P");
        ObjectProperty Q = this.createObjectProperty(tBox, "http://test.vivo/Q", "property Q");
        ObjectProperty S = this.createObjectProperty(tBox, "http://test.vivo/S", "property S");
        ObjectProperty T = this.createObjectProperty(tBox, "http://test.vivo/T", "property T");
        Literal literal1 = tBox.createLiteral("Literal value 1");
        Literal literal2 = tBox.createLiteral("Literal value 2");
        Model inf = ModelFactory.createDefaultModel();
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        aBox.register((ModelChangedListener)new SimpleReasoner(tBox, aBox, inf));
        Resource a = aBox.createResource("http://test.vivo/a");
        Resource b = aBox.createResource("http://test.vivo/b");
        Resource c = aBox.createResource("http://test.vivo/c");
        Resource d = aBox.createResource("http://test.vivo/d");
        aBox.add(a, (Property)P, (RDFNode)c);
        aBox.add(a, (Property)S, (RDFNode)literal1);
        aBox.add(b, (Property)Q, (RDFNode)d);
        aBox.add(b, (Property)T, (RDFNode)literal2);
        aBox.add(a, OWL.sameAs, (RDFNode)b);
        aBox.remove(a, (Property)P, (RDFNode)c);
        aBox.remove(a, (Property)S, (RDFNode)literal1);
        Assert.assertFalse((boolean)inf.contains(b, (Property)P, (RDFNode)c));
        Assert.assertFalse((boolean)inf.contains(b, (Property)S, (RDFNode)literal1));
    }

    @Test
    public void tBoxInverseAssertion1() throws InterruptedException {
        OntModel tBox = this.createTBoxModel();
        ObjectProperty P = this.createObjectProperty(tBox, "http://test.vivo/P", "property P");
        ObjectProperty Q = this.createObjectProperty(tBox, "http://test.vivo/Q", "property Q");
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        Model inf = ModelFactory.createDefaultModel();
        SimpleReasoner simpleReasoner = new SimpleReasoner(tBox, aBox, inf);
        aBox.register((ModelChangedListener)simpleReasoner);
        SimpleReasonerTBoxListener simpleReasonerTBoxListener = this.getTBoxListener(simpleReasoner);
        tBox.register((ModelChangedListener)simpleReasonerTBoxListener);
        Resource a = aBox.createResource("http://test.vivo/a");
        Resource b = aBox.createResource("http://test.vivo/b");
        aBox.add(a, (Property)P, (RDFNode)b);
        aBox.add(a, OWL.sameAs, (RDFNode)b);
        this.setInverse((OntProperty)Q, (OntProperty)P);
        while (!VitroBackgroundThread.getLivingThreads().isEmpty()) {
            Thread.sleep(this.delay);
        }
        Assert.assertTrue((boolean)inf.contains(b, (Property)Q, (RDFNode)a));
        Assert.assertTrue((boolean)inf.contains(b, OWL.sameAs, (RDFNode)a));
        Assert.assertTrue((boolean)inf.contains(b, (Property)P, (RDFNode)b));
        Assert.assertTrue((boolean)inf.contains(a, (Property)Q, (RDFNode)a));
        this.removeInverse((OntProperty)Q, (OntProperty)P);
        while (!VitroBackgroundThread.getLivingThreads().isEmpty()) {
            Thread.sleep(this.delay);
        }
        Assert.assertFalse((boolean)inf.contains(b, (Property)Q, (RDFNode)a));
        Assert.assertTrue((boolean)inf.contains(b, OWL.sameAs, (RDFNode)a));
        Assert.assertTrue((boolean)inf.contains(b, (Property)P, (RDFNode)b));
        Assert.assertFalse((boolean)inf.contains(a, (Property)Q, (RDFNode)a));
        simpleReasonerTBoxListener.setStopRequested();
    }

    public void tBoxTypeAssertion1() {
        OntModel tBox = this.createTBoxModel();
        OntClass classA = this.createClass(tBox, "http://test.vivo/A", "class A");
        OntClass classB = this.createClass(tBox, "http://test.vivo/B", "class B");
        this.addSubclass(classA, classB);
        Model inf = ModelFactory.createDefaultModel();
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        aBox.register((ModelChangedListener)new SimpleReasoner(tBox, aBox, inf));
        Resource x = aBox.createResource("http://test.vivo/x");
        Resource y = aBox.createResource("http://test.vivo/y");
        Resource z = aBox.createResource("http://test.vivo/z");
        aBox.add(x, OWL.sameAs, (RDFNode)y);
        aBox.add(y, OWL.sameAs, (RDFNode)z);
        aBox.add(x, RDF.type, (RDFNode)classB);
        Assert.assertTrue((boolean)inf.contains(y, RDF.type, (RDFNode)classB));
        Assert.assertTrue((boolean)inf.contains(y, RDF.type, (RDFNode)classA));
        Assert.assertTrue((boolean)inf.contains(z, RDF.type, (RDFNode)classB));
        Assert.assertTrue((boolean)inf.contains(z, RDF.type, (RDFNode)classA));
        aBox.remove(x, RDF.type, (RDFNode)classB);
        Assert.assertFalse((boolean)inf.contains(y, RDF.type, (RDFNode)classB));
        Assert.assertFalse((boolean)inf.contains(y, RDF.type, (RDFNode)classA));
        Assert.assertFalse((boolean)inf.contains(z, RDF.type, (RDFNode)classB));
        Assert.assertFalse((boolean)inf.contains(z, RDF.type, (RDFNode)classA));
    }

    public void tBoxSubclassAssertion1() throws InterruptedException {
        OntModel tBox = this.createTBoxModel();
        OntClass classA = this.createClass(tBox, "http://test.vivo/A", "class A");
        OntClass classB = this.createClass(tBox, "http://test.vivo/B", "class B");
        OntClass classC = this.createClass(tBox, "http://test.vivo/C", "class C");
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        Model inf = ModelFactory.createDefaultModel();
        SimpleReasoner simpleReasoner = new SimpleReasoner(tBox, aBox, inf);
        aBox.register((ModelChangedListener)simpleReasoner);
        SimpleReasonerTBoxListener simpleReasonerTBoxListener = this.getTBoxListener(simpleReasoner);
        tBox.register((ModelChangedListener)simpleReasonerTBoxListener);
        Resource a = aBox.createResource("http://test.vivo/a");
        Resource b = aBox.createResource("http://test.vivo/b");
        Resource c = aBox.createResource("http://test.vivo/c");
        aBox.add(a, RDF.type, (RDFNode)classC);
        aBox.add(a, OWL.sameAs, (RDFNode)b);
        aBox.add(c, OWL.sameAs, (RDFNode)a);
        this.addSubclass(classA, classB);
        while (!VitroBackgroundThread.getLivingThreads().isEmpty()) {
            Thread.sleep(this.delay);
        }
        this.addSubclass(classB, classC);
        while (!VitroBackgroundThread.getLivingThreads().isEmpty()) {
            Thread.sleep(this.delay);
        }
        Assert.assertFalse((boolean)inf.contains(a, RDF.type, (RDFNode)classC));
        Assert.assertTrue((boolean)inf.contains(a, RDF.type, (RDFNode)classB));
        Assert.assertTrue((boolean)inf.contains(a, RDF.type, (RDFNode)classA));
        Assert.assertTrue((boolean)inf.contains(b, RDF.type, (RDFNode)classC));
        Assert.assertTrue((boolean)inf.contains(b, RDF.type, (RDFNode)classB));
        Assert.assertTrue((boolean)inf.contains(b, RDF.type, (RDFNode)classA));
        Assert.assertTrue((boolean)inf.contains(c, RDF.type, (RDFNode)classC));
        Assert.assertTrue((boolean)inf.contains(c, RDF.type, (RDFNode)classB));
        Assert.assertTrue((boolean)inf.contains(c, RDF.type, (RDFNode)classA));
        this.removeSubclass(classA, classB);
        while (!VitroBackgroundThread.getLivingThreads().isEmpty()) {
            Thread.sleep(this.delay);
        }
        Assert.assertFalse((boolean)inf.contains(a, RDF.type, (RDFNode)classC));
        Assert.assertTrue((boolean)inf.contains(a, RDF.type, (RDFNode)classB));
        Assert.assertFalse((boolean)inf.contains(a, RDF.type, (RDFNode)classA));
        Assert.assertTrue((boolean)inf.contains(b, RDF.type, (RDFNode)classC));
        Assert.assertTrue((boolean)inf.contains(b, RDF.type, (RDFNode)classB));
        Assert.assertFalse((boolean)inf.contains(b, RDF.type, (RDFNode)classA));
        Assert.assertTrue((boolean)inf.contains(c, RDF.type, (RDFNode)classC));
        Assert.assertTrue((boolean)inf.contains(c, RDF.type, (RDFNode)classB));
        Assert.assertFalse((boolean)inf.contains(c, RDF.type, (RDFNode)classA));
        this.removeSubclass(classB, classC);
        while (!VitroBackgroundThread.getLivingThreads().isEmpty()) {
            Thread.sleep(this.delay);
        }
        Assert.assertFalse((boolean)inf.contains(a, RDF.type, (RDFNode)classC));
        Assert.assertFalse((boolean)inf.contains(a, RDF.type, (RDFNode)classB));
        Assert.assertFalse((boolean)inf.contains(a, RDF.type, (RDFNode)classA));
        Assert.assertTrue((boolean)inf.contains(b, RDF.type, (RDFNode)classC));
        Assert.assertFalse((boolean)inf.contains(b, RDF.type, (RDFNode)classB));
        Assert.assertFalse((boolean)inf.contains(b, RDF.type, (RDFNode)classA));
        Assert.assertTrue((boolean)inf.contains(c, RDF.type, (RDFNode)classC));
        Assert.assertFalse((boolean)inf.contains(c, RDF.type, (RDFNode)classB));
        Assert.assertFalse((boolean)inf.contains(c, RDF.type, (RDFNode)classA));
        simpleReasonerTBoxListener.setStopRequested();
    }

    public void mostSpecificTypeTest1() {
        OntModel tBox = this.createTBoxModel();
        OntClass classA = this.createClass(tBox, "http://test.vivo/A", "class A");
        OntClass classC = this.createClass(tBox, "http://test.vivo/B", "class C");
        OntClass classD = this.createClass(tBox, "http://test.vivo/B", "class D");
        OntClass classE = this.createClass(tBox, "http://test.vivo/B", "class E");
        this.addSubclass(classA, classC);
        this.addSubclass(classC, classD);
        this.addSubclass(classC, classE);
        AnnotationProperty mostSpecificType = tBox.createAnnotationProperty(mostSpecificTypePropertyURI);
        Model inf = ModelFactory.createDefaultModel();
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        SimpleReasoner simpleReasoner = new SimpleReasoner(tBox, aBox, inf);
        aBox.register((ModelChangedListener)simpleReasoner);
        Resource a = aBox.createResource("http://test.vivo/a");
        Resource b = aBox.createResource("http://test.vivo/b");
        Resource c = aBox.createResource("http://test.vivo/c");
        Resource d = aBox.createResource("http://test.vivo/d");
        aBox.add(a, OWL.sameAs, (RDFNode)b);
        aBox.add(c, OWL.sameAs, (RDFNode)b);
        aBox.add(d, OWL.sameAs, (RDFNode)a);
        aBox.add(a, RDF.type, (RDFNode)classD);
        aBox.add(d, RDF.type, (RDFNode)classC);
        Assert.assertFalse((boolean)inf.contains(a, RDF.type, (RDFNode)classD));
        Assert.assertTrue((boolean)inf.contains(a, RDF.type, (RDFNode)classC));
        Assert.assertTrue((boolean)inf.contains(b, RDF.type, (RDFNode)classD));
        Assert.assertTrue((boolean)inf.contains(b, RDF.type, (RDFNode)classC));
        Assert.assertTrue((boolean)inf.contains(c, RDF.type, (RDFNode)classD));
        Assert.assertTrue((boolean)inf.contains(c, RDF.type, (RDFNode)classC));
        Assert.assertTrue((boolean)inf.contains(d, RDF.type, (RDFNode)classD));
        Assert.assertFalse((boolean)inf.contains(d, RDF.type, (RDFNode)classC));
        Assert.assertTrue((boolean)inf.contains(a, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classD.getURI())));
        Assert.assertTrue((boolean)inf.contains(b, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classD.getURI())));
        Assert.assertTrue((boolean)inf.contains(c, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classD.getURI())));
        Assert.assertTrue((boolean)inf.contains(d, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classD.getURI())));
        Assert.assertFalse((boolean)inf.contains(a, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classC.getURI())));
        Assert.assertFalse((boolean)inf.contains(b, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classC.getURI())));
        Assert.assertFalse((boolean)inf.contains(c, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classC.getURI())));
        Assert.assertFalse((boolean)inf.contains(d, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classC.getURI())));
        aBox.remove(a, RDF.type, (RDFNode)classD);
        Assert.assertFalse((boolean)inf.contains(a, RDF.type, (RDFNode)classD));
        Assert.assertTrue((boolean)inf.contains(a, RDF.type, (RDFNode)classC));
        Assert.assertFalse((boolean)inf.contains(b, RDF.type, (RDFNode)classD));
        Assert.assertTrue((boolean)inf.contains(b, RDF.type, (RDFNode)classC));
        Assert.assertFalse((boolean)inf.contains(c, RDF.type, (RDFNode)classD));
        Assert.assertTrue((boolean)inf.contains(c, RDF.type, (RDFNode)classC));
        Assert.assertFalse((boolean)inf.contains(d, RDF.type, (RDFNode)classD));
        Assert.assertFalse((boolean)inf.contains(d, RDF.type, (RDFNode)classC));
        Assert.assertTrue((boolean)inf.contains(a, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classC.getURI())));
        Assert.assertTrue((boolean)inf.contains(b, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classC.getURI())));
        Assert.assertTrue((boolean)inf.contains(c, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classC.getURI())));
        Assert.assertTrue((boolean)inf.contains(d, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classC.getURI())));
        Assert.assertFalse((boolean)inf.contains(a, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classD.getURI())));
        Assert.assertFalse((boolean)inf.contains(b, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classD.getURI())));
        Assert.assertFalse((boolean)inf.contains(c, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classD.getURI())));
        Assert.assertFalse((boolean)inf.contains(d, (Property)mostSpecificType, (RDFNode)ResourceFactory.createResource((String)classD.getURI())));
    }

    @Test
    public void recomputeABox1() throws InterruptedException {
        OntModel tBox = this.createTBoxModel();
        ObjectProperty P = this.createObjectProperty(tBox, "http://test.vivo/P", "property P");
        ObjectProperty Q = this.createObjectProperty(tBox, "http://test.vivo/Q", "property Q");
        ObjectProperty S = this.createObjectProperty(tBox, "http://test.vivo/S", "property S");
        ObjectProperty T = this.createObjectProperty(tBox, "http://test.vivo/T", "property T");
        Literal literal1 = tBox.createLiteral("Literal value 1");
        Literal literal2 = tBox.createLiteral("Literal value 2");
        Model inf = ModelFactory.createDefaultModel();
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        SimpleReasoner simpleReasoner = new SimpleReasoner(tBox, aBox, inf);
        aBox.register((ModelChangedListener)simpleReasoner);
        Individual a = aBox.createIndividual("http://test.vivo/a", OWL.Thing);
        Individual b = aBox.createIndividual("http://test.vivo/b", OWL.Thing);
        Individual c = aBox.createIndividual("http://test.vivo/c", OWL.Thing);
        Individual d = aBox.createIndividual("http://test.vivo/d", OWL.Thing);
        aBox.add((Resource)a, (Property)P, (RDFNode)c);
        aBox.add((Resource)a, (Property)S, (RDFNode)literal1);
        aBox.add((Resource)b, (Property)Q, (RDFNode)d);
        aBox.add((Resource)b, (Property)T, (RDFNode)literal2);
        aBox.add((Resource)a, OWL.sameAs, (RDFNode)b);
        Assert.assertTrue((boolean)inf.contains((Resource)b, OWL.sameAs, (RDFNode)a));
        Assert.assertTrue((boolean)inf.contains((Resource)b, (Property)P, (RDFNode)c));
        Assert.assertTrue((boolean)inf.contains((Resource)b, (Property)S, (RDFNode)literal1));
        Assert.assertTrue((boolean)inf.contains((Resource)a, (Property)Q, (RDFNode)d));
        Assert.assertTrue((boolean)inf.contains((Resource)a, (Property)T, (RDFNode)literal2));
        inf.remove((Resource)b, OWL.sameAs, (RDFNode)a);
        inf.remove((Resource)b, (Property)P, (RDFNode)c);
        inf.remove((Resource)b, (Property)S, (RDFNode)literal1);
        inf.remove((Resource)a, (Property)Q, (RDFNode)d);
        inf.remove((Resource)a, (Property)T, (RDFNode)literal2);
        simpleReasoner.recompute();
        while (simpleReasoner.isRecomputing()) {
            Thread.sleep(this.delay);
        }
        Assert.assertTrue((boolean)inf.contains((Resource)b, OWL.sameAs, (RDFNode)a));
        Assert.assertTrue((boolean)inf.contains((Resource)b, (Property)P, (RDFNode)c));
        Assert.assertTrue((boolean)inf.contains((Resource)b, (Property)S, (RDFNode)literal1));
        Assert.assertTrue((boolean)inf.contains((Resource)a, (Property)Q, (RDFNode)d));
        Assert.assertTrue((boolean)inf.contains((Resource)a, (Property)T, (RDFNode)literal2));
    }

    SimpleReasonerTBoxListener getTBoxListener(SimpleReasoner simpleReasoner) {
        return new SimpleReasonerTBoxListener(simpleReasoner, new Exception().getStackTrace()[1].getMethodName());
    }

    void printModel(Model model, String modelName) {
        System.out.println("\nThe " + modelName + " model has " + model.size() + " statements:");
        System.out.println("---------------------------------------------------------------------");
        model.write((OutputStream)System.out);
    }

    void printModel(OntModel ontModel, String modelName) {
        System.out.println("\nThe " + modelName + " model has " + ontModel.size() + " statements:");
        System.out.println("---------------------------------------------------------------------");
        ontModel.writeAll((OutputStream)System.out, "N3", null);
    }
}

