/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.exclusions;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.IndividualImpl;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.searchindex.exclusions.ExcludeBasedOnType;
import java.util.ArrayList;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class ExcludeBasedOnTypeTest {
    @Test
    public void testCheckForExclusion() {
        ExcludeBasedOnType ebot = new ExcludeBasedOnType();
        ebot.addTypeToExclude("http://xmlns.com/foaf/0.1/Person");
        IndividualImpl ind = new IndividualImpl();
        ind.setURI("http://example.com/n2343");
        VClass personClass = new VClass("http://xmlns.com/foaf/0.1/Person");
        ind.setVClasses(Collections.singletonList(personClass), false);
        String excludeResult = ebot.checkForExclusion((Individual)ind);
        Assert.assertNotNull((Object)excludeResult);
    }

    @Test
    public void testCheckForExclusion2() {
        ExcludeBasedOnType ebot = new ExcludeBasedOnType();
        ebot.addTypeToExclude("http://example.com/KillerRobot");
        IndividualImpl ind = new IndividualImpl();
        ind.setURI("http://example.com/n2343");
        ArrayList<VClass> vClassList = new ArrayList<VClass>();
        vClassList.add(new VClass("http://xmlns.com/foaf/0.1/Agent"));
        vClassList.add(new VClass("http://example.com/Robot"));
        vClassList.add(new VClass("http://example.com/KillerRobot"));
        vClassList.add(new VClass("http://example.com/Droid"));
        ind.setVClasses(vClassList, false);
        String excludeResult = ebot.checkForExclusion((Individual)ind);
        Assert.assertNotNull((Object)excludeResult);
    }

    @Test
    public void testCheckForNonExclusion() {
        ExcludeBasedOnType ebot = new ExcludeBasedOnType();
        ebot.addTypeToExclude("http://xmlns.com/foaf/0.1/Person");
        IndividualImpl ind = new IndividualImpl();
        ind.setURI("http://example.com/n2343");
        VClass personClass = new VClass("http://xmlns.com/foaf/0.1/Robot");
        ind.setVClasses(Collections.singletonList(personClass), false);
        String excludeResult = ebot.checkForExclusion((Individual)ind);
        Assert.assertNull((Object)excludeResult);
    }

    @Test
    public void testCheckForNonExclusion2() {
        ExcludeBasedOnType ebot = new ExcludeBasedOnType();
        ebot.addTypeToExclude("http://xmlns.com/foaf/0.1/Person");
        IndividualImpl ind = new IndividualImpl();
        ind.setURI("http://example.com/n2343");
        ArrayList<VClass> vClassList = new ArrayList<VClass>();
        vClassList.add(new VClass("http://xmlns.com/foaf/0.1/Agent"));
        vClassList.add(new VClass("http://example.com/Robot"));
        vClassList.add(new VClass("http://example.com/KillerRobot"));
        vClassList.add(new VClass("http://example.com/Droid"));
        ind.setVClasses(vClassList, false);
        String excludeResult = ebot.checkForExclusion((Individual)ind);
        Assert.assertNull((Object)excludeResult);
    }
}

