/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.startup;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.startup.StartupManager;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.javax.servlet.ServletContextStub;

public class StartupManagerTest
extends AbstractTestClass {
    private static final Log log = LogFactory.getLog(StartupManagerTest.class);
    private ServletContextStub ctx;
    private ServletContextEvent sce;
    private StartupManager sm;
    private StartupStatus ss;

    @Before
    public void setup() {
        this.ctx = new ServletContextStub();
        this.sce = new ServletContextEvent((ServletContext)this.ctx);
        this.sm = new StartupManager();
        this.ss = StartupStatus.getBean((ServletContext)this.ctx);
        StartupManagerTest.setLoggerLevel(StartupStatus.class, Level.OFF);
        StartupManagerTest.setLoggerLevel(StartupManager.class, Level.OFF);
    }

    @After
    public void dumpForDebug() {
        if (log.isDebugEnabled()) {
            this.dumpStatus();
        }
    }

    @Test
    public void noSuchFile() {
        this.assertStartupFails((String)null);
    }

    @Test
    public void emptyFile() {
        this.assertStartupSucceeds(new Class[0]);
    }

    @Test
    public void blankLine() {
        this.assertStartupSucceeds("    \n");
    }

    @Test
    public void commentLines() {
        this.assertStartupSucceeds("# comment line    \n    # comment line starting with spaces\n");
    }

    @Test
    public void classDoesNotExist() {
        this.assertStartupFails("no.such.class\n");
    }

    @Test
    public void classThrowsExceptionWhenLoading() {
        this.assertStartupFails(ThrowsExceptionWhenLoading.class);
    }

    @Test
    public void classIsPrivate() {
        this.assertStartupFails(PrivateClass.class);
    }

    @Test
    public void noDefaultConstructor() {
        this.assertStartupFails(NoDefaultConstructor.class);
    }

    @Test
    public void constructorIsPrivate() {
        this.assertStartupFails(PrivateConstructor.class);
    }

    @Test
    public void constructorThrowsException() {
        this.assertStartupFails(ConstructorThrowsException.class);
    }

    @Test
    public void notAServletContextListener() {
        this.assertStartupFails(NotAListener.class);
    }

    @Test
    public void listenerThrowsException() {
        this.assertStartupFails(InitThrowsException.class);
    }

    @Test
    public void listenerSetsFatalStatus() {
        this.assertStartupFails(InitSetsFatalStatus.class);
    }

    @Test
    public void success() {
        String listener1Name = SucceedsWithInfo.class.getName();
        String listener2Name = SucceedsWithWarning.class.getName();
        this.assertStartupSucceeds(SucceedsWithInfo.class, SucceedsWithWarning.class);
        List items = this.ss.getStatusItems();
        Assert.assertEquals((String)"how many", (long)2L, (long)items.size());
        Assert.assertEquals((String)"init order 1", (Object)listener1Name, (Object)((StartupStatus.StatusItem)items.get(0)).getSourceName());
        Assert.assertEquals((String)"init order 2", (Object)listener2Name, (Object)((StartupStatus.StatusItem)items.get(1)).getSourceName());
        this.sm.contextDestroyed(this.sce);
        items = this.ss.getStatusItems();
        Assert.assertEquals((String)"how many", (long)4L, (long)items.size());
        Assert.assertEquals((String)"destroy order 1", (Object)listener2Name, (Object)((StartupStatus.StatusItem)items.get(2)).getSourceName());
        Assert.assertEquals((String)"destroy order 2", (Object)listener1Name, (Object)((StartupStatus.StatusItem)items.get(3)).getSourceName());
    }

    @Test
    public void duplicateListeners() {
        this.assertStartupFails(SucceedsWithInfo.class, SucceedsWithWarning.class, SucceedsWithInfo.class);
    }

    @Test
    public void dontExecuteAfterFailure() {
        this.assertStartupFails(InitThrowsException.class, SucceedsWithInfo.class);
        for (StartupStatus.StatusItem item : this.ss.getStatusItems()) {
            if (!item.getSourceName().equals(SucceedsWithInfo.class.getName()) || item.getLevel() != StartupStatus.StatusItem.Level.NOT_EXECUTED) continue;
            return;
        }
        Assert.fail((String)("'" + SucceedsWithInfo.class.getName() + "' should not have been run after '" + PrivateConstructor.class.getName() + "' failed."));
    }

    private void assertStartupFails(String fileContents) {
        if (fileContents != null) {
            this.ctx.setMockResource("/WEB-INF/resources/startup_listeners.txt", fileContents);
        }
        this.sm.contextInitialized(this.sce);
        Assert.assertTrue((String)"expecting abort", (boolean)this.ss.isStartupAborted());
    }

    private void assertStartupFails(Class<?> ... classes) {
        this.assertStartupFails(this.joinClassNames(classes));
    }

    private void assertStartupSucceeds(String fileContents) {
        if (fileContents != null) {
            this.ctx.setMockResource("/WEB-INF/resources/startup_listeners.txt", fileContents);
        }
        this.sm.contextInitialized(this.sce);
        Assert.assertFalse((String)"expecting success", (boolean)this.ss.isStartupAborted());
    }

    private void assertStartupSucceeds(Class<?> ... classes) {
        this.assertStartupSucceeds(this.joinClassNames(classes));
    }

    private String joinClassNames(Class<?>[] classes) {
        if (classes == null) {
            return null;
        }
        if (classes.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < classes.length; ++i) {
            result.append(classes[i].getName()).append('\n');
        }
        return result.toString();
    }

    private void dumpStatus() {
        List items = this.ss.getStatusItems();
        log.debug((Object)("-------------- " + items.size() + " items"));
        for (StartupStatus.StatusItem item : items) {
            log.debug((Object)String.format("%8s %s \n  %s \n  %s", item.getLevel(), item.getSourceName(), item.getMessage(), item.getCause()));
        }
    }

    public static class SucceedsWithWarning
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent sce) {
            StartupStatus.getBean((ServletContext)sce.getServletContext()).warning((ServletContextListener)this, "Set warning message on init.");
        }

        public void contextDestroyed(ServletContextEvent sce) {
            StartupStatus.getBean((ServletContext)sce.getServletContext()).warning((ServletContextListener)this, "Set warning message on destroy.");
        }
    }

    public static class SucceedsWithInfo
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent sce) {
            StartupStatus.getBean((ServletContext)sce.getServletContext()).info((ServletContextListener)this, "Set info message on init.");
        }

        public void contextDestroyed(ServletContextEvent sce) {
            StartupStatus.getBean((ServletContext)sce.getServletContext()).info((ServletContextListener)this, "Set info message on destroy.");
        }
    }

    public static class InitSetsFatalStatus
    extends BasicListener {
        @Override
        public void contextInitialized(ServletContextEvent sce) {
            StartupStatus.getBean((ServletContext)sce.getServletContext()).fatal((ServletContextListener)this, "Set fatal status");
        }
    }

    public static class InitThrowsException
    extends BasicListener {
        @Override
        public void contextInitialized(ServletContextEvent sce) {
            throw new IllegalStateException("Initialization failed.");
        }
    }

    public static class NotAListener {
    }

    public static class ConstructorThrowsException
    extends BasicListener {
        public ConstructorThrowsException() {
            throw new IllegalStateException("can't load me.");
        }
    }

    public static class PrivateConstructor
    extends BasicListener {
        private PrivateConstructor() {
        }
    }

    public static class NoDefaultConstructor
    extends BasicListener {
        public NoDefaultConstructor(String bogus) {
            bogus.length();
        }
    }

    private static class PrivateClass
    extends BasicListener {
        private PrivateClass() {
        }
    }

    public static class ThrowsExceptionWhenLoading
    extends BasicListener {
        static {
            throw new IllegalStateException("can't load me.");
        }
    }

    public static class BasicListener
    implements ServletContextListener {
        public void contextDestroyed(ServletContextEvent sce) {
        }

        public void contextInitialized(ServletContextEvent sce) {
        }
    }
}

