/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.configuration;

import edu.cornell.mannlib.vitro.testing.ModelUtilitiesTestHelper;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccess;
import edu.cornell.mannlib.vitro.webapp.modelaccess.RequestModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoader;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoaderException;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoaderTestBase;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationRdfParser;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ContextModelsUser;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.InstanceWrapper;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Property;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.PropertyType;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.RequestModelsUser;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Validation;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.WrappedInstance;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Statement;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ConfigurationBeanLoaderTest
extends ConfigurationBeanLoaderTestBase {
    private static final Statement[] FULL_SUCCESS_STATEMENTS = new Statement[]{ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/full_success_instance", ConfigurationBeanLoader.toJavaUri(FullSuccessResultClass.class)), ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/full_success_instance", ConfigurationBeanLoader.toJavaUri(FullSuccessConcreteClass.class)), ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/full_success_instance", "http://mydomain.edu/hasBoost", Float.valueOf(1.5f), XSDDatatype.XSDfloat), ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/full_success_instance", "http://mydomain.edu/hasBoost", Float.valueOf(-99.0f), XSDDatatype.XSDfloat), ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/full_success_instance", "http://mydomain.edu/hasText", (Object)"Huey", XSDDatatype.XSDstring), ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/full_success_instance", "http://mydomain.edu/hasText", "Dewey", "en-US"), ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/full_success_instance", "http://mydomain.edu/hasText", "Louis"), ModelUtilitiesTestHelper.objectProperty("http://mytest.edu/full_success_instance", "http://mydomain.edu/hasHelper", "http://mytest.edu/full_success_helper_instance"), ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/full_success_helper_instance", ConfigurationBeanLoader.toJavaUri(FullSuccessHelperResultClass.class)), ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/full_success_helper_instance", ConfigurationBeanLoader.toJavaUri(FullSuccessHelperConcreteClass.class))};

    @Test
    public void constructor_modelIsNull_throwsException() {
        this.expectException(NullPointerException.class, "model may not be null");
        ConfigurationBeanLoader unused = new ConfigurationBeanLoader((Model)null);
    }

    @Test
    public void loadInstance_uriIsNull_throwsException() throws ConfigurationBeanLoaderException {
        this.expectException(NullPointerException.class, "uri may not be null");
        Object unused = this.loader.loadInstance(null, SimpleSuccess.class);
    }

    @Test
    public void load_instance_resultClassIsNull_throwsException() throws ConfigurationBeanLoaderException {
        this.expectException(NullPointerException.class, "resultClass may not be null");
        Object unused = this.loader.loadInstance("http://mytest.edu/some_instance", null);
    }

    @Test
    public void noStatementsAboutUri_throwsException() throws ConfigurationBeanLoaderException {
        this.expectSimpleFailure(SimpleSuccess.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(ConfigurationRdfParser.InvalidConfigurationRdfException.class, "The model contains no statements about"));
    }

    @Test
    public void uriDoesNotDeclareResultClassAsType_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/some_instance", "http://some.simple/property", "a value"));
        this.expectSimpleFailure(SimpleSuccess.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(ConfigurationRdfParser.InvalidConfigurationRdfException.class, "A type statement is required"));
    }

    @Test
    public void uriHasNoConcreteType_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(SimpleInterfaceFailure.class)));
        this.expectSimpleFailure(SimpleInterfaceFailure.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(ConfigurationRdfParser.InvalidConfigurationRdfException.class, "No concrete class is declared"));
    }

    @Test
    public void uriHasMultipleConcreteTypes_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(SimpleSuccess.class)));
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(SecondConcreteClass.class)));
        this.expectSimpleFailure(SimpleSuccess.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(ConfigurationRdfParser.InvalidConfigurationRdfException.class, "more than one concrete class"));
    }

    @Test
    public void cantLoadConcreteType_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(UnloadableClass.class)));
        this.expectSimpleFailure(UnloadableClass.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(ConfigurationRdfParser.InvalidConfigurationRdfException.class, "Can't load this type"));
    }

    @Test
    public void concreteTypeNotAssignableToResultClass_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(SimpleSuccess.class)));
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(String.class)));
        this.expectSimpleFailure(SimpleSuccess.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(ConfigurationRdfParser.InvalidConfigurationRdfException.class, "cannot be assigned to class"));
    }

    @Test
    public void noNiladicConstructor_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(NoNiladicConstructor.class)));
        this.expectSimpleFailure(NoNiladicConstructor.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(ConfigurationRdfParser.InvalidConfigurationRdfException.class, "no zero-argument constructor."));
    }

    @Test
    public void niladicConstructorNotAccessible_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(PrivateConstructor.class)));
        this.expectSimpleFailure(PrivateConstructor.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(ConfigurationRdfParser.InvalidConfigurationRdfException.class, "no zero-argument constructor."));
    }

    @Test
    public void constructorThrowsException_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(ConstructorFails.class)));
        this.expectSimpleFailure(ConstructorFails.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(InstanceWrapper.InstanceWrapperException.class, "Failed to create an instance."));
    }

    @Test
    public void loaderCantSatisfyContextModelsUser_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(NeedsContextModels.class)));
        this.loader = this.noContextLoader;
        this.expectSimpleFailure(NeedsContextModels.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(WrappedInstance.ResourceUnavailableException.class, "Cannot satisfy ContextModelsUser"));
    }

    @Test
    public void loaderCantSatisfyRequestModelsUser_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(NeedsRequestModels.class)));
        this.loader = this.noRequestLoader;
        this.expectSimpleFailure(NeedsRequestModels.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(WrappedInstance.ResourceUnavailableException.class, "Cannot satisfy RequestModelsUser"));
    }

    @Test
    public void tripleHasUnrecognizedProperty_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(SimpleSuccess.class)));
        this.model.add(ModelUtilitiesTestHelper.dataProperty("http://mytest.edu/some_instance", "http://bogus.property/name", "No place to put it."));
        this.expectSimpleFailure(SimpleSuccess.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(WrappedInstance.NoSuchPropertyMethodException.class, "No property method"));
    }

    @Test
    public void valueTypeDoesNotMatchArgumentOfPropertyMethod_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(ExpectingAString.class)));
        this.model.add(ModelUtilitiesTestHelper.objectProperty("http://mytest.edu/some_instance", "http://mytest.edu/some_property", "http://some.other/uri"));
        this.expectSimpleFailure(ExpectingAString.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(PropertyType.PropertyTypeException.class, "type RESOURCE to a method of type STRING"));
    }

    @Test
    public void subordinateObjectCantBeLoaded_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(NoSuchSubordinateInstance.class)));
        this.model.add(ModelUtilitiesTestHelper.objectProperty("http://mytest.edu/some_instance", "http://mytest.edu/some_property", "http://some.other/uri"));
        this.expectSimpleFailure(NoSuchSubordinateInstance.class, this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"), this.throwable(ConfigurationBeanLoaderException.class, "Failed to load"));
    }

    @Test
    public void simpleSuccess() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/simple_success_instance", ConfigurationBeanLoader.toJavaUri(SimpleSuccess.class)));
        SimpleSuccess instance = (SimpleSuccess)this.loader.loadInstance("http://mytest.edu/simple_success_instance", SimpleSuccess.class);
        Assert.assertNotNull((Object)instance);
    }

    @Test
    public void fullSuccess() throws ConfigurationBeanLoaderException {
        this.model.add(FULL_SUCCESS_STATEMENTS);
        FullSuccessResultClass instance = (FullSuccessResultClass)this.loader.loadInstance("http://mytest.edu/full_success_instance", FullSuccessResultClass.class);
        Assert.assertNotNull((Object)instance);
        HashSet<String> expectedTextValues = new HashSet<String>(Arrays.asList("Huey", "Dewey", "Louis"));
        Assert.assertEquals(expectedTextValues, instance.getTextValues());
        HashSet<Float> expectedBoostValues = new HashSet<Float>(Arrays.asList(Float.valueOf(1.5f), Float.valueOf(-99.0f)));
        Assert.assertEquals(expectedBoostValues, instance.getBoostValues());
        Assert.assertEquals((long)1L, (long)instance.getHelpers().size());
        Assert.assertTrue((boolean)instance.isValidated());
    }

    @Test
    public void irrelevantNonConcreteTypesAreIgnored() throws ConfigurationBeanLoaderException {
        this.model.add(new Statement[]{ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/simple_success_instance", ConfigurationBeanLoader.toJavaUri(SimpleSuccess.class)), ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/simple_success_instance", ConfigurationBeanLoader.toJavaUri(IrrelevantInterface.class)), ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/simple_success_instance", ConfigurationBeanLoader.toJavaUri(IrrelevantAbstractClass.class)), ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/simple_success_instance", "http://irrelevant.nonJava/class")});
        SimpleSuccess instance = (SimpleSuccess)this.loader.loadInstance("http://mytest.edu/simple_success_instance", SimpleSuccess.class);
        Assert.assertNotNull((Object)instance);
    }

    @Test
    public void loaderHasNoRequestButClassDoesntRequireIt_success() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/simple_success_instance", ConfigurationBeanLoader.toJavaUri(SimpleSuccess.class)));
        this.loader = this.noRequestLoader;
        SimpleSuccess instance = (SimpleSuccess)this.loader.loadInstance("http://mytest.edu/simple_success_instance", SimpleSuccess.class);
        Assert.assertNotNull((Object)instance);
    }

    @Test
    public void loaderHasNoContextButClassDoesntRequireIt_success() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/simple_success_instance", ConfigurationBeanLoader.toJavaUri(SimpleSuccess.class)));
        this.loader = this.noContextLoader;
        SimpleSuccess instance = (SimpleSuccess)this.loader.loadInstance("http://mytest.edu/simple_success_instance", SimpleSuccess.class);
        Assert.assertNotNull((Object)instance);
    }

    @Test
    public void noValuesForProperty_success() throws ConfigurationBeanLoaderException {
        this.model.add(new Statement[]{ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/full_success_instance", ConfigurationBeanLoader.toJavaUri(FullSuccessConcreteClass.class)), ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/full_success_instance", ConfigurationBeanLoader.toJavaUri(FullSuccessResultClass.class))});
        FullSuccessResultClass instance = (FullSuccessResultClass)this.loader.loadInstance("http://mytest.edu/full_success_instance", FullSuccessResultClass.class);
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals(Collections.emptySet(), instance.getTextValues());
        Assert.assertEquals(Collections.emptySet(), instance.getBoostValues());
        Assert.assertEquals(Collections.emptySet(), instance.getHelpers());
        Assert.assertTrue((boolean)instance.isValidated());
    }

    @Test
    public void loadAll_oneObjectCantBeLoaded_throwsException() throws ConfigurationBeanLoaderException {
        this.model.add(new Statement[]{ModelUtilitiesTestHelper.typeStatement("http://apple/good", ConfigurationBeanLoader.toJavaUri(OneBadAppleSpoilsTheBunch.class)), ModelUtilitiesTestHelper.typeStatement("http://apple/good", ConfigurationBeanLoader.toJavaUri(AGoodApple.class)), ModelUtilitiesTestHelper.typeStatement("http://apple/bad", ConfigurationBeanLoader.toJavaUri(OneBadAppleSpoilsTheBunch.class))});
        this.expectException(ConfigurationBeanLoaderException.class, "Failed to load", ConfigurationRdfParser.InvalidConfigurationRdfException.class, "No concrete class is declared");
        this.loader.loadAll(OneBadAppleSpoilsTheBunch.class);
    }

    @Test
    public void loadAll_noResults_success() throws ConfigurationBeanLoaderException {
        Set instances = this.loader.loadAll(SimpleSuccess.class);
        Assert.assertTrue((boolean)instances.isEmpty());
    }

    @Test
    public void loadAll_oneResult_success() throws ConfigurationBeanLoaderException {
        this.model.add(ModelUtilitiesTestHelper.typeStatement("http://mytest.edu/some_instance", ConfigurationBeanLoader.toJavaUri(SimpleSuccess.class)));
        Set instances = this.loader.loadAll(SimpleSuccess.class);
        Assert.assertEquals((long)1L, (long)instances.size());
    }

    @Test
    public void loadAll_multipleResults_success() throws ConfigurationBeanLoaderException {
        this.model.add(new Statement[]{ModelUtilitiesTestHelper.typeStatement("http://simple.instance/one", ConfigurationBeanLoader.toJavaUri(InstanceWithProperty.class)), ModelUtilitiesTestHelper.dataProperty("http://simple.instance/one", "http://simple.text/property", "FIRST"), ModelUtilitiesTestHelper.typeStatement("http://simple.instance/two", ConfigurationBeanLoader.toJavaUri(InstanceWithProperty.class)), ModelUtilitiesTestHelper.dataProperty("http://simple.instance/two", "http://simple.text/property", "SECOND")});
        Set instances = this.loader.loadAll(InstanceWithProperty.class);
        Assert.assertEquals((long)2L, (long)instances.size());
        HashSet<String> textValues = new HashSet<String>();
        for (InstanceWithProperty instance : instances) {
            textValues.add(instance.getText());
        }
        Assert.assertEquals(new HashSet<String>(Arrays.asList("FIRST", "SECOND")), textValues);
    }

    @Test
    @Ignore
    public void circularReferencesAreNotFatal() throws ConfigurationBeanLoaderException {
        Assert.fail((String)"circularReferencesAreNotFatal not implemented");
    }

    @Test
    @Ignore
    public void subordinateObjectCantBeLoaded_leavesNoAccessibleInstanceOfParent() throws ConfigurationBeanLoaderException {
        Assert.fail((String)"subordinateObjectCantBeLoaded_leavesNoAccessibleInstanceOfParent not implemented");
    }

    @Test
    @Ignore
    public void parentObjectCantBeLoaded_leavesNoAccessibleInstanceOfSubordinate() throws ConfigurationBeanLoaderException {
        Assert.fail((String)"parentObjectCantBeLoaded_leavesNoAccessibleInstanceOfSubordinate not implemented");
    }

    public static class InstanceWithProperty {
        private String text;

        @Property(uri="http://simple.text/property")
        public void setText(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }

    public static class AGoodApple
    implements OneBadAppleSpoilsTheBunch {
    }

    public static interface OneBadAppleSpoilsTheBunch {
    }

    public abstract class IrrelevantAbstractClass {
    }

    public static interface IrrelevantInterface {
    }

    public static class FullSuccessHelperConcreteClass
    extends FullSuccessHelperResultClass {
    }

    public static abstract class FullSuccessHelperResultClass {
    }

    public static class FullSuccessConcreteClass
    implements FullSuccessResultClass {
        private Set<String> textValues = new HashSet<String>();
        private Set<Float> boostValues = new HashSet<Float>();
        private Set<FullSuccessHelperResultClass> helpers = new HashSet<FullSuccessHelperResultClass>();
        private boolean validatorOneHasRun;
        private boolean validatorTwoHasRun;

        @Property(uri="http://mydomain.edu/hasText")
        public void addText(String text) {
            this.textValues.add(text);
        }

        @Property(uri="http://mydomain.edu/hasBoost")
        public void addBoost(float boost) {
            this.boostValues.add(Float.valueOf(boost));
        }

        @Property(uri="http://mydomain.edu/hasHelper")
        public void addHelper(FullSuccessHelperResultClass helper) {
            this.helpers.add(helper);
        }

        @Validation
        public void validatorOne() {
            if (this.validatorOneHasRun) {
                throw new RuntimeException("validatorOne has already run.");
            }
            this.validatorOneHasRun = true;
        }

        @Validation
        public void validatorTwo() {
            if (this.validatorTwoHasRun) {
                throw new RuntimeException("validatorTwo has already run.");
            }
            this.validatorTwoHasRun = true;
        }

        @Override
        public Set<String> getTextValues() {
            return this.textValues;
        }

        @Override
        public Set<Float> getBoostValues() {
            return this.boostValues;
        }

        @Override
        public Set<FullSuccessHelperResultClass> getHelpers() {
            return this.helpers;
        }

        @Override
        public boolean isValidated() {
            return this.validatorOneHasRun && this.validatorTwoHasRun;
        }
    }

    public static interface FullSuccessResultClass {
        public Set<String> getTextValues();

        public Set<Float> getBoostValues();

        public Set<FullSuccessHelperResultClass> getHelpers();

        public boolean isValidated();
    }

    public static class SimpleSuccess {
    }

    public static class NoSuchSubordinateInstance {
        @Property(uri="http://mytest.edu/some_property")
        public void setHelper(SimpleDateFormat sdf) {
        }
    }

    public static class ExpectingAString {
        @Property(uri="http://mytest.edu/some_property")
        public void setString(String s) {
        }
    }

    public static class NeedsRequestModels
    implements RequestModelsUser {
        public void setRequestModels(RequestModelAccess models) {
        }
    }

    public static class NeedsContextModels
    implements ContextModelsUser {
        public void setContextModels(ContextModelAccess models) {
        }
    }

    public static class ConstructorFails {
        public ConstructorFails() {
            throw new IllegalStateException("The constructor throws an exception.");
        }
    }

    public static class PrivateConstructor {
        private PrivateConstructor() {
        }
    }

    public static class NoNiladicConstructor {
        public NoNiladicConstructor(String s) {
        }
    }

    public static class UnloadableClass {
        static {
            throw new IllegalStateException("This class cannot be loaded.");
        }
    }

    public static class SecondConcreteClass
    extends SimpleSuccess {
    }

    public static interface SimpleInterfaceFailure {
    }
}

