/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.dump;

import freemarker.core.CollectionAndSequence;
import freemarker.core.Environment;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.CollectionModel;
import freemarker.ext.dump.BaseDumpDirective;
import freemarker.ext.dump.DumpDirective;
import freemarker.template.Configuration;
import freemarker.template.SimpleCollection;
import freemarker.template.Template;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DumpDirectiveTest {
    private Template template;

    @Before
    public void setUp() {
        Configuration config = new Configuration();
        String templateStr = "";
        try {
            this.template = new Template("template", (Reader)new StringReader(templateStr), config);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Logger.getLogger(BaseDumpDirective.class).setLevel(Level.OFF);
    }

    @Test
    public void dumpUndefinedValue() {
        String varName = "dog";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        HashMap<String, String> expectedDumpValue = new HashMap<String, String>();
        expectedDumpValue.put(BaseDumpDirective.Key.VALUE.toString(), BaseDumpDirective.Value.UNDEFINED.toString());
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.test(varName, dataModel, expectedDump);
    }

    @Test
    public void dumpString() {
        String varName = "dog";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        String value = "Rover";
        dataModel.put(varName, value);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.STRING);
        expectedDumpValue.put(BaseDumpDirective.Key.VALUE.toString(), value);
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.test(varName, dataModel, expectedDump);
    }

    @Test
    public void dumpBoolean() {
        String varName = "isLoggedIn";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        boolean value = true;
        dataModel.put(varName, value);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.BOOLEAN);
        expectedDumpValue.put(BaseDumpDirective.Key.VALUE.toString(), value);
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.test(varName, dataModel, expectedDump);
    }

    @Test
    public void dumpNumber() {
        String varName = "tabCount";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        int value = 7;
        dataModel.put(varName, value);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.NUMBER);
        expectedDumpValue.put(BaseDumpDirective.Key.VALUE.toString(), value);
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.test(varName, dataModel, expectedDump);
    }

    @Test
    public void dumpSimpleDate() {
        String varName = "now";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        java.util.Date now = new java.util.Date();
        dataModel.put(varName, now);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.DATE);
        expectedDumpValue.put(BaseDumpDirective.Key.DATE_TYPE.toString(), BaseDumpDirective.DateType.UNKNOWN);
        expectedDumpValue.put(BaseDumpDirective.Key.VALUE.toString(), now);
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.test(varName, dataModel, expectedDump);
    }

    @Test
    public void dumpCalendarDate() {
        String varName = "myDate";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        Calendar c = Calendar.getInstance();
        c.set(1991, 4, 5);
        java.util.Date myDate = c.getTime();
        dataModel.put("myDate", myDate);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.DATE);
        expectedDumpValue.put(BaseDumpDirective.Key.DATE_TYPE.toString(), BaseDumpDirective.DateType.UNKNOWN);
        expectedDumpValue.put(BaseDumpDirective.Key.VALUE.toString(), myDate);
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.test(varName, dataModel, expectedDump);
    }

    @Test
    public void dumpDateTime() {
        String varName = "timestamp";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        Timestamp ts = new Timestamp(1302297332043L);
        dataModel.put(varName, ts);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.DATE);
        expectedDumpValue.put(BaseDumpDirective.Key.DATE_TYPE.toString(), BaseDumpDirective.DateType.DATETIME);
        expectedDumpValue.put(BaseDumpDirective.Key.VALUE.toString(), ts);
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.test(varName, dataModel, expectedDump);
    }

    @Test
    public void dumpSqlDate() {
        String varName = "date";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        Date date = new Date(1302297332043L);
        dataModel.put(varName, date);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.DATE);
        expectedDumpValue.put(BaseDumpDirective.Key.DATE_TYPE.toString(), BaseDumpDirective.DateType.DATE);
        expectedDumpValue.put(BaseDumpDirective.Key.VALUE.toString(), date);
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.test(varName, dataModel, expectedDump);
    }

    @Test
    public void dumpTime() {
        String varName = "time";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        Time time = new Time(1302297332043L);
        dataModel.put(varName, time);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.DATE);
        expectedDumpValue.put(BaseDumpDirective.Key.DATE_TYPE.toString(), BaseDumpDirective.DateType.TIME);
        expectedDumpValue.put(BaseDumpDirective.Key.VALUE.toString(), time);
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.test(varName, dataModel, expectedDump);
    }

    @Test
    public void dumpHelplessMethod() {
        String varName = "square";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        HelplessMethod methodModel = new HelplessMethod();
        dataModel.put(varName, methodModel);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.METHOD);
        expectedDumpValue.put(BaseDumpDirective.Key.CLASS.toString(), methodModel.getClass().getName());
        expectedDumpValue.put(BaseDumpDirective.Key.HELP.toString(), null);
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.test(varName, dataModel, expectedDump);
    }

    @Test
    public void dumpHelpfulMethod() {
        String varName = "square";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        HelpfulMethod methodModel = new HelpfulMethod();
        dataModel.put(varName, methodModel);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.METHOD);
        expectedDumpValue.put(BaseDumpDirective.Key.CLASS.toString(), methodModel.getClass().getName());
        expectedDumpValue.put(BaseDumpDirective.Key.HELP.toString(), this.getMethodHelp(varName));
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.test(varName, dataModel, expectedDump);
    }

    @Test
    public void dumpMethodWithStringHelp() {
        String varName = "square";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        MethodWithStringHelp methodModel = new MethodWithStringHelp();
        dataModel.put(varName, methodModel);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.METHOD);
        expectedDumpValue.put(BaseDumpDirective.Key.CLASS.toString(), methodModel.getClass().getName());
        expectedDumpValue.put(BaseDumpDirective.Key.HELP.toString(), null);
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.test(varName, dataModel, expectedDump);
    }

    @Test
    public void dumpMethodWithStringStringMapHelp() {
        String varName = "square";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        MethodWithStringStringMapHelp methodModel = new MethodWithStringStringMapHelp();
        dataModel.put(varName, methodModel);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.METHOD);
        expectedDumpValue.put(BaseDumpDirective.Key.CLASS.toString(), methodModel.getClass().getName());
        expectedDumpValue.put(BaseDumpDirective.Key.HELP.toString(), new HashMap());
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.test(varName, dataModel, expectedDump);
    }

    @Test
    public void dumpHelplessDirective() {
        String varName = "dump";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        HelplessDirective directiveModel = new HelplessDirective();
        dataModel.put(varName, directiveModel);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.DIRECTIVE);
        expectedDumpValue.put(BaseDumpDirective.Key.CLASS.toString(), directiveModel.getClass().getName());
        expectedDumpValue.put(BaseDumpDirective.Key.HELP.toString(), null);
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.test(varName, dataModel, expectedDump);
    }

    @Test
    public void dumpHelpfulDirective() {
        String varName = "dump";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        HelpfulDirective directiveModel = new HelpfulDirective();
        dataModel.put(varName, directiveModel);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.DIRECTIVE);
        expectedDumpValue.put(BaseDumpDirective.Key.CLASS.toString(), directiveModel.getClass().getName());
        expectedDumpValue.put(BaseDumpDirective.Key.HELP.toString(), this.getDirectiveHelp(varName));
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.test(varName, dataModel, expectedDump);
    }

    @Test
    public void dumpDirectiveWithStringHelp() {
        String varName = "dump";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        DirectiveWithStringHelp directiveModel = new DirectiveWithStringHelp();
        dataModel.put(varName, directiveModel);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.DIRECTIVE);
        expectedDumpValue.put(BaseDumpDirective.Key.CLASS.toString(), directiveModel.getClass().getName());
        expectedDumpValue.put(BaseDumpDirective.Key.HELP.toString(), null);
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.test(varName, dataModel, expectedDump);
    }

    @Test
    public void dumpDirectiveWithStringStringMapHelp() {
        String varName = "dump";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        DirectiveWithStringStringMapHelp directiveModel = new DirectiveWithStringStringMapHelp();
        dataModel.put(varName, directiveModel);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.DIRECTIVE);
        expectedDumpValue.put(BaseDumpDirective.Key.CLASS.toString(), directiveModel.getClass().getName());
        expectedDumpValue.put(BaseDumpDirective.Key.HELP.toString(), new HashMap());
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.test(varName, dataModel, expectedDump);
    }

    @Test
    public void dumpStringList() {
        String varName = "fruit";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        ArrayList<String> myList = new ArrayList<String>();
        myList.add("apples");
        myList.add("bananas");
        myList.add("oranges");
        dataModel.put(varName, myList);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.SEQUENCE);
        ArrayList myListItemsExpectedDump = new ArrayList(myList.size());
        for (String str : myList) {
            HashMap<String, Object> itemDump = new HashMap<String, Object>();
            itemDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.STRING);
            itemDump.put(BaseDumpDirective.Key.VALUE.toString(), str);
            myListItemsExpectedDump.add(itemDump);
        }
        expectedDumpValue.put(BaseDumpDirective.Key.VALUE.toString(), myListItemsExpectedDump);
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.test(varName, dataModel, expectedDump);
    }

    @Test
    public void dumpStringArray() {
        String varName = "fruit";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        String[] myArray = new String[]{"apples", "bananas", "oranges"};
        dataModel.put(varName, myArray);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.SEQUENCE);
        ArrayList myArrayExpectedDumpValue = new ArrayList(myArray.length);
        for (String str : myArray) {
            HashMap<String, Object> itemDump = new HashMap<String, Object>();
            itemDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.STRING);
            itemDump.put(BaseDumpDirective.Key.VALUE.toString(), str);
            myArrayExpectedDumpValue.add(itemDump);
        }
        expectedDumpValue.put(BaseDumpDirective.Key.VALUE.toString(), myArrayExpectedDumpValue);
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.test(varName, dataModel, expectedDump);
    }

    @Test
    public void dumpMixedList() {
        String varName = "stuff";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        ArrayList<Object> mixedList = new ArrayList<Object>();
        String myString = "apples";
        mixedList.add(myString);
        int myInt = 4;
        mixedList.add(myInt);
        boolean myBool = true;
        mixedList.add(myBool);
        ArrayList<String> myList = new ArrayList<String>();
        myList.add("dog");
        myList.add("cat");
        myList.add("elephant");
        mixedList.add(myList);
        dataModel.put(varName, mixedList);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.SEQUENCE);
        ArrayList mixedListExpectedDumpValue = new ArrayList(mixedList.size());
        HashMap<String, Object> myStringExpectedDumpValue = new HashMap<String, Object>();
        myStringExpectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.STRING);
        myStringExpectedDumpValue.put(BaseDumpDirective.Key.VALUE.toString(), myString);
        mixedListExpectedDumpValue.add(myStringExpectedDumpValue);
        HashMap<String, Object> myIntExpectedDumpValue = new HashMap<String, Object>();
        myIntExpectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.NUMBER);
        myIntExpectedDumpValue.put(BaseDumpDirective.Key.VALUE.toString(), myInt);
        mixedListExpectedDumpValue.add(myIntExpectedDumpValue);
        HashMap<String, Object> myBoolExpectedDumpValue = new HashMap<String, Object>();
        myBoolExpectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.BOOLEAN);
        myBoolExpectedDumpValue.put(BaseDumpDirective.Key.VALUE.toString(), myBool);
        mixedListExpectedDumpValue.add(myBoolExpectedDumpValue);
        HashMap<String, Object> myListExpectedDumpValue = new HashMap<String, Object>();
        myListExpectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.SEQUENCE);
        ArrayList myListItemsExpectedDumpValue = new ArrayList(myList.size());
        for (String animal : myList) {
            HashMap<String, Object> itemDump = new HashMap<String, Object>();
            itemDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.STRING);
            itemDump.put(BaseDumpDirective.Key.VALUE.toString(), animal);
            myListItemsExpectedDumpValue.add(itemDump);
        }
        myListExpectedDumpValue.put(BaseDumpDirective.Key.VALUE.toString(), myListItemsExpectedDumpValue);
        mixedListExpectedDumpValue.add(myListExpectedDumpValue);
        expectedDumpValue.put(BaseDumpDirective.Key.VALUE.toString(), mixedListExpectedDumpValue);
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.test(varName, dataModel, expectedDump);
    }

    @Test
    public void dumpNumberSet() {
        String varName = "oddNums";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        HashSet<Integer> myIntSet = new HashSet<Integer>();
        for (int i = 0; i <= 10; ++i) {
            if (i % 2 != 1) continue;
            myIntSet.add(i);
        }
        dataModel.put(varName, myIntSet);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.SEQUENCE);
        ArrayList myIntSetExpectedDumpValue = new ArrayList(myIntSet.size());
        Iterator iterator = myIntSet.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            HashMap<String, Object> itemDump = new HashMap<String, Object>();
            itemDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.NUMBER);
            itemDump.put(BaseDumpDirective.Key.VALUE.toString(), i);
            myIntSetExpectedDumpValue.add(itemDump);
        }
        expectedDumpValue.put(BaseDumpDirective.Key.VALUE.toString(), myIntSetExpectedDumpValue);
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.test(varName, dataModel, expectedDump);
    }

    @Test
    public void dumpSimpleCollection() {
        String varName = "oddNums";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        HashSet<Integer> odds = new HashSet<Integer>();
        for (int i = 0; i <= 10; ++i) {
            if (i % 2 != 1) continue;
            odds.add(i);
        }
        SimpleCollection myCollection = new SimpleCollection(odds);
        dataModel.put(varName, myCollection);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.COLLECTION);
        ArrayList myCollectionExpectedDumpValue = new ArrayList(odds.size());
        Iterator iterator = odds.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            HashMap<String, Object> itemDump = new HashMap<String, Object>();
            itemDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.NUMBER);
            itemDump.put(BaseDumpDirective.Key.VALUE.toString(), i);
            myCollectionExpectedDumpValue.add(itemDump);
        }
        expectedDumpValue.put(BaseDumpDirective.Key.VALUE.toString(), myCollectionExpectedDumpValue);
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.test(varName, dataModel, expectedDump);
    }

    @Test
    public void dumpCollectionModel() {
        String varName = "oddNums";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        HashSet<Integer> odds = new HashSet<Integer>();
        for (int i = 0; i <= 10; ++i) {
            if (i % 2 != 1) continue;
            odds.add(i);
        }
        CollectionModel myCollection = new CollectionModel(odds, new BeansWrapper());
        dataModel.put(varName, myCollection);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.COLLECTION);
        ArrayList myCollectionExpectedDumpValue = new ArrayList(odds.size());
        Iterator iterator = odds.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            HashMap<String, Object> itemDump = new HashMap<String, Object>();
            itemDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.NUMBER);
            itemDump.put(BaseDumpDirective.Key.VALUE.toString(), i);
            myCollectionExpectedDumpValue.add(itemDump);
        }
        expectedDumpValue.put(BaseDumpDirective.Key.VALUE.toString(), myCollectionExpectedDumpValue);
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.test(varName, dataModel, expectedDump);
    }

    @Test
    public void dumpCollectionAndSequenceModel() {
        String varName = "oddNums";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        HashSet<Integer> odds = new HashSet<Integer>();
        for (int i = 0; i <= 10; ++i) {
            if (i % 2 != 1) continue;
            odds.add(i);
        }
        CollectionModel coll = new CollectionModel(odds, new BeansWrapper());
        CollectionAndSequence myCollection = new CollectionAndSequence((TemplateCollectionModel)coll);
        dataModel.put(varName, myCollection);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.SEQUENCE);
        ArrayList myCollectionExpectedDumpValue = new ArrayList(odds.size());
        Iterator iterator = odds.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            HashMap<String, Object> itemDump = new HashMap<String, Object>();
            itemDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.NUMBER);
            itemDump.put(BaseDumpDirective.Key.VALUE.toString(), i);
            myCollectionExpectedDumpValue.add(itemDump);
        }
        expectedDumpValue.put(BaseDumpDirective.Key.VALUE.toString(), myCollectionExpectedDumpValue);
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.test(varName, dataModel, expectedDump);
    }

    @Test
    public void dumpStringToStringMap() {
        String varName = "capitals";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("Albany", "New York");
        myMap.put("St. Paul", "Minnesota");
        myMap.put("Austin", "Texas");
        myMap.put("Sacramento", "California");
        myMap.put("Richmond", "Virginia");
        dataModel.put(varName, myMap);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.HASH_EX);
        TreeMap myMapExpectedDump = new TreeMap();
        for (String key : myMap.keySet()) {
            HashMap<String, Object> itemDump = new HashMap<String, Object>();
            itemDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.STRING);
            itemDump.put(BaseDumpDirective.Key.VALUE.toString(), myMap.get(key));
            myMapExpectedDump.put(key, itemDump);
        }
        expectedDumpValue.put(BaseDumpDirective.Key.VALUE.toString(), myMapExpectedDump);
        HashMap<String, HashMap<String, Object>> expectedDump = new HashMap<String, HashMap<String, Object>>();
        expectedDump.put(varName, expectedDumpValue);
        Map<String, Object> dump = this.getDump(varName, dataModel);
        Assert.assertEquals(expectedDump, dump);
        ArrayList expectedKeys = new ArrayList(myMapExpectedDump.keySet());
        Map actualDumpValue = (Map)dump.get(varName);
        SortedMap myMapActualDump = (SortedMap)actualDumpValue.get(BaseDumpDirective.Key.VALUE.toString());
        ArrayList actualKeys = new ArrayList(myMapActualDump.keySet());
        Assert.assertEquals(expectedKeys, actualKeys);
    }

    @Test
    public void dumpStringToObjectMap() {
        String varName = "stuff";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        HashMap<String, Object> mixedMap = new HashMap<String, Object>();
        String myString = "apples";
        mixedMap.put("myString", myString);
        boolean myBool = true;
        mixedMap.put("myBoolean", myBool);
        int myInt = 4;
        mixedMap.put("myNumber", myInt);
        java.util.Date myDate = new java.util.Date();
        mixedMap.put("myDate", myDate);
        ArrayList<String> myList = new ArrayList<String>();
        myList.add("apples");
        myList.add("bananas");
        myList.add("oranges");
        mixedMap.put("myList", myList);
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("Great Expectations", "Charles Dickens");
        myMap.put("Pride and Prejudice", "Jane Austen");
        myMap.put("Middlemarch", "George Eliot");
        myMap.put("Jude the Obscure", "Thomas Hardy");
        mixedMap.put("myMap", myMap);
        dataModel.put(varName, mixedMap);
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.HASH_EX);
        TreeMap mixedMapExpectedDump = new TreeMap();
        HashMap<String, Object> myStringExpectedDump = new HashMap<String, Object>();
        myStringExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.STRING);
        myStringExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), myString);
        mixedMapExpectedDump.put("myString", myStringExpectedDump);
        HashMap<String, Object> myBooleanExpectedDump = new HashMap<String, Object>();
        myBooleanExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.BOOLEAN);
        myBooleanExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), myBool);
        mixedMapExpectedDump.put("myBoolean", myBooleanExpectedDump);
        HashMap<String, Object> myIntExpectedDump = new HashMap<String, Object>();
        myIntExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.NUMBER);
        myIntExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), myInt);
        mixedMapExpectedDump.put("myNumber", myIntExpectedDump);
        HashMap<String, Object> myDateExpectedDump = new HashMap<String, Object>();
        myDateExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.DATE);
        myDateExpectedDump.put(BaseDumpDirective.Key.DATE_TYPE.toString(), BaseDumpDirective.DateType.UNKNOWN);
        myDateExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), myDate);
        mixedMapExpectedDump.put("myDate", myDateExpectedDump);
        HashMap<String, Object> myListExpectedDump = new HashMap<String, Object>();
        myListExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.SEQUENCE);
        ArrayList myListItemsExpectedDump = new ArrayList(myList.size());
        for (String item : myList) {
            HashMap<String, Object> itemDump = new HashMap<String, Object>();
            itemDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.STRING);
            itemDump.put(BaseDumpDirective.Key.VALUE.toString(), item);
            myListItemsExpectedDump.add(itemDump);
        }
        myListExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), myListItemsExpectedDump);
        mixedMapExpectedDump.put("myList", myListExpectedDump);
        HashMap<String, Object> myMapExpectedDump = new HashMap<String, Object>();
        myMapExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.HASH_EX);
        TreeMap myMapItemsExpectedDump = new TreeMap();
        for (String key : myMap.keySet()) {
            HashMap<String, Object> itemDump = new HashMap<String, Object>();
            itemDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.STRING);
            itemDump.put(BaseDumpDirective.Key.VALUE.toString(), myMap.get(key));
            myMapItemsExpectedDump.put(key, itemDump);
        }
        myMapExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), myMapItemsExpectedDump);
        mixedMapExpectedDump.put("myMap", myMapExpectedDump);
        expectedDumpValue.put(BaseDumpDirective.Key.VALUE.toString(), mixedMapExpectedDump);
        HashMap<String, HashMap<String, Object>> expectedDump = new HashMap<String, HashMap<String, Object>>();
        expectedDump.put(varName, expectedDumpValue);
        Map<String, Object> dump = this.getDump(varName, dataModel);
        Assert.assertEquals(expectedDump, dump);
        ArrayList expectedDumpValueKeys = new ArrayList(mixedMapExpectedDump.keySet());
        Map actualDumpValue = (Map)dump.get(varName);
        SortedMap mixedMapActualDump = (SortedMap)actualDumpValue.get(BaseDumpDirective.Key.VALUE.toString());
        ArrayList actualDumpValueKeys = new ArrayList(mixedMapActualDump.keySet());
        Assert.assertEquals(expectedDumpValueKeys, actualDumpValueKeys);
        ArrayList myMapItemsExpectedDumpKeys = new ArrayList(myMapItemsExpectedDump.keySet());
        Map myMapActualDump = (Map)mixedMapActualDump.get("myMap");
        SortedMap myMapItemsActualDump = (SortedMap)myMapActualDump.get(BaseDumpDirective.Key.VALUE.toString());
        ArrayList myMapItemsActualDumpKeys = new ArrayList(myMapItemsActualDump.keySet());
        Assert.assertEquals(myMapItemsExpectedDumpKeys, myMapItemsActualDumpKeys);
    }

    @Test
    public void dumpObjectWithExposeNothingWrapper() {
        this.dumpObject(3);
    }

    @Test
    public void dumpObjectWithExposePropertiesOnlyWrapper() {
        this.dumpObject(2);
    }

    @Test
    public void dumpObjectWithExposeSafeWrapper() {
        this.dumpObject(1);
    }

    @Test
    public void dumpObjectWithExposeAllWrapper() {
        this.dumpObject(0);
    }

    private void test(String varName, Map<String, Object> dataModel, Map<String, Object> expectedDump) {
        Map<String, Object> dump = this.getDump(varName, dataModel);
        Assert.assertEquals(expectedDump, dump);
    }

    private void dumpObject(int exposureLevel) {
        String varName = "employee";
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        BeansWrapper wrapper = new BeansWrapper();
        wrapper.setExposureLevel(exposureLevel);
        Employee employee = this.getEmployee();
        try {
            dataModel.put("employee", wrapper.wrap((Object)employee));
        }
        catch (TemplateModelException templateModelException) {
            // empty catch block
        }
        HashMap<String, Object> expectedDumpValue = new HashMap<String, Object>();
        expectedDumpValue.put(BaseDumpDirective.Key.TYPE.toString(), employee.getClass().getName());
        expectedDumpValue.put(BaseDumpDirective.Key.VALUE.toString(), this.getJohnDoeExpectedDump(exposureLevel));
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        expectedDump.put(varName, expectedDumpValue);
        this.testObjectDump(varName, dataModel, expectedDump);
    }

    private void testObjectDump(String varName, Map<String, Object> dataModel, Map<String, Object> expectedDump) {
        Map<String, Object> dump = this.getDump(varName, dataModel);
        Assert.assertEquals(expectedDump, dump);
        Map expectedVarDump = (Map)expectedDump.get(varName);
        Map expectedValueDump = (Map)expectedVarDump.get(BaseDumpDirective.Key.VALUE.toString());
        SortedMap expectedPropertyDump = (SortedMap)expectedValueDump.get(BaseDumpDirective.Key.PROPERTIES.toString());
        ArrayList expectedPropertyDumpKeys = new ArrayList(expectedPropertyDump.keySet());
        Map actualVarDump = (Map)dump.get(varName);
        Map actualValueDump = (Map)actualVarDump.get(BaseDumpDirective.Key.VALUE.toString());
        SortedMap actualPropertyDump = (SortedMap)actualValueDump.get(BaseDumpDirective.Key.PROPERTIES.toString());
        ArrayList actualPropertyDumpKeys = new ArrayList(actualPropertyDump.keySet());
        Assert.assertEquals(expectedPropertyDumpKeys, actualPropertyDumpKeys);
    }

    private Map<String, Object> getDump(String varName, Map<String, Object> dataModel) {
        try {
            Environment env = this.template.createProcessingEnvironment(dataModel, (Writer)new StringWriter());
            return new DumpDirective().getTemplateVariableDump(varName, env);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    private Map<String, Object> getDirectiveHelp(String name) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("effect", "Dump the contents of a template variable.");
        map.put("comments", "Sequences (lists and arrays) are enclosed in square brackets. Hashes are enclosed in curly braces.");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("var", "name of variable to dump");
        map.put("parameters", params);
        ArrayList<String> examples = new ArrayList<String>();
        examples.add("<@" + name + " var=\"urls\" />");
        map.put("examples", examples);
        return map;
    }

    private Map<String, Object> getMethodHelp(String name) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("returns", "The square of the argument");
        ArrayList<String> params = new ArrayList<String>();
        params.add("Integer to square");
        map.put("parameters", params);
        ArrayList<String> examples = new ArrayList<String>();
        examples.add(name + "(4)");
        map.put("examples", examples);
        return map;
    }

    private Employee getEmployee() {
        Calendar c = Calendar.getInstance();
        c.set(1982, 4, 5);
        c = DateUtils.truncate((Calendar)c, (int)5);
        Employee jdoe = new Employee("John", "Doe", 34523, c.getTime());
        jdoe.setFavoriteColors("blue", "green");
        jdoe.setSalary(65000.0f);
        c.clear();
        c.set(1975, 9, 25);
        c = DateUtils.truncate((Calendar)c, (int)5);
        Employee jsmith = new Employee("Jane", "Smith", 78234, c.getTime());
        jsmith.setFavoriteColors("red", "orange");
        jdoe.setSupervisor(jsmith);
        return jdoe;
    }

    private Map<String, Object> getJohnDoeExpectedDump(int exposureLevel) {
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        HashMap<String, Object> supervisorExpectedDump = new HashMap<String, Object>();
        supervisorExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), "freemarker.ext.dump.DumpDirectiveTest$Employee");
        supervisorExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), this.getJaneSmithExpectedDump(exposureLevel));
        TreeMap propertiesExpectedDump = new TreeMap();
        if (exposureLevel < 3) {
            HashMap<String, Object> birthdateExpectedDump = new HashMap<String, Object>();
            birthdateExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.DATE);
            birthdateExpectedDump.put(BaseDumpDirective.Key.DATE_TYPE.toString(), BaseDumpDirective.DateType.UNKNOWN);
            Calendar c = Calendar.getInstance();
            c.set(1982, 4, 5);
            c = DateUtils.truncate((Calendar)c, (int)5);
            birthdateExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), c.getTime());
            propertiesExpectedDump.put("birthdate", birthdateExpectedDump);
            HashMap<String, Object> fullNameExpectedDump = new HashMap<String, Object>();
            fullNameExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.STRING);
            fullNameExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), "John Doe");
            propertiesExpectedDump.put("fullName", fullNameExpectedDump);
            HashMap<String, Object> idExpectedDump = new HashMap<String, Object>();
            idExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.NUMBER);
            idExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), 34523);
            propertiesExpectedDump.put("id", idExpectedDump);
            HashMap<String, Object> nicknameExpectedDump = new HashMap<String, Object>();
            nicknameExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.STRING);
            nicknameExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), "");
            propertiesExpectedDump.put("nickname", nicknameExpectedDump);
            HashMap<String, String> middleNameExpectedDump = new HashMap<String, String>();
            middleNameExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), BaseDumpDirective.Value.NULL.toString());
            propertiesExpectedDump.put("middleName", middleNameExpectedDump);
            HashMap<String, Object> marriedExpectedDump = new HashMap<String, Object>();
            marriedExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.BOOLEAN);
            marriedExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), true);
            propertiesExpectedDump.put("married", marriedExpectedDump);
            propertiesExpectedDump.put("supervisor", supervisorExpectedDump);
            HashMap<String, Object> favoriteColorsExpectedDump = new HashMap<String, Object>();
            favoriteColorsExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.SEQUENCE);
            ArrayList favoriteColorListExpectedDump = new ArrayList();
            HashMap<String, Object> color1ExpectedDump = new HashMap<String, Object>();
            color1ExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.STRING);
            color1ExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), "blue");
            favoriteColorListExpectedDump.add(color1ExpectedDump);
            HashMap<String, Object> color2ExpectedDump = new HashMap<String, Object>();
            color2ExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.STRING);
            color2ExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), "green");
            favoriteColorListExpectedDump.add(color2ExpectedDump);
            favoriteColorsExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), favoriteColorListExpectedDump);
            propertiesExpectedDump.put("favoriteColors", favoriteColorsExpectedDump);
        }
        expectedDump.put(BaseDumpDirective.Key.PROPERTIES.toString(), propertiesExpectedDump);
        SortedMap<String, Object> methodDump = this.getEmployeeMethodsExpectedDump(exposureLevel, "Doe");
        if (!methodDump.isEmpty()) {
            methodDump.put("boss()", supervisorExpectedDump);
        }
        expectedDump.put(BaseDumpDirective.Key.METHODS.toString(), methodDump);
        return expectedDump;
    }

    private SortedMap<String, Object> getEmployeeMethodsExpectedDump(int exposureLevel, String familyName) {
        TreeMap<String, Object> expectedDump = new TreeMap<String, Object>();
        if (exposureLevel <= 1) {
            HashMap<String, String> nameExpectedDump = new HashMap<String, String>();
            nameExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), "String");
            expectedDump.put("getName(String)", nameExpectedDump);
            expectedDump.put("setFavoriteColors(Strings)", Collections.emptyMap());
            expectedDump.put("setNickname(String)", Collections.emptyMap());
            HashMap<String, Object> familyNameExpectedDump = new HashMap<String, Object>();
            familyNameExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.STRING);
            familyNameExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), familyName);
            expectedDump.put("familyName()", familyNameExpectedDump);
            HashMap<String, Object> employeeCountExpectedDump = new HashMap<String, Object>();
            employeeCountExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.NUMBER);
            employeeCountExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), Employee.getEmployeeCount());
            expectedDump.put("getEmployeeCount()", employeeCountExpectedDump);
        }
        return expectedDump;
    }

    private Map<String, Object> getJaneSmithExpectedDump(int exposureLevel) {
        HashMap<String, Object> expectedDump = new HashMap<String, Object>();
        HashMap<String, String> supervisorExpectedDump = new HashMap<String, String>();
        supervisorExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), BaseDumpDirective.Value.NULL.toString());
        TreeMap propertiesExpectedDump = new TreeMap();
        if (exposureLevel < 3) {
            HashMap<String, Object> birthdateExpectedDump = new HashMap<String, Object>();
            birthdateExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.DATE);
            birthdateExpectedDump.put(BaseDumpDirective.Key.DATE_TYPE.toString(), BaseDumpDirective.DateType.UNKNOWN);
            Calendar c = Calendar.getInstance();
            c.set(1975, 9, 25);
            c = DateUtils.truncate((Calendar)c, (int)5);
            birthdateExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), c.getTime());
            propertiesExpectedDump.put("birthdate", birthdateExpectedDump);
            HashMap<String, Object> fullNameExpectedDump = new HashMap<String, Object>();
            fullNameExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.STRING);
            fullNameExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), "Jane Smith");
            propertiesExpectedDump.put("fullName", fullNameExpectedDump);
            HashMap<String, Object> idExpectedDump = new HashMap<String, Object>();
            idExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.NUMBER);
            idExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), 78234);
            propertiesExpectedDump.put("id", idExpectedDump);
            HashMap<String, Object> nicknameExpectedDump = new HashMap<String, Object>();
            nicknameExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.STRING);
            nicknameExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), "");
            propertiesExpectedDump.put("nickname", nicknameExpectedDump);
            HashMap<String, String> middleNameExpectedDump = new HashMap<String, String>();
            middleNameExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), BaseDumpDirective.Value.NULL.toString());
            propertiesExpectedDump.put("middleName", middleNameExpectedDump);
            HashMap<String, Object> marriedExpectedDump = new HashMap<String, Object>();
            marriedExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.BOOLEAN);
            marriedExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), true);
            propertiesExpectedDump.put("married", marriedExpectedDump);
            propertiesExpectedDump.put("supervisor", supervisorExpectedDump);
            HashMap<String, Object> favoriteColorsExpectedDump = new HashMap<String, Object>();
            favoriteColorsExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.SEQUENCE);
            ArrayList favoriteColorListExpectedDump = new ArrayList();
            HashMap<String, Object> color1ExpectedDump = new HashMap<String, Object>();
            color1ExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.STRING);
            color1ExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), "red");
            favoriteColorListExpectedDump.add(color1ExpectedDump);
            HashMap<String, Object> color2ExpectedDump = new HashMap<String, Object>();
            color2ExpectedDump.put(BaseDumpDirective.Key.TYPE.toString(), BaseDumpDirective.Type.STRING);
            color2ExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), "orange");
            favoriteColorListExpectedDump.add(color2ExpectedDump);
            favoriteColorsExpectedDump.put(BaseDumpDirective.Key.VALUE.toString(), favoriteColorListExpectedDump);
            propertiesExpectedDump.put("favoriteColors", favoriteColorsExpectedDump);
        }
        expectedDump.put(BaseDumpDirective.Key.PROPERTIES.toString(), propertiesExpectedDump);
        SortedMap<String, Object> methodDump = this.getEmployeeMethodsExpectedDump(exposureLevel, "Smith");
        if (!methodDump.isEmpty()) {
            methodDump.put("boss()", supervisorExpectedDump);
        }
        expectedDump.put(BaseDumpDirective.Key.METHODS.toString(), methodDump);
        return expectedDump;
    }

    public static class Employee {
        private static int count = 0;
        private String firstName;
        private String lastName;
        private String nickname;
        private java.util.Date birthdate;
        private boolean married;
        private int id;
        private String middleName;
        private List<String> favoriteColors;
        private Employee supervisor;
        private float salary;

        Employee(String firstName, String lastName, int id, java.util.Date birthdate) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.middleName = null;
            this.birthdate = birthdate;
            this.married = true;
            this.id = id;
            this.nickname = "";
            this.favoriteColors = new ArrayList<String>();
            ++count;
        }

        protected void setSupervisor(Employee supervisor) {
            this.supervisor = supervisor;
        }

        void setSalary(float salary) {
            this.salary = salary;
        }

        public void setNickname(String nickname) {
            this.nickname = nickname;
        }

        public void setFavoriteColors(String ... colors) {
            for (String color : colors) {
                this.favoriteColors.add(color);
            }
        }

        float getSalary() {
            return this.salary;
        }

        public static int getEmployeeCount() {
            return count;
        }

        public String getFullName() {
            return this.firstName + " " + this.lastName;
        }

        public String getName(String which) {
            return which == "first" ? this.firstName : this.lastName;
        }

        public String getMiddleName() {
            return this.middleName;
        }

        public String getNickname() {
            return this.nickname;
        }

        public java.util.Date getBirthdate() {
            return this.birthdate;
        }

        public int getId() {
            return this.id;
        }

        public boolean isMarried() {
            return this.married;
        }

        @Deprecated
        public int getFormerId() {
            return this.id % 10000;
        }

        public Employee getSupervisor() {
            return this.supervisor;
        }

        public Employee boss() {
            return this.supervisor;
        }

        public List<String> getFavoriteColors() {
            return this.favoriteColors;
        }

        public String familyName() {
            return this.lastName;
        }
    }

    private class DirectiveWithStringStringMapHelp
    implements TemplateDirectiveModel {
        private DirectiveWithStringStringMapHelp() {
        }

        public void execute(Environment arg0, Map arg1, TemplateModel[] arg2, TemplateDirectiveBody arg3) throws TemplateException, IOException {
        }

        public Map<String, String> help(String name) {
            return new HashMap<String, String>();
        }
    }

    private class DirectiveWithStringHelp
    implements TemplateDirectiveModel {
        private DirectiveWithStringHelp() {
        }

        public void execute(Environment arg0, Map arg1, TemplateModel[] arg2, TemplateDirectiveBody arg3) throws TemplateException, IOException {
        }

        public String help(String name) {
            return "help";
        }
    }

    private class HelpfulDirective
    implements TemplateDirectiveModel {
        private HelpfulDirective() {
        }

        public void execute(Environment arg0, Map arg1, TemplateModel[] arg2, TemplateDirectiveBody arg3) throws TemplateException, IOException {
        }

        public Map<String, Object> help(String name) {
            return DumpDirectiveTest.this.getDirectiveHelp(name);
        }
    }

    private class HelplessDirective
    implements TemplateDirectiveModel {
        private HelplessDirective() {
        }

        public void execute(Environment arg0, Map arg1, TemplateModel[] arg2, TemplateDirectiveBody arg3) throws TemplateException, IOException {
        }
    }

    private class MethodWithStringStringMapHelp
    implements TemplateMethodModel {
        private MethodWithStringStringMapHelp() {
        }

        public Object exec(List arg0) throws TemplateModelException {
            return null;
        }

        public Map<String, String> help(String name) {
            return new HashMap<String, String>();
        }
    }

    private class MethodWithStringHelp
    implements TemplateMethodModel {
        private MethodWithStringHelp() {
        }

        public Object exec(List arg0) throws TemplateModelException {
            return null;
        }

        public String help(String name) {
            return "help";
        }
    }

    private class HelpfulMethod
    implements TemplateMethodModel {
        private HelpfulMethod() {
        }

        public Object exec(List arg0) throws TemplateModelException {
            return null;
        }

        public Map<String, Object> help(String name) {
            return DumpDirectiveTest.this.getMethodHelp(name);
        }
    }

    private class HelplessMethod
    implements TemplateMethodModel {
        private HelplessMethod() {
        }

        public Object exec(List arg0) throws TemplateModelException {
            return null;
        }
    }
}

