/*
 * Decompiled with CFR 0.152.
 */
package stubs.javax.servlet.http;

import edu.cornell.mannlib.vitro.webapp.web.URLEncoder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import stubs.javax.servlet.http.HttpSessionStub;

public class HttpServletRequestStub
implements HttpServletRequest {
    private String pathInfo;
    private String requestUri;
    private String requestUrl;
    private String contextPath;
    private String servletPath;
    private String httpMethodType = "GET";
    private String remoteAddr = "127.0.0.1";
    private HttpSession session;
    private final Map<String, List<String>> parameters = new HashMap<String, List<String>>();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public HttpServletRequestStub() {
    }

    public HttpServletRequestStub(Map<String, List<String>> parameters, Map<String, Object> attributes) {
        this();
        this.parameters.putAll(parameters);
        this.attributes.putAll(attributes);
    }

    public void setRequestUrl(URL url) {
        this.contextPath = "";
        this.pathInfo = null;
        this.requestUrl = url.toString();
        String path = url.getPath();
        this.servletPath = path.isEmpty() ? "/" : path;
        this.requestUri = this.servletPath;
    }

    public void setRequestUrlByParts(String shemeHostPort, String contextPath, String servletPath, String pathInfo) {
        if (contextPath == null) {
            throw new NullPointerException("contextPath may not be null.");
        }
        this.contextPath = contextPath;
        this.pathInfo = pathInfo;
        if (servletPath == null) {
            throw new NullPointerException("servletPath may not be null.");
        }
        if (!servletPath.startsWith("/")) {
            throw new IllegalArgumentException("servletPath must start with a /");
        }
        this.servletPath = servletPath;
        this.requestUri = contextPath + servletPath + (pathInfo == null ? "" : pathInfo);
        if (shemeHostPort == null) {
            throw new NullPointerException("shemeHostPort may not be null.");
        }
        if (!shemeHostPort.contains("://")) {
            throw new IllegalArgumentException("schemeHostPort must be sheme://host[:port]");
        }
        this.requestUrl = shemeHostPort + this.requestUri;
    }

    public void setMethod(String method) {
        this.httpMethodType = method;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public void setHeader(String name, String value) {
        if (!this.headers.containsKey(name = name.toLowerCase())) {
            this.headers.put(name, new ArrayList());
        }
        this.headers.get(name).add(value);
    }

    public void addParameter(String name, String value) {
        if (!this.parameters.containsKey(name)) {
            this.parameters.put(name, new ArrayList());
        }
        this.parameters.get(name).add(value);
    }

    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (create && this.session == null) {
            this.session = new HttpSessionStub();
        }
        return this.session;
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.requestUrl);
    }

    public String getRequestURI() {
        return this.requestUri;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getQueryString() {
        if (this.parameters.isEmpty()) {
            return null;
        }
        String qs = "";
        for (String key : this.parameters.keySet()) {
            for (String value : this.parameters.get(key)) {
                qs = qs + "&" + key + "=" + URLEncoder.encode((String)value);
            }
        }
        return "?" + qs.substring(1);
    }

    public String getMethod() {
        return this.httpMethodType;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public Map getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (String key : this.parameters.keySet()) {
            map.put(key, this.parameters.get(key).toArray(new String[0]));
        }
        return map;
    }

    public String getParameter(String name) {
        if (!this.parameters.containsKey(name)) {
            return null;
        }
        return this.parameters.get(name).get(0);
    }

    public String[] getParameterValues(String name) {
        if (!this.parameters.containsKey(name)) {
            return null;
        }
        List<String> list = this.parameters.get(name);
        return list.toArray(new String[list.size()]);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.removeAttribute(name);
        }
        this.attributes.put(name, value);
    }

    public Enumeration getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public String getHeader(String name) {
        if (this.headers.containsKey(name = name.toLowerCase())) {
            return this.headers.get(name).get(0);
        }
        return null;
    }

    public Enumeration getHeaders(String name) {
        if (this.headers.containsKey(name = name.toLowerCase())) {
            return Collections.enumeration((Collection)this.headers.get(name));
        }
        return Collections.enumeration(Collections.emptyList());
    }

    public String getAuthType() {
        throw new RuntimeException("HttpServletRequestStub.getAuthType() not implemented.");
    }

    public Cookie[] getCookies() {
        throw new RuntimeException("HttpServletRequestStub.getCookies() not implemented.");
    }

    public long getDateHeader(String arg0) {
        throw new RuntimeException("HttpServletRequestStub.getDateHeader() not implemented.");
    }

    public int getIntHeader(String arg0) {
        throw new RuntimeException("HttpServletRequestStub.getIntHeader() not implemented.");
    }

    public String getPathTranslated() {
        throw new RuntimeException("HttpServletRequestStub.getPathTranslated() not implemented.");
    }

    public String getRemoteUser() {
        throw new RuntimeException("HttpServletRequestStub.getRemoteUser() not implemented.");
    }

    public String getRequestedSessionId() {
        throw new RuntimeException("HttpServletRequestStub.getRequestedSessionId() not implemented.");
    }

    public Principal getUserPrincipal() {
        throw new RuntimeException("HttpServletRequestStub.getUserPrincipal() not implemented.");
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new RuntimeException("HttpServletRequestStub.isRequestedSessionIdFromCookie() not implemented.");
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new RuntimeException("HttpServletRequestStub.isRequestedSessionIdFromURL() not implemented.");
    }

    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        throw new RuntimeException("HttpServletRequestStub.isRequestedSessionIdFromUrl() not implemented.");
    }

    public boolean isRequestedSessionIdValid() {
        throw new RuntimeException("HttpServletRequestStub.isRequestedSessionIdValid() not implemented.");
    }

    public boolean isUserInRole(String arg0) {
        throw new RuntimeException("HttpServletRequestStub.isUserInRole() not implemented.");
    }

    public String getCharacterEncoding() {
        throw new RuntimeException("HttpServletRequestStub.getCharacterEncoding() not implemented.");
    }

    public int getContentLength() {
        throw new RuntimeException("HttpServletRequestStub.getContentLength() not implemented.");
    }

    public String getContentType() {
        throw new RuntimeException("HttpServletRequestStub.getContentType() not implemented.");
    }

    public ServletInputStream getInputStream() throws IOException {
        throw new RuntimeException("HttpServletRequestStub.getInputStream() not implemented.");
    }

    public String getLocalAddr() {
        throw new RuntimeException("HttpServletRequestStub.getLocalAddr() not implemented.");
    }

    public String getLocalName() {
        throw new RuntimeException("HttpServletRequestStub.getLocalName() not implemented.");
    }

    public int getLocalPort() {
        throw new RuntimeException("HttpServletRequestStub.getLocalPort() not implemented.");
    }

    public Locale getLocale() {
        throw new RuntimeException("HttpServletRequestStub.getLocale() not implemented.");
    }

    public Enumeration getLocales() {
        throw new RuntimeException("HttpServletRequestStub.getLocales() not implemented.");
    }

    public String getProtocol() {
        throw new RuntimeException("HttpServletRequestStub.getProtocol() not implemented.");
    }

    public BufferedReader getReader() throws IOException {
        throw new RuntimeException("HttpServletRequestStub.getReader() not implemented.");
    }

    @Deprecated
    public String getRealPath(String arg0) {
        throw new RuntimeException("HttpServletRequestStub.getRealPath() not implemented.");
    }

    public String getRemoteHost() {
        throw new RuntimeException("HttpServletRequestStub.getRemoteHost() not implemented.");
    }

    public int getRemotePort() {
        throw new RuntimeException("HttpServletRequestStub.getRemotePort() not implemented.");
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        throw new RuntimeException("HttpServletRequestStub.getRequestDispatcher() not implemented.");
    }

    public String getScheme() {
        throw new RuntimeException("HttpServletRequestStub.getScheme() not implemented.");
    }

    public String getServerName() {
        throw new RuntimeException("HttpServletRequestStub.getServerName() not implemented.");
    }

    public int getServerPort() {
        throw new RuntimeException("HttpServletRequestStub.getServerPort() not implemented.");
    }

    public boolean isSecure() {
        throw new RuntimeException("HttpServletRequestStub.isSecure() not implemented.");
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        throw new RuntimeException("HttpServletRequestStub.setCharacterEncoding() not implemented.");
    }
}

