/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.controller.VitroHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.edit.MenuManagementEdit;
import edu.cornell.mannlib.vitro.webapp.dao.DisplayVocabulary;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;

public class DeletePageController
extends VitroHttpServlet {
    private static final String REDIRECT_URL = "/pageList";
    private static Model removeStatements = null;
    Log log = LogFactory.getLog(MenuManagementEdit.class);

    @Override
    protected void doPost(HttpServletRequest rawRequest, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.isAuthorizedToDisplayPage(rawRequest, resp, SimplePermission.MANAGE_MENUS.ACTION)) {
            return;
        }
        removeStatements = ModelFactory.createDefaultModel();
        VitroRequest vreq = new VitroRequest(rawRequest);
        String pageUri = vreq.getParameter("pageURI");
        if (pageUri != null) {
            this.doDeletePage(pageUri, vreq, resp);
        }
        resp.sendRedirect(rawRequest.getContextPath() + REDIRECT_URL);
    }

    @Override
    protected void doGet(HttpServletRequest rawRequest, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(rawRequest, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDeletePage(String pageUri, VitroRequest vreq, HttpServletResponse resp) {
        OntModel displayModel = this.getDisplayModel(vreq);
        if (displayModel == null) {
            this.log.error((Object)"Display model not being retrieved correctly");
        }
        String errorMessage = "";
        this.processDelete(pageUri, displayModel, vreq);
        displayModel.enterCriticalSection(false);
        try {
            this.log.debug((Object)"Statement to be removed are ");
            StringWriter r = new StringWriter();
            removeStatements.write((Writer)r, "N3");
            this.log.debug((Object)r.toString());
            r.close();
            displayModel.remove(removeStatements);
        }
        catch (Exception ex) {
            this.log.error((Object)"An error occurred in processing command", (Throwable)ex);
            errorMessage = errorMessage + "An error occurred and the operation could not be completed successfully.";
        }
        finally {
            displayModel.leaveCriticalSection();
        }
    }

    private void processDelete(String pageUri, OntModel displayModel, VitroRequest vreq) {
        Resource pageResource = this.getExistingPage(pageUri, displayModel);
        Resource menuItemResource = this.getExistingMenuItem(pageResource, displayModel);
        removeStatements.add(this.getStatementsToRemove(displayModel, menuItemResource, pageResource));
    }

    private Model getStatementsToRemove(OntModel displayModel, Resource menuItemResource, Resource pageResource) {
        Model removeModel = ModelFactory.createDefaultModel();
        removeModel.add(displayModel.listStatements(pageResource, null, (RDFNode)null));
        if (menuItemResource != null) {
            removeModel.add(displayModel.listStatements(menuItemResource, null, (RDFNode)null));
            removeModel.add(displayModel.listStatements(null, null, (RDFNode)menuItemResource));
        }
        Model associatedDataGettersModel = this.getDataGettersStatements(pageResource, displayModel);
        removeModel.add(associatedDataGettersModel);
        return removeModel;
    }

    private Model getDataGettersStatements(Resource pageResource, OntModel displayModel) {
        Model dataGettersModel = ModelFactory.createDefaultModel();
        StmtIterator dataGetterIt = displayModel.listStatements(pageResource, ResourceFactory.createProperty((String)"http://vitro.mannlib.cornell.edu/ontologies/display/1.1#hasDataGetter"), (RDFNode)null);
        while (dataGetterIt.hasNext()) {
            Statement dataGetterStmt = dataGetterIt.nextStatement();
            Resource dataGetterResource = dataGetterStmt.getResource();
            dataGettersModel.add(displayModel.listStatements(dataGetterResource, null, (RDFNode)null));
        }
        return dataGettersModel;
    }

    private Resource getExistingPage(String pageUri, OntModel displayModel) {
        return ResourceFactory.createResource((String)pageUri);
    }

    private Resource getExistingMenuItem(Resource pageResource, OntModel displayModel) {
        Resource menuItemResource = null;
        StmtIterator menuItemIt = displayModel.listStatements(null, (Property)DisplayVocabulary.TO_PAGE, (RDFNode)pageResource);
        while (menuItemIt.hasNext()) {
            Statement menuStmt = menuItemIt.nextStatement();
            menuItemResource = menuStmt.getSubject();
        }
        return menuItemResource;
    }

    private OntModel getDisplayModel(VitroRequest vreq) {
        return vreq.getDisplayModel();
    }
}

