/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.beans.FormObject;
import edu.cornell.mannlib.vedit.beans.Option;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.Ontology;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.OntologyDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.OntologyDaoJena;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OntologyEditController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)OntologyEditController.class.getName());

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(req, response, SimplePermission.EDIT_ONTOLOGY.ACTION)) {
            return;
        }
        VitroRequest request = new VitroRequest(req);
        EditProcessObject epo = super.createEpo((HttpServletRequest)request);
        request.setAttribute("epoKey", epo.getKey());
        OntologyDao oDao = request.getUnfilteredWebappDaoFactory().getOntologyDao();
        Ontology o = null;
        if (request.getParameter("uri") == null) {
            log.error((Object)"doPost() expects non-null uri parameter");
        } else {
            o = oDao.getOntologyByURI(request.getParameter("uri"));
            if (o == null) {
                if (!"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#".equals(request.getParameter("uri"))) {
                    log.debug((Object)("doPost(): no ontology object found for the namespace " + request.getParameter("uri")));
                }
            } else {
                request.setAttribute("Ontology", o);
            }
        }
        ArrayList<String> results = new ArrayList<String>();
        results.add("Ontology");
        results.add("Namespace");
        results.add("Prefix");
        String name = o == null ? "" : (o.getName() == null ? "" : o.getName());
        results.add(name);
        String namespace = o == null ? "" : (o.getURI() == null ? "" : o.getURI());
        results.add(namespace);
        String prefix = o == null ? "" : (o.getPrefix() == null ? "" : o.getPrefix());
        results.add(prefix);
        request.setAttribute("results", results);
        request.setAttribute("columncount", 3);
        request.setAttribute("suppressquery", "true");
        epo.setDataAccessObject(oDao);
        FormObject foo = new FormObject();
        HashMap<String, List<Option>> OptionMap = new HashMap<String, List<Option>>();
        HashMap formSelect = new HashMap();
        request.setAttribute("formSelect", formSelect);
        foo.setOptionLists(OptionMap);
        epo.setFormObject(foo);
        String realURI = OntologyDaoJena.adjustOntologyURI(o.getURI());
        request.setAttribute("realURI", realURI);
        request.setAttribute("exportURL", request.getContextPath() + "/export");
        request.setAttribute("epoKey", epo.getKey());
        request.setAttribute("title", "Ontology Control Panel");
        request.setAttribute("css", "<link rel=\"stylesheet\" type=\"text/css\" href=\"" + request.getAppBean().getThemeDir() + "css/edit.css\"/>");
        try {
            JSPPageHandler.renderBasicPage((HttpServletRequest)request, response, "/templates/edit/specific/ontologies_edit.jsp");
        }
        catch (Exception e) {
            log.error((Object)"OntologyEditController could not forward to view.");
            log.error((Object)e.getMessage());
            log.error((Object)e.getStackTrace());
        }
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doPost(request, response);
    }
}

