/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.EditEvent;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.ontology.DatatypeProperty;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.InvalidPropertyURIException;
import org.apache.jena.util.ResourceUtils;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;

public class RefactorOperationController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)RefactorOperationController.class.getName());
    private static final boolean NOTIFY = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doFixDataTypes(HttpServletRequest request, HttpServletResponse response) {
        try {
            super.doGet(request, response);
        }
        catch (Exception e) {
            log.error((Object)(this.getClass().getName() + " caught exception calling doGet()"));
        }
        VitroRequest vreq = new VitroRequest(request);
        request.setAttribute("title", (Object)"Check Datatype Properties");
        request.setAttribute("css", (Object)("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + vreq.getAppBean().getThemeDir() + "css/edit.css\"/>"));
        OntModel ontModel = ModelAccess.on(this.getServletContext()).getOntModel("vitro:baseOntModel");
        ontModel.enterCriticalSection(false);
        ArrayList<String> results = new ArrayList<String>();
        try {
            ExtendedIterator dataProperties = ontModel.listDatatypeProperties();
            int hasRange = 0;
            int consistent = 0;
            boolean inconsistent = false;
            int total = 0;
            int fixed = 0;
            while (dataProperties.hasNext()) {
                ++total;
                DatatypeProperty p = (DatatypeProperty)dataProperties.next();
                OntResource range = p.getRange();
                if (range != null) {
                    ++hasRange;
                }
                NodeIterator n = ontModel.listObjectsOfProperty((Property)p);
                while (n.hasNext()) {
                    RDFNode node = n.nextNode();
                    if (node.isLiteral()) {
                        if (range == null) continue;
                        Literal l = (Literal)node;
                        StmtIterator usingPandL = ontModel.listStatements(null, (Property)p, (RDFNode)l);
                        int size = 0;
                        results.add("Statements using property " + p.getLocalName() + " and literal " + l.getLexicalForm() + ":");
                        while (usingPandL.hasNext()) {
                            Statement st = usingPandL.nextStatement();
                            results.add("    " + st.getSubject().getLocalName() + " " + p.getLocalName() + " " + l.getLexicalForm());
                            ++size;
                        }
                        usingPandL.close();
                        boolean valid = range.getURI().equals(l.getDatatypeURI());
                        if (valid) {
                            consistent += size;
                        } else {
                            results.add(p.getLocalName() + " has object " + l.getLexicalForm() + " of type " + l.getDatatypeURI() + " which is inconsistent");
                            String typeName = "";
                            if (range.getURI().contains("http://www.w3.org/2001/XMLSchema")) {
                                typeName = range.getURI().substring("http://www.w3.org/2001/XMLSchema".length() + 1);
                            } else {
                                results.add("ERROR: " + p.getLocalName() + " has a range which does not contain the XSD namespace");
                            }
                            Literal newLiteral = null;
                            try {
                                newLiteral = ontModel.createTypedLiteral(l.getLexicalForm(), (RDFDatatype)new XSDDatatype(typeName));
                            }
                            catch (NullPointerException e) {
                                results.add("ERROR: Can't create XSDDatatype for literal " + l.getLexicalForm());
                            }
                            StmtIterator badStatements = ontModel.listStatements(null, (Property)p, (RDFNode)l);
                            StmtIterator toRemove = ontModel.listStatements(null, (Property)p, (RDFNode)l);
                            ArrayList<Statement> queue = new ArrayList<Statement>();
                            while (badStatements.hasNext()) {
                                Statement badState = badStatements.nextStatement();
                                Statement goodState = ontModel.createStatement(badState.getSubject(), (Property)p, (RDFNode)newLiteral);
                                queue.add(goodState);
                                results.add("    Replacing: " + badState.toString());
                                results.add("    With:      " + goodState.toString());
                                ++fixed;
                            }
                            for (int i = 0; i < queue.size(); ++i) {
                                ontModel.add((Statement)queue.get(i));
                            }
                            ontModel.remove(toRemove);
                            badStatements.close();
                            toRemove.close();
                        }
                        if (valid) {
                            results.add("Literal " + l.getLexicalForm() + " is in the range of property " + p.getLocalName());
                        }
                        results.add("--------------");
                        continue;
                    }
                    results.add("ERROR: " + node.toString() + " is not a literal");
                }
                n.close();
            }
            dataProperties.close();
            results.add(hasRange + " of " + total + " datatype properties have defined ranges.");
            results.add("Of the statements that contain datatype properties with defined ranges, " + consistent + " are consistent and " + fixed + " are inconsistent.");
            results.add(fixed + " statements have been fixed.");
        }
        finally {
            ontModel.leaveCriticalSection();
        }
        request.setAttribute("results", results);
        try {
            JSPPageHandler.renderBasicPage(request, response, "/jsp/checkDatatypeProperties.jsp");
        }
        catch (Exception e) {
            log.error((Object)(this.getClass().getName() + " could not forward to view."));
            log.error((Object)e.getMessage());
            log.error((Object)e.getStackTrace());
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doRenameResource(VitroRequest request, HttpServletResponse response, EditProcessObject epo) {
        String userURI = LoginStatusBean.getBean((HttpServletRequest)request).getUserURI();
        String oldURIStr = (String)epo.getAttribute("oldURI");
        String newURIStr = request.getParameter("newURI");
        Object errorMsg = null;
        try {
            request.getUnfilteredWebappDaoFactory().checkURI(newURIStr);
        }
        catch (InvalidPropertyURIException invalidPropertyURIException) {
            // empty catch block
        }
        if (errorMsg != null) {
            epo.setAttribute("errorMsg", errorMsg);
            String referer = request.getHeader("Referer");
            int epoKeyIndex = referer.indexOf("_epoKey");
            if (epoKeyIndex < 0) {
                try {
                    response.sendRedirect(referer + "&_epoKey=" + request.getParameter("_epoKey"));
                }
                catch (IOException iOException) {}
            } else {
                String url = referer.substring(0, epoKeyIndex) + "_epoKey=" + request.getParameter("_epoKey");
                try {
                    response.sendRedirect(url);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return "STOP";
        }
        String queryStr = "SELECT distinct ?graph WHERE {{ GRAPH ?graph { ?subj <" + oldURIStr + "> ?obj }} ";
        queryStr = queryStr + " union { GRAPH ?graph { <" + oldURIStr + "> ?prop ?obj }} ";
        queryStr = queryStr + " union { GRAPH ?graph { ?subj ?prop <" + oldURIStr + ">}}}";
        Dataset dataset = request.getDataset();
        QueryExecution qexec = null;
        dataset.getLock().enterCriticalSection(true);
        try {
            qexec = QueryExecutionFactory.create((Query)QueryFactory.create((String)queryStr), (Dataset)dataset);
            ResultSet resultSet = qexec.execSelect();
            while (resultSet.hasNext()) {
                QuerySolution qs = resultSet.next();
                String graphURI = qs.get("graph").asNode().toString();
                if (graphURI.startsWith("http://vitro.mannlib.cornell.edu/filegraph/")) continue;
                boolean doNotify = false;
                Model model = null;
                if ("http://vitro.mannlib.cornell.edu/default/asserted-tbox".equals(graphURI)) {
                    model = ModelAccess.on(this.getServletContext()).getOntModel("http://vitro.mannlib.cornell.edu/default/asserted-tbox").getBaseModel();
                    doNotify = true;
                } else if ("http://vitro.mannlib.cornell.edu/default/vitro-kb-2".equals(graphURI)) {
                    model = ModelAccess.on(this.getServletContext()).getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-2").getBaseModel();
                    doNotify = true;
                } else {
                    model = dataset.getNamedModel(graphURI);
                }
                this.renameResourceInModel(model, userURI, oldURIStr, newURIStr, doNotify);
            }
        }
        finally {
            if (qexec != null) {
                qexec.close();
            }
            dataset.getLock().leaveCriticalSection();
        }
        this.renameResourceInModel((Model)ModelAccess.on(this.getServletContext()).getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-userAccounts"), userURI, oldURIStr, newURIStr, false);
        request.getUnfilteredWebappDaoFactory().getIndividualDao().deleteIndividual(oldURIStr);
        String redirectStr = null;
        String refererStr = epo.getReferer();
        if (refererStr != null) {
            String controllerStr = null;
            String[] controllers = new String[]{"entityEdit", "propertyEdit", "datapropEdit", "ontologyEdit", "vclassEdit"};
            for (int i = 0; i < controllers.length; ++i) {
                if (refererStr.indexOf(controllers[i]) <= -1) continue;
                controllerStr = controllers[i];
            }
            if (controllerStr != null) {
                try {
                    newURIStr = URLEncoder.encode(newURIStr, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                redirectStr = controllerStr + "?uri=" + newURIStr;
            }
        }
        return redirectStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameResourceInModel(Model model, String userURI, String oldURIStr, String newURIStr, boolean doNotify) {
        model.enterCriticalSection(false);
        if (doNotify) {
            model.notifyEvent((Object)new EditEvent(userURI, true));
        }
        try {
            Property prop = model.getProperty(oldURIStr);
            try {
                Property newProp = model.createProperty(newURIStr);
                try (StmtIterator statements = model.listStatements(null, prop, (RDFNode)null);){
                    while (statements.hasNext()) {
                        Statement statement = (Statement)statements.next();
                        Resource subj = statement.getSubject();
                        RDFNode obj = statement.getObject();
                        Statement newStatement = model.createStatement(subj, newProp, obj);
                        model.add(newStatement);
                    }
                }
                model.remove(model.listStatements(null, prop, (RDFNode)null));
            }
            catch (InvalidPropertyURIException newProp) {
                // empty catch block
            }
            Resource res = model.getResource(oldURIStr);
            ResourceUtils.renameResource((Resource)res, (String)newURIStr);
        }
        finally {
            if (doNotify) {
                model.notifyEvent((Object)new EditEvent(userURI, false));
            }
            model.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMovePropertyStatements(VitroRequest request, HttpServletResponse response, EditProcessObject epo) {
        String userURI = LoginStatusBean.getBean((HttpServletRequest)request).getUserURI();
        OntModel ontModel = ModelAccess.on(this.getServletContext()).getOntModel("vitro:baseOntModel");
        Model tempRetractModel = ModelFactory.createDefaultModel();
        Model tempAddModel = ModelFactory.createDefaultModel();
        String oldURIStr = (String)epo.getAttribute("propertyURI");
        String newURIStr = request.getParameter("NewPropertyURI");
        String subjectClassURIStr = request.getParameter("SubjectClassURI");
        String objectClassURIStr = request.getParameter("ObjectClassURI");
        ontModel.enterCriticalSection(true);
        try {
            Resource subjClass = subjectClassURIStr.equals("") ? null : ResourceFactory.createResource((String)subjectClassURIStr);
            Property prop = ResourceFactory.createProperty((String)oldURIStr);
            Property newProp = newURIStr.equals("") ? null : ResourceFactory.createProperty((String)newURIStr);
            OntProperty propInv = null;
            OntProperty newPropInv = null;
            try {
                propInv = ontModel.getObjectProperty(prop.getURI()).getInverse();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                newPropInv = ontModel.getObjectProperty(newProp.getURI()).getInverse();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Resource objClass = objectClassURIStr == null || objectClassURIStr.equals("") ? null : ResourceFactory.createResource((String)objectClassURIStr);
            try (StmtIterator closeIt = epo.getAttribute("propertyType").equals("ObjectProperty") ? ontModel.listStatements(null, prop, (RDFNode)((Resource)null)) : ontModel.listStatements(null, prop, (RDFNode)((Literal)null));){
                StmtIterator stmtIt = closeIt;
                while (stmtIt.hasNext()) {
                    Resource obj;
                    Statement stmt = (Statement)stmtIt.next();
                    Resource subj = stmt.getSubject();
                    boolean moveIt = true;
                    if (objClass != null && !ontModel.contains(obj = (Resource)stmt.getObject(), RDF.type, (RDFNode)objClass)) {
                        moveIt = false;
                    }
                    if (moveIt && subjClass != null && !ontModel.contains(subj, RDF.type, (RDFNode)subjClass)) {
                        moveIt = false;
                    }
                    if (!moveIt) continue;
                    tempRetractModel.add(stmt);
                    if (propInv != null) {
                        tempRetractModel.add((Resource)stmt.getObject(), (Property)propInv, (RDFNode)stmt.getSubject());
                    }
                    if (newProp == null) continue;
                    tempAddModel.add(stmt.getSubject(), newProp, stmt.getObject());
                    if (newPropInv == null) continue;
                    tempAddModel.add((Resource)stmt.getObject(), (Property)newPropInv, (RDFNode)stmt.getSubject());
                }
            }
        }
        finally {
            ontModel.leaveCriticalSection();
        }
        ontModel.enterCriticalSection(false);
        ontModel.getBaseModel().notifyEvent((Object)new EditEvent(userURI, true));
        try {
            ontModel.remove(tempRetractModel);
            ontModel.add(tempAddModel);
        }
        finally {
            ontModel.getBaseModel().notifyEvent((Object)new EditEvent(userURI, false));
            ontModel.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMoveInstances(VitroRequest request, HttpServletResponse response, EditProcessObject epo) {
        String userURI = LoginStatusBean.getBean((HttpServletRequest)request).getUserURI();
        OntModel ontModel = ModelAccess.on(this.getServletContext()).getOntModel("vitro:baseOntModel");
        String oldClassURIStr = (String)epo.getAttribute("VClassURI");
        String newClassURIStr = request.getParameter("NewVClassURI");
        Model tempRetractModel = ModelFactory.createDefaultModel();
        Model tempAddModel = ModelFactory.createDefaultModel();
        ontModel.enterCriticalSection(true);
        try {
            Resource oldClassRes = ontModel.getResource(oldClassURIStr);
            Resource newClassRes = newClassURIStr.equals("") ? null : ontModel.getResource(newClassURIStr);
            try (StmtIterator closeIt = ontModel.listStatements(null, RDF.type, (RDFNode)oldClassRes);){
                StmtIterator stmtIt = closeIt;
                while (stmtIt.hasNext()) {
                    Statement stmt = (Statement)stmtIt.next();
                    tempRetractModel.add(stmt);
                    if (newClassRes == null) continue;
                    tempAddModel.add(stmt.getSubject(), stmt.getPredicate(), (RDFNode)newClassRes);
                }
            }
        }
        finally {
            ontModel.leaveCriticalSection();
        }
        ontModel.enterCriticalSection(false);
        ontModel.getBaseModel().notifyEvent((Object)new EditEvent(userURI, true));
        try {
            ontModel.remove(tempRetractModel);
            ontModel.add(tempAddModel);
        }
        finally {
            ontModel.getBaseModel().notifyEvent((Object)new EditEvent(userURI, false));
            ontModel.leaveCriticalSection();
        }
    }

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(req, response, SimplePermission.EDIT_ONTOLOGY.ACTION)) {
            return;
        }
        VitroRequest vreq = new VitroRequest(req);
        String defaultLandingPage = this.getDefaultLandingPage((HttpServletRequest)vreq);
        HashMap epoHash = null;
        EditProcessObject epo = null;
        try {
            epoHash = (HashMap)vreq.getSession().getAttribute("epoHash");
            epo = (EditProcessObject)epoHash.get(vreq.getParameter("_epoKey"));
        }
        catch (NullPointerException e) {
            try {
                response.sendRedirect(defaultLandingPage);
            }
            catch (IOException f) {
                log.error((Object)f, (Throwable)f);
                throw new RuntimeException(f);
            }
            return;
        }
        if (epo == null) {
            this.handleConsistencyCheckRequest((HttpServletRequest)vreq, response);
            return;
        }
        String modeStr = (String)epo.getAttribute("modeStr");
        String redirectStr = null;
        if (vreq.getParameter("_cancel") == null && modeStr != null) {
            if (modeStr.equals("renameResource")) {
                redirectStr = this.doRenameResource(vreq, response, epo);
            } else if (modeStr.equals("movePropertyStatements")) {
                this.doMovePropertyStatements(vreq, response, epo);
            } else if (modeStr.equals("moveInstances")) {
                this.doMoveInstances(vreq, response, epo);
            }
        }
        if (!"STOP".equals(redirectStr)) {
            if (redirectStr == null) {
                redirectStr = epo.getReferer() == null ? defaultLandingPage : epo.getReferer();
            }
            try {
                response.sendRedirect(redirectStr);
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private void handleConsistencyCheckRequest(HttpServletRequest req, HttpServletResponse response) {
        String modeStr = req.getParameter("modeStr");
        if (modeStr != null && modeStr.equals("fixDataTypes")) {
            this.doFixDataTypes(req, response);
        }
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse response) {
        this.doPost(req, response);
    }
}

