/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.IndividualListQueryResults;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ExceptionResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.individuallist.IndividualListResults;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineException;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchQuery;
import edu.cornell.mannlib.vitro.webapp.utils.searchengine.SearchQueryUtils;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individuallist.ListedIndividual;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individuallist.ListedIndividualBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndividualListController
extends FreemarkerHttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog((String)IndividualListController.class.getName());
    private static final int INDIVIDUALS_PER_PAGE = 30;
    private static final int MAX_PAGES = 40;
    private static final String TEMPLATE_DEFAULT = "individualList.ftl";

    /*
     * Unable to fully structure code
     */
    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        templateName = "individualList.ftl";
        body = new HashMap<String, Object>();
        errorMessage = null;
        try {
            obj = vreq.getAttribute("vclass");
            vclass = null;
            if (obj == null) {
                vitroClassIdStr = vreq.getParameter("vclassId");
                if (!StringUtils.isEmpty((CharSequence)vitroClassIdStr)) {
                    try {
                        vclass = vreq.getWebappDaoFactory().getVClassDao().getVClassByURI(vitroClassIdStr);
                        if (vclass != null) ** GOTO lbl23
                        IndividualListController.log.error((Object)("Couldn't retrieve vclass " + vitroClassIdStr));
                        errorMessage = "Class " + vitroClassIdStr + " not found";
                    }
                    catch (Exception ex) {
                        throw new HelpException("IndividualListController: url parameter 'vclassId' must be a URI string.");
                    }
                }
            } else if (obj instanceof VClass) {
                vclass = (VClass)obj;
            } else {
                throw new HelpException("IndividualListController: attribute 'vclass' must be of type " + VClass.class.getName() + ".");
            }
lbl23:
            // 4 sources

            if (vclass != null) {
                vclassUri = vclass.getURI();
                body.put("vclassId", vclassUri);
                vreq.setAttribute("displayType", vclassUri);
                classGroup = vclass.getGroup();
                if (classGroup == null) {
                    title = vclass.getName();
                } else {
                    title = classGroup.getPublicName();
                    body.put("subtitle", vclass.getName());
                }
                body.put("title", title);
                alpha = IndividualListController.getAlphaParameter(vreq);
                page = IndividualListController.getPageParameter(vreq);
                vcResults = IndividualListController.getResultsForVClass(vclass.getURI(), page, alpha, vreq);
                body.putAll(vcResults.asFreemarkerMap());
                inds = vcResults.getEntities();
                indsTm = new ArrayList<ListedIndividual>();
                if (inds != null) {
                    for (Individual ind : inds) {
                        indsTm.add(ListedIndividualBuilder.build(ind, vreq));
                    }
                }
                body.put("individuals", indsTm);
                body.put("rdfUrl", UrlBuilder.getUrl("/listrdf", new String[]{"vclass", vclass.getURI()}));
            }
        }
        catch (SearchException e) {
            errorMessage = "Error retrieving results for display.";
        }
        catch (HelpException help) {
            errorMessage = "Request attribute 'vclass' or request parameter 'vclassId' must be set before calling. Its value must be a class uri.";
        }
        catch (Throwable e) {
            return new ExceptionResponseValues(e);
        }
        if (errorMessage != null) {
            body.put("errorMessage", errorMessage);
        }
        return new TemplateResponseValues(templateName, body);
    }

    public static String getAlphaParameter(VitroRequest request) {
        return SearchQueryUtils.getAlphaParameter(request);
    }

    public static int getPageParameter(VitroRequest request) {
        return SearchQueryUtils.getPageParameter(request);
    }

    public static IndividualListResults getResultsForVClass(String vclassURI, int page, String alpha, VitroRequest vreq) throws SearchException {
        try {
            List<String> classUris = Collections.singletonList(vclassURI);
            IndividualListQueryResults results = IndividualListController.buildAndExecuteVClassQuery(classUris, alpha, page, 30, vreq.getWebappDaoFactory().getIndividualDao());
            return IndividualListController.getResultsForVClassQuery(results, page, 30, alpha, vreq);
        }
        catch (SearchEngineException e) {
            String msg = "An error occurred retrieving results for vclass query";
            log.error((Object)msg, (Throwable)e);
            throw new SearchException(msg);
        }
        catch (Throwable th) {
            log.error((Object)"An error occurred retrieving results for vclass query", th);
            return IndividualListResults.EMPTY;
        }
    }

    public static IndividualListResults getResultsForVClassIntersections(List<String> vclassURIs, int page, int pageSize, String alpha, VitroRequest vreq) {
        try {
            IndividualListQueryResults results = IndividualListController.buildAndExecuteVClassQuery(vclassURIs, alpha, page, pageSize, vreq.getWebappDaoFactory().getIndividualDao());
            return IndividualListController.getResultsForVClassQuery(results, page, pageSize, alpha, vreq);
        }
        catch (Throwable th) {
            log.error((Object)("Error retrieving individuals corresponding to intersection multiple classes." + vclassURIs.toString()), th);
            return IndividualListResults.EMPTY;
        }
    }

    public static IndividualListResults getRandomResultsForVClass(String vclassURI, int page, int pageSize, VitroRequest vreq) {
        try {
            List<String> classUris = Collections.singletonList(vclassURI);
            IndividualListQueryResults results = IndividualListController.buildAndExecuteRandomVClassQuery(classUris, page, pageSize, vreq.getWebappDaoFactory().getIndividualDao());
            return IndividualListController.getResultsForVClassQuery(results, page, pageSize, "", vreq);
        }
        catch (Throwable th) {
            log.error((Object)"An error occurred retrieving random results for vclass query", th);
            return IndividualListResults.EMPTY;
        }
    }

    private static IndividualListResults getResultsForVClassQuery(IndividualListQueryResults results, int page, int pageSize, String alpha, VitroRequest vreq) {
        long hitCount = results.getHitCount();
        if (hitCount > (long)pageSize) {
            return new IndividualListResults(hitCount, results.getIndividuals(), alpha, true, IndividualListController.makePagesList(hitCount, pageSize, page, vreq));
        }
        return new IndividualListResults(hitCount, results.getIndividuals(), alpha, false, Collections.emptyList());
    }

    private static IndividualListQueryResults buildAndExecuteVClassQuery(List<String> vclassURIs, String alpha, int page, int pageSize, IndividualDao indDao) throws SearchEngineException {
        SearchQuery query = SearchQueryUtils.getQuery(vclassURIs, alpha, page, pageSize);
        IndividualListQueryResults results = IndividualListQueryResults.runQuery(query, indDao);
        log.debug((Object)("Executed search query for " + vclassURIs));
        if (results.getIndividuals().isEmpty()) {
            log.debug((Object)("entities list is null for vclass " + vclassURIs));
        }
        return results;
    }

    private static IndividualListQueryResults buildAndExecuteRandomVClassQuery(List<String> vclassURIs, int page, int pageSize, IndividualDao indDao) throws SearchEngineException {
        SearchQuery query = SearchQueryUtils.getRandomQuery(vclassURIs, page, pageSize);
        IndividualListQueryResults results = IndividualListQueryResults.runQuery(query, indDao);
        log.debug((Object)("Executed search query for " + vclassURIs));
        if (results.getIndividuals().isEmpty()) {
            log.debug((Object)("entities list is null for vclass " + vclassURIs));
        }
        return results;
    }

    public static List<PageRecord> makePagesList(long size, int pageSize, int selectedPage, VitroRequest vreq) {
        ArrayList<PageRecord> records = new ArrayList<PageRecord>(41);
        int requiredPages = (int)(size / (long)pageSize);
        int remainder = (int)(size % (long)pageSize);
        if (remainder > 0) {
            ++requiredPages;
        }
        if (selectedPage < 40 && requiredPages > 40) {
            for (int page = 1; page < requiredPages && page <= 40; ++page) {
                records.add(new PageRecord("page=" + page, Integer.toString(page), Integer.toString(page), selectedPage == page));
            }
            records.add(new PageRecord("page=41", Integer.toString(41), I18n.text((HttpServletRequest)vreq, "paging_link_more", new Object[0]), false));
        } else if (requiredPages > 40 && selectedPage + 1 > 40 && selectedPage < requiredPages - 40) {
            int startPage = selectedPage - 20;
            int endPage = selectedPage + 20;
            for (int page = startPage; page <= endPage; ++page) {
                records.add(new PageRecord("page=" + page, Integer.toString(page), Integer.toString(page), selectedPage == page));
            }
            records.add(new PageRecord("page=" + (endPage + 1), Integer.toString(endPage + 1), I18n.text((HttpServletRequest)vreq, "paging_link_more", new Object[0]), false));
        } else if (requiredPages > 40 && selectedPage > requiredPages - 40) {
            int startPage = requiredPages - 40;
            double max = Math.ceil(size / (long)pageSize);
            int page = startPage;
            while ((double)page <= max) {
                records.add(new PageRecord("page=" + page, Integer.toString(page), Integer.toString(page), selectedPage == page));
                ++page;
            }
        } else {
            for (int i = 1; i <= requiredPages; ++i) {
                records.add(new PageRecord("page=" + i, Integer.toString(i), Integer.toString(i), selectedPage == i));
            }
        }
        return records;
    }

    public static class PageRecord {
        public String param;
        public String index;
        public String text;
        public boolean selected = false;

        public PageRecord(String param, String index, String text, boolean selected) {
            this.param = param;
            this.index = index;
            this.text = text;
            this.selected = selected;
        }

        public String getParam() {
            return this.param;
        }

        public String getIndex() {
            return this.index;
        }

        public String getText() {
            return this.text;
        }

        public boolean getSelected() {
            return this.selected;
        }
    }

    public static class SearchException
    extends Throwable {
        private static final long serialVersionUID = 1L;

        public SearchException(String string) {
            super(string);
        }
    }

    private class HelpException
    extends Throwable {
        private static final long serialVersionUID = 1L;

        public HelpException(String string) {
            super(string);
        }
    }
}

