/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Datatype;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyGroup;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.DatatypeDao;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyGroupDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.utils.json.JacksonUtils;
import edu.cornell.mannlib.vitro.webapp.web.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShowDataPropertyHierarchyController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog((String)ShowDataPropertyHierarchyController.class.getName());
    private static final String TEMPLATE_NAME = "siteAdmin-objectPropHierarchy.ftl";
    private int MAXDEPTH = 5;
    private DataPropertyDao dpDao = null;
    private DataPropertyDao dpDaoLangNeut = null;
    private VClassDao vcDao = null;
    private VClassDao vcDaoLangNeut = null;
    private PropertyGroupDao pgDao = null;
    private DatatypeDao dDao = null;
    private int previous_posn = 0;

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.EDIT_ONTOLOGY.ACTION;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        try {
            String displayOption = "";
            displayOption = vreq.getParameter("displayOption") != null ? vreq.getParameter("displayOption") : "hierarchy";
            body.put("displayOption", displayOption);
            if (displayOption.equals("all")) {
                body.put("pageTitle", "All Data Properties");
            } else {
                body.put("pageTitle", "Data Property Hierarchy");
            }
            body.put("propertyType", "data");
            this.dpDao = vreq.getUnfilteredAssertionsWebappDaoFactory().getDataPropertyDao();
            this.dpDaoLangNeut = vreq.getLanguageNeutralWebappDaoFactory().getDataPropertyDao();
            this.vcDao = vreq.getUnfilteredAssertionsWebappDaoFactory().getVClassDao();
            this.vcDaoLangNeut = vreq.getLanguageNeutralWebappDaoFactory().getVClassDao();
            this.pgDao = vreq.getUnfilteredAssertionsWebappDaoFactory().getPropertyGroupDao();
            this.dDao = vreq.getUnfilteredAssertionsWebappDaoFactory().getDatatypeDao();
            String json = new String();
            String ontologyUri = vreq.getParameter("ontologyUri");
            String startPropertyUri = vreq.getParameter("propertyUri");
            List<Object> roots = null;
            if (startPropertyUri != null) {
                roots = new LinkedList();
                roots.add(this.dpDao.getDataPropertyByURI(startPropertyUri));
            } else {
                roots = this.dpDao.getRootDataProperties();
                if (roots != null) {
                    this.sortForPickList(roots, vreq);
                }
            }
            int counter = 0;
            if (roots != null) {
                Iterator<Object> rootIt = roots.iterator();
                if (!rootIt.hasNext()) {
                    DataProperty dp = new DataProperty();
                    dp.setURI(ontologyUri + "fake");
                    String notFoundMessage = "<strong>No data properties found.</strong>";
                    dp.setName(notFoundMessage);
                    dp.setName(notFoundMessage);
                    json = json + this.addDataPropertyDataToResultsList(dp, 0, ontologyUri, counter);
                } else {
                    while (rootIt.hasNext()) {
                        DataProperty root = (DataProperty)rootIt.next();
                        if (ontologyUri != null && (ontologyUri == null || root.getNamespace() == null || !ontologyUri.equals(root.getNamespace()))) continue;
                        json = json + this.addChildren(root, 0, ontologyUri, counter, vreq);
                        ++counter;
                    }
                    int length = json.length();
                    if (length > 0) {
                        json = json + " }";
                    }
                }
            }
            body.put("jsonTree", json);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return new TemplateResponseValues(TEMPLATE_NAME, body);
    }

    private String addChildren(DataProperty parent, int position, String ontologyUri, int counter, VitroRequest vreq) {
        if (parent == null) {
            return "";
        }
        String details = this.addDataPropertyDataToResultsList(parent, position, ontologyUri, counter);
        int length = details.length();
        String leaves = "";
        leaves = leaves + details;
        List<String> childURIstrs = this.dpDao.getSubPropertyURIs(parent.getURI());
        if (childURIstrs.size() > 0 && position < this.MAXDEPTH) {
            DataProperty child;
            ArrayList<DataProperty> childProps = new ArrayList<DataProperty>();
            for (String URIstr : childURIstrs) {
                child = this.dpDao.getDataPropertyByURI(URIstr);
                childProps.add(child);
            }
            this.sortForPickList(childProps, vreq);
            Iterator childPropIt = childProps.iterator();
            while (childPropIt.hasNext()) {
                child = (DataProperty)childPropIt.next();
                leaves = leaves + this.addChildren(child, position + 1, ontologyUri, counter, vreq);
                if (childPropIt.hasNext()) continue;
                if (ontologyUri == null) {
                    leaves = leaves + " }] ";
                    continue;
                }
                if (ontologyUri == null || length <= 0) continue;
                String ending = leaves.substring(leaves.length() - 2, leaves.length());
                if (ending.equals("] ")) {
                    leaves = leaves + "}]";
                    continue;
                }
                if (ending.equals(" [")) {
                    leaves = leaves + "] ";
                    continue;
                }
                leaves = leaves + "}]";
            }
        } else if (ontologyUri == null) {
            leaves = leaves + "] ";
        } else if (ontologyUri != null && length > 0) {
            leaves = leaves + "] ";
        }
        return leaves;
    }

    private String addDataPropertyDataToResultsList(DataProperty dp, int position, String ontologyUri, int counter) {
        String tempString = "";
        if (dp == null) {
            return tempString;
        }
        if (ontologyUri == null || dp.getNamespace() != null && dp.getNamespace().equals(ontologyUri)) {
            if (counter < 1 && position < 1) {
                tempString = tempString + "{ \"name\": ";
            } else if (position == this.previous_posn) {
                tempString = tempString + "}, { \"name\": ";
            } else if (position > this.previous_posn) {
                tempString = tempString + " { \"name\": ";
            } else if (position < this.previous_posn) {
                tempString = tempString + "}, { \"name\": ";
            }
            String nameStr = dp.getPickListName() == null ? (dp.getName() == null ? (dp.getURI() == null ? "(no name)" : dp.getURI()) : dp.getName()) : dp.getPickListName();
            tempString = tempString + JacksonUtils.quote("<a href='datapropEdit?uri=" + URLEncoder.encode(dp.getURI()) + "'>" + nameStr + "</a>") + ", ";
            tempString = tempString + "\"data\": { \"internalName\": " + JacksonUtils.quote(dp.getPickListName()) + ", ";
            DataProperty dpLangNeut = this.dpDaoLangNeut.getDataPropertyByURI(dp.getURI());
            if (dpLangNeut == null) {
                dpLangNeut = dp;
            }
            String domainStr = this.getVClassNameFromURI(dpLangNeut.getDomainVClassURI(), this.vcDao, this.vcDaoLangNeut);
            try {
                tempString = tempString + "\"domainVClass\": " + JacksonUtils.quote(domainStr) + ", ";
            }
            catch (NullPointerException e) {
                tempString = tempString + "\"domainVClass\": \"\",";
            }
            try {
                Datatype rangeDatatype = this.dDao.getDatatypeByURI(dp.getRangeDatatypeURI());
                String rangeDatatypeStr = rangeDatatype == null ? dp.getRangeDatatypeURI() : rangeDatatype.getName();
                tempString = tempString + "\"rangeVClass\": " + JacksonUtils.quote(rangeDatatypeStr != null ? rangeDatatypeStr : "") + ", ";
            }
            catch (NullPointerException e) {
                tempString = tempString + "\"rangeVClass\": \"\",";
            }
            if (dp.getGroupURI() != null) {
                PropertyGroup pGroup = this.pgDao.getGroupByURI(dp.getGroupURI());
                tempString = tempString + "\"group\": " + JacksonUtils.quote(pGroup == null ? "unknown group" : pGroup.getName());
            } else {
                tempString = tempString + "\"group\": \"unspecified\"";
            }
            tempString = tempString + "}, \"children\": [";
            this.previous_posn = position;
        }
        return tempString;
    }

    private String getVClassNameFromURI(String vclassURI, VClassDao vcDao, VClassDao vcDaoLangNeut) {
        if (vclassURI == null) {
            return "";
        }
        VClass vclass = vcDaoLangNeut.getVClassByURI(vclassURI);
        if (vclass == null) {
            return "";
        }
        if (vclass.isAnonymous()) {
            return vclass.getPickListName();
        }
        VClass vclassWLang = vcDao.getVClassByURI(vclassURI);
        return vclassWLang != null ? vclassWLang.getPickListName() : vclass.getPickListName();
    }
}

