/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StaticPageController
extends FreemarkerHttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(StaticPageController.class);
    private static final Map<String, String> urlsToTemplates = new HashMap<String, String>(){
        {
            this.put("/login", "login.ftl");
        }
    };

    @Override
    protected String getTitle(String siteName, VitroRequest vreq) {
        String requestedUrl = vreq.getServletPath();
        String title = null;
        if (requestedUrl.equals("/login")) {
            title = StringUtils.capitalize((String)I18n.text((HttpServletRequest)vreq, "log_in", new Object[0])) + " - " + siteName;
        }
        return title;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        String requestedUrl = vreq.getServletPath();
        String templateName = urlsToTemplates.get(requestedUrl);
        log.debug((Object)("requestedUrl='" + requestedUrl + "', templateName='" + templateName + "'"));
        return new TemplateResponseValues(templateName);
    }
}

