/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.IndividualImpl;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UrlBuilder {
    private static final Log log = LogFactory.getLog((String)UrlBuilder.class.getName());
    protected static String contextPath = null;

    private UrlBuilder() {
    }

    public static String getHomeUrl() {
        return UrlBuilder.getUrl("");
    }

    public static String getBaseUrl() {
        return contextPath;
    }

    public static String getLoginUrl() {
        return UrlBuilder.getUrl(Route.AUTHENTICATE, "return", "true");
    }

    public static String getLogoutUrl() {
        return UrlBuilder.getUrl(Route.LOGOUT);
    }

    public static String getUrl(String path) {
        if (!path.isEmpty() && !path.startsWith("/")) {
            path = "/" + path;
        }
        return (path = contextPath + path).isEmpty() ? "/" : path;
    }

    public static String getUrl(Route route) {
        return UrlBuilder.getUrl(route.path());
    }

    public static String getUrl(String path, String ... params) {
        ParamMap urlParams = new ParamMap(params);
        return UrlBuilder.getUrl(path, urlParams);
    }

    public static String getUrl(Route route, String ... params) {
        return UrlBuilder.getUrl(route.path(), params);
    }

    public static String getUrl(String path, ParamMap params) {
        path = UrlBuilder.getPath(path, params);
        return UrlBuilder.getUrl(path);
    }

    public static String getUrl(Route route, ParamMap params) {
        return UrlBuilder.getUrl(route.path(), params);
    }

    public static String getPath(String path, ParamMap params) {
        return UrlBuilder.addParams(path, params, "?");
    }

    private static String addParams(String url, ParamMap params, String glue) {
        for (String key : params.keySet()) {
            String value = (String)params.get(key);
            value = value == null ? "" : UrlBuilder.urlEncode(value);
            url = url + glue + key + "=" + value;
            glue = "&";
        }
        return url;
    }

    public static String addParams(String url, ParamMap params) {
        String glue = url.contains("?") ? "&" : "?";
        return UrlBuilder.addParams(url, params, glue);
    }

    public static String addParams(String url, String ... params) {
        return UrlBuilder.addParams(url, new ParamMap(params));
    }

    public static String addParams(String url, List<String> params) {
        return UrlBuilder.addParams(url, new ParamMap(params));
    }

    public static String getPath(Route route, ParamMap params) {
        return UrlBuilder.getPath(route.path(), params);
    }

    public static String getIndividualProfileUrl(Individual individual, VitroRequest vreq) {
        LinkedHashMap<String, String> specialParams;
        WebappDaoFactory wadf = vreq.getWebappDaoFactory();
        String profileUrl = null;
        try {
            String localName = individual.getLocalName();
            String namespace = individual.getNamespace();
            String defaultNamespace = wadf.getDefaultNamespace();
            if (defaultNamespace.equals(namespace)) {
                profileUrl = UrlBuilder.getUrl(Route.DISPLAY.path() + "/" + localName);
            } else if (wadf.getApplicationDao().isExternallyLinkedNamespace(namespace)) {
                log.debug((Object)("Found externally linked namespace " + namespace));
                profileUrl = namespace + localName;
            } else {
                ParamMap params = new ParamMap("uri", individual.getURI());
                profileUrl = UrlBuilder.getUrl(Route.INDIVIDUAL.path(), params);
            }
        }
        catch (Exception e) {
            log.warn((Object)e);
            return null;
        }
        if (profileUrl != null && (specialParams = UrlBuilder.getModelParams(vreq)).size() != 0) {
            profileUrl = UrlBuilder.addParams(profileUrl, new ParamMap((Map<String, String>)specialParams));
        }
        return profileUrl;
    }

    public static String getIndividualProfileUrl(String individualUri, VitroRequest vreq) {
        return UrlBuilder.getIndividualProfileUrl(new IndividualImpl(individualUri), vreq);
    }

    public static boolean isUriInDefaultNamespace(String individualUri, VitroRequest vreq) {
        return UrlBuilder.isUriInDefaultNamespace(individualUri, vreq.getWebappDaoFactory());
    }

    public static boolean isUriInDefaultNamespace(String individualUri, WebappDaoFactory wadf) {
        return UrlBuilder.isUriInDefaultNamespace(individualUri, wadf.getDefaultNamespace());
    }

    public static boolean isUriInDefaultNamespace(String individualUri, String defaultNamespace) {
        try {
            IndividualImpl ind = new IndividualImpl(individualUri);
            String namespace = ind.getNamespace();
            return defaultNamespace.equals(namespace);
        }
        catch (Exception e) {
            log.warn((Object)e);
            return false;
        }
    }

    public static String urlEncode(String str) {
        String encoding = "UTF-8";
        String encodedUrl = null;
        try {
            encodedUrl = URLEncoder.encode(str, encoding);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("Error encoding url " + str + " with encoding " + encoding + ": Unsupported encoding."));
        }
        return encodedUrl;
    }

    public static String urlDecode(String str) {
        String encoding = "UTF-8";
        String decodedUrl = null;
        try {
            decodedUrl = URLDecoder.decode(str, encoding);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("Error decoding url " + str + " with encoding " + encoding + ": Unsupported encoding."));
        }
        return decodedUrl;
    }

    public static LinkedHashMap<String, String> getModelParams(VitroRequest vreq) {
        LinkedHashMap<String, String> specialParams = new LinkedHashMap<String, String>();
        if (vreq != null) {
            String useMenuModelParam = vreq.getParameter("switchToDisplayModel");
            String useMainModelUri = vreq.getParameter("useThisModel");
            String useTboxModelUri = vreq.getParameter("useThisTboxModel");
            String useDisplayModelUri = vreq.getParameter("useThisDisplayModel");
            if (useMenuModelParam != null && !useMenuModelParam.isEmpty()) {
                specialParams.put("switchToDisplayModel", useMenuModelParam);
            } else if (useMainModelUri != null && !useMainModelUri.isEmpty()) {
                specialParams.put("useThisModel", useMainModelUri);
                if (useTboxModelUri != null && !useTboxModelUri.isEmpty()) {
                    specialParams.put("useThisTboxModel", useTboxModelUri);
                }
                if (useDisplayModelUri != null && !useDisplayModelUri.isEmpty()) {
                    specialParams.put("useThisDisplayModel", useDisplayModelUri);
                }
            }
        }
        return specialParams;
    }

    public static class ParamMap
    extends LinkedHashMap<String, String> {
        private static final long serialVersionUID = 1L;

        public ParamMap() {
        }

        public ParamMap(String ... strings) {
            int stringCount = strings.length;
            for (int i = 0; i < stringCount && i != stringCount - 1; i += 2) {
                if (strings[i + 1] == null) continue;
                this.put(strings[i], strings[i + 1]);
            }
        }

        public ParamMap(List<String> strings) {
            this((String[])strings.toArray());
        }

        public ParamMap(Map<String, String> map) {
            this.putAll(map);
        }

        @Override
        public void put(String key, int value) {
            this.put(key, String.valueOf(value));
        }

        @Override
        public void put(String key, boolean value) {
            this.put(key, String.valueOf(value));
        }

        public void put(ParamMap params) {
            for (String key : params.keySet()) {
                this.put(key, params.get(key));
            }
        }
    }

    public static enum JavaScript {
        CUSTOM_FORM_UTILS("/js/customFormUtils.js"),
        JQUERY("/js/jquery-1.12.4.min.js"),
        JQUERY_MIGRATE("/js/jquery-migrate-1.4.1.js"),
        JQUERY_UI("/js/jquery-ui/js/jquery-ui-1.12.1.min.js"),
        UTILS("/js/utils.js");

        private final String path;

        private JavaScript(String path) {
            this.path = path;
        }

        public String path() {
            return this.path;
        }

        public String toString() {
            return this.path;
        }
    }

    public static enum Css {
        CUSTOM_FORM("/edit/forms/css/customForm.css"),
        JQUERY_UI("/js/jquery-ui/css/smoothness/jquery-ui-1.12.1.css");

        private final String path;

        private Css(String path) {
            this.path = path;
        }

        public String path() {
            return this.path;
        }

        public String toString() {
            return this.path;
        }
    }

    public static enum Route {
        ABOUT("/about"),
        AUTHENTICATE("/authenticate"),
        BROWSE("/browse"),
        CONTACT("/contact"),
        DATA_PROPERTY_EDIT("/datapropEdit"),
        DISPLAY("/display"),
        INDIVIDUAL("/individual"),
        INDIVIDUAL_EDIT("/entityEdit"),
        INDIVIDUAL_LIST("/individuallist"),
        LOGIN("/login"),
        LOGOUT("/logout"),
        OBJECT_PROPERTY_EDIT("/propertyEdit"),
        SEARCH("/search"),
        SITE_ADMIN("/siteAdmin"),
        TERMS_OF_USE("/termsOfUse"),
        VISUALIZATION("/visualization"),
        VISUALIZATION_SHORT("/vis"),
        VISUALIZATION_AJAX("/visualizationAjax"),
        VISUALIZATION_DATA("/visualizationData"),
        EDIT_REQUEST_DISPATCH("/editRequestDispatch");

        private final String path;

        private Route(String path) {
            this.path = path;
        }

        public String path() {
            return this.path;
        }

        public String url() {
            return UrlBuilder.getUrl(this.path);
        }

        public String url(ParamMap params) {
            return UrlBuilder.getUrl(this.path, params);
        }

        public String toString() {
            return this.path();
        }
    }
}

