/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.individual;

import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ExceptionResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.RedirectResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.individual.ExtendedRdfAssembler;
import edu.cornell.mannlib.vitro.webapp.controller.individual.IndividualRdfAssembler;
import edu.cornell.mannlib.vitro.webapp.controller.individual.IndividualRequestAnalysisContextImpl;
import edu.cornell.mannlib.vitro.webapp.controller.individual.IndividualRequestAnalyzer;
import edu.cornell.mannlib.vitro.webapp.controller.individual.IndividualRequestInfo;
import edu.cornell.mannlib.vitro.webapp.controller.individual.IndividualResponseBuilder;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndividualController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog(IndividualController.class);
    private static final String TEMPLATE_HELP = "individual-help.ftl";
    @Deprecated
    private static final String PROPERTY_EXTENDED_LOD = "serveExtendedLinkedData";
    public static final Map<String, Float> ACCEPTED_CONTENT_TYPES = IndividualController.initializeContentTypes();

    private static Map<String, Float> initializeContentTypes() {
        HashMap<String, Float> map = new HashMap<String, Float>();
        map.put("text/html", Float.valueOf(0.5f));
        map.put("application/xhtml+xml", Float.valueOf(0.5f));
        map.put("application/xml", Float.valueOf(0.5f));
        map.put("application/json", Float.valueOf(1.0f));
        map.put("application/ld+json", Float.valueOf(1.0f));
        map.put("application/rdf+xml", Float.valueOf(1.0f));
        map.put("application/rdf+xml", Float.valueOf(1.0f));
        map.put("text/n3", Float.valueOf(1.0f));
        map.put("text/turtle", Float.valueOf(1.0f));
        return Collections.unmodifiableMap(map);
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        try {
            IndividualRequestInfo requestInfo = this.analyzeTheRequest(vreq);
            switch (requestInfo.getType()) {
                case RDF_REDIRECT: {
                    return new RedirectResponseValues(requestInfo.getRedirectUrl(), 303);
                }
                case NO_INDIVIDUAL: {
                    return this.doNotFound(vreq);
                }
                case BYTESTREAM_REDIRECT: {
                    return new RedirectResponseValues(requestInfo.getRedirectUrl(), 303);
                }
                case LINKED_DATA: {
                    if (this.useExtendedLOD((HttpServletRequest)vreq)) {
                        return new ExtendedRdfAssembler(vreq, requestInfo.getIndividual(), requestInfo.getRdfFormat()).assembleRdf();
                    }
                    return new IndividualRdfAssembler(vreq, requestInfo.getIndividual().getURI(), requestInfo.getRdfFormat()).assembleRdf();
                }
            }
            return new IndividualResponseBuilder(vreq, requestInfo.getIndividual()).assembleResponse();
        }
        catch (Throwable e) {
            log.error((Object)e, e);
            return new ExceptionResponseValues(e);
        }
    }

    private IndividualRequestInfo analyzeTheRequest(VitroRequest vreq) {
        return new IndividualRequestAnalyzer(vreq, new IndividualRequestAnalysisContextImpl(vreq)).analyze();
    }

    private ResponseValues doNotFound(VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("title", I18n.text((HttpServletRequest)vreq, "individual_not_found", new Object[0]));
        body.put("errorMessage", I18n.text((HttpServletRequest)vreq, "individual_not_found_msg", new Object[0]));
        return new TemplateResponseValues(TEMPLATE_HELP, body, 404);
    }

    private boolean useExtendedLOD(HttpServletRequest req) {
        ConfigurationProperties props = ConfigurationProperties.getBean((ServletRequest)req);
        return Boolean.valueOf(props.getProperty(PROPERTY_EXTENDED_LOD));
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

