/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.jena;

import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.modules.tboxreasoner.TBoxReasonerModule;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.LinkedList;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.iri.Violation;
import org.apache.jena.ontology.AllValuesFromRestriction;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.Restriction;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class JenaAdminActions
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)JenaAdminActions.class.getName());
    private static final String VITRO = "http://vitro.mannlib.cornell.edu/ns/vitro/0.7#";
    private static final String AKT_SUPPORT = "http://www.aktors.org/ontology/support#";
    private static final String AKT_PORTAL = "http://www.aktors.org/ontology/portal#";

    private boolean checkURI(String uri) {
        IRIFactory factory = IRIFactory.jenaImplementation();
        IRI iri = factory.create(uri);
        if (iri.hasViolation(false)) {
            log.error((Object)("Bad URI: " + uri));
            log.error((Object)("Only well-formed absolute URIrefs can be included in RDF/XML output: " + ((Violation)iri.violations(false).next()).getShortMessage()));
            return true;
        }
        return false;
    }

    private void copyStatements(Model src, Model dest, Resource subj, Property pred, RDFNode obj) {
        for (Statement stmt : src.listStatements(subj, pred, obj).toList()) {
            String objNs;
            String subjNs = stmt.getSubject().getNameSpace();
            if (subjNs != null && (subjNs.equals(VITRO) || subjNs.equals(AKT_SUPPORT) || subjNs.equals(AKT_PORTAL))) continue;
            if (stmt.getObject().isLiteral()) {
                dest.add(stmt);
                continue;
            }
            if (!stmt.getObject().isResource() || (objNs = ((Resource)stmt.getObject()).getNameSpace()) != null && (objNs.equals(VITRO) || objNs.equals(AKT_SUPPORT) || objNs.equals(AKT_PORTAL))) continue;
            dest.add(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputTbox(HttpServletResponse response) {
        OntModel memoryModel = ModelAccess.on(this.getServletContext()).getOntModel("vitro:baseOntModel");
        try {
            OntModel tempOntModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
            memoryModel.enterCriticalSection(true);
            try {
                this.copyStatements((Model)memoryModel, (Model)tempOntModel, null, RDF.type, (RDFNode)OWL.Class);
                this.copyStatements((Model)memoryModel, (Model)tempOntModel, null, RDF.type, (RDFNode)OWL.ObjectProperty);
                this.copyStatements((Model)memoryModel, (Model)tempOntModel, null, RDF.type, (RDFNode)OWL.DatatypeProperty);
                this.copyStatements((Model)memoryModel, (Model)tempOntModel, null, RDF.type, (RDFNode)OWL.AnnotationProperty);
                this.copyStatements((Model)memoryModel, (Model)tempOntModel, null, RDFS.subClassOf, null);
                this.copyStatements((Model)memoryModel, (Model)tempOntModel, null, RDFS.subPropertyOf, null);
                this.copyStatements((Model)memoryModel, (Model)tempOntModel, null, RDFS.domain, null);
                this.copyStatements((Model)memoryModel, (Model)tempOntModel, null, RDFS.range, null);
                this.copyStatements((Model)memoryModel, (Model)tempOntModel, null, OWL.inverseOf, null);
            }
            finally {
                memoryModel.leaveCriticalSection();
            }
            response.setContentType("application/rdf+xml");
            ServletOutputStream out = response.getOutputStream();
            tempOntModel.write((OutputStream)out);
            out.flush();
            out.close();
            tempOntModel = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model extractTaxonomy(OntModel ontModel) {
        ontModel.enterCriticalSection(true);
        Model taxonomyModel = ModelFactory.createDefaultModel();
        try {
            HashSet<Resource> typeSet = new HashSet<Resource>();
            for (Statement stmt : ontModel.listStatements((Resource)null, RDF.type, (RDFNode)null).toList()) {
                if (!stmt.getObject().isResource()) continue;
                typeSet.add((Resource)stmt.getObject());
            }
            for (Resource classRes : ontModel.listClasses().toList()) {
                typeSet.add(classRes);
            }
            for (Resource ontClass : typeSet) {
                if (ontClass.isAnon()) continue;
                System.out.println("Describing " + ontClass.getURI());
                String queryStr = "DESCRIBE <" + ontClass.getURI() + ">";
                Query describeQuery = QueryFactory.create((String)queryStr);
                QueryExecution qe = QueryExecutionFactory.create((Query)describeQuery, (Model)ontModel);
                qe.execDescribe(taxonomyModel);
            }
        }
        finally {
            ontModel.leaveCriticalSection();
        }
        System.out.println("Cleaning out the vitro properties");
        Model cleanModel = ModelFactory.createDefaultModel();
        StmtIterator stmtIt = taxonomyModel.listStatements();
        while (stmtIt.hasNext()) {
            Statement stmt;
            stmt = stmtIt.nextStatement();
            if (stmt.getPredicate().getURI().indexOf(VITRO) == 0) continue;
            cleanModel.add(stmt);
        }
        return cleanModel;
    }

    private String testWriteXML() {
        StringBuffer output = new StringBuffer();
        output.append("<html><head><title>Test Write XML</title></head><body><pre>\n");
        OntModel model = ModelAccess.on(this.getServletContext()).getOntModel();
        Model tmp = ModelFactory.createDefaultModel();
        boolean valid = true;
        for (Statement stmt : model.listStatements().toList()) {
            tmp.add(stmt);
            StringWriter writer = new StringWriter();
            try {
                tmp.write((Writer)writer, "RDF/XML");
            }
            catch (Exception e) {
                valid = false;
                output.append("-----\n");
                output.append("Unable to write statement as RDF/XML:\n");
                output.append("Subject : \n" + stmt.getSubject().getURI());
                output.append("Subject : \n" + stmt.getPredicate().getURI());
                String objectStr = stmt.getObject().isLiteral() ? ((Literal)stmt.getObject()).getLexicalForm() : ((Resource)stmt.getObject()).getURI();
                output.append("Subject : \n" + objectStr);
                output.append("Exception: \n");
                e.printStackTrace();
            }
            tmp.removeAll();
        }
        if (valid) {
            output.append("All statements were able to be written as RDF/XML\n");
        }
        output.append("</body></html>");
        return output.toString();
    }

    private void printRestrictions() {
        TBoxReasonerModule reasoner = ApplicationUtils.instance().getTBoxReasonerModule();
        for (Restriction rest : reasoner.listRestrictions()) {
            if (rest.isAllValuesFromRestriction()) {
                log.trace((Object)"All values from: ");
                AllValuesFromRestriction avfr = rest.asAllValuesFromRestriction();
                Resource res = avfr.getAllValuesFrom();
                if (res.canAs(OntClass.class)) {
                    OntClass resClass = (OntClass)res.as(OntClass.class);
                    for (Resource inst : resClass.listInstances().toList()) {
                        log.trace((Object)("    -" + inst.getURI()));
                    }
                }
            } else if (rest.isSomeValuesFromRestriction()) {
                log.trace((Object)"Some values from: ");
            } else if (rest.isHasValueRestriction()) {
                log.trace((Object)"Has value: ");
            }
            log.trace((Object)("On property " + rest.getOnProperty().getURI()));
            for (Resource inst : rest.listInstances().toList()) {
                log.trace((Object)("     " + inst.getURI()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLongLiterals() {
        OntModel memoryModel = ModelAccess.on(this.getServletContext()).getOntModel();
        memoryModel.enterCriticalSection(false);
        try {
            LinkedList<Statement> statementsToRemove = new LinkedList<Statement>();
            for (Statement stmt : memoryModel.listStatements(null, null, (RDFNode)((Literal)null)).toList()) {
                Literal lit;
                if (!stmt.getObject().isLiteral() || (lit = (Literal)stmt.getObject()).getString().length() <= 24) continue;
                statementsToRemove.add(stmt);
            }
            for (Statement stmt : statementsToRemove) {
                memoryModel.remove(stmt);
            }
        }
        finally {
            memoryModel.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse response) {
        OntModel memoryModel;
        if (!this.isAuthorizedToDisplayPage(req, response, SimplePermission.USE_MISCELLANEOUS_ADMIN_PAGES.ACTION)) {
            return;
        }
        VitroRequest request = new VitroRequest(req);
        String actionStr = request.getParameter("action");
        if (actionStr.equals("printRestrictions")) {
            this.printRestrictions();
        } else if (actionStr.equals("outputTbox")) {
            this.outputTbox(response);
        } else if (actionStr.equals("testWriteXML")) {
            try {
                response.getWriter().write(this.testWriteXML());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        if (actionStr.equals("checkURIs")) {
            memoryModel = ModelAccess.on(this.getServletContext()).getOntModel();
            try (StmtIterator stmtIt = memoryModel.listStatements();){
                for (Statement stmt : stmtIt.toList()) {
                    boolean sFailed = false;
                    boolean pFailed = false;
                    boolean oFailed = false;
                    String sURI = "<bNode>";
                    String pURI = "???";
                    String oURI = "<bNode>";
                    if (stmt.getSubject().getURI() != null) {
                        sURI = stmt.getSubject().getURI();
                        sFailed = this.checkURI(sURI);
                    }
                    if (stmt.getPredicate().getURI() != null) {
                        pURI = stmt.getPredicate().getURI();
                        pFailed = this.checkURI(pURI);
                    }
                    if (stmt.getObject().isResource() && ((Resource)stmt.getObject()).getURI() != null) {
                        oURI = ((Resource)stmt.getObject()).getURI();
                        oFailed = this.checkURI(oURI);
                    }
                    if (!sFailed && !pFailed && !oFailed) continue;
                    log.debug((Object)(sURI + " | " + pURI + " | " + oURI));
                }
            }
        }
        if (actionStr.equals("output")) {
            memoryModel = null;
            if (request.getParameter("assertionsOnly") != null) {
                memoryModel = ModelAccess.on(this.getServletContext()).getOntModel("vitro:baseOntModel");
                System.out.println("baseOntModel");
            } else if (request.getParameter("inferences") != null) {
                memoryModel = ModelAccess.on(this.getServletContext()).getOntModel("vitro:inferenceOntModel");
                System.out.println("inferenceOntModel");
            } else {
                memoryModel = ModelAccess.on(this.getServletContext()).getOntModel();
                System.out.println("jenaOntModel");
            }
            int subModelCount = memoryModel.listSubModels().toList().size();
            System.out.println("Submodels: " + subModelCount);
            try {
                response.setContentType("application/x-turtle");
                ServletOutputStream out = response.getOutputStream();
                memoryModel.write((OutputStream)out, "TTL");
                out.flush();
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (actionStr.equals("removeLongLiterals")) {
            this.removeLongLiterals();
        }
        if (actionStr.equals("outputTaxonomy")) {
            OntModel ontModel = ModelAccess.on(this.getServletContext()).getOntModel("vitro:baseOntModel");
            Model taxonomyModel = this.extractTaxonomy(ontModel);
            try {
                taxonomyModel.write((OutputStream)response.getOutputStream());
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doGet(request, response);
    }
}

