/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.jena;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.jena.JenaIngestController;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.JenaModelUtils;
import edu.cornell.mannlib.vitro.webapp.dao.jena.OntModelSelector;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceGraph;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.BulkUpdateEvent;
import edu.cornell.mannlib.vitro.webapp.dao.jena.event.EditEvent;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model.RDFServiceModel;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.ModelMaker;
import org.apache.jena.shared.JenaException;

public class RDFUploadController
extends JenaIngestController {
    private static int maxFileSizeInBytes = 0x7D000000;
    private static FileItem fileStream = null;
    private static final String LOAD_RDF_DATA_JSP = "/jenaIngest/loadRDFData.jsp";
    private static final boolean BEGIN = true;
    private static final boolean END = false;
    private static final Log log = LogFactory.getLog((String)RDFUploadController.class.getName());

    @Override
    public long maximumMultipartFileSize() {
        return maxFileSizeInBytes;
    }

    @Override
    public boolean stashFileSizeException() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isAuthorizedToDisplayPage(req, response, SimplePermission.USE_ADVANCED_DATA_TOOLS_PAGES.ACTION)) {
            return;
        }
        VitroRequest request = new VitroRequest(req);
        if (request.hasFileSizeException()) {
            this.forwardToFileUploadError(request.getFileSizeException().getLocalizedMessage(), req, response);
            return;
        }
        Map<String, List<FileItem>> fileStreams = request.getFiles();
        LoginStatusBean loginBean = LoginStatusBean.getBean((HttpServletRequest)request);
        try {
            String modelName = req.getParameter("modelName");
            if (modelName != null) {
                this.loadRDF(request, response);
                return;
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
        boolean remove = "remove".equals(request.getParameter("mode"));
        String verb = remove ? "Removed" : "Added";
        String languageStr = request.getParameter("language");
        boolean makeClassgroups = "true".equals(request.getParameter("makeClassgroups"));
        boolean directRead = "directAddABox".equals(request.getParameter("mode"));
        String uploadDesc = "";
        OntModel uploadModel = directRead ? this.getABoxModel(this.getServletContext()) : ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        String RDFUrlStr = request.getParameter("rdfUrl");
        if (RDFUrlStr != null && RDFUrlStr.length() > 0) {
            try {
                uploadModel.enterCriticalSection(false);
                try {
                    uploadModel.read(RDFUrlStr, languageStr);
                }
                finally {
                    uploadModel.leaveCriticalSection();
                }
                uploadDesc = verb + " RDF from " + RDFUrlStr;
            }
            catch (JenaException ex) {
                this.forwardToFileUploadError("Could not parse file to " + languageStr + ": " + ex.getMessage(), req, response);
                return;
            }
            catch (Exception e) {
                this.forwardToFileUploadError("Could not load from URL: " + e.getMessage(), req, response);
                return;
            }
        }
        if (fileStreams.get("rdfStream") != null && fileStreams.get("rdfStream").size() > 0) {
            FileItem rdfStream = fileStreams.get("rdfStream").get(0);
            try {
                if (directRead) {
                    this.addUsingRDFService(rdfStream.getInputStream(), languageStr, request.getRDFService());
                } else {
                    uploadModel.enterCriticalSection(false);
                    try {
                        uploadModel.read(rdfStream.getInputStream(), null, languageStr);
                    }
                    finally {
                        uploadModel.leaveCriticalSection();
                    }
                }
                uploadDesc = verb + " RDF from file " + rdfStream.getName();
            }
            catch (IOException e) {
                this.forwardToFileUploadError("Could not read file: " + e.getLocalizedMessage(), req, response);
                return;
            }
            catch (JenaException ex) {
                this.forwardToFileUploadError("Could not parse file to " + languageStr + ": " + ex.getMessage(), req, response);
                return;
            }
            catch (Exception e) {
                this.forwardToFileUploadError("Could not load from file: " + e.getMessage(), req, response);
                return;
            }
            finally {
                rdfStream.delete();
            }
        }
        if (!directRead && uploadModel != null) {
            uploadModel.loadImports();
            long tboxstmtCount = 0L;
            long aboxstmtCount = 0L;
            JenaModelUtils xutil = new JenaModelUtils();
            OntModel tboxModel = this.getTBoxModel();
            OntModel aboxModel = this.getABoxModel(this.getServletContext());
            OntModel tboxChangeModel = null;
            Model aboxChangeModel = null;
            OntModelSelector ontModelSelector = ModelAccess.on(this.getServletContext()).getOntModelSelector();
            if (tboxModel != null) {
                boolean AGGRESSIVE = true;
                tboxChangeModel = xutil.extractTBox((Model)uploadModel, AGGRESSIVE);
                tboxstmtCount = this.operateOnModel(request.getUnfilteredWebappDaoFactory(), tboxModel, (Model)tboxChangeModel, ontModelSelector, remove, makeClassgroups, loginBean.getUserURI());
            }
            if (aboxModel != null) {
                aboxChangeModel = uploadModel.remove(tboxChangeModel);
                aboxstmtCount = aboxChangeModel.size();
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                aboxChangeModel.write((OutputStream)os, "N3");
                ByteArrayInputStream in = new ByteArrayInputStream(os.toByteArray());
                if (!remove) {
                    this.readIntoModel(in, "N3", request.getRDFService(), "http://vitro.mannlib.cornell.edu/default/vitro-kb-2");
                } else {
                    this.removeFromModel(in, "N3", request.getRDFService(), "http://vitro.mannlib.cornell.edu/default/vitro-kb-2");
                }
            }
            request.setAttribute("uploadDesc", uploadDesc + ". " + verb + " " + (tboxstmtCount + aboxstmtCount) + "  statements.");
        } else {
            request.setAttribute("uploadDesc", "RDF upload successful.");
        }
        request.setAttribute("title", "Ingest RDF Data");
        try {
            JSPPageHandler.renderBasicPage((HttpServletRequest)request, response, "/templates/edit/specific/upload_rdf_result.jsp");
        }
        catch (Exception e) {
            log.error((Object)("Could not forward to view: " + e.getLocalizedMessage()));
        }
    }

    private ChangeSet makeChangeSet(RDFService rdfService) {
        ChangeSet cs = rdfService.manufactureChangeSet();
        cs.addPreChangeEvent(new BulkUpdateEvent(null, true));
        cs.addPostChangeEvent(new BulkUpdateEvent(null, false));
        return cs;
    }

    private void addUsingRDFService(InputStream in, String languageStr, RDFService rdfService) {
        ChangeSet changeSet = this.makeChangeSet(rdfService);
        RDFService.ModelSerializationFormat format = "RDF/XML".equals(languageStr) || "RDF/XML-ABBREV".equals(languageStr) ? RDFService.ModelSerializationFormat.RDFXML : RDFService.ModelSerializationFormat.N3;
        changeSet.addAddition(in, format, "http://vitro.mannlib.cornell.edu/default/vitro-kb-2");
        try {
            rdfService.changeSetUpdate(changeSet);
        }
        catch (RDFServiceException rdfse) {
            log.error((Object)rdfse);
            throw new RuntimeException(rdfse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRDF(VitroRequest request, HttpServletResponse response) throws ServletException {
        String bodyJsp;
        Map<String, List<FileItem>> fileStreams = request.getFiles();
        String filePath = fileStreams.get("filePath").get(0).getName();
        fileStream = fileStreams.get("filePath").get(0);
        String modelName = request.getParameter("modelName");
        String docLoc = request.getParameter("docLoc");
        String languageStr = request.getParameter("language");
        ModelMaker maker = RDFUploadController.getModelMaker((HttpServletRequest)request);
        if (modelName == null) {
            request.setAttribute("title", "Load RDF Data");
            bodyJsp = LOAD_RDF_DATA_JSP;
        } else {
            try (RDFService rdfService = this.getRDFService(request, maker, modelName);){
                this.doLoadRDFData(modelName, docLoc, filePath, languageStr, rdfService);
            }
            ModelAccess.WhichService modelType = this.getModelType(request);
            bodyJsp = this.showModelList(request, maker, modelType);
        }
        try {
            JSPPageHandler.renderBasicPage((HttpServletRequest)request, response, bodyJsp);
        }
        catch (Exception e) {
            String errMsg = " could not forward to view.";
            log.error((Object)errMsg, (Throwable)e);
            throw new ServletException(errMsg, (Throwable)e);
        }
    }

    private RDFService getRDFService(VitroRequest vreq, ModelMaker maker, String modelName) {
        if (RDFUploadController.isUsingMainStoreForIngest((HttpServletRequest)vreq)) {
            log.debug((Object)"Using main RDFService");
            return ModelAccess.on(this.getServletContext()).getRDFService();
        }
        log.debug((Object)"Making RDFService for single model from ModelMaker");
        Model m = maker.getModel(modelName);
        return new RDFServiceModel(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long operateOnModel(WebappDaoFactory webappDaoFactory, OntModel mainModel, Model changesModel, OntModelSelector ontModelSelector, boolean remove, boolean makeClassgroups, String userURI) {
        block17: {
            EditEvent startEvent = null;
            EditEvent endEvent = null;
            if (remove) {
                startEvent = new BulkUpdateEvent(userURI, true);
                endEvent = new BulkUpdateEvent(userURI, false);
            } else {
                startEvent = new EditEvent(userURI, true);
                endEvent = new EditEvent(userURI, false);
            }
            OntModel[] classgroupModel = null;
            if (makeClassgroups) {
                classgroupModel = JenaModelUtils.makeClassGroupsFromRootClasses(webappDaoFactory, changesModel);
                OntModel appMetadataModel = ontModelSelector.getApplicationMetadataModel();
                appMetadataModel.enterCriticalSection(false);
                try {
                    appMetadataModel.add((Model)classgroupModel[0]);
                }
                finally {
                    appMetadataModel.leaveCriticalSection();
                }
            }
            mainModel.enterCriticalSection(false);
            try {
                mainModel.getBaseModel().notifyEvent((Object)startEvent);
                try {
                    if (remove) {
                        RDFServiceModel rdfService = new RDFServiceModel((Model)mainModel);
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        changesModel.write((OutputStream)out, "N-TRIPLE");
                        ChangeSet cs = this.makeChangeSet(rdfService);
                        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                        cs.addRemoval(in, RDFService.ModelSerializationFormat.NTRIPLE, null);
                        try {
                            rdfService.changeSetUpdate(cs);
                            break block17;
                        }
                        catch (RDFServiceException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    mainModel.add(changesModel);
                    if (classgroupModel != null) {
                        mainModel.add((Model)classgroupModel[1]);
                    }
                }
                finally {
                    mainModel.getBaseModel().notifyEvent((Object)endEvent);
                }
            }
            finally {
                mainModel.leaveCriticalSection();
            }
        }
        return changesModel.size();
    }

    private void doLoadRDFData(String modelName, String docLoc, String filePath, String language, RDFService rdfService) {
        try {
            if (docLoc != null && docLoc.length() > 0) {
                URL docLocURL = new URL(docLoc);
                InputStream in = docLocURL.openStream();
                this.readIntoModel(in, language, rdfService, modelName);
            } else if (filePath != null && filePath.length() > 0) {
                File file = new File(filePath);
                File[] files = file.isDirectory() ? file.listFiles() : new File[]{file};
                for (int i = 0; i < files.length; ++i) {
                    File currentFile = files[i];
                    log.debug((Object)("Reading file " + currentFile.getName()));
                    try {
                        this.readIntoModel(fileStream.getInputStream(), language, rdfService, modelName);
                        fileStream.delete();
                        continue;
                    }
                    catch (IOException ioe) {
                        String errMsg = "Error loading RDF from " + currentFile.getName();
                        log.error((Object)errMsg, (Throwable)ioe);
                        throw new RuntimeException(errMsg, ioe);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void readIntoModel(InputStream in, String language, RDFService rdfService, String modelName) {
        ChangeSet cs = this.makeChangeSet(rdfService);
        cs.addAddition(in, RDFServiceUtils.getSerializationFormatFromJenaString(language), modelName);
        try {
            rdfService.changeSetUpdate(cs);
        }
        catch (RDFServiceException e) {
            throw new RuntimeException(e);
        }
    }

    private void removeFromModel(InputStream in, String language, RDFService rdfService, String modelName) {
        ChangeSet cs = this.makeChangeSet(rdfService);
        cs.addRemoval(in, RDFServiceUtils.getSerializationFormatFromJenaString(language), modelName);
        try {
            rdfService.changeSetUpdate(cs);
        }
        catch (RDFServiceException e) {
            throw new RuntimeException(e);
        }
    }

    private void forwardToFileUploadError(String errrorMsg, HttpServletRequest req, HttpServletResponse response) throws ServletException {
        VitroRequest vreq = new VitroRequest(req);
        req.setAttribute("title", (Object)"RDF Upload Error ");
        req.setAttribute("errors", (Object)errrorMsg);
        req.setAttribute("css", (Object)("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + vreq.getAppBean().getThemeDir() + "css/edit.css\"/>"));
        try {
            JSPPageHandler.renderBasicPage(req, response, "/jsp/fileUploadError.jsp");
        }
        catch (IOException e1) {
            log.error((Object)e1);
            throw new ServletException((Throwable)e1);
        }
    }

    private OntModel getABoxModel(ServletContext ctx) {
        RDFService rdfService = ModelAccess.on(ctx).getRDFService();
        Model abox = RDFServiceGraph.createRDFServiceModel(new RDFServiceGraph(rdfService, "http://vitro.mannlib.cornell.edu/default/vitro-kb-2"));
        return ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, (Model)abox);
    }

    private OntModel getTBoxModel() {
        return ModelAccess.on(this.getServletContext()).getOntModel("http://vitro.mannlib.cornell.edu/default/asserted-tbox");
    }
}

