/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo;

import edu.cornell.mannlib.vitro.webapp.beans.Datatype;
import edu.cornell.mannlib.vitro.webapp.dao.jena.DatatypeDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.MultiValueEditSubmission;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.ModelFactory;

public class BasicValidationVTwo {
    Map<String, List<String>> varsToValidations;
    EditConfigurationVTwo editConfig;
    private static DatatypeDaoJena ddao = null;
    private static Pattern urlRX = Pattern.compile("(([a-zA-Z][0-9a-zA-Z+\\-\\.]*:)/{0,2}[0-9a-zA-Z;/?:@&=+$\\.\\-_!~*'()%]+)(#[0-9a-zA-Z;/?:@&=+$\\.\\-_!~*'()%]+)?");
    public static final String SUCCESS = null;
    public static final String REQUIRED_FIELD_EMPTY_MSG = "This field must not be empty.";
    public static final String DATE_NOT_PAST_MSG = "Please enter a future target date for publication (past dates are invalid).";
    private final String dateRegex = "((1[012])|([1-9]))/((3[10])|([12][0-9])|([1-9]))/[\\d]{4}";
    private final Pattern datePattern = Pattern.compile("((1[012])|([1-9]))/((3[10])|([12][0-9])|([1-9]))/[\\d]{4}");
    static final List<String> basicValidations = Arrays.asList("nonempty", "isDate", "dateNotPast", "httpUrl");
    private Log log = LogFactory.getLog(BasicValidationVTwo.class);

    public BasicValidationVTwo(EditConfigurationVTwo editConfig, MultiValueEditSubmission editSub) {
        this.editConfig = editConfig;
        HashMap<String, List<String>> validatorsForFields = new HashMap<String, List<String>>();
        for (String fieldName : editConfig.getFields().keySet()) {
            FieldVTwo field = editConfig.getField(fieldName);
            validatorsForFields.put(fieldName, field.getValidators());
        }
        this.varsToValidations = validatorsForFields;
        this.checkValidations();
    }

    public BasicValidationVTwo(Map<String, List<String>> varsToValidations) {
        this.varsToValidations = varsToValidations;
        this.checkValidations();
    }

    public Map<String, String> validateUris(Map<String, List<String>> varNamesToValues) {
        HashMap<String, String> errors = new HashMap<String, String>();
        for (String name : varNamesToValues.keySet()) {
            List<String> values = varNamesToValues.get(name);
            List<String> validations = this.varsToValidations.get(name);
            if (validations == null) continue;
            for (String validationType : validations) {
                String validateMsg = null;
                for (String value : values) {
                    String thisValidateMsg = this.validate(validationType, value);
                    if (validateMsg != null && thisValidateMsg != null) {
                        validateMsg = validateMsg + ", " + thisValidateMsg;
                        continue;
                    }
                    validateMsg = thisValidateMsg;
                }
                if (validateMsg == null) continue;
                errors.put(name, validateMsg);
            }
        }
        return errors;
    }

    public Map<String, String> validateLiterals(Map<String, List<Literal>> varNamesToValues) {
        HashMap<String, String> errors = new HashMap<String, String>();
        block2: for (String name : this.editConfig.getLiteralsOnForm()) {
            List<Literal> literals = varNamesToValues.get(name);
            List<String> validations = this.varsToValidations.get(name);
            if (validations == null) continue;
            boolean isRequiredField = validations.contains("nonempty");
            for (String validationType : validations) {
                String value = null;
                String validateMsg = null;
                if ((literals == null || literals.size() == 0) && isRequiredField) {
                    errors.put(name, REQUIRED_FIELD_EMPTY_MSG);
                    continue block2;
                }
                if (literals != null) {
                    for (Literal literal : literals) {
                        try {
                            if (literal != null) {
                                value = literal.getString();
                            }
                        }
                        catch (Throwable th) {
                            this.log.debug((Object)"could not convert literal to string", th);
                        }
                        if (BasicValidationVTwo.isEmpty(value)) {
                            if (!isRequiredField) break;
                            errors.put(name, REQUIRED_FIELD_EMPTY_MSG);
                            break;
                        }
                        String thisValidateMsg = this.validate(validationType, value);
                        if (validateMsg != null && thisValidateMsg != null) {
                            validateMsg = validateMsg + ", " + thisValidateMsg;
                            continue;
                        }
                        validateMsg = thisValidateMsg;
                    }
                }
                if (validateMsg == null) continue;
                errors.put(name, validateMsg);
            }
        }
        return errors;
    }

    public Map<String, String> validateFiles(Map<String, List<FileItem>> fileItemMap) {
        HashMap<String, String> errors = new HashMap<String, String>();
        for (String name : this.editConfig.getFilesOnForm()) {
            List<String> validators = this.varsToValidations.get(name);
            for (String validationType : validators) {
                String validateMsg = this.validate(validationType, fileItemMap.get(name));
                if (validateMsg == null) continue;
                errors.put(name, validateMsg);
            }
        }
        return errors;
    }

    private String validate(String validationType, List<FileItem> fileItems) {
        if ("nonempty".equalsIgnoreCase(validationType)) {
            if (fileItems == null || fileItems.size() == 0) {
                return "a file must be entered for this field.";
            }
            FileItem fileItem = fileItems.get(0);
            if (fileItem == null || fileItem.getName() == null || fileItem.getName().length() < 1 || fileItem.getSize() < 0L) {
                return "a file must be entered for this field.";
            }
        }
        return null;
    }

    public String validate(String validationType, String value) {
        if ("nonempty".equalsIgnoreCase(validationType)) {
            if (BasicValidationVTwo.isEmpty(value)) {
                return REQUIRED_FIELD_EMPTY_MSG;
            }
        } else {
            if ("isDate".equalsIgnoreCase(validationType)) {
                if (this.isDate(value)) {
                    return SUCCESS;
                }
                return "must be in valid date format mm/dd/yyyy.";
            }
            if (validationType.indexOf("datatype:") == 0) {
                String datatypeURI = validationType.substring(9);
                String errorMsg = BasicValidationVTwo.validateAgainstDatatype(value, datatypeURI);
                if (errorMsg == null) {
                    return SUCCESS;
                }
                return errorMsg;
            }
            if ("httpUrl".equalsIgnoreCase(validationType)) {
                if (!value.startsWith("http://") && !value.startsWith("https://")) {
                    return "This URL must start with http:// or https://";
                }
                return SUCCESS;
            }
            if ("dateNotPast".equalsIgnoreCase(validationType)) {
                Calendar c = Calendar.getInstance();
                Calendar inputC = Calendar.getInstance();
                int yearDash = value.indexOf("-");
                int monthDash = value.lastIndexOf("-");
                if (yearDash != -1 && yearDash != monthDash) {
                    String yearParamStr = value.substring(0, yearDash);
                    String monthParamStr = value.substring(yearDash + 1, monthDash);
                    String dayParamStr = value.substring(monthDash + 1, value.length());
                    inputC.set(Integer.parseInt(yearParamStr), Integer.parseInt(monthParamStr) - 1, Integer.parseInt(dayParamStr));
                    if (inputC.before(c)) {
                        return DATE_NOT_PAST_MSG;
                    }
                    return SUCCESS;
                }
            }
        }
        return null;
    }

    private boolean isDate(String in) {
        return this.datePattern.matcher(in).matches();
    }

    public static synchronized String validateAgainstDatatype(String value, String datatypeURI) {
        if (datatypeURI != null && datatypeURI.length() > 0) {
            Datatype dtype;
            RDFDatatype datatype = TypeMapper.getInstance().getSafeTypeByName(datatypeURI);
            if (datatype == null) {
                throw new RuntimeException(datatypeURI + " is not a recognized datatype");
            }
            if (datatype.isValid(value)) {
                return null;
            }
            if (ddao == null) {
                ddao = new DatatypeDaoJena(new WebappDaoFactoryJena(ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM)));
            }
            String dtypeMsg = (dtype = ddao.getDatatypeByURI(datatypeURI)) != null ? dtype.getName() : datatypeURI;
            return " Please correct this value: must be a valid " + dtypeMsg + ".";
        }
        return null;
    }

    private void checkValidations() {
        ArrayList<String> unknown = new ArrayList<String>();
        for (String key : this.varsToValidations.keySet()) {
            if (this.varsToValidations.get(key) == null) continue;
            for (String validator : this.varsToValidations.get(key)) {
                if (basicValidations.contains(validator) || validator != null && validator.indexOf("datatype:") == 0) continue;
                unknown.add(validator);
            }
        }
        if (unknown.isEmpty()) {
            return;
        }
        throw new Error("Unknown basic validators: " + unknown.toArray());
    }

    private static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }
}

