/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo;

import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.vclassgroup.ProhibitedFromSearch;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditN3GeneratorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditSubmissionVTwoPreprocessor;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.MultiValueEditSubmission;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3EditUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.SparqlEvaluateVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.ModelSelector;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.StandardModelSelector;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.StandardWDFSelector;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.WDFSelector;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.DefaultDataPropertyFormGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.ModelChangePreprocessor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ResourceFactory;
import org.joda.time.DateTime;

public class EditConfigurationVTwo {
    List<String> n3Required = new ArrayList<String>();
    List<String> n3Optional = new ArrayList<String>();
    List<String> urisOnform = new ArrayList<String>();
    List<String> literalsOnForm = new ArrayList<String>();
    List<String> filesOnForm = new ArrayList<String>();
    Map<String, List<String>> urisInScope = new HashMap<String, List<String>>();
    Map<String, List<Literal>> literalsInScope = new HashMap<String, List<Literal>>();
    Map<String, String> sparqlForAdditionalUrisInScope = new HashMap<String, String>();
    Map<String, String> sparqlForAdditionalLiteralsInScope = new HashMap<String, String>();
    Map<String, String> newResources = new HashMap<String, String>();
    Map<String, FieldVTwo> fields = new HashMap<String, FieldVTwo>();
    Map<String, String> sparqlForExistingLiterals = new HashMap<String, String>();
    Map<String, String> sparqlForExistingUris = new HashMap<String, String>();
    String subjectUri;
    String varNameForSubject;
    String predicateUri;
    String varNameForPredicate;
    String object;
    String varNameForObject;
    Integer datapropKey = null;
    String urlPatternToReturnTo = "/individual";
    String entityToReturnTo;
    String urlToReturnTo = null;
    String formUrl;
    String skipToUrl;
    String editKey;
    List<N3ValidatorVTwo> validators;
    EditN3GeneratorVTwo n3generator;
    private List<ModelChangePreprocessor> modelChangePreprocessors = new LinkedList<ModelChangePreprocessor>();
    private List<EditSubmissionVTwoPreprocessor> editSubmissionPreprocessors;
    private ProhibitedFromSearch prohibitedFromSearch;
    private HashMap<String, Object> formSpecificData;
    String template;
    String submitToUrl;
    private boolean useDependentResourceDelete = false;
    private String writeModelId;
    private String aboxModelId;
    private String tboxModelId;
    private ModelSelector writeModelSelector = StandardModelSelector.selector;
    private ModelSelector queryModelSelector = StandardModelSelector.selector;
    private ModelSelector resourceModelSelector = StandardModelSelector.selector;
    private WDFSelector wdfSelectorForOptons = StandardWDFSelector.selector;
    private boolean hasBeenPreparedForUpdate;
    public static final String USE_SYSTEM_VALUE = "USE_SYSTEM_VALUE";
    private static final Log log = LogFactory.getLog((String)EditConfigurationVTwo.class.getName());
    public boolean isParamUpdate = false;
    private static final String INDIVIDUAL_CONTROLLER = "/individual";

    public EditConfigurationVTwo() {
        this.n3generator = new EditN3GeneratorVTwo();
    }

    public EditConfigurationVTwo copy() {
        EditConfigurationVTwo editConfig = new EditConfigurationVTwo();
        editConfig.setN3Generator(this.getN3Generator());
        editConfig.setFormUrl(this.getFormUrl());
        editConfig.setEditKey(this.getEditKey());
        editConfig.setUrlPatternToReturnTo(this.getUrlPatternToReturnTo());
        editConfig.setVarNameForSubject(this.getVarNameForSubject());
        editConfig.setSubjectUri(this.getSubjectUri());
        editConfig.setEntityToReturnTo(this.getEntityToReturnTo());
        editConfig.setVarNameForPredicate(this.getVarNameForPredicate());
        editConfig.setPredicateUri(this.getPredicateUri());
        if (this.getObject() != null) {
            editConfig.setObject(this.getObject());
        }
        editConfig.setVarNameForObject(this.getVarNameForObject());
        editConfig.setDatapropKey(this.getDatapropKey());
        editConfig.setUrlPatternToReturnTo(this.getUrlPatternToReturnTo());
        editConfig.setN3Required(EditConfigurationUtils.copy(this.getN3Required()));
        editConfig.setN3Optional(EditConfigurationUtils.copy(this.getN3Optional()));
        editConfig.setUrisOnform(EditConfigurationUtils.copy(this.getUrisOnform()));
        editConfig.setLiteralsOnForm(EditConfigurationUtils.copy(this.getLiteralsOnForm()));
        editConfig.setFilesOnForm(EditConfigurationUtils.copy(this.getFilesOnForm()));
        editConfig.setNewResources(EditConfigurationUtils.copyMap(this.getNewResources()));
        editConfig.setUrisInScope(EditConfigurationUtils.copyListMap(this.getUrisInScope()));
        editConfig.setLiteralsInScope(this.getLiteralsInScope());
        editConfig.setSparqlForAdditionalUrisInScope(EditConfigurationUtils.copyMap(this.getSparqlForAdditionalUrisInScope()));
        editConfig.setSparqlForAdditionalLiteralsInScope(EditConfigurationUtils.copyMap(this.getSparqlForAdditionalLiteralsInScope()));
        editConfig.setSparqlForExistingLiterals(EditConfigurationUtils.copyMap(this.getSparqlForExistingLiterals()));
        editConfig.setSparqlForExistingUris(EditConfigurationUtils.copyMap(this.getSparqlForExistingUris()));
        Map<String, FieldVTwo> fields = this.getFields();
        editConfig.setFields(fields);
        return editConfig;
    }

    public void addSystemValues(Model model, HttpServletRequest request, ServletContext context) {
        if (model == null) {
            throw new Error("EditConfiguration.addSystemValues() needs a Model");
        }
        if (request == null) {
            throw new Error("EditConfiguration.addSystemValues() needs a request");
        }
        if (this.getSparqlForAdditionalLiteralsInScope() != null && this.getSparqlForAdditionalLiteralsInScope().containsKey("currentTime") && USE_SYSTEM_VALUE.equals(this.getSparqlForAdditionalLiteralsInScope().get("currentTime"))) {
            SimpleDateFormat dateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            String formattedDate = dateTime.format(Calendar.getInstance().getTime());
            ArrayList<Literal> dateLiterals = new ArrayList<Literal>();
            dateLiterals.add(ResourceFactory.createTypedLiteral((String)formattedDate, (RDFDatatype)XSDDatatype.XSDdateTime));
            this.literalsInScope.put("currentTime", dateLiterals);
        }
        if (this.getSparqlForAdditionalUrisInScope() != null && this.getSparqlForAdditionalUrisInScope().containsKey("editingUser") && USE_SYSTEM_VALUE.equals(this.getSparqlForAdditionalUrisInScope().get("editingUser"))) {
            if (request.getSession() == null) {
                throw new Error("EditConfiguration.addSystemValues() needs a session");
            }
            String userUri = N3EditUtils.getEditorUri(request);
            log.debug((Object)("EditConfiguration.java - checking system value for User URI " + userUri));
            ArrayList<String> userUriList = new ArrayList<String>();
            userUriList.add(userUri);
            this.urisInScope.put("editingUser", userUriList);
        }
    }

    protected void basicPrepare() {
        if (this.subjectUri != null && !this.subjectUri.trim().isEmpty() && this.varNameForSubject != null && !this.varNameForSubject.trim().isEmpty()) {
            this.urisInScope.put(this.varNameForSubject, Arrays.asList(this.subjectUri));
            log.debug((Object)("Putting uris in scope - var name for subject " + this.varNameForSubject + " and subject is " + this.subjectUri));
        }
        if (this.predicateUri != null && !this.predicateUri.trim().isEmpty() && this.varNameForPredicate != null && !this.varNameForPredicate.trim().isEmpty()) {
            this.urisInScope.put(this.varNameForPredicate, Arrays.asList(this.predicateUri));
            log.debug((Object)("Putting uris in scope - var name for predicate " + this.varNameForPredicate + " and predicate is " + this.predicateUri));
        }
        if (this.isObjectResource() && this.varNameForObject != null && !this.varNameForObject.trim().isEmpty()) {
            this.urisInScope.put(this.varNameForObject, Arrays.asList(this.getObject()));
            log.debug((Object)("Putting uris in scope - var name for object " + this.varNameForObject + " and object is " + this.object));
        }
    }

    public void prepareForDataPropUpdate(Model model, DataPropertyDao dataPropertyDao) {
        if (model == null) {
            throw new Error("EditConfiguration.prepareForDataPropUpdate() needs a Model");
        }
        if (this.isObjectResource()) {
            throw new Error("This request does not seems to be a DataPropStmt update");
        }
        if (this.datapropKey == null) {
            throw new Error("This request does not appear to be for an update since it lacks a dataProp hash key ");
        }
        this.basicPrepare();
        DefaultDataPropertyFormGenerator.prepareForDataPropUpdate(model, this, dataPropertyDao);
        SparqlEvaluateVTwo sparqlEval = new SparqlEvaluateVTwo(model);
        this.runSparqlForAdditional(sparqlEval);
        this.runSparqlForExisting(sparqlEval);
        this.hasBeenPreparedForUpdate = true;
    }

    public void prepareForObjPropUpdate(Model model) {
        if (model == null) {
            log.debug((Object)"Model is null and will be throwing an error");
            throw new Error("EditConfiguration.prepareForObjPropUpdate() needs a non-null Model");
        }
        if (!this.isObjectResource()) {
            log.debug((Object)"This does not seem to be an object property update. Lacks object.");
            throw new Error("This request does not appear to be for a object property update.");
        }
        this.basicPrepare();
        SparqlEvaluateVTwo sparqlEval = new SparqlEvaluateVTwo(model);
        this.runSparqlForAdditional(sparqlEval);
        try {
            this.runSparqlForExisting(sparqlEval);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.hasBeenPreparedForUpdate = true;
    }

    public void prepareForParamUpdate(Model model) {
        if (model == null) {
            log.debug((Object)"Model is null and will be throwing an error");
            throw new Error("EditConfiguration.prepareForObjPropUpdate() needs a non-null Model");
        }
        this.basicPrepare();
        SparqlEvaluateVTwo sparqlEval = new SparqlEvaluateVTwo(model);
        this.runSparqlForAdditional(sparqlEval);
        try {
            this.runSparqlForExisting(sparqlEval);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.hasBeenPreparedForUpdate = true;
    }

    public void prepareForNonUpdate(Model model) {
        if (model == null) {
            throw new Error("prepareForNonUpdate() needs a non-null Model");
        }
        this.basicPrepare();
        SparqlEvaluateVTwo sparqlEval = new SparqlEvaluateVTwo(model);
        this.runSparqlForAdditional(sparqlEval);
    }

    public void setFields(Map<String, FieldVTwo> fields) {
        this.fields = fields;
    }

    public void prepareForResubmit(MultiValueEditSubmission editSub) {
    }

    public void runSparqlForAdditional(SparqlEvaluateVTwo sparqlEval) {
        sparqlEval.evaluateForAdditionalUris(this);
        sparqlEval.evalulateForAdditionalLiterals(this);
    }

    public void runSparqlForExisting(SparqlEvaluateVTwo sparqlEval) {
        sparqlEval.evaluateForExistingUris(this);
        sparqlEval.evaluateForExistingLiterals(this);
    }

    public FieldVTwo getField(String key) {
        if (this.fields == null) {
            throw new Error("hashmap of field objects must be set before you can get a value from the EditConfiguration");
        }
        return this.fields.get(key);
    }

    public List<String> getN3Required() {
        return EditConfigurationUtils.copy(this.n3Required);
    }

    public void setN3Required(List<String> n3Required) {
        this.n3Required = n3Required;
    }

    public void setN3Required(String ... n3RequiredStrs) {
        this.n3Required = new ArrayList<String>(Arrays.asList(n3RequiredStrs));
    }

    public void addN3Required(List<String> n3RequiredInput) {
        this.n3Required.addAll(n3RequiredInput);
    }

    public void addN3Required(String ... n3RequiredStrsInput) {
        this.n3Required.addAll(Arrays.asList(n3RequiredStrsInput));
    }

    public List<String> getN3Optional() {
        return EditConfigurationUtils.copy(this.n3Optional);
    }

    public void setN3Optional(List<String> n3Optional) {
        this.n3Optional = n3Optional;
    }

    public void setN3Optional(String ... n3Strs) {
        this.n3Optional = new ArrayList<String>(Arrays.asList(n3Strs));
    }

    public void addN3Optional(List<String> n3Optional) {
        this.n3Optional.addAll(n3Optional);
    }

    public void addN3Optional(String ... n3Strs) {
        this.n3Optional.addAll(Arrays.asList(n3Strs));
    }

    public Map<String, String> getNewResources() {
        return this.newResources;
    }

    public void setNewResources(Map<String, String> newResources) {
        this.newResources = newResources;
    }

    public void setNewResources(String ... strs) {
        if (strs == null || strs.length % 2 != 0) {
            throw new Error(" setNewResources() must have pairs of varName, prefix ");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < strs.length; i += 2) {
            map.put(strs[i], strs[i + 1]);
        }
        this.newResources = map;
    }

    public List<String> getUrisOnform() {
        return this.urisOnform;
    }

    public void setUrisOnform(List<String> urisOnform) {
        this.urisOnform = urisOnform;
    }

    public void setUrisOnForm(String ... strs) {
        this.urisOnform = new ArrayList<String>(Arrays.asList(strs));
    }

    public void addUrisOnForm(List<String> urisOnform) {
        this.urisOnform.addAll(urisOnform);
    }

    public void addUrisOnForm(String ... strs) {
        this.urisOnform.addAll(Arrays.asList(strs));
    }

    public void setFilesOnForm(List<String> filesOnForm) {
        this.filesOnForm = filesOnForm;
    }

    public List<String> getFilesOnForm() {
        return this.filesOnForm;
    }

    public List<String> getLiteralsOnForm() {
        return this.literalsOnForm;
    }

    public void setLiteralsOnForm(List<String> literalsOnForm) {
        this.literalsOnForm = literalsOnForm;
    }

    public void setLiteralsOnForm(String ... strs) {
        this.literalsOnForm = new ArrayList<String>(Arrays.asList(strs));
    }

    public void addLiteralsOnForm(List<String> literalsOnForm) {
        this.literalsOnForm.addAll(literalsOnForm);
    }

    public void addLiteralsOnForm(String ... strs) {
        this.literalsOnForm.addAll(Arrays.asList(strs));
    }

    public Map<String, List<String>> getUrisInScope() {
        return this.urisInScope;
    }

    public void setUrisInScope(Map<String, List<String>> urisInScope) {
        this.urisInScope = urisInScope;
    }

    public EditConfigurationVTwo addUrisInScope(String key, List<String> list) {
        if (this.urisInScope == null) {
            this.urisInScope = new HashMap<String, List<String>>();
        }
        this.urisInScope.put(key, list);
        return this;
    }

    public EditConfigurationVTwo addUrisInScope(Map<String, List<String>> uriValues) {
        if (this.urisInScope == null) {
            this.urisInScope = new HashMap<String, List<String>>();
        }
        this.urisInScope.putAll(uriValues);
        return this;
    }

    public Map<String, List<Literal>> getLiteralsInScope() {
        return this.literalsInScope;
    }

    public void setLiteralsInScope(Map<String, List<Literal>> literalsInScope) {
        this.literalsInScope = literalsInScope;
    }

    public Map<String, String> getSparqlForAdditionalUrisInScope() {
        return this.copyMap(this.sparqlForAdditionalUrisInScope);
    }

    public void setSparqlForAdditionalUrisInScope(Map<String, String> sparqlForAdditionalUrisInScope) {
        this.sparqlForAdditionalUrisInScope = sparqlForAdditionalUrisInScope;
    }

    public Map<String, String> getSparqlForAdditionalLiteralsInScope() {
        return this.copyMap(this.sparqlForAdditionalLiteralsInScope);
    }

    private Map<String, String> copyMap(Map<String, String> source) {
        if (source == null) {
            return null;
        }
        HashMap<String, String> dest = new HashMap<String, String>();
        for (String key : source.keySet()) {
            if (source.get(key) != null) {
                dest.put(new String(key), source.get(key));
                continue;
            }
            dest.put(new String(key), null);
        }
        return dest;
    }

    public void setSparqlForAdditionalLiteralsInScope(Map<String, String> sparqlForAdditionalLiteralsInScope) {
        this.sparqlForAdditionalLiteralsInScope = sparqlForAdditionalLiteralsInScope;
    }

    public String getEntityToReturnTo() {
        return this.entityToReturnTo;
    }

    public void setEntityToReturnTo(String entityToReturnTo) {
        this.entityToReturnTo = entityToReturnTo;
    }

    public String getUrlPatternToReturnTo() {
        return this.urlPatternToReturnTo;
    }

    public void setUrlPatternToReturnTo(String s) {
        this.urlPatternToReturnTo = s;
    }

    public Map<String, String> getSparqlForExistingLiterals() {
        return this.copyMap(this.sparqlForExistingLiterals);
    }

    public void setSparqlForExistingLiterals(Map<String, String> sparqlForExistingLiterals) {
        this.sparqlForExistingLiterals = sparqlForExistingLiterals;
    }

    public Map<String, String> getSparqlForExistingUris() {
        return this.copyMap(this.sparqlForExistingUris);
    }

    public void setSparqlForExistingUris(Map<String, String> sparqlForExistingUris) {
        this.sparqlForExistingUris = sparqlForExistingUris;
    }

    public static void clearAllConfigsInSession(HttpSession sess) {
        if (sess == null) {
            return;
        }
        sess.removeAttribute("editConfiguration");
    }

    public static void clearEditConfigurationInSession(HttpSession session, EditConfigurationVTwo editConfig) {
        if (session == null || editConfig == null) {
            return;
        }
        Map configs = (Map)session.getAttribute("EditConfigurations");
        if (configs == null) {
            return;
        }
        if (configs.containsKey(editConfig.editKey)) {
            configs.remove(editConfig.editKey);
        }
    }

    public static void putConfigInSession(EditConfigurationVTwo ec, HttpSession sess) {
        if (sess == null) {
            throw new Error("EditConfig: could not put config in session because session was null");
        }
        if (ec.editKey == null) {
            throw new Error("EditConfig: could not put into session because editKey was null.");
        }
        HashMap<String, EditConfigurationVTwo> configs = (HashMap<String, EditConfigurationVTwo>)sess.getAttribute("EditConfigurations");
        if (configs == null) {
            configs = new HashMap<String, EditConfigurationVTwo>();
            sess.setAttribute("EditConfigurations", configs);
        }
        configs.put(ec.editKey, ec);
    }

    public static EditConfigurationVTwo getConfigFromSession(HttpSession sess, String editKey) {
        Map configs = (Map)sess.getAttribute("EditConfigurations");
        return configs != null ? (EditConfigurationVTwo)configs.get(editKey) : null;
    }

    public static EditConfigurationVTwo getConfigFromSession(HttpSession sess, HttpServletRequest request) {
        String key = EditConfigurationVTwo.getEditKeyFromRequest((ServletRequest)request);
        if (key == null) {
            return null;
        }
        return EditConfigurationVTwo.getConfigFromSession(sess, key);
    }

    public static String getEditKeyFromRequest(ServletRequest request) {
        String key = null;
        if (request instanceof VitroRequest) {
            return request.getParameter("editKey");
        }
        if (request instanceof HttpServletRequest) {
            HttpServletRequest hsreq = (HttpServletRequest)request;
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)hsreq);
            if (isMultipart) {
                key = (String)request.getAttribute("editKey");
                if (key == null) {
                    key = request.getParameter("editKey");
                }
            } else {
                key = (String)request.getAttribute("editKey");
                if (key != null) {
                    return key;
                }
                key = request.getParameter("editKey");
            }
        }
        if (key != null && key.trim().length() > 0) {
            return key;
        }
        log.debug((Object)"cannnot find editKey in request query parameters or from request");
        return null;
    }

    public static String newEditKey(HttpSession sess) {
        int mills = new DateTime().getMillisOfDay();
        Map configs = (Map)sess.getAttribute("EditConfigurations");
        if (configs == null) {
            return Integer.toString(mills);
        }
        while (configs.containsKey(Integer.toString(mills))) {
            ++mills;
        }
        return Integer.toString(mills);
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public boolean isObjectResource() {
        boolean objectFound = false;
        boolean dataKeyFound = false;
        if (this.object != null && !this.object.trim().isEmpty()) {
            objectFound = true;
        }
        if (this.getDatapropKey() != null) {
            dataKeyFound = true;
        }
        if (dataKeyFound && objectFound) {
            throw new Error("Bad configuration: both datapropKey and object are defined.");
        }
        return objectFound;
    }

    public Integer getDatapropKey() {
        return this.datapropKey;
    }

    public void setDatapropKey(Integer datapropKey) {
        this.datapropKey = datapropKey;
    }

    public String getSubjectUri() {
        return this.subjectUri;
    }

    public void setSubjectUri(String subjectUri) {
        this.subjectUri = subjectUri;
    }

    public String getPredicateUri() {
        return this.predicateUri;
    }

    public void setPredicateUri(String predicateUri) {
        this.predicateUri = predicateUri;
    }

    public Map<String, FieldVTwo> getFields() {
        return this.fields;
    }

    public String getEditKey() {
        return this.editKey;
    }

    public void setEditKey(String editKey) {
        this.editKey = editKey;
    }

    public String getFormUrl() {
        return this.formUrl;
    }

    public void setFormUrl(String formUrl) {
        this.formUrl = formUrl;
    }

    public EditN3GeneratorVTwo getN3Generator() {
        return this.n3generator;
    }

    public void setN3Generator(EditN3GeneratorVTwo gen) {
        this.n3generator = gen;
    }

    public String getVarNameForSubject() {
        return this.varNameForSubject;
    }

    public void setVarNameForSubject(String varName) {
        this.varNameForSubject = varName;
    }

    public String getVarNameForPredicate() {
        return this.varNameForPredicate;
    }

    public void setVarNameForPredicate(String varName) {
        this.varNameForPredicate = varName;
    }

    public String getVarNameForObject() {
        return this.varNameForObject;
    }

    public void setVarNameForObject(String varName) {
        this.varNameForObject = varName;
    }

    public boolean isUseDependentResourceDelete() {
        return this.useDependentResourceDelete;
    }

    public void setUseDependentResourceDelete(boolean useDependentResourceDelete) {
        this.useDependentResourceDelete = useDependentResourceDelete;
    }

    public List<ModelChangePreprocessor> getModelChangePreprocessors() {
        return this.modelChangePreprocessors;
    }

    public void addModelChangePreprocessor(ModelChangePreprocessor modelChangePreprocessor) {
        this.modelChangePreprocessors.add(modelChangePreprocessor);
    }

    public void setProhibitedFromSearch(ProhibitedFromSearch prohibitedFromSearch) {
        this.prohibitedFromSearch = prohibitedFromSearch;
    }

    public ProhibitedFromSearch getProhibitedFromSearch() {
        return this.prohibitedFromSearch;
    }

    private void debugScope(String msg) {
        if (log.isDebugEnabled()) {
            String val;
            log.debug((Object)msg);
            log.debug((Object)"literalsInScope:");
            for (String key : this.literalsInScope.keySet()) {
                val = this.literalsInScope.get(key).toString();
                log.debug((Object)(key + " " + val));
            }
            log.debug((Object)"uris in scope: ");
            for (String key : this.urisInScope.keySet()) {
                val = this.urisInScope.get(key).toString();
                log.debug((Object)(key + " " + val));
            }
        }
    }

    public ModelSelector getWriteModelSelector() {
        return this.writeModelSelector;
    }

    public void setWriteModelSelector(ModelSelector writeModel) {
        if (writeModel != null) {
            this.writeModelSelector = writeModel;
        }
    }

    public ModelSelector getQueryModelSelector() {
        return this.queryModelSelector;
    }

    public void setQueryModelSelector(ModelSelector queryModel) {
        if (queryModel != null) {
            this.queryModelSelector = queryModel;
        }
    }

    public WDFSelector getWdfSelectorForOptons() {
        return this.wdfSelectorForOptons;
    }

    public void setWdfSelectorForOptons(WDFSelector wdfForOptons) {
        this.wdfSelectorForOptons = wdfForOptons;
    }

    public ModelSelector getResourceModelSelector() {
        return this.resourceModelSelector;
    }

    public void setResourceModelSelector(ModelSelector resourceModelSelector) {
        if (resourceModelSelector != null) {
            this.resourceModelSelector = resourceModelSelector;
        }
    }

    public List<N3ValidatorVTwo> getValidators() {
        return this.validators;
    }

    public void addValidator(N3ValidatorVTwo validator) {
        if (this.validators == null) {
            this.validators = new ArrayList<N3ValidatorVTwo>();
        }
        this.validators.add(validator);
    }

    public void addEditSubmissionPreprocessor(EditSubmissionVTwoPreprocessor preprocessor) {
        if (this.editSubmissionPreprocessors == null) {
            this.editSubmissionPreprocessors = new ArrayList<EditSubmissionVTwoPreprocessor>();
        }
        this.editSubmissionPreprocessors.add(preprocessor);
    }

    public List<EditSubmissionVTwoPreprocessor> getEditSubmissionPreprocessors() {
        return this.editSubmissionPreprocessors;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getSubmitToUrl() {
        return this.submitToUrl;
    }

    public void setSubmitToUrl(String submitToUrl) {
        this.submitToUrl = submitToUrl;
    }

    public boolean isUpdate() {
        return this.isObjectPropertyUpdate() || this.isDataPropertyUpdate() || this.isParamUpdate();
    }

    public boolean isObjectPropertyUpdate() {
        return this.getObject() != null && this.getObject().trim().length() > 0;
    }

    public boolean isDataPropertyUpdate() {
        return this.getDatapropKey() != null;
    }

    public void setParamUpdate(boolean inputParamUpdate) {
        this.isParamUpdate = inputParamUpdate;
    }

    public boolean isParamUpdate() {
        return this.isParamUpdate;
    }

    public void setFormSpecificData(HashMap<String, Object> formSpecificData) {
        this.formSpecificData = formSpecificData;
    }

    public void addFormSpecificData(String key, Object value) {
        if (this.formSpecificData == null) {
            this.formSpecificData = new HashMap();
        }
        this.formSpecificData.put(key, value);
    }

    public HashMap<String, Object> getFormSpecificData() {
        return this.formSpecificData;
    }

    public boolean hasBeenPreparedForUpdate() {
        return this.hasBeenPreparedForUpdate;
    }

    public void addNewResource(String key, String namespace) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("key of new resource must not be null");
        }
        if (this.newResources == null) {
            this.newResources = new HashMap<String, String>();
            this.newResources.put(key, namespace);
        } else {
            this.newResources.put(key, namespace);
        }
    }

    public void addSparqlForExistingLiteral(String key, String sparql) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (sparql == null || sparql.isEmpty()) {
            throw new IllegalArgumentException("sparql must not be null");
        }
        Map<String, String> map = this.sparqlForExistingLiterals;
        if (map == null) {
            map = new HashMap<String, String>();
            map.put(key, sparql);
            this.setSparqlForExistingLiterals(map);
        } else {
            map.put(key, sparql);
        }
    }

    public void addSparqlForExistingUris(String key, String sparql) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (sparql == null || sparql.isEmpty()) {
            throw new IllegalArgumentException("sparql must not be null");
        }
        Map<String, String> map = this.sparqlForExistingUris;
        if (map == null) {
            map = new HashMap<String, String>();
            map.put(key, sparql);
            this.setSparqlForExistingUris(map);
        } else {
            map.put(key, sparql);
        }
    }

    public void addSparqlForAdditionalLiteralsInScope(String key, String sparql) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (sparql == null || sparql.isEmpty()) {
            throw new IllegalArgumentException("sparql must not be null");
        }
        Map<String, String> map = this.sparqlForAdditionalLiteralsInScope;
        if (map == null) {
            map = new HashMap<String, String>();
            map.put(key, sparql);
            this.setSparqlForAdditionalLiteralsInScope(map);
        } else {
            map.put(key, sparql);
        }
    }

    public void addSparqlForAdditionalUrisInScope(String key, String sparql) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (sparql == null || sparql.isEmpty()) {
            throw new IllegalArgumentException("sparql must not be null");
        }
        Map<String, String> map = this.sparqlForAdditionalUrisInScope;
        if (map == null) {
            map = new HashMap<String, String>();
            map.put(key, sparql);
            this.setSparqlForAdditionalUrisInScope(map);
        } else {
            map.put(key, sparql);
        }
    }

    public void addField(FieldVTwo field) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (field.getName() == null || field.getName().isEmpty()) {
            throw new IllegalArgumentException("field must not have null or empty name");
        }
        if (this.fields == null) {
            this.fields = new HashMap<String, FieldVTwo>();
        }
        if (this.fields.containsKey(field.getName())) {
            throw new IllegalArgumentException("adding filed that is already in the field list");
        }
        this.fields.put(field.getName(), field);
    }

    public void addFields(List<FieldVTwo> fields) {
        if (fields != null) {
            for (FieldVTwo f : fields) {
                this.addField(f);
            }
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public EditConfigurationVTwo addLiteralInScope(String key, Literal ... values) {
        if (this.literalsInScope == null) {
            this.literalsInScope = new HashMap<String, List<Literal>>();
        }
        this.literalsInScope.put(key, Arrays.asList(values));
        return this;
    }

    public EditConfigurationVTwo addLiteralsInScope(Map<String, List<Literal>> scopeLiterals) {
        if (this.literalsInScope == null) {
            this.literalsInScope = new HashMap<String, List<Literal>>();
        }
        this.literalsInScope.putAll(scopeLiterals);
        return this;
    }

    public void setUrlToReturnTo(String url) {
        this.urlToReturnTo = url;
    }

    public String getUrlToReturnTo() {
        return this.urlToReturnTo;
    }

    public void setSkipToUrl(String url) {
        this.skipToUrl = url;
    }

    public String getSkipToUrl() {
        return this.skipToUrl;
    }

    public void setWriteModelId(String writeModelId) {
        this.writeModelId = writeModelId;
    }

    public String getWriteModelId() {
        return this.writeModelId;
    }

    public void setAboxModelId(String aboxModelId) {
        this.aboxModelId = aboxModelId;
    }

    public String getAboxModelId() {
        return this.aboxModelId;
    }

    public void setTboxModelId(String tboxModelId) {
        this.tboxModelId = tboxModelId;
    }

    public String getTboxModelId() {
        return this.tboxModelId;
    }
}

