/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.dao.DisplayVocabulary;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupsForRequest;
import edu.cornell.mannlib.vitro.webapp.dao.jena.VClassGroupCache;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.BaseEditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.ManagePagePreprocessor;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.utils.ProcessDataGetterN3;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.utils.ProcessDataGetterN3Utils;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetterUtils;
import edu.cornell.mannlib.vitro.webapp.utils.menuManagement.MenuManagementDataUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.XSD;

public class ManagePageGenerator
extends BaseEditConfigurationGenerator
implements EditConfigurationGenerator {
    private String template = "pageManagement.ftl";
    public static final String defaultDisplayNs = DisplayVocabulary.NAMESPACE.getURI() + "n";
    private Log log = LogFactory.getLog(ManagePageGenerator.class);
    static final String prefixes = "@prefix display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> . \n@prefix rdfs:<http://www.w3.org/2000/01/rdf-schema#> . \n";
    static final String pageN3 = "?page a display:Page ;  \ndisplay:title ?pageName ;\ndisplay:urlMapping ?prettyUrl .";
    static final String pageBodyTemplateN3 = "?page display:requiresBodyTemplate ?customTemplate .";
    static final String isSelfContainedTemplateN3 = "?page display:isSelfContainedTemplate ?isSelfContainedTemplate .";
    static final String menuItemN3 = "?menuItem a display:NavigationElement ; \ndisplay:menuPosition ?menuPosition; \ndisplay:linkText ?menuLinkText; \ndisplay:toPage ?page .";
    static final String menuN3 = "display:DefaultMenu display:hasElement ?menuItem .";
    static final String permissionN3 = "?page display:requiresAction ?action .";

    @Override
    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) {
        EditConfigurationVTwo conf = new EditConfigurationVTwo();
        conf.setTemplate(this.template);
        this.initBasics(conf, vreq);
        this.initPropertyParameters(vreq, session, conf);
        this.initObjectPropForm(conf, vreq);
        this.setVarNames(conf);
        this.setN3Required(conf);
        this.setN3Optional(conf);
        this.setNewResources(conf);
        this.setSparqlQueries(conf);
        this.setUrisAndLiteralsInScope(conf, vreq);
        this.setUrisAndLiteralsOnForm(conf, vreq);
        this.setFields(conf);
        this.addFormSpecificData(conf, vreq);
        conf.addEditSubmissionPreprocessor(new ManagePagePreprocessor(conf));
        this.prepare(vreq, conf);
        this.populateExistingDataGetter(vreq, conf, session.getServletContext());
        return conf;
    }

    private void setUrisAndLiteralsOnForm(EditConfigurationVTwo conf, VitroRequest vreq) {
        conf.setUrisOnForm("page", "menuItem", "action");
        conf.setLiteralsOnForm("pageName", "prettyUrl", "menuPosition", "menuLinkText", "customTemplate", "isSelfContainedTemplate", "pageContentUnit");
    }

    private void setUrisAndLiteralsInScope(EditConfigurationVTwo conf, VitroRequest vreq) {
        conf.addUrisInScope(conf.getVarNameForSubject(), Arrays.asList(conf.getSubjectUri()));
        conf.addUrisInScope(conf.getVarNameForPredicate(), Arrays.asList(conf.getPredicateUri()));
    }

    private void setN3Optional(EditConfigurationVTwo conf) {
        conf.setN3Optional(new ArrayList<String>(Arrays.asList("@prefix display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> . \n@prefix rdfs:<http://www.w3.org/2000/01/rdf-schema#> . \n?page display:requiresBodyTemplate ?customTemplate .", "@prefix display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> . \n@prefix rdfs:<http://www.w3.org/2000/01/rdf-schema#> . \n?menuItem a display:NavigationElement ; \ndisplay:menuPosition ?menuPosition; \ndisplay:linkText ?menuLinkText; \ndisplay:toPage ?page .display:DefaultMenu display:hasElement ?menuItem .", "@prefix display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> . \n@prefix rdfs:<http://www.w3.org/2000/01/rdf-schema#> . \n?page display:isSelfContainedTemplate ?isSelfContainedTemplate .", "@prefix display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> . \n@prefix rdfs:<http://www.w3.org/2000/01/rdf-schema#> . \n?page display:requiresAction ?action .")));
    }

    private void setN3Required(EditConfigurationVTwo conf) {
        conf.setN3Required(new ArrayList<String>(Arrays.asList("@prefix display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> . \n@prefix rdfs:<http://www.w3.org/2000/01/rdf-schema#> . \n?page a display:Page ;  \ndisplay:title ?pageName ;\ndisplay:urlMapping ?prettyUrl .")));
    }

    private void setFields(EditConfigurationVTwo conf) {
        FieldVTwo titleField = new FieldVTwo().setName("pageName").setValidators(Arrays.asList("nonempty"));
        conf.addField(titleField);
        FieldVTwo urlField = new FieldVTwo().setName("prettyUrl").setValidators(Arrays.asList("nonempty"));
        conf.addField(urlField);
        FieldVTwo bodyTemplateField = new FieldVTwo().setName("customTemplate");
        conf.addField(bodyTemplateField);
        FieldVTwo menuItemLinkTextField = new FieldVTwo().setName("menuLinkText");
        conf.addField(menuItemLinkTextField);
        FieldVTwo menuItemPositionField = new FieldVTwo().setName("menuPosition").setRangeDatatypeUri(XSD.integer.getURI());
        conf.addField(menuItemPositionField);
        FieldVTwo isSelfContainedTemplateField = new FieldVTwo().setName("isSelfContainedTemplate");
        conf.addField(isSelfContainedTemplateField);
        FieldVTwo permissionField = new FieldVTwo().setName("action");
        conf.addField(permissionField);
        FieldVTwo pageContentUnitField = new FieldVTwo().setName("pageContentUnit");
        conf.addField(pageContentUnitField);
    }

    private void setVarNames(EditConfigurationVTwo conf) {
        if (conf.getSubjectUri() != null) {
            conf.setVarNameForSubject("page");
            conf.setVarNameForPredicate("predicate");
        } else {
            conf.setVarNameForSubject("subjectNotUsed");
            conf.setVarNameForPredicate("predicateNotUsed");
        }
    }

    @Override
    void initPropertyParameters(VitroRequest vreq, HttpSession session, EditConfigurationVTwo editConfiguration) {
        String subjectUri = EditConfigurationUtils.getSubjectUri(vreq);
        String predicateUri = EditConfigurationUtils.getPredicateUri(vreq);
        editConfiguration.setUrlToReturnTo(UrlBuilder.getUrl("/pageList"));
        if (subjectUri == null) {
            editConfiguration.setEntityToReturnTo("?page");
            editConfiguration.setPredicateUri(predicateUri);
        } else {
            editConfiguration.setEntityToReturnTo(subjectUri);
            editConfiguration.setParamUpdate(true);
        }
        editConfiguration.setSubjectUri(subjectUri);
        editConfiguration.setPredicateUri(predicateUri);
    }

    @Override
    void prepare(VitroRequest vreq, EditConfigurationVTwo editConfig) {
        this.setupModelSelectorsFromVitroRequest(vreq, editConfig);
        OntModel queryModel = ModelAccess.on((HttpServletRequest)vreq).getOntModel(new ModelAccess.LanguageOption[0]);
        if (editConfig.isParamUpdate()) {
            editConfig.prepareForParamUpdate((Model)queryModel);
        } else {
            editConfig.prepareForNonUpdate((Model)queryModel);
        }
    }

    private void populateExistingDataGetter(VitroRequest vreq, EditConfigurationVTwo editConfig, ServletContext context) {
        if (editConfig.isParamUpdate()) {
            this.setupModelSelectorsFromVitroRequest(vreq, editConfig);
            OntModel queryModel = ModelAccess.on((HttpServletRequest)vreq).getOntModel(new ModelAccess.LanguageOption[0]);
            this.retrieveExistingDataGetterInfo(context, editConfig, queryModel);
        }
    }

    private void retrieveExistingDataGetterInfo(ServletContext context, EditConfigurationVTwo editConfig, OntModel queryModel) {
        String pageUri = editConfig.getSubjectUri();
        this.executeExistingDataGettersInfo(context, editConfig, pageUri, queryModel);
    }

    private void executeExistingDataGettersInfo(ServletContext servletContext, EditConfigurationVTwo editConfig, String pageUri, OntModel queryModel) {
        ArrayNode jsonArray = new ObjectMapper().createArrayNode();
        String querystr = this.getExistingDataGettersQuery();
        QuerySolutionMap initialBindings = new QuerySolutionMap();
        initialBindings.add("page", (RDFNode)ResourceFactory.createResource((String)pageUri));
        QueryExecution qe = null;
        try {
            Query query = QueryFactory.create((String)querystr);
            qe = QueryExecutionFactory.create((Query)query, (Model)queryModel, (QuerySolution)initialBindings);
            ResultSet results = qe.execSelect();
            int counter = 0;
            while (results.hasNext()) {
                QuerySolution qs = results.nextSolution();
                Resource dg = qs.getResource("dataGetter");
                Resource dgType = qs.getResource("dataGetterType");
                String dgClassName = this.getClassName(dgType.getURI());
                this.processExistingDataGetter(counter, dg.getURI(), dgClassName, editConfig, queryModel, jsonArray, servletContext);
                ++counter;
            }
            this.addJSONArrayToFormSpecificData(jsonArray, editConfig);
        }
        catch (Exception ex) {
            this.log.error((Object)("Error occurred in executing query " + querystr), (Throwable)ex);
        }
    }

    private void addJSONArrayToFormSpecificData(ArrayNode jsonArray, EditConfigurationVTwo editConfig) {
        HashMap<String, Object> data = editConfig.getFormSpecificData();
        data.put("existingPageContentUnits", jsonArray.toString());
        data.put("existingPageContentUnitsJSONArray", jsonArray);
    }

    private void processExistingDataGetter(int counter, String dataGetterURI, String dgClassName, EditConfigurationVTwo editConfig, OntModel queryModel, ArrayNode jsonArray, ServletContext context) {
        ProcessDataGetterN3 pn = ProcessDataGetterN3Utils.getDataGetterProcessorN3(dgClassName, null);
        this.addExistingN3Optional(editConfig, pn, counter);
        this.addExistingLiteralsAndUrisOnForm(editConfig, pn, counter);
        this.addExistingFields(editConfig, pn, counter);
        this.addExistingDataGetterNewResources(editConfig, pn, counter);
        this.addValuesInScope(editConfig, pn, counter, dataGetterURI, queryModel);
        this.addDataGetterSpecificFormData(dataGetterURI, pn, queryModel, jsonArray, context);
    }

    private void addDataGetterSpecificFormData(String dataGetterURI, ProcessDataGetterN3 pn, OntModel queryModel, ArrayNode jsonArray, ServletContext context) {
        ObjectNode jo = pn.getExistingValuesJSON(dataGetterURI, queryModel, context);
        jo.put("URI", dataGetterURI);
        jsonArray.add((JsonNode)jo);
    }

    private void addExistingN3Optional(EditConfigurationVTwo editConfig, ProcessDataGetterN3 pn, int counter) {
        List<String> n3 = pn.retrieveN3Required(counter);
        if (pn.retrieveN3Optional(counter) != null) {
            n3.addAll(pn.retrieveN3Optional(counter));
        }
        n3.add(this.getPageToDataGetterN3(pn, counter));
        editConfig.addN3Optional(n3);
    }

    private String getPageToDataGetterN3(ProcessDataGetterN3 pn, int counter) {
        String dataGetterVar = pn.getDataGetterVar(counter);
        return ManagePageGenerator.getDataGetterN3(dataGetterVar);
    }

    private void addExistingLiteralsAndUrisOnForm(EditConfigurationVTwo editConfig, ProcessDataGetterN3 pn, int counter) {
        List<String> literalsOnForm = pn.retrieveLiteralsOnForm(counter);
        editConfig.addLiteralsOnForm(literalsOnForm);
        List<String> urisOnForm = pn.retrieveUrisOnForm(counter);
        editConfig.addUrisOnForm(urisOnForm);
    }

    private void addExistingFields(EditConfigurationVTwo editConfig, ProcessDataGetterN3 pn, int counter) {
        List<FieldVTwo> existingFields = pn.retrieveFields(counter);
        editConfig.addFields(existingFields);
    }

    private void addExistingDataGetterNewResources(EditConfigurationVTwo editConfig, ProcessDataGetterN3 pn, int counter) {
        List<String> newResources = pn.getNewResources(counter);
        for (String r : newResources) {
            editConfig.addNewResource(r, null);
        }
    }

    private void addValuesInScope(EditConfigurationVTwo editConfig, ProcessDataGetterN3 pn, int counter, String dataGetterURI, OntModel queryModel) {
        pn.populateExistingValues(dataGetterURI, counter, queryModel);
        Map<String, List<Literal>> existingLiteralValues = pn.retrieveExistingLiteralValues();
        Map<String, List<String>> existingUriValues = pn.retrieveExistingUriValues();
        editConfig.addLiteralsInScope(existingLiteralValues);
        editConfig.addUrisInScope(existingUriValues);
    }

    private String getClassName(String dataGetterURI) {
        if (dataGetterURI.contains("java:")) {
            return dataGetterURI.substring("java:".length());
        }
        return dataGetterURI;
    }

    private String getExistingDataGettersQuery() {
        String query = this.getSparqlPrefix() + "SELECT ?dataGetter ?dataGetterType WHERE {" + "?page display:hasDataGetter ?dataGetter .  ?dataGetter rdf:type ?dataGetterType .}";
        return query;
    }

    private void setNewResources(EditConfigurationVTwo conf) {
        conf.addNewResource("page", null);
        conf.addNewResource("menuItem", null);
    }

    private void setSparqlQueries(EditConfigurationVTwo editConfiguration) {
        editConfiguration.setSparqlForAdditionalLiteralsInScope(new HashMap<String, String>());
        HashMap<String, String> urisInScope = new HashMap<String, String>();
        editConfiguration.setSparqlForAdditionalUrisInScope(urisInScope);
        editConfiguration.setSparqlForExistingLiterals(this.generateSparqlForExistingLiterals());
        editConfiguration.setSparqlForExistingUris(this.generateSparqlForExistingUris());
    }

    private HashMap<String, String> generateSparqlForExistingUris() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("menuItem", this.getExistingMenuItemQuery());
        map.put("action", this.getExistingActionQuery());
        return map;
    }

    private String getExistingMenuItemQuery() {
        String query = this.getSparqlPrefix() + "SELECT ?menuItem WHERE {?menuItem display:toPage ?page .}";
        return query;
    }

    private String getExistingActionQuery() {
        String query = this.getSparqlPrefix() + "SELECT ?action WHERE {?page display:requiresAction ?action .}";
        return query;
    }

    private HashMap<String, String> generateSparqlForExistingLiterals() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("pageName", this.getExistingPageNameQuery());
        map.put("prettyUrl", this.getExistingPrettyUrlQuery());
        map.put("menuPosition", this.getExistingMenuPositionQuery());
        map.put("menuLinkText", this.getExistingMenuLinkTextQuery());
        map.put("customTemplate", this.getExistingCustomTemplateQuery());
        map.put("isSelfContainedTemplate", this.getExistingIsSelfContainedTemplateQuery());
        return map;
    }

    private String getSparqlPrefix() {
        return "PREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \nPREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>";
    }

    private String getExistingPageNameQuery() {
        String query = this.getSparqlPrefix() + "SELECT ?pageName WHERE {" + "?page display:title ?pageName .}";
        return query;
    }

    private String getExistingPrettyUrlQuery() {
        String query = this.getSparqlPrefix() + "SELECT ?prettyUrl WHERE {" + "?page\tdisplay:urlMapping ?prettyUrl .}";
        return query;
    }

    private String getExistingMenuPositionQuery() {
        String menuPositionQuery = this.getSparqlPrefix() + "SELECT ?menuPosition WHERE {" + "?menuItem display:toPage ?page . ?menuItem display:menuPosition ?menuPosition. }";
        return menuPositionQuery;
    }

    private String getExistingMenuLinkTextQuery() {
        String menuPositionQuery = this.getSparqlPrefix() + "SELECT ?menuLinkText WHERE {" + "?menuItem display:toPage ?page . ?menuItem display:linkText ?menuLinkText. }";
        return menuPositionQuery;
    }

    private String getExistingCustomTemplateQuery() {
        String query = this.getSparqlPrefix() + "SELECT ?customTemplate WHERE {?page display:requiresBodyTemplate ?customTemplate .}";
        return query;
    }

    private String getExistingIsSelfContainedTemplateQuery() {
        String query = this.getSparqlPrefix() + "SELECT ?isSelfContainedTemplate WHERE {?page display:isSelfContainedTemplate ?isSelfContainedTemplate .}";
        return query;
    }

    public void addFormSpecificData(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, Object> formSpecificData = new HashMap<String, Object>();
        this.addRequiredPageData(vreq, formSpecificData);
        if (editConfiguration.getSubjectUri() != null) {
            this.addExistingPageData(vreq, formSpecificData);
        } else {
            this.addNewPageData(vreq, formSpecificData);
        }
        this.retrieveMenuPosition(editConfiguration, vreq, formSpecificData);
        editConfiguration.setFormSpecificData(formSpecificData);
    }

    private void addRequiredPageData(VitroRequest vreq, Map<String, Object> data) {
        MenuManagementDataUtils.includeRequiredSystemData(vreq.getSession().getServletContext(), data);
        data.put("classGroup", new ArrayList());
        data.put("classGroups", DataGetterUtils.getClassGroups((HttpServletRequest)vreq));
        data.put("classes", this.getAllVClasses(vreq));
        data.put("availablePermissions", this.getAvailablePermissions(vreq));
        data.put("availablePermissionOrderedList", this.getAvailablePermissonsOrderedURIs());
    }

    private void addExistingPageData(VitroRequest vreq, Map<String, Object> data) {
        this.addNewPageData(vreq, data);
        data.put("menuAction", "Edit");
        data.put("title", "Edit Menu Item");
        data.put("existingPageContentUnits", null);
    }

    private void addNewPageData(VitroRequest vreq, Map<String, Object> data) {
        data.put("title", "Add Menu Item");
        data.put("menuAction", "Add");
        data.put("selectedTemplateType", "default");
        String menuItemParam = vreq.getParameter("addMenuItem");
        if (menuItemParam != null) {
            data.put("addMenuItem", menuItemParam);
        }
    }

    private HashMap<String, String> getAvailablePermissions(VitroRequest vreq) {
        HashMap<String, String> availablePermissions = new HashMap<String, String>();
        String actionNamespace = "java:edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission#";
        availablePermissions.put(actionNamespace + "PageViewableAdmin", I18n.text((HttpServletRequest)vreq, "page_admin_permission_option", new Object[0]));
        availablePermissions.put(actionNamespace + "PageViewableCurator", I18n.text((HttpServletRequest)vreq, "page_curator_permission_option", new Object[0]));
        availablePermissions.put(actionNamespace + "PageViewableEditor", I18n.text((HttpServletRequest)vreq, "page_editor_permission_option", new Object[0]));
        availablePermissions.put(actionNamespace + "PageViewableLoggedIn", I18n.text((HttpServletRequest)vreq, "page_loggedin_permission_option", new Object[0]));
        availablePermissions.put(actionNamespace + "PageViewablePublic", I18n.text((HttpServletRequest)vreq, "page_public_permission_option", new Object[0]));
        return availablePermissions;
    }

    private List<String> getAvailablePermissonsOrderedURIs() {
        ArrayList<String> availablePermissionsOrdered = new ArrayList<String>();
        String actionNamespace = "java:edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission#";
        availablePermissionsOrdered.add(actionNamespace + "PageViewableAdmin");
        availablePermissionsOrdered.add(actionNamespace + "PageViewableCurator");
        availablePermissionsOrdered.add(actionNamespace + "PageViewableEditor");
        availablePermissionsOrdered.add(actionNamespace + "PageViewableLoggedIn");
        availablePermissionsOrdered.add(actionNamespace + "PageViewablePublic");
        return availablePermissionsOrdered;
    }

    public static final String getDataGetterN3(String dataGetterVar) {
        return "@prefix display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> . \n@prefix rdfs:<http://www.w3.org/2000/01/rdf-schema#> . \n?page display:hasDataGetter " + dataGetterVar + ".";
    }

    public void retrieveMenuPosition(EditConfigurationVTwo editConfig, VitroRequest vreq, Map<String, Object> formSpecificData) {
        boolean returnHighestMenuPosition = false;
        int availableMenuPosition = this.getAvailableMenuPosition(editConfig, vreq);
        formSpecificData.put("highestMenuPosition", "" + availableMenuPosition);
    }

    public int getAvailableMenuPosition(EditConfigurationVTwo editConfig, VitroRequest vreq) {
        int maxMenuPosition = this.getMaxMenuPosition(editConfig, vreq);
        return maxMenuPosition + 1;
    }

    private int getMaxMenuPosition(EditConfigurationVTwo editConfig, VitroRequest vreq) {
        int maxMenuPosition = 0;
        Literal menuPosition = null;
        this.setupModelSelectorsFromVitroRequest(vreq, editConfig);
        OntModel queryModel = ModelAccess.on((HttpServletRequest)vreq).getOntModel(new ModelAccess.LanguageOption[0]);
        String maxMenuPositionQuery = this.getMaxMenuPositionQueryString();
        QueryExecution qe = null;
        try {
            Query query = QueryFactory.create((String)maxMenuPositionQuery);
            qe = QueryExecutionFactory.create((Query)query, (Model)queryModel);
            ResultSet results = qe.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.nextSolution();
                menuPosition = qs.getLiteral("menuPosition");
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("Error occurred in executing query " + maxMenuPositionQuery), (Throwable)ex);
        }
        if (menuPosition != null) {
            maxMenuPosition = menuPosition.getInt();
        }
        return maxMenuPosition;
    }

    private String getMaxMenuPositionQueryString() {
        String query = this.getSparqlPrefix() + "SELECT ?menuPosition WHERE {?pageUri display:menuPosition ?menuPosition . } " + "ORDER BY DESC(?menuPosition) LIMIT 1";
        return query;
    }

    private List<HashMap<String, String>> getAllVClasses(VitroRequest vreq) {
        ArrayList<VClass> vclasses = new ArrayList<VClass>();
        VClassGroupsForRequest vcgc = VClassGroupCache.getVClassGroups((HttpServletRequest)vreq);
        List<VClassGroup> groups = vcgc.getGroups();
        for (VClassGroup vcg : groups) {
            for (VClass vc : vcg) {
                vclasses.add(vc);
            }
        }
        Collections.sort(vclasses);
        ArrayList<HashMap<String, String>> classes = new ArrayList<HashMap<String, String>>(vclasses.size());
        for (VClass vc : vclasses) {
            HashMap<String, String> vcObj = new HashMap<String, String>();
            vcObj.put("name", vc.getName());
            vcObj.put("URI", vc.getURI());
            classes.add(vcObj);
        }
        return classes;
    }
}

