/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.ontology.update;

import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceDataset;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.ontology.update.ABoxUpdater;
import edu.cornell.mannlib.vitro.webapp.ontology.update.AtomicOntologyChange;
import edu.cornell.mannlib.vitro.webapp.ontology.update.ChangeLogger;
import edu.cornell.mannlib.vitro.webapp.ontology.update.ChangeRecord;
import edu.cornell.mannlib.vitro.webapp.ontology.update.OntologyChangeParser;
import edu.cornell.mannlib.vitro.webapp.ontology.update.SimpleChangeLogger;
import edu.cornell.mannlib.vitro.webapp.ontology.update.SimpleChangeRecord;
import edu.cornell.mannlib.vitro.webapp.ontology.update.TBoxUpdater;
import edu.cornell.mannlib.vitro.webapp.ontology.update.UpdateSettings;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import edu.cornell.mannlib.vitro.webapp.servlet.setup.JenaDataSourceSetupBase;
import edu.cornell.mannlib.vitro.webapp.utils.jena.JenaIngestUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;

public class KnowledgeBaseUpdater {
    private final Log log = LogFactory.getLog(KnowledgeBaseUpdater.class);
    private UpdateSettings settings;
    private ChangeLogger logger;
    private ChangeRecord record;
    private static final boolean ADD = true;
    private static final boolean RETRACT = false;

    public KnowledgeBaseUpdater(UpdateSettings settings) {
        this.settings = settings;
        this.logger = null;
        this.record = new SimpleChangeRecord(settings.getAddedDataFile(), settings.getRemovedDataFile());
    }

    public boolean update(ServletContext servletContext) throws IOException {
        if (this.logger == null) {
            this.logger = new SimpleChangeLogger(this.settings.getLogFile(), this.settings.getErrorLogFile());
        }
        long startTime = System.currentTimeMillis();
        this.log.info((Object)"Performing any necessary data migration");
        this.logger.log("Started knowledge base migration");
        boolean changesPerformed = false;
        try {
            changesPerformed = this.performUpdate(servletContext);
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage());
            this.log.error((Object)e, (Throwable)e);
        }
        if (!this.logger.errorsWritten()) {
            this.assertSuccess(servletContext);
            this.logger.logWithDate("Finished knowledge base migration");
        }
        this.record.writeChanges();
        this.logger.closeLogs();
        long elapsedSecs = (System.currentTimeMillis() - startTime) / 1000L;
        this.log.info((Object)("Finished checking knowledge base in " + elapsedSecs + " second" + (elapsedSecs != 1L ? "s" : "")));
        return changesPerformed;
    }

    private boolean performUpdate(ServletContext servletContext) throws Exception {
        List<AtomicOntologyChange> rawChanges = this.getAtomicOntologyChanges();
        AtomicOntologyChangeLists changes = new AtomicOntologyChangeLists(rawChanges, this.settings.getNewTBoxModel(), this.settings.getOldTBoxModel());
        this.log.debug((Object)"performing SPARQL CONSTRUCT additions");
        this.performSparqlConstructs(this.settings.getSparqlConstructAdditionsDir(), this.settings.getRDFService(), true);
        this.log.debug((Object)"performing SPARQL CONSTRUCT retractions");
        this.performSparqlConstructs(this.settings.getSparqlConstructDeletionsDir(), this.settings.getRDFService(), false);
        this.log.info((Object)"\tchecking the abox");
        this.updateABox(changes);
        this.log.debug((Object)"performing post-processing SPARQL CONSTRUCT additions");
        this.performSparqlConstructs(this.settings.getSparqlConstructAdditionsDir() + "/post/", this.settings.getRDFService(), true);
        this.log.debug((Object)"performing post-processing SPARQL CONSTRUCT retractions");
        this.performSparqlConstructs(this.settings.getSparqlConstructDeletionsDir() + "/post/", this.settings.getRDFService(), false);
        if (this.updateRequired(servletContext)) {
            try {
                this.log.debug((Object)"\tupdating tbox annotations");
                this.updateTBoxAnnotations();
            }
            catch (Exception e) {
                this.log.error((Object)e, (Throwable)e);
            }
        }
        return !rawChanges.isEmpty();
    }

    private void performSparqlConstructs(String sparqlConstructDir, RDFService rdfService, boolean add) throws IOException {
        RDFServiceDataset dataset = new RDFServiceDataset(rdfService);
        File sparqlConstructDirectory = new File(sparqlConstructDir);
        this.log.debug((Object)("Using SPARQL CONSTRUCT directory " + sparqlConstructDirectory));
        if (!sparqlConstructDirectory.isDirectory()) {
            String logMsg = this.getClass().getName() + "performSparqlConstructs() expected to find a directory " + " at " + sparqlConstructDir + ". Unable to execute " + " SPARQL CONSTRUCTS.";
            this.logger.logError(logMsg);
            this.log.error((Object)logMsg);
            return;
        }
        List<File> sparqlFiles = Arrays.asList(sparqlConstructDirectory.listFiles());
        Collections.sort(sparqlFiles);
        JenaIngestUtils jiu = new JenaIngestUtils();
        for (File sparqlFile : sparqlFiles) {
            if (sparqlFile.isDirectory()) continue;
            StringBuffer fileContents = new StringBuffer();
            try {
                String ln;
                BufferedReader reader = new BufferedReader(new FileReader(sparqlFile));
                while ((ln = reader.readLine()) != null) {
                    fileContents.append(ln).append('\n');
                }
            }
            catch (FileNotFoundException fnfe) {
                String logMsg = "WARNING: performSparqlConstructs() could not find  SPARQL CONSTRUCT file " + sparqlFile + ". Skipping.";
                this.logger.log(logMsg);
                this.log.info((Object)logMsg);
                continue;
            }
            Model anonModel = ModelFactory.createDefaultModel();
            try {
                this.log.debug((Object)("\t\tprocessing SPARQL construct query from file " + sparqlFile.getName()));
                anonModel = RDFServiceUtils.parseModel(rdfService.sparqlConstructQuery(fileContents.toString(), RDFService.ModelSerializationFormat.NTRIPLE), RDFService.ModelSerializationFormat.NTRIPLE);
                long num = anonModel.size();
                if (num > 0L) {
                    String logMsg = (add ? "Added " : "Removed ") + num + " statement" + (num > 1L ? "s" : "") + " using the SPARQL construct query from file " + sparqlFile.getParentFile().getName() + "/" + sparqlFile.getName();
                    this.logger.log(logMsg);
                    this.log.info((Object)logMsg);
                }
            }
            catch (Exception e) {
                this.logger.logError(this.getClass().getName() + ".performSparqlConstructs() unable to execute " + "query at " + sparqlFile + ". Error message is: " + e.getMessage());
                this.log.error((Object)e, (Throwable)e);
            }
            if (!add) {
                StmtIterator sit = anonModel.listStatements();
                while (sit.hasNext()) {
                    Statement stmt = sit.nextStatement();
                    if (stmt.getSubject().isAnon() || stmt.getObject().isAnon()) continue;
                    Iterator graphIt = dataset.listNames();
                    while (graphIt.hasNext()) {
                        Model writeModel;
                        String graph = (String)graphIt.next();
                        if (!KnowledgeBaseUpdater.isUpdatableABoxGraph(graph) || !(writeModel = dataset.getNamedModel(graph)).contains(stmt)) continue;
                        writeModel.remove(stmt);
                    }
                }
                this.record.recordRetractions(anonModel);
                continue;
            }
            Model writeModel = dataset.getNamedModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-2");
            Model dedupeModel = dataset.getDefaultModel();
            Model additions = jiu.renameBNodes(anonModel, this.settings.getDefaultNamespace() + "n", dedupeModel);
            additions = this.stripBadURIs(additions);
            Model actualAdditions = ModelFactory.createDefaultModel();
            StmtIterator stmtIt = additions.listStatements();
            while (stmtIt.hasNext()) {
                Statement stmt = stmtIt.nextStatement();
                if (writeModel.contains(stmt)) continue;
                actualAdditions.add(stmt);
            }
            writeModel.add(actualAdditions);
            this.record.recordAdditions(actualAdditions);
        }
    }

    private Model stripBadURIs(Model additions) {
        Model badURITriples = ModelFactory.createDefaultModel();
        StmtIterator stmtIt = additions.listStatements();
        block0: while (stmtIt.hasNext()) {
            String[] uris = new String[3];
            Statement stmt = stmtIt.nextStatement();
            if (stmt.getSubject().isURIResource()) {
                uris[0] = stmt.getSubject().getURI();
            }
            uris[1] = stmt.getPredicate().getURI();
            if (stmt.getObject().isURIResource()) {
                uris[2] = ((Resource)stmt.getObject()).getURI();
            }
            for (int i = 0; i < 3; ++i) {
                IRIFactory factory;
                IRI iri;
                String uri = uris[i];
                if (uri == null || !(iri = (factory = IRIFactory.jenaImplementation()).create(uri)).hasViolation(false)) continue;
                badURITriples.add(stmt);
                this.log.error((Object)("Discarding added triple " + stmt + " because " + "it includes one or more invalid URIs."));
                continue block0;
            }
        }
        additions.remove(badURITriples);
        return additions;
    }

    private List<AtomicOntologyChange> getAtomicOntologyChanges() throws IOException {
        return new OntologyChangeParser(this.logger).parseFile(this.settings.getDiffFile());
    }

    private void updateABox(AtomicOntologyChangeLists changes) throws IOException {
        ABoxUpdater aboxUpdater = new ABoxUpdater(this.settings, this.logger, this.record);
        aboxUpdater.processPropertyChanges(changes.getAtomicPropertyChanges());
        aboxUpdater.processClassChanges(changes.getAtomicClassChanges());
    }

    private void updateTBoxAnnotations() {
        TBoxUpdater tboxUpdater = new TBoxUpdater(this.settings, this.logger, this.record);
        try {
            tboxUpdater.modifyPropertyQualifications();
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to modify qualified property config file ", (Throwable)e);
        }
        try {
            tboxUpdater.updateDefaultAnnotationValues();
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to update default annotation values ", (Throwable)e);
        }
    }

    public boolean updateRequired(ServletContext servletContext) throws IOException {
        boolean required = true;
        String sparqlQueryStr = KnowledgeBaseUpdater.loadSparqlQuery(this.settings.getAskUpdatedQueryFile());
        if (sparqlQueryStr == null) {
            return required;
        }
        RDFService rdfService = ModelAccess.on(servletContext).getRDFService();
        try {
            if (rdfService.sparqlAskQuery(sparqlQueryStr)) {
                required = false;
            } else {
                required = true;
                if (JenaDataSourceSetupBase.isFirstStartup()) {
                    this.assertSuccess(servletContext);
                    this.log.info((Object)"The application is starting with an empty database. An indication will be added to the database that a knowledge base migration to the current version is not required.");
                    required = false;
                }
            }
        }
        catch (RDFServiceException e) {
            this.log.error((Object)"error trying to execute query to find out if knowledge base update is required", (Throwable)e);
        }
        return required;
    }

    public static String loadSparqlQuery(String filePath) throws IOException {
        String ln;
        File file = new File(filePath);
        if (!file.exists()) {
            throw new RuntimeException("SPARQL file not found at " + filePath);
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        StringBuffer fileContents = new StringBuffer();
        while ((ln = reader.readLine()) != null) {
            fileContents.append(ln).append('\n');
        }
        return fileContents.toString();
    }

    private void assertSuccess(ServletContext servletContext) throws FileNotFoundException, IOException {
        try {
            RDFService rdfService = ModelAccess.on(servletContext).getRDFService();
            ChangeSet changeSet = rdfService.manufactureChangeSet();
            File successAssertionsFile = new File(this.settings.getSuccessAssertionsFile());
            FileInputStream inStream = new FileInputStream(successAssertionsFile);
            changeSet.addAddition(inStream, RDFService.ModelSerializationFormat.N3, "http://vitro.mannlib.cornell.edu/default/vitro-kb-applicationMetadata");
            rdfService.changeSetUpdate(changeSet);
        }
        catch (Exception e) {
            this.log.error((Object)"unable to make RDF assertions about successful  update to new ontology version: ", (Throwable)e);
        }
    }

    public static boolean isUpdatableABoxGraph(String graphName) {
        return graphName != null && !graphName.contains("tbox") && !graphName.contains("filegraph") && !graphName.contains("x-arq:UnionGraph");
    }

    private class AtomicOntologyChangeLists {
        private List<AtomicOntologyChange> atomicClassChanges = new ArrayList<AtomicOntologyChange>();
        private List<AtomicOntologyChange> atomicPropertyChanges = new ArrayList<AtomicOntologyChange>();

        public AtomicOntologyChangeLists(List<AtomicOntologyChange> changeList, OntModel newTboxModel, OntModel oldTboxModel) throws IOException {
            for (AtomicOntologyChange changeObj : changeList) {
                if (changeObj.getSourceURI() != null) {
                    KnowledgeBaseUpdater.this.log.debug((Object)("triaging " + changeObj));
                    if (oldTboxModel.getOntProperty(changeObj.getSourceURI()) != null) {
                        this.atomicPropertyChanges.add(changeObj);
                        KnowledgeBaseUpdater.this.log.debug((Object)"added to property changes");
                        continue;
                    }
                    if (oldTboxModel.getOntClass(changeObj.getSourceURI()) != null) {
                        this.atomicClassChanges.add(changeObj);
                        KnowledgeBaseUpdater.this.log.debug((Object)"added to class changes");
                        continue;
                    }
                    if ("Prop".equals(changeObj.getNotes())) {
                        this.atomicPropertyChanges.add(changeObj);
                        continue;
                    }
                    if ("Class".equals(changeObj.getNotes())) {
                        this.atomicClassChanges.add(changeObj);
                        continue;
                    }
                    KnowledgeBaseUpdater.this.logger.log("WARNING: Source URI is neither a Property nor a Class. Change Object skipped for sourceURI: " + changeObj.getSourceURI());
                    continue;
                }
                if (changeObj.getDestinationURI() != null) {
                    if (newTboxModel.getOntProperty(changeObj.getDestinationURI()) != null) {
                        this.atomicPropertyChanges.add(changeObj);
                        continue;
                    }
                    if (newTboxModel.getOntClass(changeObj.getDestinationURI()) != null) {
                        this.atomicClassChanges.add(changeObj);
                        continue;
                    }
                    KnowledgeBaseUpdater.this.logger.log("WARNING: Destination URI is neither a Property nor a Class. Change Object skipped for destinationURI: " + changeObj.getDestinationURI());
                    continue;
                }
                KnowledgeBaseUpdater.this.logger.log("WARNING: Source and Destination URI can't be null. Change Object skipped");
            }
        }

        public List<AtomicOntologyChange> getAtomicClassChanges() {
            return this.atomicClassChanges;
        }

        public List<AtomicOntologyChange> getAtomicPropertyChanges() {
            return this.atomicPropertyChanges;
        }
    }
}

