/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.adapters;

import edu.cornell.mannlib.vitro.webapp.dao.jena.SparqlGraph;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.AbstractBulkUpdater;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEvents;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.util.iterator.ExtendedIterator;

public class SparqlBulkUpdater
extends AbstractBulkUpdater {
    private SparqlGraph graph;

    public SparqlBulkUpdater(SparqlGraph graph) {
        this.graph = graph;
    }

    @Override
    protected void performAddModel(Model model) {
        this.verbModel(model, "INSERT");
    }

    @Override
    protected void performRemoveModel(Model model) {
        this.verbModel(model, "DELETE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verbModel(Model model, String verb) {
        Model m = ModelFactory.createDefaultModel();
        int testLimit = 1000;
        int count = 0;
        try (StmtIterator stmtIt = model.listStatements();){
            while (stmtIt.hasNext()) {
                m.add(stmtIt.nextStatement());
                if (++count % testLimit != 0 && stmtIt.hasNext()) continue;
                StringWriter sw = new StringWriter();
                m.write((Writer)sw, "N-TRIPLE");
                StringBuffer updateStringBuff = new StringBuffer();
                String graphURI = this.graph.getGraphURI();
                updateStringBuff.append(verb + " DATA { " + (graphURI != null ? "GRAPH <" + graphURI + "> { " : ""));
                updateStringBuff.append(sw);
                updateStringBuff.append((graphURI != null ? " } " : "") + " }");
                String updateString = updateStringBuff.toString();
                this.graph.executeUpdate(updateString);
                m.removeAll();
            }
        }
    }

    @Override
    protected void performRemoveAll() {
        try (ExtendedIterator it = GraphUtil.findAll((Graph)this.graph);){
            while (it.hasNext()) {
                Triple t = (Triple)it.next();
                this.graph.delete(t);
                it.remove();
            }
        }
        this.graph.removeAll();
        this.graph.getEventManager().notifyEvent((Graph)this.graph, (Object)GraphEvents.removeAll);
    }
}

