/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.filter;

import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceGraph;
import edu.cornell.mannlib.vitro.webapp.rdfservice.filter.LanguageFilteringRDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model.RDFServiceModel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;

public class LanguageFilteringUtils {
    public static List<String> localesToLanguages(Enumeration<?> locales) {
        ArrayList<String> langs = new ArrayList<String>();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            langs.add(locale.toString().replace("_", "-"));
        }
        if (langs.isEmpty()) {
            langs.add("en");
        }
        return langs;
    }

    public static OntModel wrapOntModelInALanguageFilter(OntModel rawModel, ServletRequest req) {
        List<String> languages = LanguageFilteringUtils.localesToLanguages(req.getLocales());
        return ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, (Model)RDFServiceGraph.createRDFServiceModel(new RDFServiceGraph(new LanguageFilteringRDFService(new RDFServiceModel((Model)rawModel), languages))));
    }

    private LanguageFilteringUtils() {
    }
}

