/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena;

import edu.cornell.mannlib.vitro.webapp.dao.jena.DatasetWrapper;
import edu.cornell.mannlib.vitro.webapp.dao.jena.RDFServiceDataset;
import edu.cornell.mannlib.vitro.webapp.dao.jena.SparqlGraph;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ChangeSet;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ModelChange;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceImpl;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import edu.cornell.mannlib.vitro.webapp.utils.logging.ToString;
import edu.cornell.mannlib.vitro.webapp.utils.sparql.ResultSetIterators;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sdb.SDB;
import org.apache.log4j.lf5.util.StreamUtils;

public abstract class RDFServiceJena
extends RDFServiceImpl
implements RDFService {
    private static final Log log = LogFactory.getLog(RDFServiceJena.class);
    private static final boolean WHERE_CLAUSE = true;
    private static final boolean CONSTRUCT = true;
    private static final boolean DESCRIBE = false;

    protected abstract DatasetWrapper getDatasetWrapper();

    @Override
    public abstract boolean changeSetUpdate(ChangeSet var1) throws RDFServiceException;

    protected void notifyListenersOfPreChangeEvents(ChangeSet changeSet) {
        for (Object o : changeSet.getPreChangeEvents()) {
            this.notifyListenersOfEvent(o);
        }
    }

    protected void insureThatInputStreamsAreResettable(ChangeSet changeSet) throws IOException {
        for (ModelChange modelChange : changeSet.getModelChanges()) {
            if (!modelChange.getSerializedModel().markSupported()) {
                byte[] bytes = IOUtils.toByteArray((InputStream)modelChange.getSerializedModel());
                modelChange.setSerializedModel(new ByteArrayInputStream(bytes));
            }
            modelChange.getSerializedModel().mark(Integer.MAX_VALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyChangeSetToModel(ChangeSet changeSet, Dataset dataset) {
        for (ModelChange modelChange : changeSet.getModelChanges()) {
            dataset.getLock().enterCriticalSection(false);
            try {
                Model model = modelChange.getGraphURI() == null ? dataset.getDefaultModel() : dataset.getNamedModel(modelChange.getGraphURI());
                this.operateOnModel(model, modelChange, dataset);
            }
            finally {
                dataset.getLock().leaveCriticalSection();
            }
        }
    }

    protected void notifyListenersOfPostChangeEvents(ChangeSet changeSet) {
        for (Object o : changeSet.getPostChangeEvents()) {
            this.notifyListenersOfEvent(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void operateOnModel(Model model, ModelChange modelChange, Dataset dataset) {
        model.enterCriticalSection(false);
        try {
            if (log.isDebugEnabled()) {
                this.dumpOperation(model, modelChange);
            }
            if (modelChange.getOperation() == ModelChange.Operation.ADD) {
                Model addition = this.parseModel(modelChange);
                model.add(addition);
            } else if (modelChange.getOperation() == ModelChange.Operation.REMOVE) {
                Model removal = this.parseModel(modelChange);
                model.remove(removal);
                if (dataset != null) {
                    this.removeBlankNodesWithSparqlUpdate(dataset, removal, modelChange.getGraphURI());
                }
            } else {
                log.error((Object)"unrecognized operation type");
            }
        }
        finally {
            model.leaveCriticalSection();
        }
    }

    private void dumpOperation(Model model, ModelChange modelChange) {
        String op = String.valueOf((Object)modelChange.getOperation());
        byte[] changeBytes = new byte[]{};
        try {
            modelChange.getSerializedModel().mark(Integer.MAX_VALUE);
            changeBytes = StreamUtils.getBytes((InputStream)modelChange.getSerializedModel());
            modelChange.getSerializedModel().reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int puncCount = 0;
        boolean inUri = false;
        boolean inQuotes = false;
        for (byte b : changeBytes) {
            if (inQuotes) {
                if (b != 34) continue;
                inQuotes = false;
                continue;
            }
            if (inUri) {
                if (b != 62) continue;
                inUri = false;
                continue;
            }
            if (b == 34) {
                inQuotes = true;
                continue;
            }
            if (b == 60) {
                inUri = true;
                continue;
            }
            if (b != 44 && b != 59 && b != 46) continue;
            ++puncCount;
        }
        String changeString = new String(changeBytes).replace('\n', ' ');
        log.debug((Object)String.format(">>>>OPERATION: %3.3s %03dpunc, format=%s, graphUri='%s'\n    start=%.200s\n    model=%s", new Object[]{modelChange.getOperation(), puncCount, modelChange.getSerializationFormat(), modelChange.getGraphURI(), changeString, ToString.modelToString(model)}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBlankNodesWithSparqlUpdate(Dataset dataset, Model model, String graphURI) {
        ArrayList<Statement> blankNodeStatements = new ArrayList<Statement>();
        StmtIterator stmtIt = model.listStatements();
        while (stmtIt.hasNext()) {
            Statement stmt = stmtIt.nextStatement();
            if (!stmt.getSubject().isAnon() && !stmt.getObject().isAnon()) continue;
            blankNodeStatements.add(stmt);
        }
        if (blankNodeStatements.size() == 0) {
            return;
        }
        Model blankNodeModel = ModelFactory.createDefaultModel();
        blankNodeModel.add(blankNodeStatements);
        log.debug((Object)("removal model size " + model.size()));
        log.debug((Object)("blank node model size " + blankNodeModel.size()));
        if (blankNodeModel.size() == 1L) {
            log.warn((Object)("Deleting single triple with blank node: " + blankNodeModel));
            log.warn((Object)"This likely indicates a problem; excessive data may be deleted.");
        }
        Query rootFinderQuery = QueryFactory.create((String)"SELECT DISTINCT ?s WHERE { ?s ?p ?o OPTIONAL { ?ss ?pp ?s } FILTER (!isBlank(?s) || !bound(?ss)) }");
        try (QueryExecution qe = QueryExecutionFactory.create((Query)rootFinderQuery, (Model)blankNodeModel);){
            ResultSet rs = qe.execSelect();
            if (!rs.hasNext()) {
                log.warn((Object)"No rooted blank node trees; deletion is not possible.");
            }
            while (rs.hasNext()) {
                QuerySolution qs = rs.next();
                Resource s = qs.getResource("s");
                String treeFinder = this.makeDescribe(s);
                Query treeFinderQuery = QueryFactory.create((String)treeFinder);
                try (QueryExecution qee = QueryExecutionFactory.create((Query)treeFinderQuery, (Model)blankNodeModel);){
                    Model tree = qee.execDescribe();
                    Dataset ds = DatasetFactory.createMem();
                    if (graphURI == null) {
                        ds.setDefaultModel(dataset.getDefaultModel());
                    } else {
                        ds.addNamedModel(graphURI, dataset.getNamedModel(graphURI));
                    }
                    if (s.isAnon()) {
                        this.removeUsingSparqlUpdate(ds, tree, graphURI);
                        continue;
                    }
                    StmtIterator sit = tree.listStatements(s, null, (RDFNode)null);
                    while (sit.hasNext()) {
                        Statement stmt = sit.nextStatement();
                        RDFNode n = stmt.getObject();
                        Model m2 = ModelFactory.createDefaultModel();
                        if (n.isResource()) {
                            Resource s2 = (Resource)n;
                            String smallerTree = this.makeDescribe(s2);
                            log.debug((Object)smallerTree);
                            Query smallerTreeQuery = QueryFactory.create((String)smallerTree);
                            try (QueryExecution qe3 = QueryExecutionFactory.create((Query)smallerTreeQuery, (Model)tree);){
                                qe3.execDescribe(m2);
                            }
                        }
                        m2.add(stmt);
                        this.removeUsingSparqlUpdate(ds, m2, graphURI);
                    }
                }
            }
        }
    }

    private String makeDescribe(Resource s) {
        StringBuffer query = new StringBuffer("DESCRIBE <");
        if (s.isAnon()) {
            query.append("_:" + s.getId().toString());
        } else {
            query.append(s.getURI());
        }
        query.append(">");
        return query.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUsingSparqlUpdate(Dataset dataset, Model model, String graphURI) {
        StmtIterator stmtIt = model.listStatements();
        if (!stmtIt.hasNext()) {
            stmtIt.close();
            return;
        }
        StringBuffer queryBuff = new StringBuffer();
        queryBuff.append("CONSTRUCT { \n");
        List<Statement> stmts = stmtIt.toList();
        stmts = this.sort(stmts);
        this.addStatementPatterns(stmts, queryBuff, false);
        queryBuff.append("} WHERE { \n");
        if (graphURI != null) {
            queryBuff.append("    GRAPH <" + graphURI + "> { \n");
        }
        stmtIt = model.listStatements();
        stmts = stmtIt.toList();
        stmts = this.sort(stmts);
        this.addStatementPatterns(stmts, queryBuff, true);
        if (graphURI != null) {
            queryBuff.append("    } \n");
        }
        queryBuff.append("} \n");
        log.debug((Object)queryBuff.toString());
        Query construct = QueryFactory.create((String)queryBuff.toString());
        Dataset ds = DatasetFactory.createMem();
        if (graphURI == null) {
            ds.setDefaultModel(dataset.getDefaultModel());
        } else {
            ds.addNamedModel(graphURI, dataset.getNamedModel(graphURI));
        }
        try (QueryExecution qe = QueryExecutionFactory.create((Query)construct, (Dataset)ds);){
            Model m = qe.execConstruct();
            if (graphURI != null) {
                dataset.getNamedModel(graphURI).remove(m);
            } else {
                dataset.getDefaultModel().remove(m);
            }
        }
    }

    private List<Statement> sort(List<Statement> stmts) {
        ArrayList<Statement> output = new ArrayList<Statement>();
        int originalSize = stmts.size();
        if (originalSize == 1) {
            return stmts;
        }
        List<Statement> remaining = stmts;
        ConcurrentLinkedQueue<Resource> subjQueue = new ConcurrentLinkedQueue<Resource>();
        for (Statement stmt : remaining) {
            if (!stmt.getSubject().isURIResource()) continue;
            subjQueue.add(stmt.getSubject());
            break;
        }
        if (subjQueue.isEmpty()) {
            log.warn((Object)"No named subject in statement patterns");
            return stmts;
        }
        while (remaining.size() > 0) {
            if (subjQueue.isEmpty()) {
                subjQueue.add(remaining.get(0).getSubject());
            }
            while (!subjQueue.isEmpty()) {
                Resource subj = (Resource)subjQueue.poll();
                ArrayList<Statement> temp = new ArrayList<Statement>();
                for (Statement stmt : remaining) {
                    if (stmt.getSubject().equals((Object)subj)) {
                        output.add(stmt);
                        if (!stmt.getObject().isResource()) continue;
                        subjQueue.add((Resource)stmt.getObject());
                        continue;
                    }
                    temp.add(stmt);
                }
                remaining = temp;
            }
        }
        if (output.size() != originalSize) {
            throw new RuntimeException("original list size was " + originalSize + " but sorted size is " + output.size());
        }
        return output;
    }

    private void addStatementPatterns(List<Statement> stmts, StringBuffer patternBuff, boolean whereClause) {
        for (Statement stmt : stmts) {
            Triple t = stmt.asTriple();
            patternBuff.append(SparqlGraph.sparqlNodeDelete(t.getSubject(), null));
            patternBuff.append(" ");
            patternBuff.append(SparqlGraph.sparqlNodeDelete(t.getPredicate(), null));
            patternBuff.append(" ");
            patternBuff.append(SparqlGraph.sparqlNodeDelete(t.getObject(), null));
            patternBuff.append(" .\n");
            if (!whereClause) continue;
            if (t.getSubject().isBlank()) {
                patternBuff.append("    FILTER(isBlank(" + SparqlGraph.sparqlNodeDelete(t.getSubject(), null)).append(")) \n");
            }
            if (!t.getObject().isBlank()) continue;
            patternBuff.append("    FILTER(isBlank(" + SparqlGraph.sparqlNodeDelete(t.getObject(), null)).append(")) \n");
        }
    }

    private Model parseModel(ModelChange modelChange) {
        Model model = ModelFactory.createDefaultModel();
        model.read(modelChange.getSerializedModel(), null, RDFServiceJena.getSerializationFormatString(modelChange.getSerializationFormat()));
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getRDFResultStream(String query, boolean construct, RDFService.ModelSerializationFormat resultFormat) throws RDFServiceException {
        try (DatasetWrapper dw = this.getDatasetWrapper();){
            ByteArrayInputStream byteArrayInputStream;
            Dataset d = dw.getDataset();
            Query q = this.createQuery(query);
            QueryExecution qe = this.createQueryExecution(query, q, d);
            ByteArrayOutputStream serializedModel = new ByteArrayOutputStream();
            try {
                ByteArrayInputStream result;
                Model m = construct ? qe.execConstruct() : qe.execDescribe();
                m.write((OutputStream)serializedModel, RDFServiceJena.getSerializationFormatString(resultFormat));
                byteArrayInputStream = result = new ByteArrayInputStream(serializedModel.toByteArray());
            }
            catch (Throwable throwable) {
                qe.close();
                throw throwable;
            }
            qe.close();
            return byteArrayInputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getRDFModel(String query, boolean construct, Model model) throws RDFServiceException {
        try (DatasetWrapper dw = this.getDatasetWrapper();){
            Dataset d = dw.getDataset();
            Query q = this.createQuery(query);
            try (QueryExecution qe = this.createQueryExecution(query, q, d);){
                Model model2 = construct ? qe.execConstruct(model) : qe.execDescribe(model);
            }
        }
    }

    @Override
    public InputStream sparqlConstructQuery(String query, RDFService.ModelSerializationFormat resultFormat) throws RDFServiceException {
        return this.getRDFResultStream(query, true, resultFormat);
    }

    @Override
    public void sparqlConstructQuery(String query, Model model) throws RDFServiceException {
        this.getRDFModel(query, true, model);
    }

    @Override
    public InputStream sparqlDescribeQuery(String query, RDFService.ModelSerializationFormat resultFormat) throws RDFServiceException {
        return this.getRDFResultStream(query, false, resultFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream sparqlSelectQuery(String query, RDFService.ResultFormat resultFormat) throws RDFServiceException {
        try (DatasetWrapper dw = this.getDatasetWrapper();){
            ByteArrayInputStream byteArrayInputStream;
            Dataset d = dw.getDataset();
            Query q = this.createQuery(query);
            QueryExecution qe = this.createQueryExecution(query, q, d);
            try {
                ByteArrayInputStream result;
                ResultSet resultSet = qe.execSelect();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                switch (resultFormat) {
                    case CSV: {
                        ResultSetFormatter.outputAsCSV((OutputStream)outputStream, (ResultSet)resultSet);
                        break;
                    }
                    case TEXT: {
                        ResultSetFormatter.out((OutputStream)outputStream, (ResultSet)resultSet);
                        break;
                    }
                    case JSON: {
                        ResultSetFormatter.outputAsJSON((OutputStream)outputStream, (ResultSet)resultSet);
                        break;
                    }
                    case XML: {
                        ResultSetFormatter.outputAsXML((OutputStream)outputStream, (ResultSet)resultSet);
                        break;
                    }
                    default: {
                        throw new RDFServiceException("unrecognized result format");
                    }
                }
                byteArrayInputStream = result = new ByteArrayInputStream(outputStream.toByteArray());
            }
            catch (Throwable throwable) {
                qe.close();
                throw throwable;
            }
            qe.close();
            return byteArrayInputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sparqlSelectQuery(String query, ResultSetConsumer consumer) throws RDFServiceException {
        try (DatasetWrapper dw = this.getDatasetWrapper();){
            Dataset d = dw.getDataset();
            Query q = this.createQuery(query);
            try (QueryExecution qe = this.createQueryExecution(query, q, d);){
                consumer.processResultSet(qe.execSelect());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sparqlAskQuery(String query) throws RDFServiceException {
        try (DatasetWrapper dw = this.getDatasetWrapper();){
            boolean bl;
            Dataset d = dw.getDataset();
            Query q = this.createQuery(query);
            QueryExecution qe = this.createQueryExecution(query, q, d);
            try {
                bl = qe.execAsk();
            }
            catch (Throwable throwable) {
                qe.close();
                throw throwable;
            }
            qe.close();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getGraphURIs() throws RDFServiceException {
        try (DatasetWrapper dw = this.getDatasetWrapper();){
            Dataset d = dw.getDataset();
            ArrayList<String> graphURIs = new ArrayList<String>();
            Iterator nameIt = d.listNames();
            while (nameIt.hasNext()) {
                graphURIs.add((String)nameIt.next());
            }
            ArrayList<String> arrayList = graphURIs;
            return arrayList;
        }
    }

    @Override
    public void getGraphMetadata() throws RDFServiceException {
    }

    @Override
    public void serializeAll(OutputStream outputStream) throws RDFServiceException {
        String query = "SELECT * WHERE { GRAPH ?g {?s ?p ?o}}";
        this.serialize(outputStream, query);
    }

    @Override
    public void serializeGraph(String graphURI, OutputStream outputStream) throws RDFServiceException {
        String query = "SELECT * WHERE { GRAPH <" + graphURI + "> {?s ?p ?o}}";
        this.serialize(outputStream, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serialize(OutputStream outputStream, String query) throws RDFServiceException {
        try (DatasetWrapper dw = this.getDatasetWrapper();){
            Dataset d = dw.getDataset();
            Query q = this.createQuery(query);
            QueryExecution qe = this.createQueryExecution(query, q, d);
            qe.getContext().set(SDB.jdbcFetchSize, (Object)Integer.MIN_VALUE);
            qe.getContext().set(SDB.jdbcStream, true);
            qe.getContext().set(SDB.streamGraphAPI, true);
            try {
                ResultSet resultSet = qe.execSelect();
                if (resultSet.getResultVars().contains("g")) {
                    ResultSetIterators.ResultSetQuadsIterator quads = new ResultSetIterators.ResultSetQuadsIterator(resultSet);
                    RDFDataMgr.writeQuads((OutputStream)outputStream, (Iterator)quads);
                } else {
                    ResultSetIterators.ResultSetTriplesIterator triples = new ResultSetIterators.ResultSetTriplesIterator(resultSet);
                    RDFDataMgr.writeTriples((OutputStream)outputStream, (Iterator)triples);
                }
            }
            finally {
                qe.close();
            }
        }
    }

    @Override
    public boolean isEquivalentGraph(String graphURI, InputStream serializedGraph, RDFService.ModelSerializationFormat serializationFormat) throws RDFServiceException {
        Model fileModel = RDFServiceUtils.parseModel(serializedGraph, serializationFormat);
        Model tripleStoreModel = new RDFServiceDataset(this).getNamedModel(graphURI);
        Model fromTripleStoreModel = ModelFactory.createDefaultModel().add(tripleStoreModel);
        return fileModel.isIsomorphicWith(fromTripleStoreModel);
    }

    @Override
    public boolean isEquivalentGraph(String graphURI, Model graph) throws RDFServiceException {
        Model tripleStoreModel = new RDFServiceDataset(this).getNamedModel(graphURI);
        Model fromTripleStoreModel = ModelFactory.createDefaultModel().add(tripleStoreModel);
        return graph.isIsomorphicWith(fromTripleStoreModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long countTriples(RDFNode subject, RDFNode predicate, RDFNode object) throws RDFServiceException {
        Query countQuery = QueryFactory.create((String)"SELECT (COUNT(?s) AS ?count) WHERE { ?s ?p ?o } ORDER BY ?s ?p ?o", (Syntax)Syntax.syntaxSPARQL_11);
        QuerySolutionMap map = new QuerySolutionMap();
        if (subject != null) {
            map.add("s", subject);
        }
        if (predicate != null) {
            map.add("p", predicate);
        }
        if (object != null) {
            map.add("o", object);
        }
        try (DatasetWrapper dw = this.getDatasetWrapper();){
            Dataset d = dw.getDataset();
            try (QueryExecution qexec = QueryExecutionFactory.create((Query)countQuery, (Dataset)d, (QuerySolution)map);){
                ResultSet results = qexec.execSelect();
                if (results.hasNext()) {
                    QuerySolution soln = results.nextSolution();
                    Literal literal = soln.getLiteral("count");
                    long l = literal.getLong();
                    return l;
                }
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model getTriples(RDFNode subject, RDFNode predicate, RDFNode object, long limit, long offset) throws RDFServiceException {
        Query query = QueryFactory.create((String)"CONSTRUCT WHERE { ?s ?p ?o }", (Syntax)Syntax.syntaxSPARQL_11);
        QuerySolutionMap map = new QuerySolutionMap();
        if (subject != null) {
            map.add("s", subject);
        }
        if (predicate != null) {
            map.add("p", predicate);
        }
        if (object != null) {
            map.add("o", object);
        }
        query.setOffset(offset);
        query.setLimit(limit);
        Model triples = ModelFactory.createDefaultModel();
        try (DatasetWrapper dw = this.getDatasetWrapper();){
            Dataset d = dw.getDataset();
            try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Dataset)d, (QuerySolution)map);){
                qexec.execConstruct(triples);
            }
            Model model = triples;
            return model;
        }
    }

    @Override
    public void close() {
    }

    protected QueryExecution createQueryExecution(String queryString, Query q, Dataset d) {
        return QueryExecutionFactory.create((Query)q, (Dataset)d);
    }
}

