/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.sparql;

import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyInstance;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyInstanceDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetClazzAllProperties
extends BaseEditController {
    private static final Log log = LogFactory.getLog(GetClazzAllProperties.class);

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.USE_MISCELLANEOUS_PAGES.ACTION)) {
            return;
        }
        VitroRequest vreq = new VitroRequest(request);
        String vClassURI = vreq.getParameter("vClassURI");
        if (vClassURI == null || vClassURI.trim().equals("")) {
            return;
        }
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("label", "http://www.w3.org/2000/01/rdf-schema#label0");
        DataPropertyDao ddao = vreq.getUnfilteredWebappDaoFactory().getDataPropertyDao();
        List<DataProperty> dataProps = ddao.getDataPropertiesForVClass(vClassURI);
        Iterator dataPropIt = dataProps.iterator();
        HashSet<String> dpropURIs = new HashSet<String>();
        while (dataPropIt.hasNext()) {
            DataProperty dp = (DataProperty)dataPropIt.next();
            if (dpropURIs.contains(dp.getURI())) continue;
            dpropURIs.add(dp.getURI());
            DataProperty dprop = ddao.getDataPropertyByURI(dp.getURI());
            if (dprop == null || dprop.getLocalName() == null && dprop.getLocalName().equals("")) continue;
            hm.put(dprop.getLocalName(), dprop.getURI() + "0");
        }
        ObjectPropertyDao odao = vreq.getUnfilteredWebappDaoFactory().getObjectPropertyDao();
        PropertyInstanceDao piDao = vreq.getUnfilteredWebappDaoFactory().getPropertyInstanceDao();
        VClassDao vcDao = vreq.getUnfilteredWebappDaoFactory().getVClassDao();
        List<String> superclassURIs = vcDao.getAllSuperClassURIs(vClassURI);
        superclassURIs.add(vClassURI);
        superclassURIs.addAll(vcDao.getEquivalentClassURIs(vClassURI));
        HashMap<String, PropertyInstance> propInstMap = new HashMap<String, PropertyInstance>();
        for (String classURI : superclassURIs) {
            Collection<PropertyInstance> propInsts = piDao.getAllPropInstByVClass(classURI);
            try {
                for (PropertyInstance propInst : propInsts) {
                    propInstMap.put(propInst.getPropertyURI(), propInst);
                }
            }
            catch (NullPointerException ex) {
            }
        }
        ArrayList propInsts = new ArrayList();
        propInsts.addAll(propInstMap.values());
        Collections.sort(propInsts);
        Iterator propInstIt = propInsts.iterator();
        HashSet<String> opropURIs = new HashSet<String>();
        while (propInstIt.hasNext()) {
            PropertyInstance pi = (PropertyInstance)propInstIt.next();
            if (opropURIs.contains(pi.getPropertyURI())) continue;
            opropURIs.add(pi.getPropertyURI());
            ObjectProperty oprop = odao.getObjectPropertyByURI(pi.getPropertyURI());
            if (oprop == null || oprop.getLocalName() == null && oprop.getLocalName().equals("")) continue;
            hm.put(oprop.getLocalName(), oprop.getURI() + "1");
        }
        String respo = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        respo = respo + "<options>";
        Object[] keys = hm.keySet().toArray();
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            String value = (String)hm.get(key);
            respo = respo + "<option><key>" + key + "</key>" + "<value>" + value.substring(0, value.length() - 1) + "</value>" + "<type>" + value.charAt(value.length() - 1) + "</type>" + "</option>";
        }
        respo = respo + "</options>";
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        out.println(respo);
        out.flush();
        out.close();
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

