/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.json;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JacksonUtils {
    private static final String QUOTE = "\"";

    public static String quote(String raw) {
        if (raw == null) {
            return "\"\"";
        }
        return QUOTE + JsonStringEncoder.getInstance().quoteAsString(raw) + QUOTE;
    }

    public static JsonNode parseJson(String json) {
        try {
            return new ObjectMapper().readTree(json);
        }
        catch (IOException e) {
            throw new JacksonUtilsException(e);
        }
    }

    public static List<String> jsonArrayToStrings(ArrayNode values) {
        ArrayList<String> strings = new ArrayList<String>();
        for (JsonNode node : values) {
            strings.add(node.asText());
        }
        return strings;
    }

    public static class JacksonUtilsException
    extends RuntimeException {
        public JacksonUtilsException() {
        }

        public JacksonUtilsException(String message, Throwable cause) {
            super(message, cause);
        }

        public JacksonUtilsException(String message) {
            super(message);
        }

        public JacksonUtilsException(Throwable cause) {
            super(cause);
        }
    }
}

