/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsOrdering;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsSelection;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsSelectionCriteria;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsSelector;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class UserAccountsSelectorTest
extends AbstractTestClass {
    private static final String N3_DATA_FILENAME = "UserAccountsSelectorTest.n3";
    private static final String NS_MINE = "http://vivo.mydomain.edu/individual/";
    private static OntModel ontModel;
    private UserAccountsSelection selection;
    private UserAccountsSelectionCriteria criteria;

    @BeforeClass
    public static void setupModel() throws IOException {
        InputStream stream = UserAccountsSelectorTest.class.getResourceAsStream(N3_DATA_FILENAME);
        Model model = ModelFactory.createDefaultModel();
        model.read(stream, null, "N3");
        stream.close();
        ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM, (Model)model);
        ontModel.prepare();
    }

    @Test(expected=NullPointerException.class)
    public void modelIsNull() {
        UserAccountsSelector.select(null, (UserAccountsSelectionCriteria)this.criteria(10, 1, UserAccountsOrdering.DEFAULT_ORDERING, "", ""));
    }

    @Test(expected=NullPointerException.class)
    public void criteriaIsNull() {
        UserAccountsSelector.select((OntModel)ontModel, null);
    }

    @Test
    public void checkAllFields() {
        this.selectOnCriteria(1, 10, UserAccountsOrdering.DEFAULT_ORDERING, "", "");
        this.assertSelectedUris(10, "user10");
        UserAccount acct = (UserAccount)this.selection.getUserAccounts().get(0);
        Assert.assertEquals((String)"uri", (Object)"http://vivo.mydomain.edu/individual/user10", (Object)acct.getUri());
        Assert.assertEquals((String)"email", (Object)"email@jones.edu", (Object)acct.getEmailAddress());
        Assert.assertEquals((String)"firstName", (Object)"Bob", (Object)acct.getFirstName());
        Assert.assertEquals((String)"lastName", (Object)"Caruso", (Object)acct.getLastName());
        Assert.assertEquals((String)"password", (Object)"garbage", (Object)acct.getMd5Password());
        Assert.assertEquals((String)"expires", (long)1100234965897L, (long)acct.getPasswordLinkExpires());
        Assert.assertEquals((String)"loginCount", (long)50L, (long)acct.getLoginCount());
        Assert.assertEquals((String)"lastLogin", (long)1020304050607080L, (long)acct.getLastLoginTime());
        Assert.assertEquals((String)"status", (Object)UserAccount.Status.ACTIVE, (Object)acct.getStatus());
        this.assertEqualSets("permissions", Collections.singleton("http://vivo.mydomain.edu/individual/role2"), acct.getPermissionSetUris());
        Assert.assertEquals((String)"rootUser", (Object)false, (Object)acct.isRootUser());
    }

    @Test
    public void checkFieldsForRootUser() {
        this.selectOnCriteria(1, 8, UserAccountsOrdering.DEFAULT_ORDERING, "", "");
        this.assertSelectedUris(10, "user08");
        UserAccount acct = (UserAccount)this.selection.getUserAccounts().get(0);
        Assert.assertEquals((String)"uri", (Object)"http://vivo.mydomain.edu/individual/user08", (Object)acct.getUri());
        Assert.assertEquals((String)"email", (Object)"email@henry.edu", (Object)acct.getEmailAddress());
        Assert.assertEquals((String)"firstName", (Object)"Mary", (Object)acct.getFirstName());
        Assert.assertEquals((String)"lastName", (Object)"McInerney", (Object)acct.getLastName());
        Assert.assertEquals((String)"password", (Object)"garbage", (Object)acct.getMd5Password());
        Assert.assertEquals((String)"expires", (long)0L, (long)acct.getPasswordLinkExpires());
        Assert.assertEquals((String)"loginCount", (long)7L, (long)acct.getLoginCount());
        Assert.assertEquals((String)"lastLogin", (long)1122334455667788L, (long)acct.getLastLoginTime());
        Assert.assertEquals((String)"status", (Object)UserAccount.Status.ACTIVE, (Object)acct.getStatus());
        this.assertEqualSets("permissions", Collections.emptySet(), acct.getPermissionSetUris());
        Assert.assertEquals((String)"rootUser", (Object)true, (Object)acct.isRootUser());
    }

    @Test
    public void showFirstPageOfFifteen() {
        this.selectOnCriteria(15, 1, UserAccountsOrdering.DEFAULT_ORDERING, "", "");
        this.assertSelectedUris(10, "user01", "user02", "user03", "user04", "user05", "user06", "user07", "user08", "user09", "user10");
    }

    @Test
    public void showFirstPageOfOne() {
        this.selectOnCriteria(1, 1, UserAccountsOrdering.DEFAULT_ORDERING, "", "");
        this.assertSelectedUris(10, "user01");
    }

    @Test
    public void showFirstPageOfFive() {
        this.selectOnCriteria(5, 1, UserAccountsOrdering.DEFAULT_ORDERING, "", "");
        this.assertSelectedUris(10, "user01", "user02", "user03", "user04", "user05");
    }

    @Test
    public void showSecondPageOfSeven() {
        this.selectOnCriteria(7, 2, UserAccountsOrdering.DEFAULT_ORDERING, "", "");
        this.assertSelectedUris(10, "user08", "user09", "user10");
    }

    @Test
    public void showTenthPageOfThree() {
        this.selectOnCriteria(3, 10, UserAccountsOrdering.DEFAULT_ORDERING, "", "");
        this.assertSelectedUris(10, new String[0]);
    }

    @Test
    public void sortByEmailAscending() {
        UserAccountsOrdering orderBy = new UserAccountsOrdering(UserAccountsOrdering.Field.EMAIL, UserAccountsOrdering.Direction.ASCENDING);
        this.selectOnCriteria(3, 1, orderBy, "", "");
        this.assertSelectedUris(10, "user01", "user02", "user03");
    }

    @Test
    public void sortByEmailDescending() {
        UserAccountsOrdering orderBy = new UserAccountsOrdering(UserAccountsOrdering.Field.EMAIL, UserAccountsOrdering.Direction.DESCENDING);
        this.selectOnCriteria(3, 1, orderBy, "", "");
        this.assertSelectedUris(10, "user10", "user09", "user08");
    }

    @Test
    public void sortByFirstNameAscending() {
        UserAccountsOrdering orderBy = new UserAccountsOrdering(UserAccountsOrdering.Field.FIRST_NAME, UserAccountsOrdering.Direction.ASCENDING);
        this.selectOnCriteria(3, 1, orderBy, "", "");
        this.assertSelectedUris(10, "user02", "user10", "user09");
    }

    @Test
    public void sortByFirstNameDescending() {
        UserAccountsOrdering orderBy = new UserAccountsOrdering(UserAccountsOrdering.Field.FIRST_NAME, UserAccountsOrdering.Direction.DESCENDING);
        this.selectOnCriteria(3, 1, orderBy, "", "");
        this.assertSelectedUris(10, "user01", "user03", "user04");
    }

    @Test
    public void sortByLastNameAscending() {
        UserAccountsOrdering orderBy = new UserAccountsOrdering(UserAccountsOrdering.Field.LAST_NAME, UserAccountsOrdering.Direction.ASCENDING);
        this.selectOnCriteria(3, 1, orderBy, "", "");
        this.assertSelectedUris(10, "user03", "user05", "user09");
    }

    @Test
    public void sortByLastNameDescending() {
        UserAccountsOrdering orderBy = new UserAccountsOrdering(UserAccountsOrdering.Field.LAST_NAME, UserAccountsOrdering.Direction.DESCENDING);
        this.selectOnCriteria(3, 1, orderBy, "", "");
        this.assertSelectedUris(10, "user06", "user07", "user01");
    }

    @Test
    public void sortByStatusAscending() {
        UserAccountsOrdering orderBy = new UserAccountsOrdering(UserAccountsOrdering.Field.STATUS, UserAccountsOrdering.Direction.ASCENDING);
        this.selectOnCriteria(3, 1, orderBy, "", "");
        this.assertSelectedUris(10, "user07", "user01", "user04");
    }

    @Test
    public void sortByStatusDescending() {
        UserAccountsOrdering orderBy = new UserAccountsOrdering(UserAccountsOrdering.Field.STATUS, UserAccountsOrdering.Direction.DESCENDING);
        this.selectOnCriteria(3, 1, orderBy, "", "");
        this.assertSelectedUris(10, "user02", "user03", "user06");
    }

    @Test
    public void sortByLoginCountAscending() {
        UserAccountsOrdering orderBy = new UserAccountsOrdering(UserAccountsOrdering.Field.LOGIN_COUNT, UserAccountsOrdering.Direction.ASCENDING);
        this.selectOnCriteria(3, 1, orderBy, "", "");
        this.assertSelectedUris(10, "user06", "user03", "user07");
    }

    @Test
    public void sortByLoginCountDescending() {
        UserAccountsOrdering orderBy = new UserAccountsOrdering(UserAccountsOrdering.Field.LOGIN_COUNT, UserAccountsOrdering.Direction.DESCENDING);
        this.selectOnCriteria(3, 1, orderBy, "", "");
        this.assertSelectedUris(10, "user10", "user04", "user08");
    }

    @Test
    public void sortByLastLoginTimeAscending() {
        UserAccountsOrdering orderBy = new UserAccountsOrdering(UserAccountsOrdering.Field.LAST_LOGIN_TIME, UserAccountsOrdering.Direction.ASCENDING);
        this.selectOnCriteria(3, 1, orderBy, "", "");
        this.assertSelectedUris(10, "user07", "user03", "user06");
    }

    @Test
    public void sortByLastLoginTimeDescending() {
        UserAccountsOrdering orderBy = new UserAccountsOrdering(UserAccountsOrdering.Field.LAST_LOGIN_TIME, UserAccountsOrdering.Direction.DESCENDING);
        this.selectOnCriteria(3, 1, orderBy, "", "");
        this.assertSelectedUris(10, "user08", "user10", "user09");
    }

    @Test
    public void filterAgainstRole1() {
        this.selectOnCriteria(20, 1, UserAccountsOrdering.DEFAULT_ORDERING, "http://vivo.mydomain.edu/individual/role1", "");
        this.assertSelectedUris(6, "user01", "user02", "user03", "user05", "user06", "user09");
    }

    @Test
    public void filterAgainstRole2() {
        this.selectOnCriteria(20, 1, UserAccountsOrdering.DEFAULT_ORDERING, "http://vivo.mydomain.edu/individual/role2", "");
        this.assertSelectedUris(2, "user03", "user10");
    }

    @Test
    public void filterAgainstNoSuchRole() {
        this.selectOnCriteria(20, 1, UserAccountsOrdering.DEFAULT_ORDERING, "BogusRole", "");
        this.assertSelectedUris(0, new String[0]);
    }

    @Test
    public void searchTermFoundInAllThreeFields() {
        this.selectOnCriteria(20, 1, UserAccountsOrdering.DEFAULT_ORDERING, "", "bob");
        this.assertSelectedUris(3, "user02", "user05", "user10");
    }

    @Test
    public void searchTermNotFound() {
        this.selectOnCriteria(20, 1, UserAccountsOrdering.DEFAULT_ORDERING, "", "bogus");
        this.assertSelectedUris(0, new String[0]);
    }

    @Test
    public void searchTermContainsSpecialRegexCharacters() {
        this.selectOnCriteria(20, 1, UserAccountsOrdering.DEFAULT_ORDERING, "", "b.b");
        this.assertSelectedUris(0, new String[0]);
    }

    @Test
    public void searchWithFilter() {
        this.selectOnCriteria(20, 1, UserAccountsOrdering.DEFAULT_ORDERING, "http://vivo.mydomain.edu/individual/role1", "bob");
        this.assertSelectedUris(2, "user02", "user05");
    }

    @Test
    public void searchWithFilterPaginatedWithFunkySortOrder() {
        this.selectOnCriteria(1, 2, new UserAccountsOrdering(UserAccountsOrdering.Field.STATUS, UserAccountsOrdering.Direction.ASCENDING), "http://vivo.mydomain.edu/individual/role1", "bob");
        this.assertSelectedUris(2, "user02");
    }

    private UserAccountsSelectionCriteria criteria(int accountsPerPage, int pageIndex, UserAccountsOrdering orderBy, String roleFilterUri, String searchTerm) {
        return new UserAccountsSelectionCriteria(accountsPerPage, pageIndex, orderBy, roleFilterUri, searchTerm);
    }

    private void selectOnCriteria(int accountsPerPage, int pageIndex, UserAccountsOrdering orderBy, String roleFilterUri, String searchTerm) {
        this.criteria = new UserAccountsSelectionCriteria(accountsPerPage, pageIndex, orderBy, roleFilterUri, searchTerm);
        this.selection = UserAccountsSelector.select((OntModel)ontModel, (UserAccountsSelectionCriteria)this.criteria);
    }

    private void assertSelectedUris(int resultCount, String ... uris) {
        Assert.assertEquals((String)"result count", (long)resultCount, (long)this.selection.getResultCount());
        List<String> expectedList = Arrays.asList(uris);
        ArrayList<String> actualList = new ArrayList<String>();
        for (UserAccount a : this.selection.getUserAccounts()) {
            String[] uriParts = a.getUri().split("/");
            actualList.add(uriParts[uriParts.length - 1]);
        }
        Assert.assertEquals((String)"uris", expectedList, actualList);
    }
}

