/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import com.fasterxml.jackson.databind.JsonNode;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyGroup;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.ListControllerTestBase;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.ListPropertyWebappsController;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.OntologyDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.PropertyGroupDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.VClassDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactoryStub;
import stubs.edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccessFactoryStub;
import stubs.javax.servlet.http.HttpServletRequestStub;

public class ListPropertyWebappsControllerTest
extends ListControllerTestBase {
    private static final String PATH = "./propertyEdit";
    private static final String ONT1 = "http://ont1/";
    private static final String ONT2 = "http://ont2/";
    private static final String ONT3 = "http://ont3/";
    private static final String OP1 = "http://ont1/first";
    private static final String OP2 = "http://ont2/second";
    private static final String OP3 = "http://ont1/third";
    private static final String OP4 = "http://ont1/fourth";
    private static final String OP2_PICK_NAME = "The second one";
    private static final String OP3_PICK_NAME = "The third one";
    private static final String OP4_PICK_NAME = "The fourth one";
    private static final String OP3_LOCALNAME_W_PREFIX = "ontology1:third";
    private static final String OP4_LOCALNAME_W_PREFIX = "ontology1:fourth";
    private static final String DOMAIN_NONE = "http://domain/noSuchDomain";
    private static final String DOMAIN_NO_NAME = "http://domain/domainWithNoName";
    private static final String DOMAIN_W_NAME = "http://domain/namedDomain";
    private static final String NAME_DOMAIN = "An excellent domain";
    private static final String RANGE_NONE = "http://domain/noSuchRange";
    private static final String RANGE_NO_NAME = "http://domain/rangeWithNoName";
    private static final String RANGE_W_NAME = "http://domain/namedRange";
    private static final String NAME_RANGE = "Home on the range";
    private static final String GROUP_NONE = "http://domain/noSuchGroup";
    private static final String GROUP_NO_NAME = "http://domain/groupWithNoName";
    private static final String GROUP_W_NAME = "http://domain/namedGroup";
    private static final String NAME_GROUP = "The Groupsters";
    private static final JsonNode NO_DATA_RESPONSE = ListPropertyWebappsControllerTest.arrayOf(new JsonNode[]{mapper.createObjectNode().put("name", "No object properties found")});
    private static final JsonNode RESPONSE_UNFILTERED = ListPropertyWebappsControllerTest.arrayOf(new JsonNode[]{ListPropertyWebappsControllerTest.propertyListNode("./propertyEdit", "http://ont1/first", "first", "first", "", "", "unspecified"), ListPropertyWebappsControllerTest.propertyListNode("./propertyEdit", "http://ont1/fourth", "The fourth one", "ontology1:fourth", "An excellent domain", "Home on the range", "The Groupsters"), ListPropertyWebappsControllerTest.propertyListNode("./propertyEdit", "http://ont2/second", "The second one", "second", "", "", "unknown group"), ListPropertyWebappsControllerTest.propertyListNode("./propertyEdit", "http://ont1/third", "The third one", "ontology1:third", "domainWithNoName", "rangeWithNoName", "")});
    private static final JsonNode RESPONSE_FILTERED_BY_ONT1 = ListPropertyWebappsControllerTest.arrayOf(new JsonNode[]{ListPropertyWebappsControllerTest.propertyListNode("./propertyEdit", "http://ont1/first", "first", "first", "", "", "unspecified"), ListPropertyWebappsControllerTest.propertyListNode("./propertyEdit", "http://ont1/fourth", "The fourth one", "ontology1:fourth", "An excellent domain", "Home on the range", "The Groupsters"), ListPropertyWebappsControllerTest.propertyListNode("./propertyEdit", "http://ont1/third", "The third one", "ontology1:third", "domainWithNoName", "rangeWithNoName", "")});
    private static final JsonNode RESPONSE_FILTERED_BY_ONT2 = ListPropertyWebappsControllerTest.arrayOf(new JsonNode[]{ListPropertyWebappsControllerTest.propertyListNode("./propertyEdit", "http://ont2/second", "The second one", "second", "", "", "unknown group")});
    private static final JsonNode RESPONSE_FILTERED_BY_ONT3 = ListPropertyWebappsControllerTest.arrayOf(new JsonNode[]{mapper.createObjectNode().put("name", "No object properties found")});
    private ListPropertyWebappsController controller;
    private HttpServletRequestStub req;
    private ModelAccessFactoryStub modelsFactory;
    private WebappDaoFactoryStub wadf;
    private ObjectPropertyDaoStub opdao;
    private OntologyDaoStub odao;
    private PropertyGroupDaoStub pgdao;
    private VClassDaoStub vcdao;

    @Before
    public void setup() {
        this.controller = new ListPropertyWebappsController();
        this.req = new HttpServletRequestStub();
        new VitroRequest((HttpServletRequest)this.req).setCollator(Collator.getInstance());
        this.opdao = new ObjectPropertyDaoStub();
        this.odao = new OntologyDaoStub();
        this.pgdao = new PropertyGroupDaoStub();
        this.vcdao = new VClassDaoStub();
        this.wadf = new WebappDaoFactoryStub();
        this.wadf.setObjectPropertyDao(this.opdao);
        this.wadf.setOntologyDao(this.odao);
        this.wadf.setPropertyGroupDao(this.pgdao);
        this.wadf.setVClassDao(this.vcdao);
        this.modelsFactory = new ModelAccessFactoryStub();
        this.modelsFactory.get(this.req).setWebappDaoFactory(this.wadf, new ModelAccess.WebappDaoFactoryOption[]{ModelAccess.PolicyOption.POLICY_NEUTRAL});
        this.modelsFactory.get(this.req).setWebappDaoFactory(this.wadf, new ModelAccess.WebappDaoFactoryOption[]{ModelAccess.PolicyOption.POLICY_NEUTRAL, ModelAccess.LanguageOption.LANGUAGE_NEUTRAL});
    }

    @Test
    public void noDataProperties() throws Exception {
        ListPropertyWebappsControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, NO_DATA_RESPONSE);
    }

    @Test
    public void unfiltered() throws Exception {
        this.populate();
        ListPropertyWebappsControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, RESPONSE_UNFILTERED);
    }

    @Test
    public void filteredByOnt1() throws Exception {
        this.populate();
        this.req.addParameter("ontologyUri", ONT1);
        ListPropertyWebappsControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, RESPONSE_FILTERED_BY_ONT1);
    }

    @Test
    public void filteredByOnt2() throws Exception {
        this.populate();
        this.req.addParameter("ontologyUri", ONT2);
        ListPropertyWebappsControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, RESPONSE_FILTERED_BY_ONT2);
    }

    @Test
    public void filteredByOnt3() throws Exception {
        this.populate();
        this.req.addParameter("ontologyUri", ONT3);
        ListPropertyWebappsControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, RESPONSE_FILTERED_BY_ONT3);
    }

    private void populate() {
        this.vcdao.setVClass(this.vclass(DOMAIN_NO_NAME, null));
        this.vcdao.setVClass(this.vclass(DOMAIN_W_NAME, NAME_DOMAIN));
        this.vcdao.setVClass(this.vclass(RANGE_NO_NAME, null));
        this.vcdao.setVClass(this.vclass(RANGE_W_NAME, NAME_RANGE));
        this.pgdao.addPropertyGroup(this.propertyGroup(GROUP_NO_NAME, null, 5, new Property[0]));
        this.pgdao.addPropertyGroup(this.propertyGroup(GROUP_W_NAME, NAME_GROUP, 3, new Property[0]));
        this.opdao.addObjectProperty(this.objectProperty(OP1, null, null, null, null, null));
        this.opdao.addObjectProperty(this.objectProperty(OP2, OP2_PICK_NAME, null, DOMAIN_NONE, RANGE_NONE, GROUP_NONE));
        this.opdao.addObjectProperty(this.objectProperty(OP3, OP3_PICK_NAME, OP3_LOCALNAME_W_PREFIX, DOMAIN_NO_NAME, RANGE_NO_NAME, GROUP_NO_NAME));
        this.opdao.addObjectProperty(this.objectProperty(OP4, OP4_PICK_NAME, OP4_LOCALNAME_W_PREFIX, DOMAIN_W_NAME, RANGE_W_NAME, GROUP_W_NAME));
    }

    private PropertyGroup propertyGroup(String uri, String name, int displayRank, Property ... properties) {
        PropertyGroup pg = new PropertyGroup();
        pg.setURI(uri);
        pg.setName(name);
        pg.setDisplayRank(displayRank);
        pg.setPropertyList(new ArrayList<Property>(Arrays.asList(properties)));
        return pg;
    }

    private ObjectProperty objectProperty(String uri, String name, String localNameWithPrefix, String domainVClass, String rangeVClass, String propertyGroup) {
        ObjectProperty op = new ObjectProperty();
        op.setURI(uri);
        op.setPickListName(name);
        op.setLocalNameWithPrefix(localNameWithPrefix);
        op.setRangeVClassURI(rangeVClass);
        op.setDomainVClassURI(domainVClass);
        op.setGroupURI(propertyGroup);
        return op;
    }

    private VClass vclass(String uri, String name) {
        VClass vc = new VClass();
        vc.setURI(uri);
        vc.setPickListName(name);
        return vc;
    }
}

