/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.cornell.mannlib.vitro.webapp.beans.Datatype;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyGroup;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.ListControllerTestBase;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.ShowObjectPropertyHierarchyController;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.text.Collator;
import javax.servlet.http.HttpServletRequest;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.DatatypeDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.PropertyGroupDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.VClassDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactoryStub;
import stubs.edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccessFactoryStub;
import stubs.javax.servlet.http.HttpServletRequestStub;

public class ShowObjectPropertyHierarchyControllerTest
extends ListControllerTestBase {
    private static final String PATH = "propertyEdit";
    private static final String ONT1 = "http://ont1/";
    private static final String ONT2 = "http://ont2/";
    private static final String ONT3 = "http://ont3/";
    private static final String URI_GREATAUNT = "http://ont1/greatAunt";
    private static final String URI_GRANDMOTHER = "http://ont2/grandmother";
    private static final String URI_AUNT = "http://ont1/aunt";
    private static final String URI_MOTHER = "http://ont1/mother";
    private static final String URI_DAUGHTER = "http://ont2/daughter";
    private static final String NAME_GRANDMOTHER = "GrandMother";
    private static final String NAME_AUNT = "Aunt";
    private static final String NAME_MOTHER = "Mother";
    private static final String NAME_DAUGHTER = "Me";
    private static final String LOCAL_NAME_WITH_PREFIX_AUNT = "family:aunt";
    private static final String LOCAL_NAME_WITH_PREFIX_MOTHER = "family:mother";
    private static final String DOMAIN_NONE = "http://domain/noSuchDomain";
    private static final String DOMAIN_NO_NAME = "http://domain/domainWithNoName";
    private static final String DOMAIN_W_NAME = "http://domain/namedDomain";
    private static final String NAME_DOMAIN = "An excellent domain";
    private static final String RANGE_NONE = "http://domain/noSuchRange";
    private static final String RANGE_NO_NAME = "http://domain/rangeWithNoName";
    private static final String RANGE_W_NAME = "http://domain/namedRange";
    private static final String NAME_RANGE = "Home on the range";
    private static final String GROUP_NONE = "http://domain/noSuchGroup";
    private static final String GROUP_NO_NAME = "http://domain/groupWithNoName";
    private static final String GROUP_W_NAME = "http://domain/namedGroup";
    private static final String NAME_GROUP = "The Groupsters";
    private static final ArrayNode NO_DATA_RESPONSE = ShowObjectPropertyHierarchyControllerTest.arrayOf(new JsonNode[]{ShowObjectPropertyHierarchyControllerTest.propertyHierarchyNode("propertyEdit", "nullfake", "ullfake", "ullfake", "", "", "unspecified", new ObjectNode[0])});
    private static final ArrayNode RESPONSE_UNFILTERED = ShowObjectPropertyHierarchyControllerTest.arrayOf(new JsonNode[]{ShowObjectPropertyHierarchyControllerTest.propertyHierarchyNode("propertyEdit", "http://ont2/grandmother", "GrandMother", "grandmother", "", "", "unknown group", ShowObjectPropertyHierarchyControllerTest.propertyHierarchyNode("propertyEdit", "http://ont1/aunt", "Aunt", "family:aunt", "domainWithNoName", "", "", new ObjectNode[0]), ShowObjectPropertyHierarchyControllerTest.propertyHierarchyNode("propertyEdit", "http://ont1/mother", "Mother", "family:mother", "namedDomain", "", "The Groupsters", ShowObjectPropertyHierarchyControllerTest.propertyHierarchyNode("propertyEdit", "http://ont2/daughter", "Me", "daughter", "", "", "unspecified", new ObjectNode[0]))), ShowObjectPropertyHierarchyControllerTest.propertyHierarchyNode("propertyEdit", "http://ont1/greatAunt", "greatAunt", "greatAunt", "", "", "unspecified", new ObjectNode[0])});
    private static final ArrayNode RESPONSE_FILTERED_BY_ONT1 = ShowObjectPropertyHierarchyControllerTest.arrayOf(new JsonNode[]{ShowObjectPropertyHierarchyControllerTest.propertyHierarchyNode("propertyEdit", "http://ont1/greatAunt", "greatAunt", "greatAunt", "", "", "unspecified", new ObjectNode[0])});
    private static final ArrayNode RESPONSE_FILTERED_BY_ONT2 = ShowObjectPropertyHierarchyControllerTest.arrayOf(new JsonNode[]{ShowObjectPropertyHierarchyControllerTest.propertyHierarchyNode("propertyEdit", "http://ont2/grandmother", "GrandMother", "grandmother", "", "", "unknown group", ShowObjectPropertyHierarchyControllerTest.propertyHierarchyNode("propertyEdit", "http://ont2/daughter", "Me", "daughter", "", "", "unspecified", new ObjectNode[0]))});
    private static final ArrayNode RESPONSE_FILTERED_BY_ONT3 = ShowObjectPropertyHierarchyControllerTest.arrayOf(new JsonNode[0]);
    private ShowObjectPropertyHierarchyController controller;
    private HttpServletRequestStub req;
    private ModelAccessFactoryStub modelsFactory;
    private WebappDaoFactoryStub wadf;
    private DatatypeDaoStub ddao;
    private ObjectPropertyDaoStub opdao;
    private PropertyGroupDaoStub pgdao;
    private VClassDaoStub vcdao;

    @Before
    public void setup() {
        this.controller = new ShowObjectPropertyHierarchyController();
        this.req = new HttpServletRequestStub();
        new VitroRequest((HttpServletRequest)this.req).setCollator(Collator.getInstance());
        this.ddao = new DatatypeDaoStub();
        this.opdao = new ObjectPropertyDaoStub();
        this.pgdao = new PropertyGroupDaoStub();
        this.vcdao = new VClassDaoStub();
        this.wadf = new WebappDaoFactoryStub();
        this.wadf.setDatatypeDao(this.ddao);
        this.wadf.setObjectPropertyDao(this.opdao);
        this.wadf.setPropertyGroupDao(this.pgdao);
        this.wadf.setVClassDao(this.vcdao);
        this.modelsFactory = new ModelAccessFactoryStub();
        this.modelsFactory.get(this.req).setWebappDaoFactory(this.wadf, new ModelAccess.WebappDaoFactoryOption[]{ModelAccess.POLICY_NEUTRAL});
        this.modelsFactory.get(this.req).setWebappDaoFactory(this.wadf, new ModelAccess.WebappDaoFactoryOption[]{ModelAccess.POLICY_NEUTRAL, ModelAccess.ASSERTIONS_ONLY});
        this.modelsFactory.get(this.req).setWebappDaoFactory(this.wadf, new ModelAccess.WebappDaoFactoryOption[]{ModelAccess.POLICY_NEUTRAL, ModelAccess.LANGUAGE_NEUTRAL});
    }

    @Test
    public void noDataTest() throws Exception {
        String rawResponse = ShowObjectPropertyHierarchyControllerTest.getJsonFromController((FreemarkerHttpServlet)this.controller, this.req);
        String kluged = rawResponse + "]}";
        this.assertKlugedJson((JsonNode)NO_DATA_RESPONSE, kluged);
    }

    @Test
    public void unfiltered() throws Exception {
        this.populate();
        ShowObjectPropertyHierarchyControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, (JsonNode)RESPONSE_UNFILTERED);
    }

    @Test
    public void filteredByOnt1() throws Exception {
        this.populate();
        this.req.addParameter("ontologyUri", ONT1);
        ShowObjectPropertyHierarchyControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, (JsonNode)RESPONSE_FILTERED_BY_ONT1);
    }

    @Test
    public void filteredByOnt2() throws Exception {
        this.populate();
        this.req.addParameter("ontologyUri", ONT2);
        ShowObjectPropertyHierarchyControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, (JsonNode)RESPONSE_FILTERED_BY_ONT2);
    }

    @Test
    public void filteredByOnt3() throws Exception {
        this.populate();
        this.req.addParameter("ontologyUri", ONT3);
        ShowObjectPropertyHierarchyControllerTest.assertMatchingJson((FreemarkerHttpServlet)this.controller, this.req, (JsonNode)RESPONSE_FILTERED_BY_ONT3);
    }

    private void populate() {
        this.vcdao.setVClass(this.vclass(DOMAIN_NO_NAME, null));
        this.vcdao.setVClass(this.vclass(DOMAIN_W_NAME, NAME_DOMAIN));
        this.ddao.addDatatype(this.datatype(RANGE_NO_NAME, null));
        this.ddao.addDatatype(this.datatype(RANGE_W_NAME, NAME_RANGE));
        this.pgdao.addPropertyGroup(this.propertyGroup(GROUP_NO_NAME, null));
        this.pgdao.addPropertyGroup(this.propertyGroup(GROUP_W_NAME, NAME_GROUP));
        this.opdao.addObjectProperty(this.objectProperty(URI_GREATAUNT, null, null, null, null, null));
        this.opdao.addObjectProperty(this.objectProperty(URI_GRANDMOTHER, NAME_GRANDMOTHER, null, DOMAIN_NONE, RANGE_NONE, GROUP_NONE));
        this.opdao.addObjectProperty(this.objectProperty(URI_AUNT, NAME_AUNT, LOCAL_NAME_WITH_PREFIX_AUNT, DOMAIN_NO_NAME, RANGE_NO_NAME, GROUP_NO_NAME), URI_GRANDMOTHER);
        this.opdao.addObjectProperty(this.objectProperty(URI_MOTHER, NAME_MOTHER, LOCAL_NAME_WITH_PREFIX_MOTHER, DOMAIN_W_NAME, RANGE_W_NAME, GROUP_W_NAME), URI_GRANDMOTHER);
        this.opdao.addObjectProperty(this.objectProperty(URI_DAUGHTER, NAME_DAUGHTER, null, null, null, null), URI_MOTHER);
    }

    private ObjectProperty objectProperty(String uri, String name, String localNameWithPrefix, String domainClassUri, String rangeDatatypeUri, String groupUri) {
        ObjectProperty op = new ObjectProperty();
        op.setURI(uri);
        op.setPickListName(name);
        op.setLocalNameWithPrefix(localNameWithPrefix);
        op.setDomainVClassURI(domainClassUri);
        op.setDomainPublic(this.getLocalName(domainClassUri));
        op.setRangeVClassURI(rangeDatatypeUri);
        op.setGroupURI(groupUri);
        return op;
    }

    private Datatype datatype(String uri, String name) {
        Datatype d = new Datatype();
        d.setUri(uri);
        d.setName(name);
        return d;
    }

    private PropertyGroup propertyGroup(String uri, String name) {
        PropertyGroup pg = new PropertyGroup();
        pg.setURI(uri);
        pg.setName(name);
        return pg;
    }

    private VClass vclass(String uri) {
        VClass vc = new VClass();
        vc.setURI(uri);
        return vc;
    }

    private VClass vclass(String uri, String name) {
        VClass vc = this.vclass(uri);
        vc.setName(name);
        return vc;
    }

    private String getLocalName(String uri) {
        if (uri == null) {
            return null;
        }
        int delimiter = Math.max(uri.lastIndexOf(35), uri.lastIndexOf(47));
        return uri.substring(delimiter + 1);
    }
}

