/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.json;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.json.JsonObjectProducer;
import edu.cornell.mannlib.vitro.webapp.controller.json.JsonServlet;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.log4j.Level;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.VClassDaoStub;
import stubs.edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactoryStub;
import stubs.edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccessFactoryStub;
import stubs.edu.cornell.mannlib.vitro.webapp.modules.ApplicationStub;
import stubs.edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineStub;
import stubs.javax.servlet.ServletConfigStub;
import stubs.javax.servlet.ServletContextStub;
import stubs.javax.servlet.http.HttpServletRequestStub;
import stubs.javax.servlet.http.HttpServletResponseStub;
import stubs.javax.servlet.http.HttpSessionStub;

public class JsonServletTest
extends AbstractTestClass {
    private static final String GET_SEARCH_INDIVIDUALS_BY_VCLASS = "getSearchIndividualsByVClass";
    private static final String GET_VCLASSES_FOR_VCLASS_GROUP = "getVClassesForVClassGroup";
    private static final String VCLASS_ID = "vclassId";
    private JsonServlet servlet;
    private ServletConfigStub config;
    private ServletContextStub ctx;
    private HttpSessionStub session;
    private HttpServletRequestStub req;
    private HttpServletResponseStub resp;
    private WebappDaoFactoryStub wadf;
    private VClassDaoStub vcDao;
    private SearchEngineStub search;

    @Before
    public void setup() throws ServletException {
        this.ctx = new ServletContextStub();
        this.session = new HttpSessionStub();
        this.session.setServletContext(this.ctx);
        this.config = new ServletConfigStub();
        this.config.setServletContext(this.ctx);
        this.servlet = new JsonServlet();
        this.servlet.init((ServletConfig)this.config);
        this.req = new HttpServletRequestStub();
        this.req.setMethod("GET");
        this.req.setSession(this.session);
        this.resp = new HttpServletResponseStub();
        this.wadf = new WebappDaoFactoryStub();
        new ModelAccessFactoryStub().get(this.req).setWebappDaoFactory(this.wadf, new ModelAccess.WebappDaoFactoryOption[0]);
        this.vcDao = new VClassDaoStub();
        this.wadf.setVClassDao(this.vcDao);
        this.search = new SearchEngineStub();
        ApplicationStub.setup(new ServletContextStub(), this.search);
    }

    @Test
    public void noRecognizedRequestParameters() throws ServletException, IOException {
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.resp);
        Assert.assertEquals((String)"empty response", (Object)"", (Object)this.resp.getOutput());
        Assert.assertEquals((String)"status=ok", (long)200L, (long)this.resp.getStatus());
    }

    @Test
    public void vclassesNoClassgroup() throws ServletException, IOException {
        JsonServletTest.setLoggerLevel(JsonServlet.class, Level.FATAL);
        JsonServletTest.setLoggerLevel(JsonObjectProducer.class, Level.FATAL);
        this.req.addParameter(GET_VCLASSES_FOR_VCLASS_GROUP, "true");
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.resp);
        this.assertFailureWithErrorMessage("java.lang.Exception: no URI passed for classgroupUri");
        Assert.assertEquals((String)"status=failure", (long)500L, (long)this.resp.getStatus());
    }

    @Ignore
    @Test
    public void vclassesClassgroupNotRecognized() throws ServletException, IOException {
        this.req.addParameter(GET_VCLASSES_FOR_VCLASS_GROUP, "true");
        this.req.addParameter("classgroupUri", "http://bogusUri");
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.resp);
        Assert.assertEquals((String)"empty response", (Object)"", (Object)this.resp.getOutput());
        Assert.assertEquals((String)"status=failure", (long)500L, (long)this.resp.getStatus());
    }

    @Test
    public void individualsByClassNoVClass() throws ServletException, IOException {
        JsonServletTest.setLoggerLevel(JsonServlet.class, Level.FATAL);
        JsonServletTest.setLoggerLevel(JsonObjectProducer.class, Level.FATAL);
        this.req.addParameter(GET_SEARCH_INDIVIDUALS_BY_VCLASS, "true");
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.resp);
        this.assertFailureWithErrorMessage("java.lang.Exception: parameter vclassId URI parameter expected ");
    }

    @Test
    public void individualsByClassUnrecognizedVClass() throws ServletException, IOException {
        JsonServletTest.setLoggerLevel(JsonServlet.class, Level.FATAL);
        JsonServletTest.setLoggerLevel(JsonObjectProducer.class, Level.FATAL);
        String vclassId = "http://bogusVclass";
        this.req.addParameter(GET_SEARCH_INDIVIDUALS_BY_VCLASS, "true");
        this.req.addParameter(VCLASS_ID, vclassId);
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.resp);
        this.assertFailureWithErrorMessage("java.lang.Exception: Class " + vclassId + " not found");
    }

    @Test
    public void individualsByClassNoIndividuals() throws ServletException, IOException {
        JsonServletTest.setLoggerLevel(JsonServlet.class, Level.FATAL);
        JsonServletTest.setLoggerLevel(ModelAccess.class, Level.ERROR);
        String vclassId = "http://myVclass";
        this.vcDao.setVClass(new VClass(vclassId));
        this.req.addParameter(GET_SEARCH_INDIVIDUALS_BY_VCLASS, "true");
        this.req.addParameter(VCLASS_ID, vclassId);
        this.servlet.service((ServletRequest)this.req, (ServletResponse)this.resp);
        this.assertSuccessWithIndividuals(vclassId, 0);
    }

    private void assertFailureWithErrorMessage(String expected) {
        try {
            JSONObject result = new JSONObject(this.resp.getOutput());
            Assert.assertEquals((String)"errorMessage", (Object)expected, (Object)this.getFieldValue(result, "errorMessage"));
            Assert.assertEquals((String)"status", (long)500L, (long)this.resp.getStatus());
        }
        catch (JSONException e) {
            Assert.fail((String)e.toString());
        }
    }

    private void assertSuccessWithIndividuals(String vclassId, int count) {
        try {
            JSONObject actual = new JSONObject(this.resp.getOutput());
            Assert.assertEquals((String)"errorMessage", (Object)"", (Object)this.getFieldValue(actual, "errorMessage"));
            Assert.assertEquals((String)"count", (Object)count, (Object)this.getFieldValue(actual, "totalCount"));
            JSONObject vclassObj = (JSONObject)this.getFieldValue(actual, "vclass");
            Assert.assertEquals((String)"vclass name", (Object)vclassId.split("://")[1], (Object)this.getFieldValue(vclassObj, "name"));
            Assert.assertEquals((String)"vclass uri", (Object)vclassId, (Object)this.getFieldValue(vclassObj, "URI"));
            Assert.assertEquals((String)"status", (long)200L, (long)this.resp.getStatus());
        }
        catch (JSONException e) {
            Assert.fail((String)e.toString());
        }
    }

    private Object getFieldValue(JSONObject json, String fieldName) {
        try {
            Assert.assertEquals((String)("find " + fieldName), (Object)true, (Object)json.has(fieldName));
            return json.get(fieldName);
        }
        catch (JSONException e) {
            Assert.fail((String)e.toString());
            return -1;
        }
    }
}

