/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.dao.jena.JenaBaseDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JenaBaseDao_2_Test
extends AbstractTestClass {
    private static final String NS_MINE = "http://my.namespace.edu/";
    private static final String EMPTY_RESOURCE_URI = "http://my.namespace.edu/emptyResource";
    private static final String FULL_RESOURCE_URI = "http://my.namespace.edu/fullResource";
    private static final String OLD_URI_1 = "http://my.namespace.edu/oldUri1";
    private static final String OLD_URI_2 = "http://my.namespace.edu/oldUri2";
    private static final String NEW_URI_1 = "http://my.namespace.edu/newUri1";
    private static final String NEW_URI_2 = "http://my.namespace.edu/newUri2";
    private static final String BOGUS_URI = "bogusUri";
    private OntModel ontModel;
    private Property prop1;
    private Resource emptyResource;
    private Resource fullResource;
    private JenaBaseDao dao;

    @Before
    public void initializeThings() {
        this.ontModel = ModelFactory.createOntologyModel();
        this.prop1 = this.ontModel.createProperty("property1");
        this.emptyResource = this.ontModel.createResource(EMPTY_RESOURCE_URI);
        this.fullResource = this.ontModel.createResource(FULL_RESOURCE_URI);
        this.ontModel.createStatement(this.fullResource, this.prop1, (RDFNode)this.ontModel.createResource(OLD_URI_1));
        this.ontModel.createStatement(this.fullResource, this.prop1, (RDFNode)this.ontModel.createResource(OLD_URI_2));
        WebappDaoFactoryJena wdfj = new WebappDaoFactoryJena(this.ontModel);
        this.dao = new JenaBaseDao(wdfj);
    }

    @Test
    public void updatePropertyResourceURIValuesFromNothing() {
        this.updateAndConfirm(this.emptyResource, this.prop1, this.buildSet(NEW_URI_1, NEW_URI_2));
    }

    @Test
    public void updatePropertyResourceURIValuesToNothing() {
        this.updateAndConfirm(this.fullResource, this.prop1, Collections.emptySet());
    }

    @Test
    public void updatePropertyResourceURIValuesNoChange() {
        this.updateAndConfirm(this.fullResource, this.prop1, this.buildSet(OLD_URI_1, OLD_URI_2));
    }

    @Test
    public void updatePropertyResourceURIValuesReplaceSome() {
        this.updateAndConfirm(this.fullResource, this.prop1, this.buildSet(OLD_URI_1, NEW_URI_2));
    }

    @Test
    public void updatePropertyResourceURIValuesReplaceAll() {
        this.updateAndConfirm(this.fullResource, this.prop1, this.buildSet(NEW_URI_1));
    }

    @Test
    public void updatePropertyResourceURIValuesTryToAddEmptyURI() {
        Set<String> uris = this.buildSet("");
        this.dao.updatePropertyResourceURIValues(this.emptyResource, this.prop1, uris, (Model)this.ontModel);
        this.assertExpectedUriValues("update URIs", this.emptyResource, this.prop1, Collections.emptySet());
    }

    @Test
    public void updatePropertyResourceURIValuesTryToAddInvalidURI() {
        JenaBaseDao_2_Test.setLoggerLevel(JenaBaseDao.class, Level.ERROR);
        Set<String> uris = this.buildSet(BOGUS_URI);
        this.dao.updatePropertyResourceURIValues(this.emptyResource, this.prop1, uris, (Model)this.ontModel);
        this.assertExpectedUriValues("update URIs", this.emptyResource, this.prop1, Collections.emptySet());
    }

    private void updateAndConfirm(Resource res, Property prop, Set<String> uris) {
        this.dao.updatePropertyResourceURIValues(res, prop, uris, (Model)this.ontModel);
        this.assertExpectedUriValues("update URIs", res, prop, uris);
    }

    private void assertExpectedUriValues(String message, Resource res, Property prop, Set<String> expectedUris) {
        HashSet<String> actualUris = new HashSet<String>();
        StmtIterator stmts = this.ontModel.listStatements(res, prop, (RDFNode)null);
        while (stmts.hasNext()) {
            Statement stmt = (Statement)stmts.next();
            actualUris.add(stmt.getObject().asResource().getURI());
        }
        Assert.assertEquals((String)message, expectedUris, actualUris);
    }
}

