/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.rdfservice.adapters;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.testing.RecordingProxy;
import edu.cornell.mannlib.vitro.webapp.rdfservice.adapters.VitroModelFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.impl.GraphWithPerform;
import org.apache.jena.mem.GraphMem;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.listeners.StatementListener;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.junit.Assert;
import org.junit.Test;

public class VitroModelFactoryTest
extends AbstractTestClass {
    private static final Statement SINGLE_STATEMENT = VitroModelFactoryTest.stmt(VitroModelFactoryTest.resource("http://subject"), VitroModelFactoryTest.property("http://add"), (RDFNode)VitroModelFactoryTest.literal("object"));
    private static final Statement[] MULTIPLE_STATEMENTS = new Statement[]{VitroModelFactoryTest.stmt(VitroModelFactoryTest.resource("http://subject"), VitroModelFactoryTest.property("http://add"), (RDFNode)VitroModelFactoryTest.literal("first")), VitroModelFactoryTest.stmt(VitroModelFactoryTest.resource("http://subject"), VitroModelFactoryTest.property("http://add"), (RDFNode)VitroModelFactoryTest.literal("second"))};
    private static final String[] BORING_METHOD_NAMES = new String[]{"getPrefixMapping", "getEventManager", "getBulkUpdateHandler", "find", "getGraph"};
    private ModelGroup mg;
    private OntModelGroup omg;
    private UnionModelGroup umg;
    private UnionOntModelGroup uomg;
    private OntModelUnionModelGroup omumg;

    @Test
    public void addOneToModel() {
        this.mg = new DefaultModelGroup();
        this.mg.m.add(SINGLE_STATEMENT);
        new MethodCalls().add(this.mg.g, "add").add(this.mg.l, "addedStatement").test();
    }

    @Test
    public void addOneToVitroModel() {
        this.mg = new VitroModelGroup();
        this.mg.m.add(SINGLE_STATEMENT);
        new MethodCalls().add(this.mg.g, "add").add(this.mg.l, "addedStatement").test();
    }

    @Test
    public void addMultipleToModel() {
        this.mg = new DefaultModelGroup();
        this.mg.m.add(MULTIPLE_STATEMENTS);
        new MethodCalls().add(this.mg.g, "performAdd", "performAdd").add(this.mg.l, "addedStatements").test();
    }

    @Test
    public void addMultipleToVitroModel() {
        this.mg = new VitroModelGroup();
        this.mg.m.add(MULTIPLE_STATEMENTS);
        new MethodCalls().add(this.mg.g, "performAdd", "performAdd").add(this.mg.l, "addedStatements").test();
    }

    @Test
    public void addOneToOntModel() {
        this.omg = new DefaultOntModelGroup();
        this.omg.om.add(SINGLE_STATEMENT);
        new MethodCalls().add(this.omg.g, "add").add(this.omg.l, "addedStatement").add(this.omg.ol, "addedStatement").test();
    }

    @Test
    public void addOneToVitroOntModel() {
        this.omg = new VitroOntModelGroup();
        this.omg.om.add(SINGLE_STATEMENT);
        new MethodCalls().add(this.omg.g, "add").add(this.omg.l, "addedStatement").add(this.omg.ol, "addedStatement").test();
    }

    @Test
    public void addMultipleToOntModel() {
        this.omg = new DefaultOntModelGroup();
        this.omg.om.add(MULTIPLE_STATEMENTS);
        new MethodCalls().add(this.omg.g, "add", "add").add(this.omg.l, "addedStatement", "addedStatement").add(this.omg.ol, "addedStatements").test();
    }

    @Test
    public void addMultipleToVitroOntModel() {
        this.omg = new VitroOntModelGroup();
        this.omg.om.add(MULTIPLE_STATEMENTS);
        new MethodCalls().add(this.omg.g, "add", "add").add(this.omg.l, "addedStatement", "addedStatement").add(this.omg.ol, "addedStatements").test();
    }

    @Test
    public void addOneToUnion() {
        this.umg = new DefaultUnionModelGroup();
        this.umg.m.add(SINGLE_STATEMENT);
        new MethodCalls().add(this.umg.base.g, "add").add(this.umg.base.l, "addedStatement").add(this.umg.plus.g, new String[0]).add(this.umg.plus.l, new String[0]).add(this.umg.l, "addedStatement").test();
    }

    @Test
    public void addOneToVitroUnion() {
        this.umg = new VitroUnionModelGroup();
        this.umg.m.add(SINGLE_STATEMENT);
        new MethodCalls().add(this.umg.base.g, "add").add(this.umg.base.l, "addedStatement").add(this.umg.plus.g, new String[0]).add(this.umg.plus.l, new String[0]).add(this.umg.l, "addedStatement").test();
    }

    @Test
    public void addMultipleToUnion() {
        this.umg = new DefaultUnionModelGroup();
        this.umg.m.add(MULTIPLE_STATEMENTS);
        new MethodCalls().add(this.umg.base.g, "add", "add").add(this.umg.base.l, "addedStatement", "addedStatement").add(this.umg.plus.g, new String[0]).add(this.umg.plus.l, new String[0]).add(this.umg.l, "addedStatements").test();
    }

    @Test
    public void addMultipleToVitroUnion() {
        this.umg = new VitroUnionModelGroup();
        this.umg.m.add(MULTIPLE_STATEMENTS);
        new MethodCalls().add(this.umg.base.g, "add", "add").add(this.umg.base.l, "addedStatement", "addedStatement").add(this.umg.plus.g, new String[0]).add(this.umg.plus.l, new String[0]).add(this.umg.l, "addedStatements").test();
    }

    @Test
    public void addOneToOntUnion() {
        this.uomg = new DefaultUnionOntModelGroup();
        this.uomg.om.add(SINGLE_STATEMENT);
        new MethodCalls().add(this.uomg.base.g, "add").add(this.uomg.base.l, "addedStatement").add(this.uomg.plus.g, new String[0]).add(this.uomg.plus.l, new String[0]).add(this.uomg.l, "addedStatement").test();
    }

    @Test
    public void addOneToVitroOntUnion() {
        this.uomg = new VitroUnionOntModelGroup();
        this.uomg.om.add(SINGLE_STATEMENT);
        new MethodCalls().add(this.uomg.base.g, "add").add(this.uomg.base.l, "addedStatement").add(this.uomg.plus.g, new String[0]).add(this.uomg.plus.l, new String[0]).add(this.uomg.l, "addedStatement").test();
    }

    @Test
    public void addMultipleToOntUnion() {
        this.uomg = new DefaultUnionOntModelGroup();
        this.uomg.om.add(MULTIPLE_STATEMENTS);
        new MethodCalls().add(this.uomg.base.g, "add", "add").add(this.uomg.base.l, "addedStatement", "addedStatement").add(this.uomg.plus.g, new String[0]).add(this.uomg.plus.l, new String[0]).add(this.uomg.l, "addedStatements").test();
    }

    @Test
    public void addMultipleToVitroOntUnion() {
        this.uomg = new VitroUnionOntModelGroup();
        this.uomg.om.add(MULTIPLE_STATEMENTS);
        new MethodCalls().add(this.uomg.base.g, "add", "add").add(this.uomg.base.l, "addedStatement", "addedStatement").add(this.uomg.plus.g, new String[0]).add(this.uomg.plus.l, new String[0]).add(this.uomg.l, "addedStatements").test();
    }

    @Test
    public void addOneToOntModeledUnionModel() {
        this.omumg = new DefaultOntModelUnionModelGroup();
        this.omumg.om.add(SINGLE_STATEMENT);
        new MethodCalls().add(this.omumg.om, "add").add(this.omumg.ol, "addedStatement").add(this.omumg.union.base.g, "add").add(this.omumg.union.base.m, new String[0]).add(this.omumg.union.base.l, "addedStatement").add(this.omumg.union.plus.g, new String[0]).add(this.omumg.union.plus.m, new String[0]).add(this.omumg.union.plus.l, new String[0]).test();
    }

    @Test
    public void addOneToVitroOntModeledUnionModel() {
        this.omumg = new VitroOntModelUnionModelGroup();
        this.omumg.om.add(SINGLE_STATEMENT);
        new MethodCalls().add(this.omumg.om, "add").add(this.omumg.ol, "addedStatement").add(this.omumg.union.base.g, "add").add(this.omumg.union.base.m, new String[0]).add(this.omumg.union.base.l, "addedStatement").add(this.omumg.union.plus.g, new String[0]).add(this.omumg.union.plus.m, new String[0]).add(this.omumg.union.plus.l, new String[0]).test();
    }

    @Test
    public void addMultipleToOntModeledUnionModel() {
        this.omumg = new DefaultOntModelUnionModelGroup();
        this.omumg.om.add(MULTIPLE_STATEMENTS);
        new MethodCalls().add(this.omumg.om, "add").add(this.omumg.ol, "addedStatements").add(this.omumg.union.base.g, "add", "add").add(this.omumg.union.base.m, new String[0]).add(this.omumg.union.base.l, "addedStatement", "addedStatement").add(this.omumg.union.plus.g, new String[0]).add(this.omumg.union.plus.m, new String[0]).add(this.omumg.union.plus.l, new String[0]).test();
    }

    @Test
    public void addMultipleToVitroOntModeledUnionModel() {
        this.omumg = new VitroOntModelUnionModelGroup();
        this.omumg.om.add(MULTIPLE_STATEMENTS);
        new MethodCalls().add(this.omumg.om, "add").add(this.omumg.ol, "addedStatements").add(this.omumg.union.base.g, "add", "add").add(this.omumg.union.base.m, new String[0]).add(this.omumg.union.base.l, "addedStatement", "addedStatement").add(this.omumg.union.plus.g, new String[0]).add(this.omumg.union.plus.m, new String[0]).add(this.omumg.union.plus.l, new String[0]).test();
    }

    private static Statement stmt(Resource subject, Property predicate, RDFNode object) {
        return ResourceFactory.createStatement((Resource)subject, (Property)predicate, (RDFNode)object);
    }

    private static Resource resource(String uri) {
        return ResourceFactory.createResource((String)uri);
    }

    private static Property property(String uri) {
        return ResourceFactory.createProperty((String)uri);
    }

    private static Literal literal(String value) {
        return ResourceFactory.createPlainLiteral((String)value);
    }

    private void dumpMethodCalls(String message, Object proxy) {
        System.out.println(message + " method calls:");
        for (RecordingProxy.MethodCall call : ((RecordingProxy.MethodCallRecorder)proxy).getMethodCalls()) {
            String formatted = "   " + call.getName();
            for (Object arg : call.getArgList()) {
                formatted = formatted + "  " + arg.getClass();
            }
            System.out.println(formatted);
        }
    }

    private static abstract class TestObjectGrouping {
        private TestObjectGrouping() {
        }

        protected GraphWithPerform wrapGraph(GraphMem raw) {
            return RecordingProxy.create(raw, GraphWithPerform.class);
        }

        protected static ModelChangedListener makeListener() {
            return RecordingProxy.create(new StatementListener(), ModelChangedListener.class);
        }

        protected Model wrapModel(Model m) {
            return RecordingProxy.create(m, Model.class);
        }

        protected OntModel wrapOntModel(OntModel om) {
            return RecordingProxy.create(om, OntModel.class);
        }

        protected <T> T reset(T proxy) {
            ((RecordingProxy.MethodCallRecorder)proxy).resetMethodCalls();
            return proxy;
        }
    }

    private static class MethodCalls {
        private final List<CallNames> list = new ArrayList<CallNames>();

        private MethodCalls() {
        }

        public MethodCalls add(Object proxy, String ... names) {
            this.list.add(new CallNames((RecordingProxy.MethodCallRecorder)proxy, names));
            return this;
        }

        private void test() {
            try (StringWriter expectSw = new StringWriter();
                 PrintWriter expectWriter = new PrintWriter((Writer)expectSw, true);
                 StringWriter actualSw = new StringWriter();
                 PrintWriter actualWriter = new PrintWriter((Writer)actualSw, true);){
                for (CallNames calls : this.list) {
                    expectWriter.println(Arrays.asList(calls.names));
                    actualWriter.println(this.filterMethodNames(calls.proxy.getMethodCallNames()));
                }
                Assert.assertEquals((Object)expectSw.toString(), (Object)actualSw.toString());
            }
            catch (IOException e) {
                Assert.fail((String)e.toString());
            }
        }

        private List<String> filterMethodNames(List<String> raw) {
            ArrayList<String> filtered = new ArrayList<String>(raw);
            filtered.removeAll(Arrays.asList(BORING_METHOD_NAMES));
            return filtered;
        }

        private static class CallNames {
            private final RecordingProxy.MethodCallRecorder proxy;
            private final String[] names;

            public CallNames(RecordingProxy.MethodCallRecorder proxy, String[] names) {
                this.proxy = proxy;
                this.names = names;
            }
        }
    }

    private static class VitroOntModelUnionModelGroup
    extends OntModelUnionModelGroup {
        private VitroOntModelUnionModelGroup() {
        }

        @Override
        protected UnionModelGroup makeUnionModelGroup() {
            return new VitroUnionModelGroup();
        }

        @Override
        protected OntModel makeOntModel(Model m) {
            return VitroModelFactory.createOntologyModel((Model)m);
        }
    }

    private static class DefaultOntModelUnionModelGroup
    extends OntModelUnionModelGroup {
        private DefaultOntModelUnionModelGroup() {
        }

        @Override
        protected UnionModelGroup makeUnionModelGroup() {
            return new DefaultUnionModelGroup();
        }

        @Override
        protected OntModel makeOntModel(Model m) {
            return ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, (Model)m);
        }
    }

    private static abstract class OntModelUnionModelGroup
    extends TestObjectGrouping {
        final UnionModelGroup union = this.makeUnionModelGroup();
        final OntModel om;
        final ModelChangedListener ol;

        protected OntModelUnionModelGroup() {
            this.om = this.wrapOntModel(this.makeOntModel(this.union.m));
            this.ol = OntModelUnionModelGroup.makeListener();
            this.om.register(this.ol);
            this.reset(this.om);
        }

        protected abstract UnionModelGroup makeUnionModelGroup();

        protected abstract OntModel makeOntModel(Model var1);
    }

    private static class VitroUnionOntModelGroup
    extends UnionOntModelGroup {
        private VitroUnionOntModelGroup() {
        }

        @Override
        protected OntModelGroup makeOntModelGroup() {
            return new VitroOntModelGroup();
        }

        @Override
        protected OntModel makeOntUnion(OntModel baseModel, OntModel plusModel) {
            return VitroModelFactory.createUnion((OntModel)baseModel, (OntModel)plusModel);
        }
    }

    private static class DefaultUnionOntModelGroup
    extends UnionOntModelGroup {
        private DefaultUnionOntModelGroup() {
        }

        @Override
        protected OntModelGroup makeOntModelGroup() {
            return new DefaultOntModelGroup();
        }

        @Override
        protected OntModel makeOntUnion(OntModel baseModel, OntModel plusModel) {
            return ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, (Model)ModelFactory.createUnion((Model)baseModel, (Model)plusModel));
        }
    }

    private static abstract class UnionOntModelGroup
    extends TestObjectGrouping {
        final OntModelGroup base = this.makeOntModelGroup();
        final OntModelGroup plus = this.makeOntModelGroup();
        final OntModel om;
        final ModelChangedListener l;

        protected UnionOntModelGroup() {
            this.om = this.wrapOntModel(this.makeOntUnion(this.base.om, this.plus.om));
            this.l = UnionOntModelGroup.makeListener();
            this.om.register(this.l);
        }

        protected abstract OntModelGroup makeOntModelGroup();

        protected abstract OntModel makeOntUnion(OntModel var1, OntModel var2);
    }

    private static class VitroUnionModelGroup
    extends UnionModelGroup {
        private VitroUnionModelGroup() {
        }

        @Override
        protected ModelGroup makeModelGroup() {
            return new VitroModelGroup();
        }

        @Override
        protected Model makeUnion(Model baseModel, Model plusModel) {
            return VitroModelFactory.createUnion((Model)baseModel, (Model)plusModel);
        }
    }

    private static class DefaultUnionModelGroup
    extends UnionModelGroup {
        private DefaultUnionModelGroup() {
        }

        @Override
        protected ModelGroup makeModelGroup() {
            return new DefaultModelGroup();
        }

        @Override
        protected Model makeUnion(Model baseModel, Model plusModel) {
            return ModelFactory.createUnion((Model)baseModel, (Model)plusModel);
        }
    }

    private static abstract class UnionModelGroup
    extends TestObjectGrouping {
        final ModelGroup base = this.makeModelGroup();
        final ModelGroup plus = this.makeModelGroup();
        final Model m;
        final ModelChangedListener l;

        protected UnionModelGroup() {
            this.m = this.wrapModel(this.makeUnion(this.base.m, this.plus.m));
            this.l = UnionModelGroup.makeListener();
            this.m.register(this.l);
        }

        protected abstract ModelGroup makeModelGroup();

        protected abstract Model makeUnion(Model var1, Model var2);
    }

    private static class VitroOntModelGroup
    extends OntModelGroup {
        private VitroOntModelGroup() {
        }

        @Override
        protected OntModel makeOntModel(Model m) {
            return VitroModelFactory.createOntologyModel((Model)m);
        }

        @Override
        protected Model makeModel(GraphWithPerform g) {
            return VitroModelFactory.createModelForGraph((Graph)g);
        }
    }

    private static class DefaultOntModelGroup
    extends OntModelGroup {
        private DefaultOntModelGroup() {
        }

        @Override
        protected OntModel makeOntModel(Model m) {
            return ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, (Model)m);
        }

        @Override
        protected Model makeModel(GraphWithPerform g) {
            return ModelFactory.createModelForGraph((Graph)g);
        }
    }

    private static abstract class OntModelGroup
    extends ModelGroup {
        final ModelChangedListener ol = OntModelGroup.makeListener();
        final OntModel om = this.wrapOntModel(this.makeOntModel(this.m));

        protected OntModelGroup() {
            this.om.register(this.ol);
        }

        protected abstract OntModel makeOntModel(Model var1);
    }

    private static class VitroModelGroup
    extends ModelGroup {
        private VitroModelGroup() {
        }

        @Override
        protected Model makeModel(GraphWithPerform g) {
            return VitroModelFactory.createModelForGraph((Graph)g);
        }
    }

    private static class DefaultModelGroup
    extends ModelGroup {
        private DefaultModelGroup() {
        }

        @Override
        protected Model makeModel(GraphWithPerform g) {
            return ModelFactory.createModelForGraph((Graph)g);
        }
    }

    private static abstract class ModelGroup
    extends TestObjectGrouping {
        final GraphWithPerform g;
        final ModelChangedListener l;
        final Model m;

        protected ModelGroup() {
            GraphMem rawGraph = new GraphMem();
            this.g = this.wrapGraph(rawGraph);
            this.l = ModelGroup.makeListener();
            this.m = this.wrapModel(this.makeModel(this.g));
            this.m.register(this.l);
            this.reset(this.g);
            this.reset(this.l);
            this.reset(this.m);
        }

        protected abstract Model makeModel(GraphWithPerform var1);
    }
}

