/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.reasoner;

import edu.cornell.mannlib.vitro.webapp.reasoner.ReasonerPlugin;
import edu.cornell.mannlib.vitro.webapp.reasoner.SimpleReasoner;
import edu.cornell.mannlib.vitro.webapp.reasoner.SimpleReasonerTBoxHelper;
import edu.cornell.mannlib.vitro.webapp.reasoner.SimpleReasonerTBoxListener;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.jena.ontology.ObjectProperty;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDFS;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SimpleReasonerPluginTest
extends SimpleReasonerTBoxHelper {
    long delay = 50L;
    private static final String DEFAULT_NS = "http://vivoweb.org/individual/";
    private static final String DCTERMS_NS = "http://purl.org/dc/terms/";
    private static final String VIVOCORE_NS = "http://vivoweb.org/ontology/core#";
    private static final String creator_URI = "http://purl.org/dc/terms/creator";
    private static final String authorInAuthorship_URI = "http://vivoweb.org/ontology/core#authorInAuthorship";
    private static final String linkedAuthor_URI = "http://vivoweb.org/ontology/core#linkedAuthor";
    private static final String informationResourceInAuthorship_URI = "http://vivoweb.org/ontology/core#informationResourceInAuthorship";
    private static final String linkedInformationResource_URI = "http://vivoweb.org/ontology/core#linkedInformationResource";

    @Before
    public void suppressErrorOutput() {
        SimpleReasonerPluginTest.setLoggerLevel(SimpleReasoner.class, Level.DEBUG);
        SimpleReasonerPluginTest.setLoggerLevel(SimpleReasonerTBoxListener.class, Level.DEBUG);
    }

    @Test
    public void test1() {
        OntModel tBox = this.createTBoxModel();
        ObjectProperty authorInAuthorship = tBox.createObjectProperty(authorInAuthorship_URI);
        ObjectProperty linkedAuthor = tBox.createObjectProperty(linkedAuthor_URI);
        ObjectProperty informationResourceInAuthorship = tBox.createObjectProperty(informationResourceInAuthorship_URI);
        ObjectProperty linkedInformationResource = tBox.createObjectProperty(linkedInformationResource_URI);
        authorInAuthorship.addInverseOf((Property)linkedAuthor);
        informationResourceInAuthorship.addInverseOf((Property)linkedInformationResource);
        Literal title1 = tBox.createLiteral("My Findings");
        Literal name1 = tBox.createLiteral("Priscilla Powers");
        Model inf = ModelFactory.createDefaultModel();
        OntModel aBox = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        SimpleReasoner simpleReasoner = new SimpleReasoner(tBox, aBox, inf);
        aBox.register((ModelChangedListener)simpleReasoner);
        ArrayList<ReasonerPlugin> pluginList = new ArrayList<ReasonerPlugin>();
        String pluginClassName = "edu.cornell.mannlib.vitro.webapp.reasoner.plugin.SamplePlugin";
        try {
            ReasonerPlugin plugin = (ReasonerPlugin)Class.forName(pluginClassName).getConstructors()[0].newInstance(new Object[0]);
            plugin.setSimpleReasoner(simpleReasoner);
            pluginList.add(plugin);
            simpleReasoner.setPluginList(pluginList);
        }
        catch (Exception e) {
            System.out.println("Exception trying to instantiate plugin: " + e.getMessage());
            e.printStackTrace();
            return;
        }
        Property dctermsCreator = ResourceFactory.createProperty((String)creator_URI);
        Resource prissy = aBox.createResource("http://vivoweb.org/individual/prissy");
        Resource authorship1 = aBox.createResource("http://vivoweb.org/individual/authorship1");
        Resource article1 = aBox.createResource("http://vivoweb.org/individual/article1");
        Resource article100 = aBox.createResource("http://vivoweb.org/individual/article100");
        aBox.add(prissy, RDFS.label, (RDFNode)name1);
        aBox.add(prissy, (Property)authorInAuthorship, (RDFNode)authorship1);
        aBox.add(authorship1, (Property)linkedAuthor, (RDFNode)prissy);
        aBox.add(authorship1, (Property)linkedInformationResource, (RDFNode)article1);
        aBox.add(article1, RDFS.label, (RDFNode)title1);
        aBox.add(article1, (Property)informationResourceInAuthorship, (RDFNode)authorship1);
        aBox.add(article1, OWL.sameAs, (RDFNode)article100);
        Assert.assertTrue((boolean)inf.contains(article1, dctermsCreator, (RDFNode)prissy));
        Assert.assertTrue((boolean)inf.contains(article100, dctermsCreator, (RDFNode)prissy));
        aBox.remove(authorship1, (Property)linkedAuthor, (RDFNode)prissy);
        Assert.assertFalse((boolean)inf.contains(article1, dctermsCreator, (RDFNode)prissy));
        Assert.assertFalse((boolean)inf.contains(article100, dctermsCreator, (RDFNode)prissy));
    }

    SimpleReasonerTBoxListener getTBoxListener(SimpleReasoner simpleReasoner) {
        return new SimpleReasonerTBoxListener(simpleReasoner, new Exception().getStackTrace()[1].getMethodName());
    }

    void printModel(Model model, String modelName) {
        System.out.println("\nThe " + modelName + " model has " + model.size() + " statements:");
        System.out.println("---------------------------------------------------------------------");
        model.write((OutputStream)System.out);
    }

    void printModel(OntModel ontModel, String modelName) {
        System.out.println("\nThe " + modelName + " model has " + ontModel.size() + " statements:");
        System.out.println("---------------------------------------------------------------------");
        ontModel.writeAll((OutputStream)System.out, "N3", null);
    }
}

