/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.application;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.application.VitroHomeDirectory;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.modules.Application;
import edu.cornell.mannlib.vitro.webapp.modules.fileStorage.FileStorage;
import edu.cornell.mannlib.vitro.webapp.modules.imageProcessor.ImageProcessor;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngine;
import edu.cornell.mannlib.vitro.webapp.modules.searchIndexer.SearchIndexer;
import edu.cornell.mannlib.vitro.webapp.modules.tboxreasoner.TBoxReasonerModule;
import edu.cornell.mannlib.vitro.webapp.modules.tripleSource.ConfigurationTripleSource;
import edu.cornell.mannlib.vitro.webapp.modules.tripleSource.ContentTripleSource;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import edu.cornell.mannlib.vitro.webapp.startup.ComponentStartupStatusImpl;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import edu.cornell.mannlib.vitro.webapp.triplesource.impl.BasicCombinedTripleSource;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.Property;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.jena.ontology.OntDocumentManager;

public class ApplicationImpl
implements Application {
    private ServletContext ctx;
    private VitroHomeDirectory homeDirectory;
    private SearchEngine searchEngine;
    private SearchIndexer searchIndexer;
    private ImageProcessor imageProcessor;
    private FileStorage fileStorage;
    private ContentTripleSource contentTripleSource;
    private ConfigurationTripleSource configurationTripleSource;
    private TBoxReasonerModule tboxReasonerModule;

    public void setServletContext(ServletContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public ServletContext getServletContext() {
        return this.ctx;
    }

    @Override
    public VitroHomeDirectory getHomeDirectory() {
        return this.homeDirectory;
    }

    public void setHomeDirectory(VitroHomeDirectory homeDirectory) {
        this.homeDirectory = homeDirectory;
    }

    @Override
    public SearchEngine getSearchEngine() {
        return this.searchEngine;
    }

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasSearchEngine", minOccurs=1, maxOccurs=1)
    public void setSearchEngine(SearchEngine se) {
        this.searchEngine = se;
    }

    @Override
    public SearchIndexer getSearchIndexer() {
        return this.searchIndexer;
    }

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasSearchIndexer", minOccurs=1, maxOccurs=1)
    public void setSearchIndexer(SearchIndexer si) {
        this.searchIndexer = si;
    }

    @Override
    public ImageProcessor getImageProcessor() {
        return this.imageProcessor;
    }

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasImageProcessor", minOccurs=1, maxOccurs=1)
    public void setImageProcessor(ImageProcessor ip) {
        this.imageProcessor = ip;
    }

    @Override
    public FileStorage getFileStorage() {
        return this.fileStorage;
    }

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasFileStorage", minOccurs=1, maxOccurs=1)
    public void setFileStorage(FileStorage fs) {
        this.fileStorage = fs;
    }

    @Override
    public ContentTripleSource getContentTripleSource() {
        return this.contentTripleSource;
    }

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasContentTripleSource", minOccurs=1, maxOccurs=1)
    public void setContentTripleSource(ContentTripleSource source) {
        this.contentTripleSource = source;
    }

    @Override
    public ConfigurationTripleSource getConfigurationTripleSource() {
        return this.configurationTripleSource;
    }

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasConfigurationTripleSource", minOccurs=1, maxOccurs=1)
    public void setConfigurationTripleSource(ConfigurationTripleSource source) {
        this.configurationTripleSource = source;
    }

    @Override
    public TBoxReasonerModule getTBoxReasonerModule() {
        return this.tboxReasonerModule;
    }

    @Property(uri="http://vitro.mannlib.cornell.edu/ns/vitro/ApplicationSetup#hasTBoxReasonerModule", minOccurs=1, maxOccurs=1)
    public void setTBoxReasonerModule(TBoxReasonerModule module) {
        this.tboxReasonerModule = module;
    }

    @Override
    public void shutdown() {
    }

    public static class ReasonersSetup
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent sce) {
            ServletContext ctx = sce.getServletContext();
            Application app = ApplicationUtils.instance();
            StartupStatus ss = StartupStatus.getBean(ctx);
            ComponentStartupStatusImpl css = new ComponentStartupStatusImpl(this, ss);
            TBoxReasonerModule tboxReasoner = app.getTBoxReasonerModule();
            tboxReasoner.startup(app, css);
            ss.info(this, "Started the TBoxReasonerModule: " + tboxReasoner);
        }

        public void contextDestroyed(ServletContextEvent sce) {
            Application app = ApplicationUtils.instance();
            app.getTBoxReasonerModule().shutdown(app);
        }
    }

    public static class ComponentsSetup
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent sce) {
            ServletContext ctx = sce.getServletContext();
            Application app = ApplicationUtils.instance();
            StartupStatus ss = StartupStatus.getBean(ctx);
            ComponentStartupStatusImpl css = new ComponentStartupStatusImpl(this, ss);
            SearchEngine searchEngine = app.getSearchEngine();
            searchEngine.startup(app, css);
            ss.info(this, "Started the SearchEngine: " + searchEngine);
            ImageProcessor imageProcessor = app.getImageProcessor();
            imageProcessor.startup(app, css);
            ss.info(this, "Started the ImageProcessor: " + imageProcessor);
            FileStorage fileStorage = app.getFileStorage();
            fileStorage.startup(app, css);
            ss.info(this, "Started the FileStorage system: " + fileStorage);
            ContentTripleSource contentTripleSource = app.getContentTripleSource();
            contentTripleSource.startup(app, css);
            ss.info(this, "Started the ContentTripleSource: " + contentTripleSource);
            ConfigurationTripleSource configurationTripleSource = app.getConfigurationTripleSource();
            configurationTripleSource.startup(app, css);
            ss.info(this, "Started the ConfigurationTripleSource: " + configurationTripleSource);
            this.configureJena();
            this.prepareCombinedTripleSource(app, ctx);
        }

        private void configureJena() {
            OntDocumentManager.getInstance().setProcessImports(false);
        }

        private void prepareCombinedTripleSource(Application app, ServletContext ctx) {
            ContentTripleSource contentSource = app.getContentTripleSource();
            ConfigurationTripleSource configurationSource = app.getConfigurationTripleSource();
            BasicCombinedTripleSource source = new BasicCombinedTripleSource(contentSource, configurationSource);
            RDFServiceUtils.setRDFServiceFactory(ctx, contentSource.getRDFServiceFactory());
            RDFServiceUtils.setRDFServiceFactory(ctx, configurationSource.getRDFServiceFactory(), ModelAccess.WhichService.CONFIGURATION);
            ModelAccess.setCombinedTripleSource(source);
        }

        public void contextDestroyed(ServletContextEvent sce) {
            Application app = ApplicationUtils.instance();
            app.getConfigurationTripleSource().shutdown(app);
            app.getContentTripleSource().shutdown(app);
            app.getFileStorage().shutdown(app);
            app.getImageProcessor().shutdown(app);
            app.getSearchEngine().shutdown(app);
        }
    }
}

