/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.auth.policy.bean;

import edu.cornell.mannlib.vitro.webapp.auth.policy.bean.PropertyRestrictionBean;
import edu.cornell.mannlib.vitro.webapp.auth.policy.bean.PropertyRestrictionLevels;
import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.FauxProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccess;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.impl.Util;

public class PropertyRestrictionBeanImpl
extends PropertyRestrictionBean {
    private static final Log log = LogFactory.getLog(PropertyRestrictionBeanImpl.class);
    private final Set<String> prohibitedNamespaces;
    private final Set<String> permittedExceptions;
    private final Map<PropertyDao.FullPropertyKey, PropertyRestrictionLevels> thresholdMap = new ConcurrentHashMap<PropertyDao.FullPropertyKey, PropertyRestrictionLevels>();

    public PropertyRestrictionBeanImpl(Collection<String> prohibitedNamespaces, Collection<String> permittedExceptions, ContextModelAccess models) {
        Objects.requireNonNull(prohibitedNamespaces, "prohibitedNamespaces may not be null.");
        this.prohibitedNamespaces = Collections.unmodifiableSet(new TreeSet<String>(prohibitedNamespaces));
        Objects.requireNonNull(permittedExceptions, "permittedExceptions may not be null.");
        this.permittedExceptions = Collections.unmodifiableSet(new TreeSet<String>(permittedExceptions));
        Objects.requireNonNull(models, "models may not be null.");
        this.populateThresholdMap(models.getWebappDaoFactory());
    }

    private void populateThresholdMap(WebappDaoFactory wadf) {
        for (ObjectProperty oProp : wadf.getObjectPropertyDao().getAllObjectProperties()) {
            this.addObjectPropertyToMap(oProp);
            for (FauxProperty fProp : wadf.getFauxPropertyDao().getFauxPropertiesForBaseUri(oProp.getURI())) {
                this.addFauxPropertyToMap(fProp);
            }
        }
        for (DataProperty dProp : wadf.getDataPropertyDao().getAllDataProperties()) {
            this.addDataPropertyToMap(dProp);
        }
    }

    private void addObjectPropertyToMap(ObjectProperty oProp) {
        PropertyDao.FullPropertyKey key = new PropertyDao.FullPropertyKey(oProp.getURI());
        PropertyRestrictionLevels levels = new PropertyRestrictionLevels(key, oProp.getHiddenFromDisplayBelowRoleLevel(), oProp.getProhibitedFromUpdateBelowRoleLevel(), oProp.getHiddenFromPublishBelowRoleLevel());
        this.thresholdMap.put(key, levels);
    }

    private void addFauxPropertyToMap(FauxProperty fProp) {
        PropertyDao.FullPropertyKey key = new PropertyDao.FullPropertyKey(fProp.getDomainURI(), fProp.getBaseURI(), fProp.getRangeURI());
        PropertyRestrictionLevels levels = new PropertyRestrictionLevels(key, fProp.getHiddenFromDisplayBelowRoleLevel(), fProp.getProhibitedFromUpdateBelowRoleLevel(), fProp.getHiddenFromPublishBelowRoleLevel());
        this.thresholdMap.put(key, levels);
    }

    private void addDataPropertyToMap(DataProperty dProp) {
        PropertyDao.FullPropertyKey key = new PropertyDao.FullPropertyKey(dProp.getURI());
        PropertyRestrictionLevels levels = new PropertyRestrictionLevels(key, dProp.getHiddenFromDisplayBelowRoleLevel(), dProp.getProhibitedFromUpdateBelowRoleLevel(), dProp.getHiddenFromPublishBelowRoleLevel());
        this.thresholdMap.put(key, levels);
    }

    @Override
    public boolean canDisplayResource(String resourceUri, BaseResourceBean.RoleLevel userRole) {
        return resourceUri != null && userRole != null;
    }

    @Override
    public boolean canModifyResource(String resourceUri, BaseResourceBean.RoleLevel userRole) {
        if (resourceUri == null || userRole == null) {
            return false;
        }
        return !this.prohibitedNamespaces.contains(this.namespace(resourceUri)) || this.permittedExceptions.contains(resourceUri);
    }

    @Override
    public boolean canPublishResource(String resourceUri, BaseResourceBean.RoleLevel userRole) {
        return resourceUri != null && userRole != null;
    }

    @Override
    public boolean canDisplayPredicate(Property predicate, BaseResourceBean.RoleLevel userRole) {
        if (predicate == null || predicate.getURI() == null) {
            return false;
        }
        return this.isAuthorized(userRole, this.getThreshold(predicate, PropertyRestrictionLevels.Which.DISPLAY));
    }

    @Override
    public boolean canModifyPredicate(Property predicate, BaseResourceBean.RoleLevel userRole) {
        if (predicate == null || predicate.getURI() == null) {
            return false;
        }
        return this.isAuthorized(userRole, this.getPropertyModifyThreshold(predicate));
    }

    @Override
    public boolean canPublishPredicate(Property predicate, BaseResourceBean.RoleLevel userRole) {
        if (predicate == null || predicate.getURI() == null) {
            return false;
        }
        return this.isAuthorized(userRole, this.getThreshold(predicate, PropertyRestrictionLevels.Which.PUBLISH));
    }

    @Override
    public void updateProperty(PropertyRestrictionLevels levels) {
        this.thresholdMap.put(levels.getKey(), levels);
    }

    private boolean isAuthorized(BaseResourceBean.RoleLevel userRole, BaseResourceBean.RoleLevel thresholdRole) {
        if (userRole == null) {
            return false;
        }
        if (thresholdRole == null) {
            return true;
        }
        return userRole.compareTo(thresholdRole) >= 0;
    }

    private BaseResourceBean.RoleLevel getPropertyModifyThreshold(Property p) {
        if (this.prohibitedNamespaces.contains(this.namespace(p.getURI())) && !this.permittedExceptions.contains(p.getURI())) {
            return BaseResourceBean.RoleLevel.NOBODY;
        }
        return this.getThreshold(p, PropertyRestrictionLevels.Which.MODIFY);
    }

    private BaseResourceBean.RoleLevel getThreshold(Property p, PropertyRestrictionLevels.Which which) {
        BaseResourceBean.RoleLevel qualifiedLevel = this.getThreshold(new PropertyDao.FullPropertyKey(p), which);
        if (qualifiedLevel != null) {
            return qualifiedLevel;
        }
        BaseResourceBean.RoleLevel bareLevel = this.getThreshold(new PropertyDao.FullPropertyKey(p.getURI()), which);
        return bareLevel;
    }

    private BaseResourceBean.RoleLevel getThreshold(PropertyDao.FullPropertyKey key, PropertyRestrictionLevels.Which which) {
        PropertyRestrictionLevels levels = this.thresholdMap.get(key);
        if (levels == null) {
            return null;
        }
        return levels.getLevel(which);
    }

    private String namespace(String uri) {
        return uri.substring(0, Util.splitNamespaceXML((String)uri));
    }

    public String toString() {
        TreeSet<PropertyDao.FullPropertyKey> keys = new TreeSet<PropertyDao.FullPropertyKey>(new Comparator<PropertyDao.FullPropertyKey>(){

            @Override
            public int compare(PropertyDao.FullPropertyKey o1, PropertyDao.FullPropertyKey o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        keys.addAll(this.thresholdMap.keySet());
        StringBuilder buffer = new StringBuilder();
        for (PropertyDao.FullPropertyKey key : keys) {
            buffer.append(key + " " + (Object)((Object)this.thresholdMap.get(key).getLevel(PropertyRestrictionLevels.Which.DISPLAY)) + " " + (Object)((Object)this.thresholdMap.get(key).getLevel(PropertyRestrictionLevels.Which.MODIFY)) + " " + (Object)((Object)this.thresholdMap.get(key).getLevel(PropertyRestrictionLevels.Which.PUBLISH)) + "\n");
        }
        return buffer.toString();
    }
}

