/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.beans;

import edu.cornell.mannlib.vitro.webapp.auth.policy.bean.RoleRestrictedProperty;
import edu.cornell.mannlib.vitro.webapp.beans.BaseResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.beans.ResourceBean;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import java.beans.XMLEncoder;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.joda.time.DateTime;

public class ObjectProperty
extends Property
implements Comparable<ObjectProperty>,
ResourceBean,
Cloneable,
RoleRestrictedProperty {
    private static final Log log = LogFactory.getLog((String)ObjectProperty.class.getName());
    private String parentURI = null;
    private String domainVClassURI = null;
    private VClass domainVClass = null;
    private String domainEntityURI = null;
    private String domainPublic = null;
    private String rangeVClassURI = null;
    private VClass rangeVClass = null;
    private String rangeEntityURI = null;
    private String rangePublic = null;
    private boolean transitive = false;
    private boolean symmetric = false;
    private boolean functional = false;
    private boolean inverseFunctional = false;
    private List<ObjectPropertyStatement> objectPropertyStatements = null;
    private String example = null;
    private String description = null;
    private String publicDescription = null;
    private String URIInverse = null;
    private String namespaceInverse = null;
    private String localNameInverse = null;
    private String domainEntitySortDirection = null;
    private Integer domainDisplayTier = null;
    private Integer domainDisplayLimit = null;
    private String objectIndividualSortPropertyURI = null;
    private String rangeEntitySortDirection = null;
    private Integer rangeDisplayTier = null;
    private Integer rangeDisplayLimit = null;
    private boolean selectFromExisting = true;
    private boolean offerCreateNewOption = false;
    private boolean stubObjectRelation = false;
    private boolean collateBySubclass = false;

    public void xmlToSysOut() {
        XMLEncoder e = new XMLEncoder(System.out);
        e.writeObject(this);
    }

    @Override
    public String getDomainVClassURI() {
        return this.domainVClassURI;
    }

    @Override
    public void setDomainVClassURI(String domainClassURI) {
        this.domainVClassURI = domainClassURI;
    }

    public String getDomainEntityURI() {
        return this.domainEntityURI;
    }

    public void setDomainEntityURI(String domainEntityURI) {
        this.domainEntityURI = domainEntityURI;
    }

    @Override
    public String getLabel() {
        return this.getDomainPublic();
    }

    public String getDomainPublic() {
        return this.domainPublic;
    }

    public void setDomainPublic(String domainPublic) {
        this.domainPublic = domainPublic;
    }

    public VClass getDomainVClass() {
        return this.domainVClass;
    }

    public void setDomainVClass(VClass domainVClass) {
        this.domainVClass = domainVClass;
    }

    public String getParentURI() {
        return this.parentURI;
    }

    public void setParentURI(String parentURI) {
        this.parentURI = parentURI;
    }

    @Override
    public String getRangeVClassURI() {
        return this.rangeVClassURI;
    }

    @Override
    public void setRangeVClassURI(String rangeClassURI) {
        this.rangeVClassURI = rangeClassURI;
    }

    public String getRangeEntityURI() {
        return this.rangeEntityURI;
    }

    public void setRangeEntityURI(String rangeEntityURI) {
        this.rangeEntityURI = rangeEntityURI;
    }

    public String getRangePublic() {
        return this.rangePublic;
    }

    public void setRangePublic(String rangePublic) {
        this.rangePublic = rangePublic;
    }

    public VClass getRangeVClass() {
        return this.rangeVClass;
    }

    public void setRangeVClass(VClass rangeVClass) {
        this.rangeVClass = rangeVClass;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPublicDescription() {
        return this.publicDescription;
    }

    public void setPublicDescription(String s) {
        this.publicDescription = s;
    }

    public String getExample() {
        return this.example;
    }

    public void setExample(String example) {
        this.example = example;
    }

    public List<ObjectPropertyStatement> getObjectPropertyStatements() {
        return this.objectPropertyStatements;
    }

    public void setObjectPropertyStatements(List<ObjectPropertyStatement> objectPropertyStatements) {
        this.objectPropertyStatements = objectPropertyStatements;
    }

    public String getURIInverse() {
        return this.URIInverse;
    }

    public void setURIInverse(String URIInverse) {
        if (URIInverse == null) {
            this.URIInverse = null;
            this.namespaceInverse = null;
            this.localNameInverse = null;
        } else {
            this.URIInverse = URIInverse;
            BaseResourceBean uriInverse = new BaseResourceBean(URIInverse);
            this.namespaceInverse = uriInverse.getNamespace();
            this.localNameInverse = uriInverse.getLocalName();
        }
    }

    public String getNamespaceInverse() {
        return this.namespaceInverse;
    }

    public void setNamespaceInverse(String namespaceInverse) {
        this.namespaceInverse = namespaceInverse;
        if (namespaceInverse != null && this.localNameInverse != null) {
            this.URIInverse = namespaceInverse + this.localNameInverse;
        }
    }

    public String getLocalNameInverse() {
        return this.localNameInverse;
    }

    public void setLocalNameInverse(String localNameInverse) {
        this.localNameInverse = localNameInverse;
        if (this.namespaceInverse != null && localNameInverse != null) {
            this.URIInverse = this.namespaceInverse + localNameInverse;
        }
    }

    public boolean getTransitive() {
        return this.transitive;
    }

    public void setTransitive(boolean transitive) {
        this.transitive = transitive;
    }

    public boolean getSymmetric() {
        return this.symmetric;
    }

    public void setSymmetric(boolean symmetric) {
        this.symmetric = symmetric;
    }

    public boolean getFunctional() {
        return this.functional;
    }

    public void setFunctional(boolean functional) {
        this.functional = functional;
    }

    public boolean getInverseFunctional() {
        return this.inverseFunctional;
    }

    public void setInverseFunctional(boolean inverseFunctional) {
        this.inverseFunctional = inverseFunctional;
    }

    public void setCollateBySubclass(boolean collate) {
        this.collateBySubclass = collate;
    }

    public boolean getCollateBySubclass() {
        return this.collateBySubclass;
    }

    public final void addObjectPropertyStatement(ObjectPropertyStatement objPropertyStmt) {
        if (objPropertyStmt == null) {
            return;
        }
        if (this.getObjectPropertyStatements() == null) {
            this.setObjectPropertyStatements(new LinkedList<ObjectPropertyStatement>());
        }
        this.getObjectPropertyStatements().add(objPropertyStmt);
    }

    public int getDomainDisplayLimit() {
        return this.domainDisplayLimit == null ? -1 : this.domainDisplayLimit;
    }

    public Integer getDomainDisplayLimitInteger() {
        return this.domainDisplayLimit;
    }

    public void setDomainDisplayLimit(Integer domainDisplayLimit) {
        this.domainDisplayLimit = domainDisplayLimit;
    }

    public int getDomainDisplayTier() {
        return this.domainDisplayTier != null ? this.domainDisplayTier : -1;
    }

    public Integer getDomainDisplayTierInteger() {
        return this.domainDisplayTier;
    }

    public void setDomainDisplayTier(Integer domainDisplayTier) {
        this.domainDisplayTier = domainDisplayTier;
    }

    public String getDomainEntitySortDirection() {
        return this.domainEntitySortDirection;
    }

    public void setDomainEntitySortDirection(String domainEntitySortDirection) {
        this.domainEntitySortDirection = domainEntitySortDirection;
    }

    public String getObjectIndividualSortPropertyURI() {
        return this.objectIndividualSortPropertyURI;
    }

    public void setObjectIndividualSortPropertyURI(String objectIndividualSortPropertyURI) {
        this.objectIndividualSortPropertyURI = objectIndividualSortPropertyURI;
    }

    public int getRangeDisplayLimit() {
        return this.rangeDisplayLimit == null ? -1 : this.rangeDisplayLimit;
    }

    public Integer getRangeDisplayLimitInteger() {
        return this.rangeDisplayLimit;
    }

    public void setRangeDisplayLimit(int rangeDisplayLimit) {
        this.rangeDisplayLimit = rangeDisplayLimit;
    }

    public int getRangeDisplayTier() {
        return this.rangeDisplayTier == null ? -1 : this.rangeDisplayTier;
    }

    public Integer getRangeDisplayTierInteger() {
        return this.rangeDisplayTier;
    }

    public void setRangeDisplayTier(Integer rangeDisplayTier) {
        this.rangeDisplayTier = rangeDisplayTier;
    }

    public String getRangeEntitySortDirection() {
        return this.rangeEntitySortDirection;
    }

    public void setRangeEntitySortDirection(String rangeEntitySortDirection) {
        this.rangeEntitySortDirection = rangeEntitySortDirection;
    }

    public boolean getSelectFromExisting() {
        return this.selectFromExisting;
    }

    public void setSelectFromExisting(boolean b) {
        this.selectFromExisting = b;
    }

    public boolean getOfferCreateNewOption() {
        return this.offerCreateNewOption;
    }

    public void setOfferCreateNewOption(boolean b) {
        this.offerCreateNewOption = b;
    }

    public boolean getStubObjectRelation() {
        return this.stubObjectRelation;
    }

    public void setStubObjectRelation(boolean b) {
        this.stubObjectRelation = b;
    }

    @Override
    public int compareTo(ObjectProperty op) {
        Collator collator = Collator.getInstance();
        return collator.compare(this.getDomainPublic(), op.getDomainPublic());
    }

    public static List<ObjectPropertyStatement> sortObjectPropertyStatementsForDisplay(ObjectProperty prop, List objPropStmtsList) {
        if (objPropStmtsList == null) {
            log.error((Object)"incoming object property statement list is null; returning null");
            return null;
        }
        if (objPropStmtsList.size() < 2) {
            return objPropStmtsList;
        }
        String tmpDirection = prop.getDomainEntitySortDirection();
        final boolean ascending = !"desc".equalsIgnoreCase(tmpDirection);
        String objIndivSortPropURI = prop.getObjectIndividualSortPropertyURI();
        if (prop.getObjectIndividualSortPropertyURI() == null || prop.getObjectIndividualSortPropertyURI().length() == 0) {
            log.debug((Object)"objectIndividualSortPropertyURI is null or blank so sorting by name ");
            Comparator fieldComp = new Comparator(){

                public final int compare(Object o1, Object o2) {
                    ObjectPropertyStatement e2e1 = (ObjectPropertyStatement)o1;
                    ObjectPropertyStatement e2e2 = (ObjectPropertyStatement)o2;
                    Individual e1 = e2e1 != null ? e2e1.getObject() : null;
                    Individual e2 = e2e2 != null ? e2e2.getObject() : null;
                    String val1 = null;
                    String val2 = null;
                    if (e1 != null) {
                        val1 = e1.getName();
                    } else {
                        log.debug((Object)"PropertyWebapp.sortObjectPropertiesForDisplay() passed object property statement with no range entity.");
                    }
                    if (e2 != null) {
                        val2 = e2.getName();
                    } else {
                        log.debug((Object)"PropertyWebapp.sortObjectPropertyStatementsForDisplay passed object property statement with no range entity.");
                    }
                    int rv = 0;
                    try {
                        if (val1 instanceof String) {
                            if (val2 == null) {
                                rv = -1;
                            } else {
                                Collator collator = Collator.getInstance();
                                rv = collator.compare(val1, val2);
                            }
                        } else if (val1 instanceof Date) {
                            DateTime dt1 = new DateTime((Object)((Date)((Object)val1)));
                            DateTime dt2 = new DateTime((Object)((Date)((Object)val2)));
                            rv = dt1.compareTo((Object)dt2);
                        } else {
                            rv = 0;
                        }
                    }
                    catch (NullPointerException e) {
                        e.printStackTrace();
                    }
                    if (ascending) {
                        return rv;
                    }
                    return rv * -1;
                }
            };
            try {
                Collections.sort(objPropStmtsList, fieldComp);
            }
            catch (Exception e) {
                log.error((Object)("Exception sorting object property statements for object property " + prop.getURI()));
            }
        } else {
            log.debug((Object)("using data property " + prop.getObjectIndividualSortPropertyURI() + " to sort related entities"));
            final String objIndSortPropURI = prop.getObjectIndividualSortPropertyURI();
            Comparator dpComp = new Comparator(){
                final String cDatapropURI;
                {
                    this.cDatapropURI = objIndSortPropURI;
                }

                public final int compare(Object o1, Object o2) {
                    List<DataPropertyStatement> dataPropertyStatements;
                    ObjectPropertyStatement e2e1 = (ObjectPropertyStatement)o1;
                    ObjectPropertyStatement e2e2 = (ObjectPropertyStatement)o2;
                    Individual e1 = e2e1 != null ? e2e1.getObject() : null;
                    Individual e2 = e2e2 != null ? e2e2.getObject() : null;
                    Object val1 = null;
                    Object val2 = null;
                    if (e1 != null) {
                        try {
                            dataPropertyStatements = e1.getDataPropertyStatements();
                            for (DataPropertyStatement dps : dataPropertyStatements) {
                                if (!this.cDatapropURI.equals(dps.getDatapropURI()) || dps.getData() == null || dps.getData().trim().length() <= 0) continue;
                                if (XSDDatatype.XSDint.getURI().equals(dps.getDatatypeURI()) || XSDDatatype.XSDinteger.getURI().equals(dps.getDatatypeURI())) {
                                    val1 = Integer.parseInt(dps.getData());
                                    continue;
                                }
                                val1 = dps.getData();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        log.debug((Object)"PropertyWebapp.sortObjectPropertiesForDisplay passed object property statement with no range entity.");
                    }
                    if (e2 != null) {
                        try {
                            dataPropertyStatements = e2.getDataPropertyStatements();
                            for (DataPropertyStatement dps : dataPropertyStatements) {
                                if (!this.cDatapropURI.equals(dps.getDatapropURI()) || dps.getData() == null || dps.getData().trim().length() <= 0) continue;
                                if (XSDDatatype.XSDint.getURI().equals(dps.getDatatypeURI()) || XSDDatatype.XSDinteger.getURI().equals(dps.getDatatypeURI())) {
                                    val2 = Integer.parseInt(dps.getData());
                                    continue;
                                }
                                val2 = dps.getData();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        log.debug((Object)"PropertyWebapp.sortObjectPropertyStatementsForDisplay passed object property statement with no range entity.");
                    }
                    int rv = 0;
                    try {
                        if (val1 == null && val2 == null) {
                            rv = 0;
                        } else if (val1 == null) {
                            rv = 1;
                        } else if (val2 == null) {
                            rv = -1;
                        } else if (val1 instanceof String) {
                            Collator collator = Collator.getInstance();
                            rv = collator.compare((String)val1, (String)val2);
                        } else if (val1 instanceof Date) {
                            DateTime dt1 = new DateTime((Object)((Date)val1));
                            DateTime dt2 = new DateTime((Object)((Date)val2));
                            rv = dt1.compareTo((Object)dt2);
                        } else {
                            rv = val1 instanceof Integer ? (Integer)val1 - (Integer)val2 : 0;
                        }
                    }
                    catch (NullPointerException e) {
                        e.printStackTrace();
                    }
                    if (!ascending) {
                        rv *= -1;
                    }
                    if (rv == 0) {
                        String nameValue1 = e1.getName() != null ? e1.getName() : "";
                        String nameValue2 = e2.getName() != null ? e2.getName() : "";
                        rv = Collator.getInstance().compare(nameValue1, nameValue2);
                    }
                    return rv;
                }
            };
            try {
                Collections.sort(objPropStmtsList, dpComp);
            }
            catch (Exception e) {
                log.error((Object)("Exception sorting object property statements for object property " + prop.getURI()), (Throwable)e);
            }
        }
        return objPropStmtsList;
    }

    @Override
    public String toString() {
        String list = "null";
        if (this.getObjectPropertyStatements() != null) {
            Iterator<ObjectPropertyStatement> it = this.getObjectPropertyStatements().iterator();
            if (!it.hasNext()) {
                list = " none";
            }
            while (it.hasNext()) {
                ObjectPropertyStatement obj = it.next();
                if (obj != null && obj instanceof ObjectPropertyStatement) {
                    list = list + "\n\t\t" + obj.toString();
                    continue;
                }
                list = list + "\n\t\t" + ((Object)obj).toString();
            }
        }
        return "* Property:id: " + this.getURI() + "\n\t" + "domainDisplayLimit: " + this.getDomainDisplayLimit() + " \n\t" + "domainDisplayTier: " + this.getDomainDisplayTier() + "\n\t" + "domainEntityId: " + this.getDomainEntityURI() + "\n\t" + "domainEntitySortDirection: " + this.getDomainEntitySortDirection() + "\n\t" + "domainVClass: " + this.getDomainVClass() + "\n\t" + "domainClassId: " + this.getDomainVClassURI() + "\n\t" + "domainPublic: " + this.getDomainPublic() + "\n\t" + "parentId: " + this.getParentURI() + "\n\t" + "rangeDisplayLimit: " + this.getRangeDisplayLimit() + "\n\t" + "rangeDisplayTier: " + this.getRangeDisplayTier() + "\n\t" + "rangeEntityId: " + this.getRangeEntityURI() + "\n\t" + "rangeEntitySortDirection: " + this.getRangeEntitySortDirection() + "\n\t" + "rangeVClass: " + this.getRangeVClass() + "\n\t" + "rangeClassId: " + this.getRangeVClassURI() + "\n\t" + "rangePublic: " + this.getRangePublic() + "\n\t" + "customEntryForm" + this.getCustomEntryForm() + "\n\t" + "selectFromExisting" + this.getSelectFromExisting() + "\n\t" + "offerCreateNewOption" + this.getOfferCreateNewOption() + "\n\t" + "** object property statements: " + list + "\n";
    }

    public ObjectProperty clone() {
        ObjectProperty clone = new ObjectProperty();
        clone.setAddLinkSuppressed(this.isAddLinkSuppressed());
        clone.setCollateBySubclass(this.getCollateBySubclass());
        clone.setCustomEntryForm(this.getCustomEntryForm());
        clone.setDeleteLinkSuppressed(this.isDeleteLinkSuppressed());
        clone.setDescription(this.getDescription());
        clone.setDomainDisplayLimit(this.getDomainDisplayLimitInteger());
        clone.setDomainDisplayTier(this.getDomainDisplayTier());
        clone.setDomainEntitySortDirection(this.getDomainEntitySortDirection());
        clone.setDomainEntityURI(this.getDomainEntityURI());
        clone.setDomainPublic(this.getDomainPublic());
        clone.setDomainVClass(this.getDomainVClass());
        clone.setDomainVClassURI(this.getDomainVClassURI());
        clone.setEditLinkSuppressed(this.isEditLinkSuppressed());
        clone.setExample(this.getExample());
        clone.setFunctional(this.getFunctional());
        clone.setGroupURI(this.getGroupURI());
        clone.setHiddenFromDisplayBelowRoleLevel(this.getHiddenFromDisplayBelowRoleLevel());
        clone.setHiddenFromPublishBelowRoleLevel(this.getHiddenFromPublishBelowRoleLevel());
        clone.setInverseFunctional(this.getInverseFunctional());
        clone.setLabel(this.getLabel());
        clone.setLocalName(this.getLocalName());
        clone.setLocalNameInverse(this.getLocalNameInverse());
        clone.setLocalNameWithPrefix(this.getLocalNameWithPrefix());
        clone.setNamespace(this.getNamespace());
        clone.setNamespaceInverse(this.getNamespaceInverse());
        clone.setObjectIndividualSortPropertyURI(this.getObjectIndividualSortPropertyURI());
        clone.setOfferCreateNewOption(this.getOfferCreateNewOption());
        clone.setParentURI(this.getParentURI());
        clone.setPickListName(this.getPickListName());
        clone.setProhibitedFromUpdateBelowRoleLevel(this.getProhibitedFromUpdateBelowRoleLevel());
        clone.setPublicDescription(this.getPublicDescription());
        clone.setRangeDisplayLimit(this.getRangeDisplayLimit());
        clone.setRangeDisplayTier(this.getRangeDisplayTier());
        clone.setRangeEntitySortDirection(this.getRangeEntitySortDirection());
        clone.setRangeEntityURI(this.getRangeEntityURI());
        clone.setRangePublic(this.getRangePublic());
        clone.setRangeVClass(this.getRangeVClass());
        clone.setRangeVClassURI(this.getRangeVClassURI());
        clone.setSelectFromExisting(this.getSelectFromExisting());
        clone.setStubObjectRelation(this.getStubObjectRelation());
        clone.setSymmetric(this.getSymmetric());
        clone.setTransitive(this.getTransitive());
        clone.setURI(this.getURI());
        clone.setURIInverse(this.getURIInverse());
        return clone;
    }

    public static class DisplayComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof ObjectProperty) && !(o2 instanceof ObjectProperty)) {
                return 0;
            }
            Integer tier1 = ((ObjectProperty)o1).getDomainDisplayTier();
            Integer tier2 = ((ObjectProperty)o2).getDomainDisplayTier();
            tier1 = tier1 == null ? 0 : tier1;
            tier2 = tier2 == null ? 0 : tier2;
            return tier1 - tier2;
        }
    }
}

