/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.config;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.application.BuildProperties;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationPropertiesImpl;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationPropertiesSetup
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(ConfigurationPropertiesSetup.class);
    private static final String FILE_RUNTIME_PROPERTIES = "runtime.properties";
    private static final String VHD_CONFIGURATION_PROPERTY = "vitro.home";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        StartupStatus ss = StartupStatus.getBean(ctx);
        try {
            InputStream stream = null;
            try {
                File vitroHomeDir = ApplicationUtils.instance().getHomeDirectory().getPath().toFile();
                File runtimePropertiesFile = this.locateRuntimePropertiesFile(vitroHomeDir, ss);
                stream = new FileInputStream(runtimePropertiesFile);
                Map<String, String> preempts = this.createPreemptiveProperties(VHD_CONFIGURATION_PROPERTY, vitroHomeDir);
                ConfigurationPropertiesImpl bean = new ConfigurationPropertiesImpl(stream, preempts, new BuildProperties(ctx).getMap());
                ConfigurationProperties.setBean(ctx, bean);
                ss.info(this, "Loaded " + bean.getPropertyMap().size() + " properties.");
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e, (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            ss.fatal(this, e.getMessage(), e);
        }
    }

    private File locateRuntimePropertiesFile(File vitroHomeDir, StartupStatus ss) {
        File rpf = new File(vitroHomeDir, FILE_RUNTIME_PROPERTIES);
        if (!rpf.exists()) {
            throw new IllegalStateException("Did not find 'runtime.properties' in vitro home directory '" + vitroHomeDir + "'");
        }
        if (!rpf.isFile()) {
            throw new IllegalStateException("'" + rpf.getPath() + "' is not a file.");
        }
        if (!rpf.canRead()) {
            throw new IllegalStateException("Cannot read '" + rpf.getPath() + "'.");
        }
        ss.info(this, "Loading runtime properties from '" + rpf.getPath() + "'");
        return rpf;
    }

    private Map<String, String> createPreemptiveProperties(String propertyVitroHome, File vitroHomeDir) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(propertyVitroHome, vitroHomeDir.getAbsolutePath());
        return map;
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

