/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller;

import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyGroup;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyInstance;
import edu.cornell.mannlib.vitro.webapp.controller.VitroHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyGroupDao;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyInstanceDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DashboardPropertyListController
extends VitroHttpServlet {
    private static final Log log = LogFactory.getLog((String)DashboardPropertyListController.class.getName());
    private static final int MAX_GROUP_DISPLAY_RANK = 99;

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            super.doGet(req, res);
            Object obj = req.getAttribute("entity");
            if (obj == null || !(obj instanceof Individual)) {
                throw new HelpException("EntityMergedPropertyListController requires request.attribute 'entity' to be of type " + Individual.class.getName());
            }
            Individual subject = (Individual)obj;
            String groupForUngroupedProperties = null;
            String unassignedStr = req.getParameter("unassignedPropsGroupName");
            if (unassignedStr != null && unassignedStr.length() > 0) {
                groupForUngroupedProperties = unassignedStr;
                req.setAttribute("unassignedPropsGroupName", (Object)unassignedStr);
                log.debug((Object)("found temp group parameter \"" + unassignedStr + "\" for unassigned properties"));
            }
            boolean groupedMode = false;
            String groupedStr = req.getParameter("grouped");
            if (groupedStr != null && groupedStr.equalsIgnoreCase("true")) {
                groupedMode = true;
            }
            boolean onlyPopulatedProps = true;
            String allPossiblePropsStr = req.getParameter("allProps");
            if (allPossiblePropsStr != null && allPossiblePropsStr.length() > 0) {
                log.debug((Object)("found props inclusion parameter \"" + allPossiblePropsStr + "\""));
                if (allPossiblePropsStr.equalsIgnoreCase("true")) {
                    onlyPopulatedProps = false;
                }
            }
            VitroRequest vreq = new VitroRequest(req);
            WebappDaoFactory wdf = vreq.getWebappDaoFactory();
            PropertyGroupDao pgDao = null;
            List<PropertyGroup> groupsList = null;
            if (groupedMode) {
                pgDao = wdf.getPropertyGroupDao();
                groupsList = pgDao.getPublicGroups(false);
            }
            PropertyInstanceDao piDao = wdf.getPropertyInstanceDao();
            ObjectPropertyDao opDao = wdf.getObjectPropertyDao();
            ArrayList<Property> mergedPropertyList = new ArrayList<Property>();
            if (onlyPopulatedProps) {
                List<ObjectProperty> objectPropertyList = subject.getObjectPropertyList();
                for (ObjectProperty objectProperty : objectPropertyList) {
                    objectProperty.setLabel(objectProperty.getDomainPublic());
                    mergedPropertyList.add(objectProperty);
                }
            } else {
                log.debug((Object)"getting all possible object property choices");
                Collection<PropertyInstance> allPropInstColl = piDao.getAllPossiblePropInstForIndividual(subject.getURI());
                if (allPropInstColl != null) {
                    for (PropertyInstance propertyInstance : allPropInstColl) {
                        if (propertyInstance != null) {
                            ObjectProperty op = opDao.getObjectPropertyByURI(propertyInstance.getPropertyURI());
                            op.setLabel(op.getDomainPublic());
                            mergedPropertyList.add(op);
                            continue;
                        }
                        log.error((Object)"a property instance in the Collection created by PropertyInstanceDao.getAllPossiblePropInstForIndividual() is unexpectedly null");
                    }
                } else {
                    log.error((Object)"a null Collection is returned from PropertyInstanceDao.getAllPossiblePropInstForIndividual()");
                }
            }
            DataPropertyDao dpDao = wdf.getDataPropertyDao();
            if (onlyPopulatedProps) {
                List<DataProperty> dataPropertyList = subject.getDataPropertyList();
                for (DataProperty dp : dataPropertyList) {
                    dp.setLabel(dp.getPublicName());
                    mergedPropertyList.add(dp);
                }
            } else {
                log.debug((Object)"getting all possible data property choices");
                Collection<DataProperty> allDatapropColl = dpDao.getAllPossibleDatapropsForIndividual(subject.getURI());
                if (allDatapropColl != null) {
                    for (DataProperty dp : allDatapropColl) {
                        if (dp != null) {
                            dp.setLabel(dp.getPublicName());
                            mergedPropertyList.add(dp);
                            continue;
                        }
                        log.error((Object)"a data property in the Collection created in DataPropertyDao.getAllPossibleDatapropsForIndividual() is unexpectedly null)");
                    }
                } else {
                    log.error((Object)"a null Collection is returned from DataPropertyDao.getAllPossibleDatapropsForIndividual())");
                }
            }
            if (mergedPropertyList != null) {
                try {
                    Collections.sort(mergedPropertyList, new PropertyRanker(vreq));
                }
                catch (Exception ex) {
                    log.error((Object)("Exception sorting merged property list: " + ex.getMessage()));
                }
                if (groupedMode) {
                    int groupsCount = 0;
                    try {
                        groupsCount = this.populateGroupsListWithProperties(pgDao, groupsList, mergedPropertyList, groupForUngroupedProperties);
                    }
                    catch (Exception exception) {
                        log.error((Object)("Exception on trying to populate groups list with properties: " + exception.getMessage()));
                        exception.printStackTrace();
                    }
                    try {
                        int n = pgDao.removeUnpopulatedGroups(groupsList);
                        if (n == 0) {
                            log.warn((Object)("Of " + groupsCount + " groups, none removed by removeUnpopulatedGroups"));
                        }
                        req.setAttribute("groupsCount", (Object)new Integer(groupsCount -= n));
                        if (groupsCount > 0) {
                            for (PropertyGroup g : groupsList) {
                                int statementCount = 0;
                                if (g.getPropertyList() != null && g.getPropertyList().size() > 0) {
                                    for (Property p : g.getPropertyList()) {
                                        ObjectProperty op;
                                        if (!(p instanceof ObjectProperty) || (op = (ObjectProperty)p).getObjectPropertyStatements() == null || op.getObjectPropertyStatements().size() <= 0) continue;
                                        statementCount += op.getObjectPropertyStatements().size();
                                    }
                                }
                                g.setStatementCount(statementCount);
                            }
                        }
                    }
                    catch (Exception exception) {
                        log.error((Object)("Exception on trying to prune groups list with properties: " + exception.getMessage()));
                    }
                    mergedPropertyList.clear();
                }
                if (groupedMode) {
                    req.setAttribute("groupsList", groupsList);
                } else {
                    req.setAttribute("dashboardPropertyList", mergedPropertyList);
                }
            }
            req.setAttribute("entity", (Object)subject);
            JSPPageHandler.renderPlainInclude(req, res, "edit/dashboardPropsList.jsp");
        }
        catch (HelpException help) {
            this.doHelp(res);
        }
        catch (Throwable e) {
            req.setAttribute("javax.servlet.jsp.jspException", (Object)e);
            JSPPageHandler.renderPlainPage(req, res, "/error.jsp");
        }
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private boolean alreadyOnPropertyList(List<Property> propsList, Property p) {
        if (p.getURI() == null) {
            log.error((Object)"Property p has no propertyURI in alreadyOnPropertyList()");
            return true;
        }
        for (Property ptest : propsList) {
            if (ptest.getURI() == null || !ptest.getURI().equals(p.getURI())) continue;
            return true;
        }
        return false;
    }

    private int populateGroupsListWithProperties(PropertyGroupDao pgDao, List<PropertyGroup> groupsList, List<Property> mergedPropertyList, String unassignedGroupName) {
        int count = groupsList.size();
        PropertyGroup tempGroup = null;
        if (unassignedGroupName != null) {
            tempGroup = pgDao.createDummyPropertyGroup(unassignedGroupName, 99);
            log.debug((Object)("creating temp property group " + unassignedGroupName + " for any unassigned properties"));
        }
        switch (count) {
            case 0: {
                log.warn((Object)"groupsList has no groups on entering populateGroupsListWithProperties(); will create a new group \"other\"");
                break;
            }
            case 1: {
                break;
            }
            default: {
                try {
                    Collections.sort(groupsList);
                    break;
                }
                catch (Exception ex) {
                    log.error((Object)"Exception on sorting groupsList in populateGroupsListWithProperties()");
                }
            }
        }
        if (count == 0 && unassignedGroupName != null) {
            groupsList.add(tempGroup);
        }
        for (PropertyGroup pg : groupsList) {
            if (pg.getPropertyList().size() > 0) {
                pg.getPropertyList().clear();
            }
            for (Property p : mergedPropertyList) {
                if (p.getURI() == null) {
                    log.error((Object)"Property p has null URI in populateGroupsListWithProperties()");
                    continue;
                }
                if (p.getGroupURI() == null) {
                    if (tempGroup == null || this.alreadyOnPropertyList(tempGroup.getPropertyList(), p)) continue;
                    tempGroup.getPropertyList().add(p);
                    log.debug((Object)("adding property " + p.getLabel() + " to members of temp group " + unassignedGroupName));
                    continue;
                }
                if (!p.getGroupURI().equals(pg.getURI()) || this.alreadyOnPropertyList(pg.getPropertyList(), p)) continue;
                pg.getPropertyList().add(p);
            }
            if (pg.getPropertyList().size() <= 1) continue;
            try {
                Collections.sort(pg.getPropertyList(), new Property.DisplayComparatorIgnoringPropertyGroup());
            }
            catch (Exception ex) {
                log.error((Object)("Exception sorting property group " + pg.getName() + " property list: " + ex.getMessage()));
            }
        }
        if (count > 0 && tempGroup != null && tempGroup.getPropertyList().size() > 0) {
            groupsList.add(tempGroup);
        }
        count = groupsList.size();
        return count;
    }

    private void doHelp(HttpServletResponse res) throws IOException, ServletException {
        ServletOutputStream out = res.getOutputStream();
        res.setContentType("text/html; charset=UTF-8");
        out.println("<html><body><h2>Quick Notes on using EntityMergedPropList:</h2>");
        out.println("<p>request.attributes 'entity' must be set by Entity servlet before calling. It should already be 'filled out.' </p>");
        out.println("</body></html>");
    }

    private class PropertyRanker
    implements Comparator {
        VitroRequest vreq;
        WebappDaoFactory wdf;
        PropertyGroupDao pgDao;

        private PropertyRanker(VitroRequest vreq) {
            this.vreq = vreq;
            this.wdf = vreq.getWebappDaoFactory();
            this.pgDao = this.wdf.getPropertyGroupDao();
        }

        public int compare(Object o1, Object o2) {
            int diff;
            PropertyGroup pg2;
            PropertyGroup pg1;
            Property p1 = (Property)o1;
            Property p2 = (Property)o2;
            int MAX_GROUP_RANK = 99;
            int p1GroupRank = 99;
            if (p1.getGroupURI() != null && (pg1 = this.pgDao.getGroupByURI(p1.getGroupURI())) != null) {
                p1GroupRank = pg1.getDisplayRank();
            }
            int p2GroupRank = 99;
            if (p2.getGroupURI() != null && (pg2 = this.pgDao.getGroupByURI(p2.getGroupURI())) != null) {
                p2GroupRank = pg2.getDisplayRank();
            }
            if ((diff = p1GroupRank - p2GroupRank) == 0) {
                diff = this.determineDisplayRank(p1) - this.determineDisplayRank(p2);
                if (diff == 0) {
                    return p1.getLabel().compareTo(p2.getLabel());
                }
                return diff;
            }
            return diff;
        }

        private int determineDisplayRank(Property p) {
            if (p instanceof DataProperty) {
                DataProperty dp = (DataProperty)p;
                return dp.getDisplayTier();
            }
            if (p instanceof ObjectProperty) {
                ObjectProperty op = (ObjectProperty)p;
                return op.getDomainDisplayTier();
            }
            log.error((Object)"Property is of unknown class in PropertyRanker()");
            return 0;
        }
    }

    private class HelpException
    extends Throwable {
        public HelpException(String string) {
            super(string);
        }
    }
}

