/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller;

import edu.cornell.mannlib.vitro.webapp.beans.ApplicationBean;
import edu.cornell.mannlib.vitro.webapp.controller.VitroHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import edu.cornell.mannlib.vitro.webapp.utils.jena.JenaOutputUtils;
import edu.cornell.mannlib.vitro.webapp.web.ContentType;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;

public class OntologyController
extends VitroHttpServlet {
    private static final Log log = LogFactory.getLog((String)OntologyController.class.getName());
    private static Pattern RDF_REQUEST = Pattern.compile("^/ontology/([^/]*)/([^/]*).rdf$");
    private static Pattern N3_REQUEST = Pattern.compile("^/ontology/([^/]*)/([^/]*).n3$");
    private static Pattern TTL_REQUEST = Pattern.compile("^/ontology/([^/]*)/([^/]*).ttl$");
    private static Pattern HTML_REQUEST = Pattern.compile("^/ontology/([^/]*)$");
    private static Pattern URI_PATTERN = Pattern.compile("^/ontology/([^/]*)/([^/]*)$");

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        super.doGet(req, res);
        String url = req.getRequestURI().substring(req.getContextPath().length());
        String redirectURL = this.checkForRedirect(url, req.getHeader("accept"));
        if (redirectURL != null) {
            this.doRedirect(req, res, redirectURL);
            return;
        }
        ContentType rdfFormat = this.checkForLinkedDataRequest(url, req.getHeader("accept"));
        if (rdfFormat != null) {
            this.doRdf(req, res, rdfFormat);
            return;
        }
    }

    protected ContentType checkForLinkedDataRequest(String url, String acceptHeader) {
        try {
            Matcher m;
            if (acceptHeader != null) {
                ArrayList<ContentType> actualContentTypes = new ArrayList<ContentType>();
                actualContentTypes.add(new ContentType("application/xhtml+xml"));
                actualContentTypes.add(new ContentType("text/html"));
                actualContentTypes.add(new ContentType("application/rdf+xml"));
                actualContentTypes.add(new ContentType("text/n3"));
                actualContentTypes.add(new ContentType("text/turtle"));
                ContentType best = ContentType.getBestContentType(acceptHeader, actualContentTypes);
                if (best != null && ("application/rdf+xml".equals(best.getMediaType()) || "text/n3".equals(best.getMediaType()) || "text/turtle".equals(best.getMediaType()))) {
                    return best;
                }
            }
            if ((m = RDF_REQUEST.matcher(url)).matches()) {
                return new ContentType("application/rdf+xml");
            }
            m = N3_REQUEST.matcher(url);
            if (m.matches()) {
                return new ContentType("text/n3");
            }
            m = TTL_REQUEST.matcher(url);
            if (m.matches()) {
                return new ContentType("text/turtle");
            }
        }
        catch (Throwable th) {
            log.error((Object)"problem while checking accept header ", th);
        }
        return new ContentType("application/rdf+xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRdf(HttpServletRequest req, HttpServletResponse res, ContentType rdfFormat) throws IOException, ServletException {
        Model newModel;
        boolean found;
        VitroRequest vreq;
        block15: {
            vreq = new VitroRequest(req);
            int index = vreq.getRequestURL().lastIndexOf("/");
            String ontology = vreq.getRequestURL().substring(0, index);
            String classOrProperty = vreq.getRequestURL().substring(index + 1);
            if (classOrProperty.lastIndexOf(".") != -1) {
                int indexx = classOrProperty.lastIndexOf(".");
                classOrProperty = classOrProperty.substring(0, indexx);
            }
            String url = ontology;
            OntModel ontModel = ModelAccess.on(this.getServletContext()).getOntModel();
            found = false;
            newModel = ModelFactory.createDefaultModel();
            ontModel.enterCriticalSection(true);
            try {
                OntResource ontResource = ontModel.getOntResource(url);
                if (ontResource == null) {
                    ontResource = ontModel.getOntResource(url + "/");
                }
                if (ontResource != null) {
                    found = true;
                    OntResource resource = ontResource;
                    try (QueryExecution qexec = null;){
                        String queryString = "Describe <" + resource.getURI() + ">";
                        qexec = QueryExecutionFactory.create((Query)QueryFactory.create((String)queryString), (Model)ontModel);
                        newModel = qexec.execDescribe();
                        break block15;
                    }
                }
                found = false;
            }
            finally {
                ontModel.leaveCriticalSection();
            }
        }
        if (!found) {
            this.doNotFound(req, res);
            return;
        }
        JenaOutputUtils.setNameSpacePrefixes(newModel, vreq.getWebappDaoFactory());
        res.setContentType(rdfFormat.getMediaType());
        String format = "";
        if ("application/rdf+xml".equals(rdfFormat.getMediaType())) {
            format = "RDF/XML";
        } else if ("text/n3".equals(rdfFormat.getMediaType())) {
            format = "N3";
        } else if ("text/turtle".equals(rdfFormat.getMediaType())) {
            format = "TTL";
        }
        newModel.write((OutputStream)res.getOutputStream(), format);
    }

    private String checkForRedirect(String url, String acceptHeader) {
        ContentType c = this.checkForLinkedDataRequest(url, acceptHeader);
        Matcher m = URI_PATTERN.matcher(url);
        if (m.matches() && m.groupCount() <= 2) {
            String group2 = "";
            if (m.group(2).indexOf(".") != -1) {
                group2 = m.group(2).substring(0, m.group(2).indexOf("."));
                System.out.println("group2 " + group2);
                System.out.println("group1 " + m.group(1));
            }
            if (c != null && !group2.trim().equals(m.group(1).trim())) {
                String redirectUrl = null;
                redirectUrl = m.group(2).isEmpty() || m.group(2) == null ? "/ontology/" + m.group(1) + "/" + m.group(1) : "/ontology/" + m.group(1) + "/" + m.group(2) + "/" + m.group(2);
                if ("application/rdf+xml".equals(c.getMediaType())) {
                    return redirectUrl + ".rdf";
                }
                if ("text/n3".equals(c.getMediaType())) {
                    return redirectUrl + ".n3";
                }
                if ("text/turtle".equals(c.getMediaType())) {
                    return redirectUrl + ".ttl";
                }
            }
            return null;
        }
        return null;
    }

    private void doRedirect(HttpServletRequest req, HttpServletResponse res, String redirectURL) throws IOException {
        String hn = req.getHeader("Host");
        if (req.isSecure()) {
            res.setHeader("Location", res.encodeURL("https://" + hn + req.getContextPath() + redirectURL));
            log.info((Object)"doRedirect by using HTTPS");
        } else {
            res.setHeader("Location", res.encodeURL("http://" + hn + req.getContextPath() + redirectURL));
            log.info((Object)"doRedirect by using HTTP");
        }
        res.setStatus(303);
    }

    private void doNotFound(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        VitroRequest vreq = new VitroRequest(req);
        ApplicationBean appBean = vreq.getAppBean();
        req.setAttribute("title", (Object)"not found");
        res.setStatus(404);
        String css = "<link rel=\"stylesheet\" type=\"text/css\" media=\"screen\" href=\"" + appBean.getThemeDir() + "css/entity.css\"/>" + "<script language='JavaScript' type='text/javascript' src='js/toggle.js'></script>";
        req.setAttribute("css", (Object)css);
        JSPPageHandler.renderBasicPage(req, res, "/templates/error/entityNotFound.jsp");
    }
}

