/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts;

import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsOrdering;

public class UserAccountsSelectionCriteria {
    public static final int DEFAULT_ACCOUNTS_PER_PAGE = 25;
    public static final UserAccountsSelectionCriteria DEFAULT_CRITERIA = new UserAccountsSelectionCriteria(25, 1, UserAccountsOrdering.DEFAULT_ORDERING, "", "");
    private final int accountsPerPage;
    private final int pageIndex;
    private final UserAccountsOrdering orderBy;
    private final String roleFilterUri;
    private final String searchTerm;

    public UserAccountsSelectionCriteria(int accountsPerPage, int pageIndex, UserAccountsOrdering orderBy, String roleFilterUri, String searchTerm) {
        if (accountsPerPage <= 0) {
            throw new IllegalArgumentException("accountsPerPage must be a positive integer, not " + accountsPerPage);
        }
        this.accountsPerPage = accountsPerPage;
        if (pageIndex <= 0) {
            throw new IllegalArgumentException("pageIndex must be a non-negative integer, not " + pageIndex);
        }
        this.pageIndex = pageIndex;
        this.orderBy = this.nonNull(orderBy, UserAccountsOrdering.DEFAULT_ORDERING);
        this.roleFilterUri = this.nonNull(roleFilterUri, "");
        this.searchTerm = this.nonNull(searchTerm, "");
    }

    public int getAccountsPerPage() {
        return this.accountsPerPage;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public UserAccountsOrdering getOrderBy() {
        return this.orderBy;
    }

    public String getRoleFilterUri() {
        return this.roleFilterUri;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    private <T> T nonNull(T t, T nullValue) {
        return t == null ? nullValue : t;
    }

    public String toString() {
        return "UserAccountsSelectionCriteria[accountsPerPage=" + this.accountsPerPage + ", pageIndex=" + this.pageIndex + ", orderBy=" + this.orderBy + ", roleFilterUri='" + this.roleFilterUri + "', searchTerm='" + this.searchTerm + "']";
    }
}

