/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.admin;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.DisplayMessage;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.admin.UserAccountsAddPage;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.admin.UserAccountsDeleter;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.admin.UserAccountsEditPage;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.admin.UserAccountsListPage;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.RedirectResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserAccountsAdminController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog(UserAccountsAdminController.class);
    private static final String ACTION_ADD = "/add";
    private static final String ACTION_DELETE = "/delete";
    private static final String ACTION_EDIT = "/edit";

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.MANAGE_USER_ACCOUNTS.ACTION;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        if (log.isDebugEnabled()) {
            this.dumpRequestParameters((HttpServletRequest)vreq);
        }
        String action = vreq.getPathInfo();
        log.debug((Object)("action = '" + action + "'"));
        if (ACTION_ADD.equals(action)) {
            return this.handleAddRequest(vreq);
        }
        if (ACTION_EDIT.equals(action)) {
            return this.handleEditRequest(vreq);
        }
        if (ACTION_DELETE.equals(action)) {
            return this.handleDeleteRequest(vreq);
        }
        return this.handleListRequest(vreq);
    }

    private ResponseValues handleAddRequest(VitroRequest vreq) {
        UserAccountsAddPage page = new UserAccountsAddPage(vreq);
        if (page.isSubmit() && page.isValid()) {
            page.createNewAccount();
            UserAccountsListPage.Message.showNewAccount((HttpServletRequest)vreq, page.getAddedAccount(), page.wasPasswordEmailSent());
            return this.redirectToList();
        }
        return page.showPage();
    }

    private ResponseValues handleEditRequest(VitroRequest vreq) {
        UserAccountsEditPage page = new UserAccountsEditPage(vreq);
        if (page.isBogus()) {
            return this.showHomePage(vreq, page.getBogusMessage());
        }
        if (page.isSubmit() && page.isValid()) {
            page.updateAccount();
            UserAccountsListPage.Message.showUpdatedAccount((HttpServletRequest)vreq, page.getUpdatedAccount(), page.wasPasswordEmailSent());
            return this.redirectToList();
        }
        return page.showPage();
    }

    private ResponseValues handleDeleteRequest(VitroRequest vreq) {
        UserAccountsDeleter deleter = new UserAccountsDeleter(vreq);
        if (deleter.isBogus()) {
            return this.showHomePage(vreq, deleter.getBogusMessage());
        }
        Collection<String> deletedUris = deleter.delete();
        UserAccountsListPage.Message.showDeletions((HttpServletRequest)vreq, deletedUris);
        return this.redirectToList();
    }

    private ResponseValues handleListRequest(VitroRequest vreq) {
        UserAccountsListPage page = new UserAccountsListPage(vreq);
        return page.showPage();
    }

    private ResponseValues redirectToList() {
        return new RedirectResponseValues("/accountsAdmin/list");
    }

    private ResponseValues showHomePage(VitroRequest vreq, String message) {
        DisplayMessage.setMessage((HttpServletRequest)vreq, message);
        return new RedirectResponseValues("/");
    }
}

