/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.api;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.api.VitroApiServlet;
import edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery.InvalidQueryTypeException;
import edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery.SparqlQueryApiExecutor;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.utils.http.AcceptHeaderParsingException;
import edu.cornell.mannlib.vitro.webapp.utils.http.NotAcceptableException;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.query.QueryParseException;

public class SparqlQueryApiController
extends VitroApiServlet {
    private static final AuthorizationRequest REQUIRED_ACTIONS = SimplePermission.USE_SPARQL_QUERY_API.ACTION;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RDFService rdfService = ModelAccess.on(this.getServletContext()).getRDFService();
        String acceptHeader = req.getHeader("Accept");
        String queryString = req.getParameter("query");
        try {
            this.confirmAuthorization(req, REQUIRED_ACTIONS);
            this.confirmQueryIsPresent(queryString);
            SparqlQueryApiExecutor core = SparqlQueryApiExecutor.instance(rdfService, queryString, acceptHeader);
            resp.setContentType(core.getMediaType());
            core.executeAndFormat((OutputStream)resp.getOutputStream());
        }
        catch (VitroApiServlet.AuthException e) {
            this.sendShortResponse(403, e.getMessage(), resp);
        }
        catch (VitroApiServlet.BadParameterException e) {
            this.sendShortResponse(400, e.getMessage(), resp);
        }
        catch (InvalidQueryTypeException e) {
            this.sendShortResponse(400, "Query type is not SELECT, ASK, CONSTRUCT, or DESCRIBE: '" + queryString + "'", resp);
        }
        catch (QueryParseException e) {
            this.sendShortResponse(400, "Failed to parse query: '" + queryString + "'", e, resp);
        }
        catch (AcceptHeaderParsingException | NotAcceptableException e) {
            this.sendShortResponse(406, "The accept header does not include any available content type: " + e.getMessage(), resp);
        }
        catch (RDFServiceException e) {
            this.sendShortResponse(500, "Problem executing the query.", e, resp);
        }
        catch (Exception e) {
            this.sendShortResponse(500, "Unrecognized error.", e, resp);
        }
    }

    private void confirmQueryIsPresent(String queryString) throws VitroApiServlet.BadParameterException {
        if (queryString == null) {
            throw new VitroApiServlet.BadParameterException("Query string was not supplied.");
        }
        if (queryString.trim().isEmpty()) {
            throw new VitroApiServlet.BadParameterException("Query string is empty.");
        }
    }
}

