/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.beans.FormObject;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vedit.forwarder.PageForwarder;
import edu.cornell.mannlib.vedit.forwarder.impl.UrlForwarder;
import edu.cornell.mannlib.vedit.util.FormUtils;
import edu.cornell.mannlib.vedit.validator.impl.RequiredFieldValidator;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupDao;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassgroupRetryController
extends BaseEditController {
    private static final Log log = LogFactory.getLog((String)ClassgroupRetryController.class.getName());

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(req, response, SimplePermission.USE_MISCELLANEOUS_ADMIN_PAGES.ACTION)) {
            return;
        }
        VitroRequest request = new VitroRequest(req);
        EditProcessObject epo = super.createEpo((HttpServletRequest)request);
        String action = null;
        if (epo.getAction() == null) {
            action = "insert";
            epo.setAction("insert");
        } else {
            action = epo.getAction();
        }
        VClassGroupDao cgDao = ModelAccess.on(this.getServletContext()).getWebappDaoFactory().getVClassGroupDao();
        epo.setDataAccessObject(cgDao);
        VClassGroup vclassGroupForEditing = null;
        if (!epo.getUseRecycledBean()) {
            if (request.getParameter("uri") != null) {
                try {
                    vclassGroupForEditing = cgDao.getGroupByURI(request.getParameter("uri"));
                    action = "update";
                    epo.setAction("update");
                }
                catch (NullPointerException e) {
                    log.error((Object)"Need to implement 'record not found' error message.");
                }
                if (vclassGroupForEditing == null) {
                    String uriToFind = new String(request.getParameter("uri"));
                    vclassGroupForEditing = cgDao.getGroupByURI(uriToFind);
                }
            } else {
                vclassGroupForEditing = new VClassGroup();
            }
            epo.setOriginalBean(vclassGroupForEditing);
        } else {
            vclassGroupForEditing = (VClassGroup)epo.getNewBean();
        }
        ArrayList<RequiredFieldValidator> validatorList = new ArrayList<RequiredFieldValidator>();
        validatorList.add(new RequiredFieldValidator());
        epo.getValidatorMap().put("PublicName", validatorList);
        epo.setPostInsertPageForwarder(new VclassGroupInsertPageForwarder());
        epo.setPostDeletePageForwarder(new UrlForwarder("listGroups"));
        try {
            Class[] args = new Class[]{String.class};
            epo.setGetMethod(cgDao.getClass().getDeclaredMethod("getGroupByURI", args));
        }
        catch (NoSuchMethodException e) {
            log.error((Object)(this.getClass().getName() + " could not find the getGroupByURI method"));
        }
        FormObject foo = new FormObject();
        foo.setErrorMap(epo.getErrMsgMap());
        epo.setFormObject(foo);
        FormUtils.populateFormFromBean(vclassGroupForEditing, action, foo, epo.getBadValueMap());
        request.setAttribute("formJsp", "/templates/edit/specific/classgroup_retry.jsp");
        request.setAttribute("scripts", "/templates/edit/formBasic.js");
        request.setAttribute("title", "Classgroup Editing Form");
        request.setAttribute("_action", action);
        request.setAttribute("unqualifiedClassName", "VClassGroup");
        this.setRequestAttributes((HttpServletRequest)request, epo);
        try {
            JSPPageHandler.renderBasicPage((HttpServletRequest)request, response, "/templates/edit/formBasic.jsp");
        }
        catch (Exception e) {
            log.error((Object)"VclassGroupRetryController could not forward to view.");
            log.error((Object)e.getMessage());
            log.error((Object)e.getStackTrace());
        }
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doPost(request, response);
    }

    class VclassGroupInsertPageForwarder
    implements PageForwarder {
        VclassGroupInsertPageForwarder() {
        }

        @Override
        public void doForward(HttpServletRequest request, HttpServletResponse response, EditProcessObject epo) {
            String newVclassGroupUrl = "listGroups";
            try {
                response.sendRedirect(newVclassGroupUrl);
            }
            catch (IOException ioe) {
                log.error((Object)"VclassGroupInsertPageForwarder could not send redirect.");
            }
        }
    }
}

