/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.edit.listing.jena;

import edu.cornell.mannlib.vedit.beans.EditProcessObject;
import edu.cornell.mannlib.vedit.controller.BaseEditController;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.JSPPageHandler;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.ontology.AllValuesFromRestriction;
import org.apache.jena.ontology.CardinalityRestriction;
import org.apache.jena.ontology.HasValueRestriction;
import org.apache.jena.ontology.MaxCardinalityRestriction;
import org.apache.jena.ontology.MinCardinalityRestriction;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.ontology.Restriction;
import org.apache.jena.ontology.SomeValuesFromRestriction;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;

public class RestrictionsListingController
extends BaseEditController {
    private static String LAMBDA = "";
    private EditProcessObject epo = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        if (!this.isAuthorizedToDisplayPage(request, response, SimplePermission.EDIT_ONTOLOGY.ACTION)) {
            return;
        }
        VitroRequest vrequest = new VitroRequest(request);
        this.epo = super.createEpo(request);
        OntModel ontModel = ModelAccess.on(this.getServletContext()).getOntModel();
        ObjectPropertyDao opDao = vrequest.getUnfilteredWebappDaoFactory().getObjectPropertyDao();
        VClassDao vcDao = vrequest.getUnfilteredWebappDaoFactory().getVClassDao();
        IndividualDao iDao = vrequest.getUnfilteredWebappDaoFactory().getIndividualDao();
        ArrayList<String> results = new ArrayList<String>();
        request.setAttribute("results", results);
        results.add("XX");
        results.add("property");
        results.add("restriction");
        results.add("filler(s)");
        results.add(LAMBDA);
        String vClassURI = request.getParameter("VClassURI");
        if (vClassURI != null) {
            ontModel.enterCriticalSection(true);
            try {
                OntClass ontClass = ontModel.getOntClass(vClassURI);
                if (ontClass != null) {
                    try (ExtendedIterator superClassIt = ontClass.listSuperClasses();){
                        ExtendedIterator i = superClassIt;
                        while (i.hasNext()) {
                            OntClass superClass = (OntClass)i.next();
                            this.tryRestriction(superClass, vcDao, opDao, iDao, results, vClassURI);
                        }
                    }
                    try (ExtendedIterator equivClassIt = ontClass.listEquivalentClasses();){
                        ExtendedIterator i = equivClassIt;
                        while (i.hasNext()) {
                            OntClass superClass = (OntClass)i.next();
                            this.tryRestriction(superClass, vcDao, opDao, iDao, results, vClassURI);
                        }
                    }
                }
                this.doClassNotFound(results);
            }
            finally {
                ontModel.leaveCriticalSection();
            }
        } else {
            this.doClassNotFound(results);
        }
        request.setAttribute("columncount", (Object)new Integer(5));
        request.setAttribute("suppressquery", (Object)"true");
        request.setAttribute("title", (Object)"Restrictions");
        try {
            JSPPageHandler.renderBasicPage(request, response, "/templates/edit/fetch/horizontal.jsp");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void tryRestriction(OntClass theClass, VClassDao vcDao, ObjectPropertyDao opDao, IndividualDao iDao, ArrayList results, String vClassURI) {
        if (theClass.isRestriction()) {
            Restriction rest = (Restriction)theClass.as(Restriction.class);
            try {
                results.add("XX");
                OntProperty onProperty = rest.getOnProperty();
                ObjectProperty op = opDao.getObjectPropertyByURI(onProperty.getURI());
                results.add(op.getPickListName());
                if (rest.isAllValuesFromRestriction()) {
                    results.add("all values from");
                    AllValuesFromRestriction avfrest = (AllValuesFromRestriction)rest.as(AllValuesFromRestriction.class);
                    Resource allValuesFrom = avfrest.getAllValuesFrom();
                    results.add(this.printAsClass(vcDao, allValuesFrom));
                } else if (rest.isSomeValuesFromRestriction()) {
                    results.add("some values from");
                    SomeValuesFromRestriction svfrest = (SomeValuesFromRestriction)rest.as(SomeValuesFromRestriction.class);
                    Resource someValuesFrom = svfrest.getSomeValuesFrom();
                    results.add(this.printAsClass(vcDao, someValuesFrom));
                } else if (rest.isHasValueRestriction()) {
                    results.add("has value");
                    HasValueRestriction hvrest = (HasValueRestriction)rest.as(HasValueRestriction.class);
                    RDFNode hasValue = hvrest.getHasValue();
                    if (hasValue.isResource()) {
                        Resource hasValueRes = (Resource)hasValue.as(Resource.class);
                        try {
                            Individual ind;
                            if (hasValueRes.getURI() != null && (ind = iDao.getIndividualByURI(hasValueRes.getURI())).getName() != null) {
                                results.add(ind.getName());
                            }
                        }
                        catch (Exception e) {
                            results.add("???");
                        }
                    }
                } else if (rest.isMinCardinalityRestriction()) {
                    MinCardinalityRestriction crest = (MinCardinalityRestriction)rest.as(MinCardinalityRestriction.class);
                    results.add("at least " + crest.getMinCardinality());
                    results.add(LAMBDA);
                } else if (rest.isMaxCardinalityRestriction()) {
                    MaxCardinalityRestriction crest = (MaxCardinalityRestriction)rest.as(MaxCardinalityRestriction.class);
                    results.add("at most " + crest.getMaxCardinality());
                    results.add(LAMBDA);
                } else if (rest.isCardinalityRestriction()) {
                    CardinalityRestriction crest = (CardinalityRestriction)rest.as(CardinalityRestriction.class);
                    results.add("exactly " + crest.getCardinality());
                    results.add(LAMBDA);
                }
                results.add("<form action=\"addRestriction\" method=\"post\"><input type=\"hidden\" name=\"_action\" value=\"delete\"/><input type=\"submit\" value=\"Delete\"/><input type=\"hidden\" name=\"_epoKey\" value=\"" + this.epo.getKey() + "\"/>" + "<input type=\"hidden\" name=\"classUri\" value=\"" + vClassURI + "\"/>" + "<input type=\"hidden\" name=\"restrictionId\" value=\"" + (rest.getId() != null ? rest.getId() : rest.getURI()) + "\"/>" + "</form>");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String printAsClass(VClassDao vcDao, Resource res) {
        String UNKNOWN = "???";
        try {
            VClass vClass = vcDao.getVClassByURI(res.getURI());
            return vClass.getName() != null ? vClass.getName() : UNKNOWN;
        }
        catch (Exception e) {
            return UNKNOWN;
        }
    }

    private void doClassNotFound(ArrayList results) {
        results.add("XX");
        results.add("Class not found");
        results.add(LAMBDA);
        results.add(LAMBDA);
        results.add(LAMBDA);
    }
}

