/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.beans.VClassGroup;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.VClassGroupDao;
import edu.cornell.mannlib.vitro.webapp.utils.json.JacksonUtils;
import edu.cornell.mannlib.vitro.webapp.web.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ListClassGroupsController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog((String)ListClassGroupsController.class.getName());
    private static final String TEMPLATE_NAME = "siteAdmin-classHierarchy.ftl";

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.EDIT_ONTOLOGY.ACTION;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        try {
            body.put("displayOption", "group");
            body.put("pageTitle", "Class Groups");
            VClassGroupDao dao = vreq.getUnfilteredWebappDaoFactory().getVClassGroupDao();
            List<VClassGroup> groups = dao.getPublicGroupsWithVClasses();
            String json = new String();
            int counter = 0;
            if (groups != null) {
                for (VClassGroup vcg : groups) {
                    String publicName;
                    if (counter > 0) {
                        json = json + ", ";
                    }
                    if (StringUtils.isBlank((CharSequence)(publicName = vcg.getPublicName()))) {
                        publicName = "(unnamed group)";
                    }
                    try {
                        json = json + "{ \"name\": " + JacksonUtils.quote("<a href='./editForm?uri=" + URLEncoder.encode(vcg.getURI()) + "&amp;controller=Classgroup'>" + publicName + "</a>") + ", ";
                    }
                    catch (Exception e) {
                        json = json + "{ \"name\": " + JacksonUtils.quote(publicName) + ", ";
                    }
                    Integer t = vcg.getDisplayRank();
                    json = json + "\"data\": { \"displayRank\": \"" + (t != -1 ? t.toString() : "") + "\"}, ";
                    List<VClass> classList = vcg.getVitroClassList();
                    if (classList != null && classList.size() > 0) {
                        json = json + "\"children\": [";
                        Iterator<VClass> classIt = classList.iterator();
                        while (classIt.hasNext()) {
                            VClass vcw = classIt.next();
                            if (vcw.getName() != null && vcw.getURI() != null) {
                                try {
                                    json = json + "{ \"name\": " + JacksonUtils.quote("<a href='vclassEdit?uri=" + URLEncoder.encode(vcw.getURI()) + "'>" + vcw.getName() + "</a>") + ", ";
                                }
                                catch (Exception e) {
                                    json = json + "" + JacksonUtils.quote(vcw.getName()) + ", ";
                                }
                            } else {
                                json = json + "\"\", ";
                            }
                            String shortDefStr = vcw.getShortDef() == null ? "" : vcw.getShortDef();
                            json = json + "\"data\": { \"shortDef\": " + JacksonUtils.quote(shortDefStr) + "}, \"children\": [] ";
                            if (classIt.hasNext()) {
                                json = json + "} , ";
                                continue;
                            }
                            json = json + "}] ";
                        }
                    } else {
                        json = json + "\"children\": [] ";
                    }
                    json = json + "} ";
                    ++counter;
                }
            }
            body.put("jsonTree", json);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return new TemplateResponseValues(TEMPLATE_NAME, body);
    }
}

