/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Datatype;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyGroup;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.DatatypeDao;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyGroupDao;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.utils.json.JacksonUtils;
import edu.cornell.mannlib.vitro.webapp.web.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ListDatatypePropertiesController
extends FreemarkerHttpServlet {
    private static Log log = LogFactory.getLog(ListDatatypePropertiesController.class);
    private static final String TEMPLATE_NAME = "siteAdmin-objectPropHierarchy.ftl";

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.EDIT_ONTOLOGY.ACTION;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        HashMap<String, Object> body;
        block17: {
            body = new HashMap<String, Object>();
            try {
                body.put("displayOption", "all");
                body.put("pageTitle", "All Data Properties");
                body.put("propertyType", "data");
                String noResultsMsgStr = "No data properties found";
                String ontologyUri = vreq.getParameter("ontologyUri");
                DataPropertyDao dao = vreq.getUnfilteredWebappDaoFactory().getDataPropertyDao();
                DataPropertyDao dpDaoLangNeut = vreq.getLanguageNeutralWebappDaoFactory().getDataPropertyDao();
                VClassDao vcDao = vreq.getUnfilteredWebappDaoFactory().getVClassDao();
                VClassDao vcDaoLangNeut = vreq.getLanguageNeutralWebappDaoFactory().getVClassDao();
                DatatypeDao dDao = vreq.getUnfilteredWebappDaoFactory().getDatatypeDao();
                PropertyGroupDao pgDao = vreq.getUnfilteredWebappDaoFactory().getPropertyGroupDao();
                List<Object> props = new ArrayList();
                if (vreq.getParameter("propsForClass") != null) {
                    noResultsMsgStr = "There are no data properties that apply to this class.";
                    List<DataProperty> dataProps = vreq.getLanguageNeutralWebappDaoFactory().getDataPropertyDao().getDataPropertiesForVClass(vreq.getParameter("vclassUri"));
                    Iterator<Object> dataPropIt = dataProps.iterator();
                    HashSet<String> hashSet = new HashSet<String>();
                    while (dataPropIt.hasNext()) {
                        DataProperty dataProperty = (DataProperty)dataPropIt.next();
                        if (hashSet.contains(dataProperty.getURI())) continue;
                        hashSet.add(dataProperty.getURI());
                        DataProperty prop = dao.getDataPropertyByURI(dataProperty.getURI());
                        if (prop == null) continue;
                        props.add(prop);
                    }
                } else {
                    props = dao.getAllDataProperties();
                }
                if (ontologyUri != null) {
                    ArrayList<DataProperty> scratch = new ArrayList<DataProperty>();
                    for (DataProperty dataProperty : props) {
                        if (!dataProperty.getNamespace().equals(ontologyUri)) continue;
                        scratch.add(dataProperty);
                    }
                    props = scratch;
                }
                if (props != null) {
                    this.sortForPickList(props, vreq);
                }
                String json = new String();
                int counter = 0;
                if (props == null) break block17;
                if (props.size() == 0) {
                    json = "{ \"name\": \"" + noResultsMsgStr + "\" }";
                } else {
                    for (DataProperty dataProperty : props) {
                        if (counter > 0) {
                            json = json + ", ";
                        }
                        String nameStr = dataProperty.getPickListName() == null ? (dataProperty.getName() == null ? (dataProperty.getURI() == null ? "(no name)" : dataProperty.getURI()) : dataProperty.getName()) : dataProperty.getPickListName();
                        try {
                            json = json + "{ \"name\": " + JacksonUtils.quote("<a href='datapropEdit?uri=" + URLEncoder.encode(dataProperty.getURI()) + "'>" + nameStr + "</a>") + ", ";
                        }
                        catch (Exception e) {
                            json = json + "{ \"name\": " + JacksonUtils.quote(nameStr) + ", ";
                        }
                        json = json + "\"data\": { \"internalName\": " + JacksonUtils.quote(dataProperty.getPickListName()) + ", ";
                        DataProperty dpLangNeut = dpDaoLangNeut.getDataPropertyByURI(dataProperty.getURI());
                        if (dpLangNeut == null) {
                            dpLangNeut = dataProperty;
                        }
                        String domainStr = this.getVClassNameFromURI(dpLangNeut.getDomainVClassURI(), vcDao, vcDaoLangNeut);
                        json = json + "\"domainVClass\": " + JacksonUtils.quote(domainStr) + ", ";
                        Datatype rangeDatatype = dDao.getDatatypeByURI(dataProperty.getRangeDatatypeURI());
                        String rangeDatatypeStr = rangeDatatype == null ? dataProperty.getRangeDatatypeURI() : rangeDatatype.getName();
                        json = json + "\"rangeVClass\": " + JacksonUtils.quote(rangeDatatypeStr) + ", ";
                        if (dataProperty.getGroupURI() != null) {
                            PropertyGroup pGroup = pgDao.getGroupByURI(dataProperty.getGroupURI());
                            json = json + "\"group\": " + JacksonUtils.quote(pGroup == null ? "unknown group" : pGroup.getName()) + " } } ";
                        } else {
                            json = json + "\"group\": \"unspecified\" } }";
                        }
                        ++counter;
                    }
                }
                body.put("jsonTree", json);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return new TemplateResponseValues(TEMPLATE_NAME, body);
    }

    private String getVClassNameFromURI(String vclassURI, VClassDao vcDao, VClassDao vcDaoLangNeut) {
        if (vclassURI == null) {
            return "";
        }
        VClass vclass = vcDaoLangNeut.getVClassByURI(vclassURI);
        if (vclass == null) {
            return "";
        }
        if (vclass.isAnonymous()) {
            return vclass.getPickListName();
        }
        VClass vclassWLang = vcDao.getVClassByURI(vclassURI);
        return vclassWLang != null ? vclassWLang.getPickListName() : vclass.getPickListName();
    }
}

